/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.api.metadata.v3.model;

import com.google.auto.value.AutoValue;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.molgenis.api.metadata.v3.model.AutoValue_I18nValue;
import org.molgenis.util.AutoGson;

@AutoGson(autoValueClass=AutoValue_I18nValue.class)
@AutoValue
public abstract class I18nValue {
    @NotNull
    @AutoValue.CopyAnnotations(exclude={NotNull.class})
    public abstract String getDefaultValue();

    @Nullable
    @CheckForNull
    @AutoValue.CopyAnnotations(exclude={CheckForNull.class, Nullable.class})
    public abstract Map<String, String> getTranslations();

    public static I18nValue create(String defaultValue, Map<String, String> translations) {
        return I18nValue.builder().setDefaultValue(defaultValue).setTranslations(translations).build();
    }

    public static Builder builder() {
        return new AutoValue_I18nValue.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setDefaultValue(String var1);

        public abstract Builder setTranslations(Map<String, String> var1);

        public abstract I18nValue build();
    }
}

