/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.api.permissions;

import com.google.common.base.Strings;
import cz.jirutka.rsql.parser.RSQLParser;
import cz.jirutka.rsql.parser.RSQLParserException;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.molgenis.api.ApiController;
import org.molgenis.api.model.response.ApiResponse;
import org.molgenis.api.model.response.PagedApiResponse;
import org.molgenis.api.permissions.PermissionResponseUtils;
import org.molgenis.api.permissions.exceptions.MissingUserOrRoleException;
import org.molgenis.api.permissions.exceptions.PageWithoutPageSizeException;
import org.molgenis.api.permissions.exceptions.UnsupportedPermissionQueryException;
import org.molgenis.api.permissions.exceptions.UserAndRoleException;
import org.molgenis.api.permissions.model.request.DeletePermissionRequest;
import org.molgenis.api.permissions.model.request.ObjectPermissionsRequest;
import org.molgenis.api.permissions.model.request.PermissionRequest;
import org.molgenis.api.permissions.model.request.SetObjectPermissionRequest;
import org.molgenis.api.permissions.model.request.SetTypePermissionsRequest;
import org.molgenis.api.permissions.model.response.AllPermissionsResponse;
import org.molgenis.api.permissions.model.response.LabelledPermissionResponse;
import org.molgenis.api.permissions.model.response.ObjectPermissionResponse;
import org.molgenis.api.permissions.model.response.ObjectResponse;
import org.molgenis.api.permissions.model.response.PermissionResponse;
import org.molgenis.api.permissions.model.response.TypePermissionsResponse;
import org.molgenis.api.permissions.model.response.TypeResponse;
import org.molgenis.api.permissions.rsql.PermissionRsqlVisitor;
import org.molgenis.api.permissions.rsql.PermissionsQuery;
import org.molgenis.data.security.permission.EntityHelper;
import org.molgenis.data.security.permission.PermissionService;
import org.molgenis.data.security.permission.PermissionSetUtils;
import org.molgenis.data.security.permission.UserRoleTools;
import org.molgenis.data.security.permission.model.LabelledPermission;
import org.molgenis.data.security.permission.model.LabelledType;
import org.molgenis.data.security.permission.model.Permission;
import org.molgenis.security.acl.ObjectIdentityService;
import org.molgenis.security.core.PermissionSet;
import org.molgenis.security.core.SidUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Sid;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@Api(value="Permissions API")
@RestController
@RequestMapping(value={"/api/permissions"})
@Transactional
public class PermissionsController
extends ApiController {
    private static final String PERMISSION_API_IDENTIFIER = "permissions";
    public static final String BASE_URI = "/api/permissions";
    static final Integer DEFAULT_PAGE = 1;
    static final Integer DEFAULT_PAGESIZE = 100;
    private static final String TYPE = "type";
    public static final String TYPES = "types";
    private static final String TYPE_ID = "typeId";
    private static final String OBJECT = "object";
    public static final String OBJECTS = "objects";
    private static final String OBJECT_ID = "objectId";
    private final PermissionService permissionService;
    private final RSQLParser rsqlParser;
    private final ObjectIdentityService objectIdentityService;
    private final UserRoleTools userRoleTools;
    private final EntityHelper entityHelper;

    public PermissionsController(PermissionService permissionService, RSQLParser rsqlParser, ObjectIdentityService objectIdentityService, UserRoleTools userRoleTools, EntityHelper entityHelper) {
        super(PERMISSION_API_IDENTIFIER, Integer.valueOf(1));
        this.permissionService = Objects.requireNonNull(permissionService);
        this.rsqlParser = Objects.requireNonNull(rsqlParser);
        this.objectIdentityService = Objects.requireNonNull(objectIdentityService);
        this.userRoleTools = Objects.requireNonNull(userRoleTools);
        this.entityHelper = Objects.requireNonNull(entityHelper);
    }

    @PostMapping(value={"types/{typeId}"})
    @ApiOperation(value="Create a type this enables row level secure an entity", response=ResponseEntity.class)
    public ResponseEntity enableRLS(HttpServletRequest request, @PathVariable(value="typeId") String typeId) {
        this.permissionService.addType(typeId);
        return ResponseEntity.created((URI)this.getUriFromRequest(request)).build();
    }

    private URI getUriFromRequest(HttpServletRequest request) {
        return ServletUriComponentsBuilder.fromRequestUri((HttpServletRequest)request).build().toUri();
    }

    @DeleteMapping(value={"types/{typeId}"})
    @ApiOperation(value="Delete a type this removes row level security from an entity", response=ResponseEntity.class)
    public ResponseEntity disableRLS(@PathVariable(value="typeId") String typeId) {
        this.permissionService.deleteType(typeId);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"types"})
    @ApiOperation(value="Get a list of ACL types in the system", response=ResponseEntity.class)
    public ApiResponse getRlsEntities() {
        return ApiResponse.create(this.convertTypes(this.permissionService.getLabelledTypes()));
    }

    @GetMapping(value={"types/permissions/{typeId}"})
    @ApiOperation(value="Get a list of permissions that can be used on a type", response=List.class)
    public ApiResponse getSuitablePermissions(@PathVariable(value="typeId") String typeId) {
        return ApiResponse.create(this.permissionService.getSuitablePermissionsForType(typeId).stream().map(PermissionSetUtils::getPermissionStringValue).collect(Collectors.toSet()));
    }

    @PostMapping(value={"objects/{typeId}/{objectId}"})
    @ApiOperation(value="Create a type for a entity", response=ResponseEntity.class)
    public ResponseEntity createAcl(HttpServletRequest request, @PathVariable(value="typeId") String typeId, @PathVariable(value="objectId") String identifier) {
        this.permissionService.createAcl(this.entityHelper.getObjectIdentity(typeId, identifier));
        return ResponseEntity.created((URI)this.getUriFromRequest(request)).build();
    }

    @GetMapping(value={"objects/{typeId}"})
    @ApiOperation(value="Get a list object's for a type. Typically this is a row in a row level secured entity.", response=List.class)
    public PagedApiResponse getAcls(@PathVariable(value="typeId") String typeId, @RequestParam(value="page", required=false) Integer page, @RequestParam(value="pageSize", required=false) Integer pageSize) {
        this.validateQueryParams(page, pageSize, false);
        if (page == null) {
            page = DEFAULT_PAGE;
            pageSize = DEFAULT_PAGESIZE;
        }
        Set data = this.permissionService.getObjects(typeId, page.intValue(), pageSize.intValue()).stream().map(labelledObject -> ObjectResponse.create(labelledObject.getId(), labelledObject.getLabel())).collect(Collectors.toSet());
        int totalItems = this.objectIdentityService.getNrOfObjectIdentities(typeId);
        return PermissionResponseUtils.getPermissionResponse("", page, pageSize, totalItems, data);
    }

    @GetMapping(value={"{typeId}/{objectId}"})
    @ApiOperation(value="Gets permissions on a single object", response=ResponseEntity.class)
    public ApiResponse getPermissionsForObject(@PathVariable(value="typeId") String typeId, @PathVariable(value="objectId") String identifier, @RequestParam(value="q", required=false) String queryString, @RequestParam(value="inheritance", defaultValue="false", required=false) boolean inheritance) {
        Set<Sid> sids = this.getSidsFromQuery(queryString);
        Set labelledObjectPermissions = this.permissionService.getPermissionsForObject(this.entityHelper.getObjectIdentity(typeId, identifier), sids, inheritance);
        ObjectPermissionResponse permissionResponse = this.convertToObjectResponse(typeId, identifier, labelledObjectPermissions);
        return ApiResponse.create((Object)permissionResponse);
    }

    @GetMapping(value={"{typeId}"})
    @ApiOperation(value="Gets all permissions for all objects of a certain type", response=ResponseEntity.class)
    public PagedApiResponse getPermissionsForType(@PathVariable(value="typeId") String typeId, @RequestParam(value="q", required=false) String queryString, @RequestParam(value="page", required=false) Integer page, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="inheritance", defaultValue="false", required=false) boolean inheritance) {
        PagedApiResponse response;
        this.validateQueryParams(page, pageSize, inheritance);
        Set<Sid> sids = this.getSidsFromQuery(queryString);
        if (page != null) {
            Map typePermission = this.permissionService.getPermissionsForType(typeId, sids, page.intValue(), pageSize.intValue());
            TypePermissionsResponse permissionsResponse = this.convertToTypeResponse(typeId, typePermission);
            Integer totalItems = this.objectIdentityService.getNrOfObjectIdentities(typeId, sids);
            response = PermissionResponseUtils.getPermissionResponse(queryString, page, pageSize, totalItems, permissionsResponse);
        } else {
            Map typePermission = this.permissionService.getPermissionsForType(typeId, sids, inheritance);
            TypePermissionsResponse permissionsResponse = this.convertToTypeResponse(typeId, typePermission);
            response = PermissionResponseUtils.getPermissionResponse(queryString, permissionsResponse);
        }
        return response;
    }

    @GetMapping
    @ApiOperation(value="Gets all permissions for one or more users or roles", response=ResponseEntity.class)
    public ApiResponse getPermissionsForUser(@RequestParam(value="q", required=false) String queryString, @RequestParam(value="inheritance", defaultValue="false", required=false) boolean inheritance) {
        Set<Sid> sids = this.getSidsFromQuery(queryString);
        Set permissions = this.permissionService.getPermissions(sids, inheritance);
        return ApiResponse.create((Object)this.convertToAllPermissionsResponse(permissions));
    }

    @PatchMapping(value={"{typeId}/{objectId}"})
    @ApiOperation(value="Update a permission on a single object for one or more users or roles", response=ResponseEntity.class)
    public ResponseEntity setPermission(@PathVariable(value="typeId") String typeId, @PathVariable(value="objectId") String identifier, @RequestBody SetObjectPermissionRequest request) {
        Set<Permission> permissions = this.convertRequests(request.getPermissions(), typeId, identifier);
        this.permissionService.updatePermissions(permissions);
        return ResponseEntity.noContent().build();
    }

    @PatchMapping(value={"{typeId}"})
    @ApiOperation(value="Update a list of permissions on objects of a certain type", response=ResponseEntity.class)
    public ResponseEntity setTypePermissions(@PathVariable(value="typeId") String typeId, @RequestBody SetTypePermissionsRequest request) {
        Set<Permission> permissions = this.convertRequests(request.getObjects(), typeId);
        this.permissionService.updatePermissions(permissions);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"{typeId}"})
    @ApiOperation(value="Create a list of permissions on an type for a single user or role")
    public ResponseEntity<Object> createPermissions(HttpServletRequest request, @PathVariable(value="typeId") String typeId, @RequestBody SetTypePermissionsRequest setTypePermissionsRequest) {
        Set<Permission> permissions = this.convertRequests(setTypePermissionsRequest.getObjects(), typeId);
        this.permissionService.createPermissions(permissions);
        return ResponseEntity.created((URI)this.getUriFromRequest(request)).build();
    }

    @PostMapping(value={"{typeId}/{objectId}"})
    @ApiOperation(value="Create a permission on an object for a single user or role")
    public ResponseEntity<Object> createPermission(HttpServletRequest request, @PathVariable(value="typeId") String typeId, @PathVariable(value="objectId") String identifier, @RequestBody SetObjectPermissionRequest setIdentityPermissionRequest) {
        Set<Permission> permissions = this.convertRequests(setIdentityPermissionRequest.getPermissions(), typeId, identifier);
        this.permissionService.createPermissions(permissions);
        return ResponseEntity.created((URI)this.getUriFromRequest(request)).build();
    }

    @DeleteMapping(value={"{typeId}/{objectId}"})
    @ApiOperation(value="Delete a permission on an object for a single user or role", response=ResponseEntity.class)
    public ResponseEntity deletePermission(@PathVariable(value="typeId") String typeId, @PathVariable(value="objectId") String identifier, @RequestBody DeletePermissionRequest request) {
        Sid sid = this.getSid(request.getUser(), request.getRole());
        this.permissionService.deletePermission(sid, this.entityHelper.getObjectIdentity(typeId, identifier));
        return ResponseEntity.noContent().build();
    }

    private Set<Sid> getSidsFromQuery(String queryString) {
        Set<Sid> sids = Collections.emptySet();
        if (!Strings.isNullOrEmpty((String)queryString)) {
            try {
                Node node = this.rsqlParser.parse(queryString);
                PermissionsQuery permissionsQuery = (PermissionsQuery)node.accept((RSQLVisitor)new PermissionRsqlVisitor());
                sids = new LinkedHashSet<Sid>(this.userRoleTools.getSids(permissionsQuery.getUsers(), permissionsQuery.getRoles()));
            }
            catch (RSQLParserException rSQLParserException) {
                // empty catch block
            }
        }
        return sids;
    }

    private void validateQueryParams(Integer page, Integer pageSize, boolean inheritance) {
        if (page == null && pageSize != null || page != null && pageSize == null) {
            throw new PageWithoutPageSizeException();
        }
        if (page != null && inheritance) {
            throw new UnsupportedPermissionQueryException();
        }
    }

    private Set<TypeResponse> convertTypes(Set<LabelledType> types) {
        return types.stream().map(type -> TypeResponse.create(type.getId(), type.getEntityType(), type.getLabel())).collect(Collectors.toSet());
    }

    private ObjectPermissionResponse convertToObjectResponse(String typeId, String id, Set<LabelledPermission> labelledObjectPermissions) {
        Set<PermissionResponse> permissions = this.convertToPermissions(labelledObjectPermissions);
        String label = this.entityHelper.getLabel(typeId, id);
        return ObjectPermissionResponse.create(id, label, permissions);
    }

    private TypePermissionsResponse convertToTypeResponse(String typeId, Map<String, Set<LabelledPermission>> typePermissions) {
        LinkedHashSet<ObjectPermissionResponse> objectPermissions = new LinkedHashSet<ObjectPermissionResponse>();
        for (Map.Entry<String, Set<LabelledPermission>> entry : typePermissions.entrySet()) {
            Set<LabelledPermission> permissions = entry.getValue();
            if (permissions.isEmpty()) continue;
            LabelledPermission labelledObjectPermission = (LabelledPermission)permissions.stream().findFirst().orElseThrow(() -> new IllegalStateException("Empty set of permissions"));
            objectPermissions.add(this.convertToObjectResponse(typeId, labelledObjectPermission.getLabelledObjectIdentity().getIdentifier().toString(), permissions));
        }
        String label = this.entityHelper.getLabel(typeId);
        return TypePermissionsResponse.create(typeId, label, objectPermissions);
    }

    private Set<PermissionResponse> convertToPermissions(Set<LabelledPermission> permissions) {
        LinkedHashSet<PermissionResponse> result = new LinkedHashSet<PermissionResponse>();
        permissions.stream().map(labelledPermission -> PermissionResponse.create(UserRoleTools.getUsername((Sid)labelledPermission.getSid()).orElse(null), UserRoleTools.getRolename((Sid)labelledPermission.getSid()).orElse(null), PermissionSetUtils.getPermissionStringValue((LabelledPermission)labelledPermission).orElse(null), this.convertLabelledPermissions(labelledPermission.getInheritedPermissions()))).forEach(result::add);
        return result;
    }

    private AllPermissionsResponse convertToAllPermissionsResponse(Set<LabelledPermission> permissions) {
        return AllPermissionsResponse.create(this.convertLabelledPermissions(permissions));
    }

    private Set<LabelledPermissionResponse> convertLabelledPermissions(Set<LabelledPermission> objectPermissionResponses) {
        LinkedHashSet<LabelledPermissionResponse> permissionResponses = null;
        if (objectPermissionResponses != null) {
            permissionResponses = new LinkedHashSet<LabelledPermissionResponse>();
            for (LabelledPermission permission : objectPermissionResponses) {
                LabelledPermissionResponse labelledResponse;
                PermissionSet permissionSet = permission.getPermission();
                String permissionString = null;
                if (permissionSet != null) {
                    permissionString = PermissionSetUtils.getPermissionStringValue((PermissionSet)permissionSet);
                }
                if (permission.getLabelledObjectIdentity() != null) {
                    ObjectResponse objectResponse = ObjectResponse.create(permission.getLabelledObjectIdentity().getIdentifier().toString(), permission.getLabelledObjectIdentity().getIdentifierLabel());
                    TypeResponse typeResponse = TypeResponse.create(permission.getLabelledObjectIdentity().getType(), permission.getLabelledObjectIdentity().getEntityTypeId(), permission.getLabelledObjectIdentity().getTypeLabel());
                    labelledResponse = LabelledPermissionResponse.create(UserRoleTools.getUsername((Sid)permission.getSid()).orElse(null), UserRoleTools.getRolename((Sid)permission.getSid()).orElse(null), objectResponse, typeResponse, permissionString, this.convertLabelledPermissions(permission.getInheritedPermissions()));
                } else {
                    labelledResponse = LabelledPermissionResponse.create(UserRoleTools.getUsername((Sid)permission.getSid()).orElse(null), UserRoleTools.getRolename((Sid)permission.getSid()).orElse(null), null, null, permissionString, this.convertLabelledPermissions(permission.getInheritedPermissions()));
                }
                permissionResponses.add(labelledResponse);
            }
        }
        return permissionResponses;
    }

    private Set<Permission> convertRequests(List<PermissionRequest> requests, String typeId, String identifier) {
        HashSet<Permission> permissions = new HashSet<Permission>();
        for (PermissionRequest permissionRequest : requests) {
            permissions.add(Permission.create((ObjectIdentity)this.entityHelper.getObjectIdentity(typeId, identifier), (Sid)this.getSid(permissionRequest.getUser(), permissionRequest.getRole()), (PermissionSet)PermissionSetUtils.paramValueToPermissionSet((String)permissionRequest.getPermission())));
        }
        return permissions;
    }

    private Set<Permission> convertRequests(List<ObjectPermissionsRequest> requests, String typeId) {
        HashSet<Permission> permissions = new HashSet<Permission>();
        for (ObjectPermissionsRequest request : requests) {
            permissions.addAll(this.convertRequests(request.getPermissions(), typeId, request.getObjectId()));
        }
        return permissions;
    }

    private Sid getSid(String user, String role) {
        if (Strings.isNullOrEmpty((String)user) && Strings.isNullOrEmpty((String)role)) {
            throw new MissingUserOrRoleException();
        }
        if (!Strings.isNullOrEmpty((String)user) && !Strings.isNullOrEmpty((String)role)) {
            throw new UserAndRoleException();
        }
        if (!Strings.isNullOrEmpty((String)user)) {
            this.userRoleTools.checkUserExists(user);
            return SidUtils.createUserSid((String)user);
        }
        this.userRoleTools.checkRoleExists(role);
        return SidUtils.createRoleSid((String)role);
    }
}

