
package org.molgenis.api.permissions.model.request;

import javax.annotation.CheckForNull;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_PermissionRequest extends PermissionRequest {

  private final String role;
  private final String user;
  private final String permission;

  private AutoValue_PermissionRequest(
      @Nullable String role,
      @Nullable String user,
      String permission) {
    this.role = role;
    this.user = user;
    this.permission = permission;
  }

  @Nullable
  @CheckForNull
  @Override
  public String getRole() {
    return role;
  }

  @Nullable
  @CheckForNull
  @Override
  public String getUser() {
    return user;
  }

  @Override
  public String getPermission() {
    return permission;
  }

  @Override
  public String toString() {
    return "PermissionRequest{"
        + "role=" + role + ", "
        + "user=" + user + ", "
        + "permission=" + permission
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PermissionRequest) {
      PermissionRequest that = (PermissionRequest) o;
      return ((this.role == null) ? (that.getRole() == null) : this.role.equals(that.getRole()))
           && ((this.user == null) ? (that.getUser() == null) : this.user.equals(that.getUser()))
           && (this.permission.equals(that.getPermission()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (role == null) ? 0 : this.role.hashCode();
    h *= 1000003;
    h ^= (user == null) ? 0 : this.user.hashCode();
    h *= 1000003;
    h ^= this.permission.hashCode();
    return h;
  }

  static final class Builder extends PermissionRequest.Builder {
    private String role;
    private String user;
    private String permission;
    Builder() {
    }
    @Override
    public PermissionRequest.Builder setRole(@Nullable String role) {
      this.role = role;
      return this;
    }
    @Override
    public PermissionRequest.Builder setUser(@Nullable String user) {
      this.user = user;
      return this;
    }
    @Override
    public PermissionRequest.Builder setPermission(String permission) {
      if (permission == null) {
        throw new NullPointerException("Null permission");
      }
      this.permission = permission;
      return this;
    }
    @Override
    public PermissionRequest build() {
      String missing = "";
      if (this.permission == null) {
        missing += " permission";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PermissionRequest(
          this.role,
          this.user,
          this.permission);
    }
  }

}
