/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.api.permissions.model.request;

import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.molgenis.api.permissions.exceptions.MissingUserOrRoleException;
import org.molgenis.api.permissions.exceptions.UserAndRoleException;
import org.molgenis.api.permissions.model.request.AutoValue_PermissionRequest;
import org.molgenis.util.AutoGson;

@AutoGson(autoValueClass=AutoValue_PermissionRequest.class)
@AutoValue
public abstract class PermissionRequest {
    @Nullable
    @CheckForNull
    public abstract String getRole();

    @Nullable
    @CheckForNull
    public abstract String getUser();

    public abstract String getPermission();

    public static PermissionRequest create(String role, String user, String permission) {
        if (Strings.isNullOrEmpty((String)user) && Strings.isNullOrEmpty((String)role)) {
            throw new MissingUserOrRoleException();
        }
        if (!Strings.isNullOrEmpty((String)user) && !Strings.isNullOrEmpty((String)role)) {
            throw new UserAndRoleException();
        }
        return PermissionRequest.builder().setRole(role).setUser(user).setPermission(permission).build();
    }

    private static Builder builder() {
        return new AutoValue_PermissionRequest.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setRole(String var1);

        public abstract Builder setUser(String var1);

        public abstract Builder setPermission(String var1);

        public abstract PermissionRequest build();
    }
}

