/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.api.permissions.model.response;

import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.molgenis.api.permissions.model.response.AutoValue_LabelledPermissionResponse;
import org.molgenis.api.permissions.model.response.ObjectResponse;
import org.molgenis.api.permissions.model.response.TypeResponse;
import org.molgenis.util.AutoGson;

@AutoGson(autoValueClass=AutoValue_LabelledPermissionResponse.class)
@AutoValue
public abstract class LabelledPermissionResponse {
    @Nullable
    @CheckForNull
    public abstract String getUser();

    @Nullable
    @CheckForNull
    public abstract String getRole();

    @Nullable
    @CheckForNull
    public abstract ObjectResponse getObject();

    @Nullable
    @CheckForNull
    public abstract TypeResponse getType();

    @Nullable
    @CheckForNull
    public abstract String getPermission();

    @Nullable
    @CheckForNull
    public abstract Set<LabelledPermissionResponse> getInheritedPermissions();

    public static LabelledPermissionResponse create(String user, String role, ObjectResponse object, TypeResponse type, String permission, Set<LabelledPermissionResponse> inheritedPermissions) {
        if (!(LabelledPermissionResponse.hasAuthority(user, role) || LabelledPermissionResponse.hasInheritedPermissions(inheritedPermissions) || LabelledPermissionResponse.hasPermission(object, permission))) {
            throw new IllegalStateException("No user, role, permission or inherited permissions provided.");
        }
        if (!Strings.isNullOrEmpty((String)user) && !Strings.isNullOrEmpty((String)role)) {
            throw new IllegalStateException("Both user and role provided.");
        }
        return new AutoValue_LabelledPermissionResponse(user, role, object, type, permission, inheritedPermissions);
    }

    private static boolean hasPermission(ObjectResponse object, String permission) {
        return !Strings.isNullOrEmpty((String)object.getId()) && !Strings.isNullOrEmpty((String)permission);
    }

    private static boolean hasInheritedPermissions(Set<LabelledPermissionResponse> inheritedPermissions) {
        return inheritedPermissions != null && !inheritedPermissions.isEmpty();
    }

    private static boolean hasAuthority(String user, String role) {
        return !Strings.isNullOrEmpty((String)user) || !Strings.isNullOrEmpty((String)role);
    }
}

