/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.app.manager.decorator;

import java.util.Objects;
import java.util.stream.Stream;
import org.molgenis.app.manager.meta.App;
import org.molgenis.app.manager.service.AppManagerService;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.Repository;
import org.molgenis.data.support.QueryImpl;

public class AppRepositoryDecorator
extends AbstractRepositoryDecorator<App> {
    private final Repository<App> delegateRepository;
    private AppManagerService appManagerService;

    public AppRepositoryDecorator(Repository<App> delegateRepository, AppManagerService appManagerService) {
        super(delegateRepository);
        this.appManagerService = Objects.requireNonNull(appManagerService);
        this.delegateRepository = Objects.requireNonNull(delegateRepository);
    }

    public void delete(App entity) {
        this.deleteById(entity.getId());
    }

    public void deleteById(Object id) {
        this.appManagerService.deleteApp((String)id);
        this.delegate().deleteById(id);
    }

    public void deleteAll() {
        this.findAll((Query)new QueryImpl()).forEach(app -> this.deleteById(app.getId()));
    }

    protected Repository<App> delegate() {
        return this.delegateRepository;
    }

    public void update(App app) {
        App current = (App)this.findOneById(app.getId());
        if (current != null && current.isActive() != app.isActive()) {
            if (app.isActive()) {
                this.appManagerService.activateApp(app);
            } else {
                this.appManagerService.deactivateApp(app);
            }
        }
        this.delegate().update((Entity)app);
    }

    public void update(Stream<App> apps) {
        apps.forEach(this::update);
    }
}

