/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.app.manager.meta;

import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.EntityType;
import org.springframework.stereotype.Component;

@Component
public class AppMetadata
extends SystemEntityType {
    private static final String SIMPLE_NAME = "App";
    public static final String APP = "sys_App";
    public static final String ID = "id";
    public static final String LABEL = "label";
    public static final String DESCRIPTION = "description";
    public static final String IS_ACTIVE = "isActive";
    public static final String APP_VERSION = "appVersion";
    public static final String API_DEPENDENCY = "apiDependency";
    public static final String TEMPLATE_CONTENT = "templateContent";
    public static final String RESOURCE_FOLDER = "resourceFolder";
    public static final String NAME = "name";
    public static final String APP_CONFIG = "appConfig";
    public static final String INCLUDE_MENU_AND_FOOTER = "includeMenuAndFooter";

    public AppMetadata() {
        super(SIMPLE_NAME, "sys");
    }

    protected void init() {
        this.setLabel(SIMPLE_NAME);
        this.addAttribute(ID, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID}).setAuto(true).setLabel("Identifier");
        this.addAttribute(LABEL, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_LABEL, EntityType.AttributeRole.ROLE_LOOKUP}).setLabel("Label").setNillable(false);
        this.addAttribute(DESCRIPTION, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_LOOKUP}).setDataType(AttributeType.TEXT).setNillable(true).setLabel("Description");
        this.addAttribute(IS_ACTIVE, new EntityType.AttributeRole[0]).setDataType(AttributeType.BOOL).setLabel("Active").setNillable(false).setDefaultValue(Boolean.FALSE.toString());
        this.addAttribute(APP_VERSION, new EntityType.AttributeRole[0]).setNillable(true).setLabel("App version");
        this.addAttribute(API_DEPENDENCY, new EntityType.AttributeRole[0]).setNillable(true).setLabel("API dependency version");
        this.addAttribute(TEMPLATE_CONTENT, new EntityType.AttributeRole[0]).setDataType(AttributeType.HTML).setNillable(false).setLabel("Template content");
        this.addAttribute(RESOURCE_FOLDER, new EntityType.AttributeRole[0]).setNillable(false).setLabel("Resource folder");
        this.addAttribute(NAME, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_LOOKUP}).setLabel("Name").setDescription("The name of this app").setNillable(false).setUnique(true);
        this.addAttribute(APP_CONFIG, new EntityType.AttributeRole[0]).setDataType(AttributeType.TEXT).setNillable(true).setLabel("Runtime Application configuration");
        this.addAttribute(INCLUDE_MENU_AND_FOOTER, new EntityType.AttributeRole[0]).setDataType(AttributeType.BOOL).setLabel("Include a menu above your app and a footer below").setNillable(false).setDefaultValue(Boolean.FALSE.toString());
    }
}

