/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.app.manager.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.molgenis.app.manager.exception.AppAlreadyExistsException;
import org.molgenis.app.manager.exception.AppArchiveMissingFilesException;
import org.molgenis.app.manager.exception.AppConfigMissingParametersException;
import org.molgenis.app.manager.exception.AppForIDDoesNotExistException;
import org.molgenis.app.manager.exception.AppForURIDoesNotExistException;
import org.molgenis.app.manager.exception.CouldNotDeleteAppException;
import org.molgenis.app.manager.exception.IllegalAppNameException;
import org.molgenis.app.manager.exception.InvalidAppArchiveException;
import org.molgenis.app.manager.exception.InvalidAppConfigException;
import org.molgenis.app.manager.meta.App;
import org.molgenis.app.manager.meta.AppFactory;
import org.molgenis.app.manager.model.AppConfig;
import org.molgenis.app.manager.model.AppResponse;
import org.molgenis.app.manager.service.AppManagerService;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.file.FileStore;
import org.molgenis.data.plugin.model.Plugin;
import org.molgenis.data.plugin.model.PluginFactory;
import org.molgenis.util.file.UnzipException;
import org.molgenis.util.file.ZipFileUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppManagerServiceImpl
implements AppManagerService {
    public static final String APPS_DIR = "apps";
    public static final String ZIP_INDEX_FILE = "index.html";
    public static final String ZIP_CONFIG_FILE = "config.json";
    public static final String APP_PLUGIN_ROOT = "app/";
    private static final String APPS_TMP_DIR = "apps_tmp";
    private final AppFactory appFactory;
    private final DataService dataService;
    private final FileStore fileStore;
    private final Gson gson;
    private final PluginFactory pluginFactory;

    public AppManagerServiceImpl(AppFactory appFactory, DataService dataService, FileStore fileStore, Gson gson, PluginFactory pluginFactory) {
        this.appFactory = Objects.requireNonNull(appFactory);
        this.dataService = Objects.requireNonNull(dataService);
        this.fileStore = Objects.requireNonNull(fileStore);
        this.gson = Objects.requireNonNull(gson);
        this.pluginFactory = Objects.requireNonNull(pluginFactory);
        fileStore.createDirectory(APPS_DIR);
        fileStore.createDirectory(APPS_TMP_DIR);
    }

    @Override
    public List<AppResponse> getApps() {
        return this.dataService.findAll("sys_App", App.class).map(AppResponse::create).collect(Collectors.toList());
    }

    @Override
    public AppResponse getAppByName(String appName) {
        App app = (App)this.dataService.query("sys_App", App.class).eq("name", (Object)appName).findOne();
        if (app == null) {
            throw new AppForURIDoesNotExistException(appName);
        }
        return AppResponse.create(app);
    }

    @Override
    @Transactional
    public void activateApp(App app) {
        String pluginId = this.generatePluginId(app);
        Plugin plugin = (Plugin)this.pluginFactory.create((Object)pluginId);
        plugin.setLabel(app.getLabel());
        plugin.setPath(APP_PLUGIN_ROOT + app.getName());
        plugin.setDescription(app.getDescription());
        this.dataService.add("sys_Plugin", (Entity)plugin);
    }

    @Override
    @Transactional
    public void deactivateApp(App app) {
        String pluginId = this.generatePluginId(app);
        this.dataService.deleteById("sys_Plugin", (Object)pluginId);
    }

    @Override
    @Transactional
    public void deleteApp(String id) {
        App app = this.getAppById(id);
        if (app.isActive()) {
            this.deactivateApp(app);
        }
        try {
            FileUtils.deleteDirectory((File)this.fileStore.getFile(app.getResourceFolder()));
        }
        catch (IOException err) {
            throw new CouldNotDeleteAppException(id);
        }
    }

    @Override
    public String uploadApp(InputStream zipData, String zipFileName, String formFieldName) throws IOException {
        String tempFilesDir = "extracted_" + zipFileName;
        String tempAppDirectoryName = APPS_TMP_DIR + File.separator + tempFilesDir;
        this.fileStore.createDirectory(tempAppDirectoryName);
        try {
            ZipFileUtil.unzip((InputStream)zipData, (File)this.fileStore.getFile(tempAppDirectoryName));
        }
        catch (UnzipException unzipException) {
            this.fileStore.delete(tempAppDirectoryName);
            throw new InvalidAppArchiveException(formFieldName, (Exception)((Object)unzipException));
        }
        List<String> missingRequiredFilesList = this.buildMissingRequiredFiles(tempAppDirectoryName);
        if (!missingRequiredFilesList.isEmpty()) {
            this.fileStore.deleteDirectory(APPS_TMP_DIR);
            throw new AppArchiveMissingFilesException(missingRequiredFilesList);
        }
        return tempAppDirectoryName;
    }

    @Override
    public AppConfig checkAndObtainConfig(String tempDir, String configContent) throws IOException {
        if (configContent.isEmpty() || !this.isConfigContentValidJson(configContent)) {
            this.fileStore.deleteDirectory(APPS_TMP_DIR);
            throw new InvalidAppConfigException();
        }
        AppConfig appConfig = (AppConfig)this.gson.fromJson(configContent, AppConfig.class);
        List<String> missingAppConfigParams = this.buildMissingConfigParams(appConfig);
        if (!missingAppConfigParams.isEmpty()) {
            this.fileStore.deleteDirectory(APPS_TMP_DIR);
            throw new AppConfigMissingParametersException(missingAppConfigParams);
        }
        if (appConfig.getName().contains("/")) {
            this.fileStore.deleteDirectory(APPS_TMP_DIR);
            throw new IllegalAppNameException(appConfig.getName());
        }
        if (this.fileStore.getFile(APPS_DIR + File.separator + appConfig.getName()).exists()) {
            this.fileStore.deleteDirectory(APPS_TMP_DIR);
            throw new AppAlreadyExistsException(appConfig.getName());
        }
        this.fileStore.move(tempDir, APPS_DIR + File.separator + appConfig.getName());
        this.fileStore.deleteDirectory(APPS_TMP_DIR);
        return appConfig;
    }

    @Override
    @Transactional
    public void configureApp(AppConfig appConfig, String htmlTemplate) {
        String appDirName = APPS_DIR + File.separator + appConfig.getName();
        HashMap runtimeOptions = appConfig.getRuntimeOptions();
        if (runtimeOptions == null) {
            runtimeOptions = Maps.newHashMap();
        }
        App newApp = (App)this.appFactory.create();
        newApp.setLabel(appConfig.getLabel());
        newApp.setDescription(appConfig.getDescription());
        newApp.setAppVersion(appConfig.getVersion());
        newApp.setApiDependency(appConfig.getApiDependency());
        newApp.setTemplateContent(htmlTemplate);
        newApp.setActive(false);
        newApp.setIncludeMenuAndFooter(appConfig.getIncludeMenuAndFooter());
        newApp.setResourceFolder(appDirName);
        newApp.setAppConfig(this.gson.toJson((Object)runtimeOptions));
        newApp.setName(appConfig.getName());
        this.dataService.add("sys_App", (Entity)newApp);
    }

    @Override
    public String extractFileContent(String appDir, String fileName) {
        File indexFile = this.fileStore.getFile(appDir + File.separator + fileName);
        return this.utf8Encodedfiletostring(indexFile);
    }

    private String generatePluginId(App app) {
        return "app-" + app.getName();
    }

    private App getAppById(String id) {
        App app = (App)this.dataService.findOneById("sys_App", (Object)id, App.class);
        if (app == null) {
            throw new AppForIDDoesNotExistException(id);
        }
        return app;
    }

    private boolean isConfigContentValidJson(String configContent) {
        try {
            this.gson.fromJson(configContent, AppConfig.class);
        }
        catch (JsonSyntaxException e) {
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String utf8Encodedfiletostring(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            String string = IOUtils.toString((InputStream)fileInputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new InvalidAppConfigException();
        }
    }

    private List<String> buildMissingRequiredFiles(String appDirectoryName) {
        File configFile;
        ArrayList missingFromArchive = Lists.newArrayList();
        File indexFile = this.fileStore.getFile(appDirectoryName + File.separator + ZIP_INDEX_FILE);
        if (!indexFile.exists()) {
            missingFromArchive.add(ZIP_INDEX_FILE);
        }
        if (!(configFile = this.fileStore.getFile(appDirectoryName + File.separator + ZIP_CONFIG_FILE)).exists()) {
            missingFromArchive.add(ZIP_CONFIG_FILE);
        }
        return missingFromArchive;
    }

    private List<String> buildMissingConfigParams(AppConfig appConfig) {
        ArrayList missingConfigParameters = Lists.newArrayList();
        if (appConfig.getLabel() == null) {
            missingConfigParameters.add("label");
        }
        if (appConfig.getDescription() == null) {
            missingConfigParameters.add("description");
        }
        if (appConfig.getIncludeMenuAndFooter() == null) {
            missingConfigParameters.add("includeMenuAndFooter");
        }
        if (appConfig.getName() == null) {
            missingConfigParameters.add("name");
        }
        if (appConfig.getVersion() == null) {
            missingConfigParameters.add("version");
        }
        return missingConfigParameters;
    }
}

