package org.molgenis.app.manager.meta;

import static org.molgenis.app.manager.meta.AppMetadata.API_DEPENDENCY;
import static org.molgenis.app.manager.meta.AppMetadata.APP_CONFIG;
import static org.molgenis.app.manager.meta.AppMetadata.APP_VERSION;
import static org.molgenis.app.manager.meta.AppMetadata.DESCRIPTION;
import static org.molgenis.app.manager.meta.AppMetadata.ID;
import static org.molgenis.app.manager.meta.AppMetadata.INCLUDE_MENU_AND_FOOTER;
import static org.molgenis.app.manager.meta.AppMetadata.IS_ACTIVE;
import static org.molgenis.app.manager.meta.AppMetadata.LABEL;
import static org.molgenis.app.manager.meta.AppMetadata.NAME;
import static org.molgenis.app.manager.meta.AppMetadata.RESOURCE_FOLDER;
import static org.molgenis.app.manager.meta.AppMetadata.TEMPLATE_CONTENT;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.support.StaticEntity;

public class App extends StaticEntity {
  public App(Entity entity) {
    super(entity);
  }

  public App(EntityType entityType) {
    super(entityType);
  }

  public App(String label, EntityType entityType) {
    super(entityType);
    setLabel(label);
  }

  public String getId() {
    return getString(ID);
  }

  public void setId(String id) {
    set(ID, id);
  }

  public String getName() {
    return getString(NAME);
  }

  public void setName(String name) {
    set(NAME, name);
  }

  public String getLabel() {
    return getString(LABEL);
  }

  public void setLabel(String label) {
    set(LABEL, label);
  }

  @Nullable
  @CheckForNull
  public String getDescription() {
    return getString(DESCRIPTION);
  }

  public void setDescription(String description) {
    set(DESCRIPTION, description);
  }

  public boolean isActive() {
    return getBoolean(IS_ACTIVE);
  }

  public void setActive(boolean isActive) {
    set(IS_ACTIVE, isActive);
  }

  public boolean includeMenuAndFooter() {
    return getBoolean(INCLUDE_MENU_AND_FOOTER);
  }

  public void setIncludeMenuAndFooter(boolean includeMenuAndFooter) {
    set(INCLUDE_MENU_AND_FOOTER, includeMenuAndFooter);
  }

  public String getTemplateContent() {
    return getString(TEMPLATE_CONTENT);
  }

  public void setTemplateContent(String templateContent) {
    set(TEMPLATE_CONTENT, templateContent);
  }

  public String getAppVersion() {
    return getString(APP_VERSION);
  }

  public void setAppVersion(String appVersion) {
    set(APP_VERSION, appVersion);
  }

  public String getApiDependency() {
    return getString(API_DEPENDENCY);
  }

  public void setApiDependency(String apiDependency) {
    set(API_DEPENDENCY, apiDependency);
  }

  public String getAppConfig() {
    return getString(APP_CONFIG);
  }

  public void setAppConfig(String appConfig) {
    set(APP_CONFIG, appConfig);
  }

  public String getResourceFolder() {
    return getString(RESOURCE_FOLDER);
  }

  public void setResourceFolder(String resourceFolder) {
    set(RESOURCE_FOLDER, resourceFolder);
  }
}
