/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.app.manager.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.molgenis.app.manager.exception.AppIsInactiveException;
import org.molgenis.app.manager.model.AppResponse;
import org.molgenis.app.manager.service.AppManagerService;
import org.molgenis.data.file.FileStore;
import org.molgenis.data.plugin.model.PluginIdentity;
import org.molgenis.data.plugin.model.PluginPermission;
import org.molgenis.data.plugin.model.PluginPermissionDeniedException;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.UserPermissionEvaluator;
import org.molgenis.settings.AppSettings;
import org.molgenis.web.PluginController;
import org.molgenis.web.menu.MenuReaderService;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/plugin/app"})
public class AppController
extends PluginController {
    public static final String ID = "app";
    public static final String URI = "/plugin/app";
    private final FileStore fileStore;
    private final AppManagerService appManagerService;
    private final UserPermissionEvaluator userPermissionEvaluator;
    private final AppSettings appSettings;
    private final MenuReaderService menuReaderService;

    public AppController(AppManagerService appManagerService, UserPermissionEvaluator userPermissionEvaluator, AppSettings appSettings, MenuReaderService menuReaderService, FileStore fileStore) {
        super(URI);
        this.appManagerService = Objects.requireNonNull(appManagerService);
        this.userPermissionEvaluator = Objects.requireNonNull(userPermissionEvaluator);
        this.appSettings = Objects.requireNonNull(appSettings);
        this.menuReaderService = Objects.requireNonNull(menuReaderService);
        this.fileStore = Objects.requireNonNull(fileStore);
    }

    @GetMapping(value={"/{appName}/**"})
    @Nullable
    @CheckForNull
    public ModelAndView serveApp(@PathVariable String appName, Model model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PluginIdentity pluginIdentity = new PluginIdentity("app-" + appName);
        if (!this.userPermissionEvaluator.hasPermission((ObjectIdentity)pluginIdentity, (Permission)PluginPermission.VIEW_PLUGIN)) {
            throw new PluginPermissionDeniedException(appName, PluginPermission.VIEW_PLUGIN);
        }
        String wildCardPath = AppController.extractWildcardPath(request, appName);
        if (wildCardPath.isEmpty()) {
            RedirectView redirectView = new RedirectView(this.findAppMenuURL(appName));
            redirectView.setExposePathVariables(false);
            return new ModelAndView((View)redirectView);
        }
        AppResponse appResponse = this.appManagerService.getAppByName(appName);
        if (!appResponse.getIsActive()) {
            throw new AppIsInactiveException(appName);
        }
        if (AppController.isResourceRequest(wildCardPath)) {
            this.serveAppResource(response, wildCardPath, appResponse);
            return null;
        }
        return this.serveAppTemplate(appName, model, appResponse);
    }

    private static boolean isResourceRequest(String wildCardPath) {
        return wildCardPath.startsWith("/js/") || wildCardPath.startsWith("/css/") || wildCardPath.startsWith("/img/");
    }

    private ModelAndView serveAppTemplate(String appName, Model model, AppResponse appResponse) {
        model.addAttribute("baseUrl", (Object)this.findAppMenuURL(appName));
        model.addAttribute("template", (Object)appResponse.getTemplateContent());
        model.addAttribute("molgenis_app_version", (Object)appResponse.getVersion());
        model.addAttribute("lng", (Object)LocaleContextHolder.getLocale().getLanguage());
        model.addAttribute("fallbackLng", (Object)this.appSettings.getLanguageCode());
        model.addAttribute(ID, (Object)appResponse);
        return new ModelAndView("view-app");
    }

    private void serveAppResource(HttpServletResponse response, String wildCardPath, AppResponse appResponse) throws IOException {
        File requestedResource = this.fileStore.getFileUnchecked(appResponse.getResourceFolder() + wildCardPath);
        response.setContentType(AppController.guessMimeType(requestedResource.getName()));
        response.setContentLength((int)requestedResource.length());
        response.setHeader("Content-Disposition", "attachment; filename=" + requestedResource.getName().replace(" ", "_"));
        try (FileInputStream is = new FileInputStream(requestedResource);){
            FileCopyUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
        }
    }

    private static String extractWildcardPath(HttpServletRequest request, String key) {
        int index = request.getRequestURI().indexOf(key);
        return request.getRequestURI().substring(index + key.length());
    }

    private String findAppMenuURL(String appName) {
        return this.menuReaderService.findMenuItemPath("app-" + appName);
    }

    private static String guessMimeType(String fileName) {
        if (fileName.endsWith(".js")) {
            return "application/javascript;charset=UTF-8";
        }
        if (fileName.endsWith(".css")) {
            return "text/css;charset=UTF-8";
        }
        return URLConnection.guessContentTypeFromName(fileName);
    }
}

