/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.app.manager.controller;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.molgenis.app.manager.exception.CouldNotUploadAppException;
import org.molgenis.app.manager.meta.App;
import org.molgenis.app.manager.model.AppConfig;
import org.molgenis.app.manager.model.AppResponse;
import org.molgenis.app.manager.service.AppManagerService;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.web.PluginController;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/plugin/appmanager"})
public class AppManagerController
extends PluginController {
    public static final String ID = "appmanager";
    public static final String URI = "/plugin/appmanager";
    private final AppManagerService appManagerService;
    private final DataService dataService;

    public AppManagerController(AppManagerService appManagerService, DataService dataService) {
        super(URI);
        this.appManagerService = Objects.requireNonNull(appManagerService);
        this.dataService = Objects.requireNonNull(dataService);
    }

    @GetMapping
    public String init() {
        return "view-app-manager";
    }

    @ResponseBody
    @GetMapping(value={"/apps"})
    public List<AppResponse> getApps() {
        return this.appManagerService.getApps();
    }

    @ResponseStatus(value=HttpStatus.OK)
    @PostMapping(value={"/activate/{id}"})
    public void activateApp(@PathVariable(value="id") String id) {
        App app = this.getApp(id);
        app.setActive(true);
        this.dataService.update("sys_App", (Entity)app);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @PostMapping(value={"/deactivate/{id}"})
    public void deactivateApp(@PathVariable(value="id") String id) {
        App app = this.getApp(id);
        app.setActive(false);
        this.dataService.update("sys_App", (Entity)app);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @DeleteMapping(value={"/delete/{id}"})
    public void deleteApp(@PathVariable(value="id") String id) {
        this.dataService.deleteById("sys_App", (Object)id);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @PostMapping(value={"/upload"})
    public void uploadApp(@RequestParam(value="file") MultipartFile multipartFile) {
        String filename = multipartFile.getOriginalFilename();
        String formFieldName = multipartFile.getName();
        try (InputStream fileInputStream = multipartFile.getInputStream();){
            String tempDir = this.appManagerService.uploadApp(fileInputStream, filename, formFieldName);
            String configFile = this.appManagerService.extractFileContent(tempDir, "config.json");
            AppConfig appConfig = this.appManagerService.checkAndObtainConfig(tempDir, configFile);
            String htmlTemplate = this.appManagerService.extractFileContent("apps" + File.separator + appConfig.getName(), "index.html");
            this.appManagerService.configureApp(appConfig, htmlTemplate);
        }
        catch (IOException err) {
            throw new CouldNotUploadAppException(filename);
        }
    }

    private App getApp(String id) {
        App app = (App)this.dataService.findOneById("sys_App", (Object)id, App.class);
        if (app == null) {
            throw new UnknownEntityException("sys_App", (Object)id);
        }
        return app;
    }
}

