
package org.molgenis;

import javax.persistence.EntityManagerFactory;

import org.molgenis.omx.ngs.Project;	
import org.molgenis.omx.ngs.NgsUser;	
import org.molgenis.omx.ngs.Sample;	
import org.molgenis.omx.ngs.FlowcellLane;	
import org.molgenis.omx.ngs.Flowcell;	
import org.molgenis.omx.ngs.SampleBarcode;	
import org.molgenis.omx.ngs.SampleBarcodeType;	
import org.molgenis.omx.ngs.CapturingKit;	
import org.molgenis.omx.ngs.PrepKit;	
import org.molgenis.omx.ngs.Machine;	
import org.molgenis.omx.core.MolgenisEntity;	
import org.molgenis.omx.core.MolgenisFile;	
import org.molgenis.omx.core.RuntimeProperty;	
import org.molgenis.omx.observ.Characteristic;	
import org.molgenis.omx.observ.ObservationTarget;	
import org.molgenis.omx.observ.ObservableFeature;	
import org.molgenis.omx.observ.Category;	
import org.molgenis.omx.observ.Protocol;	
import org.molgenis.omx.observ.DataSet;	
import org.molgenis.omx.observ.ObservationSet;	
import org.molgenis.omx.observ.ObservedValue;	
import org.molgenis.omx.observ.target.Species;	
import org.molgenis.omx.observ.target.Individual;	
import org.molgenis.omx.observ.target.Panel;	
import org.molgenis.omx.observ.target.PanelSource;	
import org.molgenis.omx.observ.target.Ontology;	
import org.molgenis.omx.observ.target.OntologyTerm;	
import org.molgenis.omx.observ.target.Accession;	
import org.molgenis.omx.observ.value.Value;	
import org.molgenis.omx.observ.value.BoolValue;	
import org.molgenis.omx.observ.value.CategoricalValue;	
import org.molgenis.omx.observ.value.DateValue;	
import org.molgenis.omx.observ.value.DateTimeValue;	
import org.molgenis.omx.observ.value.DecimalValue;	
import org.molgenis.omx.observ.value.EmailValue;	
import org.molgenis.omx.observ.value.HtmlValue;	
import org.molgenis.omx.observ.value.HyperlinkValue;	
import org.molgenis.omx.observ.value.IntValue;	
import org.molgenis.omx.observ.value.LongValue;	
import org.molgenis.omx.observ.value.MrefValue;	
import org.molgenis.omx.observ.value.StringValue;	
import org.molgenis.omx.observ.value.TextValue;	
import org.molgenis.omx.observ.value.XrefValue;	
import org.molgenis.omx.auth.MolgenisRole;	
import org.molgenis.omx.auth.MolgenisGroup;	
import org.molgenis.omx.auth.MolgenisRoleGroupLink;	
import org.molgenis.omx.auth.Person;	
import org.molgenis.omx.auth.PersonRole;	
import org.molgenis.omx.auth.Institute;	
import org.molgenis.omx.auth.MolgenisUser;	
import org.molgenis.omx.auth.MolgenisPermission;	
import org.molgenis.omx.ngs.Project_ProjectAnalist;	
import org.molgenis.omx.ngs.Sample_SampleInPool;	

import org.springframework.beans.factory.annotation.Autowired;

public class JpaDatabase extends org.molgenis.framework.db.jpa.JpaDatabase
{    
	@Autowired
	public JpaDatabase(EntityManagerFactory entityManagerFactory) throws org.molgenis.framework.db.DatabaseException
	{
		super(entityManagerFactory.createEntityManager(), new JDBCMetaDatabase());
        initMappers();
	}
	    
	private void initMappers()
	{
		this.putMapper(Project.class, new org.molgenis.omx.ngs.db.ProjectSecurityDecorator<Project>(new org.molgenis.omx.ngs.db.ProjectJpaMapper(this)));
		this.putMapper(NgsUser.class, new org.molgenis.omx.ngs.db.NgsUserSecurityDecorator<NgsUser>(new org.molgenis.omx.ngs.db.NgsUserJpaMapper(this)));
		this.putMapper(Sample.class, new org.molgenis.omx.ngs.db.SampleSecurityDecorator<Sample>(new org.molgenis.omx.ngs.db.SampleJpaMapper(this)));
		this.putMapper(FlowcellLane.class, new org.molgenis.omx.ngs.db.FlowcellLaneSecurityDecorator<FlowcellLane>(new org.molgenis.omx.ngs.db.FlowcellLaneJpaMapper(this)));
		this.putMapper(Flowcell.class, new org.molgenis.omx.ngs.db.FlowcellSecurityDecorator<Flowcell>(new org.molgenis.omx.ngs.db.FlowcellJpaMapper(this)));
		this.putMapper(SampleBarcode.class, new org.molgenis.omx.ngs.db.SampleBarcodeSecurityDecorator<SampleBarcode>(new org.molgenis.omx.ngs.db.SampleBarcodeJpaMapper(this)));
		this.putMapper(SampleBarcodeType.class, new org.molgenis.omx.ngs.db.SampleBarcodeTypeSecurityDecorator<SampleBarcodeType>(new org.molgenis.omx.ngs.db.SampleBarcodeTypeJpaMapper(this)));
		this.putMapper(CapturingKit.class, new org.molgenis.omx.ngs.db.CapturingKitSecurityDecorator<CapturingKit>(new org.molgenis.omx.ngs.db.CapturingKitJpaMapper(this)));
		this.putMapper(PrepKit.class, new org.molgenis.omx.ngs.db.PrepKitSecurityDecorator<PrepKit>(new org.molgenis.omx.ngs.db.PrepKitJpaMapper(this)));
		this.putMapper(Machine.class, new org.molgenis.omx.ngs.db.MachineSecurityDecorator<Machine>(new org.molgenis.omx.ngs.db.MachineJpaMapper(this)));
		this.putMapper(MolgenisEntity.class, new org.molgenis.omx.core.db.MolgenisEntitySecurityDecorator<MolgenisEntity>(new org.molgenis.omx.core.db.MolgenisEntityJpaMapper(this)));
		this.putMapper(MolgenisFile.class, new org.molgenis.omx.decorators.MolgenisFileDecorator<MolgenisFile>(new org.molgenis.omx.core.db.MolgenisFileSecurityDecorator<MolgenisFile>(new org.molgenis.omx.core.db.MolgenisFileJpaMapper(this))));
		this.putMapper(RuntimeProperty.class, new org.molgenis.omx.core.db.RuntimePropertySecurityDecorator<RuntimeProperty>(new org.molgenis.omx.core.db.RuntimePropertyJpaMapper(this)));
		this.putMapper(Characteristic.class, new org.molgenis.omx.observ.db.CharacteristicSecurityDecorator<Characteristic>(new org.molgenis.omx.observ.db.CharacteristicJpaMapper(this)));
		this.putMapper(ObservationTarget.class, new org.molgenis.omx.observ.db.ObservationTargetSecurityDecorator<ObservationTarget>(new org.molgenis.omx.observ.db.ObservationTargetJpaMapper(this)));
		this.putMapper(ObservableFeature.class, new org.molgenis.omx.observ.db.ObservableFeatureSecurityDecorator<ObservableFeature>(new org.molgenis.omx.observ.db.ObservableFeatureJpaMapper(this)));
		this.putMapper(Category.class, new org.molgenis.omx.observ.db.CategorySecurityDecorator<Category>(new org.molgenis.omx.observ.db.CategoryJpaMapper(this)));
		this.putMapper(Protocol.class, new org.molgenis.omx.observ.db.ProtocolSecurityDecorator<Protocol>(new org.molgenis.omx.observ.db.ProtocolJpaMapper(this)));
		this.putMapper(DataSet.class, new org.molgenis.omx.observ.db.DataSetSecurityDecorator<DataSet>(new org.molgenis.omx.observ.db.DataSetJpaMapper(this)));
		this.putMapper(ObservationSet.class, new org.molgenis.omx.observ.db.ObservationSetSecurityDecorator<ObservationSet>(new org.molgenis.omx.observ.db.ObservationSetJpaMapper(this)));
		this.putMapper(ObservedValue.class, new org.molgenis.omx.observ.db.ObservedValueSecurityDecorator<ObservedValue>(new org.molgenis.omx.observ.db.ObservedValueJpaMapper(this)));
		this.putMapper(Species.class, new org.molgenis.omx.observ.target.db.SpeciesSecurityDecorator<Species>(new org.molgenis.omx.observ.target.db.SpeciesJpaMapper(this)));
		this.putMapper(Individual.class, new org.molgenis.omx.observ.target.db.IndividualSecurityDecorator<Individual>(new org.molgenis.omx.observ.target.db.IndividualJpaMapper(this)));
		this.putMapper(Panel.class, new org.molgenis.omx.observ.target.db.PanelSecurityDecorator<Panel>(new org.molgenis.omx.observ.target.db.PanelJpaMapper(this)));
		this.putMapper(PanelSource.class, new org.molgenis.omx.observ.target.db.PanelSourceSecurityDecorator<PanelSource>(new org.molgenis.omx.observ.target.db.PanelSourceJpaMapper(this)));
		this.putMapper(Ontology.class, new org.molgenis.omx.observ.target.db.OntologySecurityDecorator<Ontology>(new org.molgenis.omx.observ.target.db.OntologyJpaMapper(this)));
		this.putMapper(OntologyTerm.class, new org.molgenis.omx.observ.target.db.OntologyTermSecurityDecorator<OntologyTerm>(new org.molgenis.omx.observ.target.db.OntologyTermJpaMapper(this)));
		this.putMapper(Accession.class, new org.molgenis.omx.observ.target.db.AccessionSecurityDecorator<Accession>(new org.molgenis.omx.observ.target.db.AccessionJpaMapper(this)));
		this.putMapper(Value.class, new org.molgenis.omx.observ.value.db.ValueSecurityDecorator<Value>(new org.molgenis.omx.observ.value.db.ValueJpaMapper(this)));
		this.putMapper(BoolValue.class, new org.molgenis.omx.observ.value.db.BoolValueSecurityDecorator<BoolValue>(new org.molgenis.omx.observ.value.db.BoolValueJpaMapper(this)));
		this.putMapper(CategoricalValue.class, new org.molgenis.omx.observ.value.db.CategoricalValueSecurityDecorator<CategoricalValue>(new org.molgenis.omx.observ.value.db.CategoricalValueJpaMapper(this)));
		this.putMapper(DateValue.class, new org.molgenis.omx.observ.value.db.DateValueSecurityDecorator<DateValue>(new org.molgenis.omx.observ.value.db.DateValueJpaMapper(this)));
		this.putMapper(DateTimeValue.class, new org.molgenis.omx.observ.value.db.DateTimeValueSecurityDecorator<DateTimeValue>(new org.molgenis.omx.observ.value.db.DateTimeValueJpaMapper(this)));
		this.putMapper(DecimalValue.class, new org.molgenis.omx.observ.value.db.DecimalValueSecurityDecorator<DecimalValue>(new org.molgenis.omx.observ.value.db.DecimalValueJpaMapper(this)));
		this.putMapper(EmailValue.class, new org.molgenis.omx.decorators.EmailValueDecorator<EmailValue>(new org.molgenis.omx.observ.value.db.EmailValueSecurityDecorator<EmailValue>(new org.molgenis.omx.observ.value.db.EmailValueJpaMapper(this))));
		this.putMapper(HtmlValue.class, new org.molgenis.omx.observ.value.db.HtmlValueSecurityDecorator<HtmlValue>(new org.molgenis.omx.observ.value.db.HtmlValueJpaMapper(this)));
		this.putMapper(HyperlinkValue.class, new org.molgenis.omx.decorators.HyperlinkValueDecorator<HyperlinkValue>(new org.molgenis.omx.observ.value.db.HyperlinkValueSecurityDecorator<HyperlinkValue>(new org.molgenis.omx.observ.value.db.HyperlinkValueJpaMapper(this))));
		this.putMapper(IntValue.class, new org.molgenis.omx.observ.value.db.IntValueSecurityDecorator<IntValue>(new org.molgenis.omx.observ.value.db.IntValueJpaMapper(this)));
		this.putMapper(LongValue.class, new org.molgenis.omx.observ.value.db.LongValueSecurityDecorator<LongValue>(new org.molgenis.omx.observ.value.db.LongValueJpaMapper(this)));
		this.putMapper(MrefValue.class, new org.molgenis.omx.observ.value.db.MrefValueSecurityDecorator<MrefValue>(new org.molgenis.omx.observ.value.db.MrefValueJpaMapper(this)));
		this.putMapper(StringValue.class, new org.molgenis.omx.observ.value.db.StringValueSecurityDecorator<StringValue>(new org.molgenis.omx.observ.value.db.StringValueJpaMapper(this)));
		this.putMapper(TextValue.class, new org.molgenis.omx.observ.value.db.TextValueSecurityDecorator<TextValue>(new org.molgenis.omx.observ.value.db.TextValueJpaMapper(this)));
		this.putMapper(XrefValue.class, new org.molgenis.omx.observ.value.db.XrefValueSecurityDecorator<XrefValue>(new org.molgenis.omx.observ.value.db.XrefValueJpaMapper(this)));
		this.putMapper(MolgenisRole.class, new org.molgenis.omx.auth.db.MolgenisRoleSecurityDecorator<MolgenisRole>(new org.molgenis.omx.auth.db.MolgenisRoleJpaMapper(this)));
		this.putMapper(MolgenisGroup.class, new org.molgenis.omx.auth.db.MolgenisGroupSecurityDecorator<MolgenisGroup>(new org.molgenis.omx.auth.db.MolgenisGroupJpaMapper(this)));
		this.putMapper(MolgenisRoleGroupLink.class, new org.molgenis.omx.auth.db.MolgenisRoleGroupLinkSecurityDecorator<MolgenisRoleGroupLink>(new org.molgenis.omx.auth.db.MolgenisRoleGroupLinkJpaMapper(this)));
		this.putMapper(Person.class, new org.molgenis.omx.auth.db.PersonSecurityDecorator<Person>(new org.molgenis.omx.auth.db.PersonJpaMapper(this)));
		this.putMapper(PersonRole.class, new org.molgenis.omx.auth.db.PersonRoleSecurityDecorator<PersonRole>(new org.molgenis.omx.auth.db.PersonRoleJpaMapper(this)));
		this.putMapper(Institute.class, new org.molgenis.omx.auth.db.InstituteSecurityDecorator<Institute>(new org.molgenis.omx.auth.db.InstituteJpaMapper(this)));
		this.putMapper(MolgenisUser.class, new org.molgenis.omx.auth.decorators.MolgenisUserDecorator<MolgenisUser>(new org.molgenis.omx.auth.db.MolgenisUserSecurityDecorator<MolgenisUser>(new org.molgenis.omx.auth.db.MolgenisUserJpaMapper(this))));
		this.putMapper(MolgenisPermission.class, new org.molgenis.omx.auth.db.MolgenisPermissionSecurityDecorator<MolgenisPermission>(new org.molgenis.omx.auth.db.MolgenisPermissionJpaMapper(this)));
		this.putMapper(Project_ProjectAnalist.class, new org.molgenis.omx.ngs.db.Project_ProjectAnalistSecurityDecorator<Project_ProjectAnalist>(new org.molgenis.omx.ngs.db.Project_ProjectAnalistJpaMapper(this)));
		this.putMapper(Sample_SampleInPool.class, new org.molgenis.omx.ngs.db.Sample_SampleInPoolSecurityDecorator<Sample_SampleInPool>(new org.molgenis.omx.ngs.db.Sample_SampleInPoolJpaMapper(this)));
	}
}
