/* File:        ngs/model/Project.java
 * Copyright:   GBIC 2000-2,013, all rights reserved
 * Date:        August 21, 2013
 * Template:	JpaMapperGen.java.ftl
 * generator:   org.molgenis.generators.db.JpaMapperGen 4.0.0-testing
 *
 * Jpa Entity Mapper, helper to add, delete and update entities
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.ngs.db;

@edu.umd.cs.findbugs.annotations.SuppressWarnings(value = "DLS_DEAD_LOCAL_STORE", justification = "Too much template code required to prevent warnings")
public class ProjectJpaMapper extends org.molgenis.framework.db.jpa.AbstractJpaMapper<org.molgenis.omx.ngs.Project>
{
	private final static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(ProjectJpaMapper.class);

	public ProjectJpaMapper(org.molgenis.framework.db.Database db) 
	{
		super(db);
	}
	
	@Override
	public String createFindSqlInclRules(org.molgenis.framework.db.QueryRule[] rules) throws org.molgenis.framework.db.DatabaseException
	{
		return "SELECT Project.id"
			+", Project.ProjectName"
			+", Project.ProjectComment"
			+", Project.ProjectCustomer"
			+", Project.ProjectPlannedFinishDate"
			+", Project.LaneAmount"
			+", Project.SampleAmount"
			+", Project.SampleType"
			+", Project.SeqType"
			+", Project.PrepKit"
			+", Project.DeclarationNr"
			+", Project.GccAnalysis"
			+", Project.GccInstructions"
			+", Project.ResultFilesDir"
			+", Project.ResultShippedUser"
			+", Project.ResultShippedTo"
			+", Project.ResultShippedDate"
			//parent is SimpleTree(name='ProjectCustomer')
			+", xref_ProjectCustomer.UserName AS ProjectCustomer_UserName"
			//parent is SimpleTree(name='PrepKit')
			+", xref_PrepKit.PrepKitName AS PrepKit_PrepKitName"
			//parent is SimpleTree(name='ResultShippedUser')
			+", xref_ResultShippedUser.UserName AS ResultShippedUser_UserName"
			//parent is SimpleTree(name='ResultShippedTo')
			+", xref_ResultShippedTo.UserName AS ResultShippedTo_UserName"
			+" FROM Project "

			
			//label for ProjectCustomer=UserName
//path==ProjectCustomer. type==xref.
//path==ProjectCustomer_UserName. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN NgsUser AS xref_ProjectCustomer " 
			+" ON xref_ProjectCustomer.id = Project.ProjectCustomer"
			
			//label for PrepKit=PrepKitName
//path==PrepKit. type==xref.
//path==PrepKit_PrepKitName. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN PrepKit AS xref_PrepKit " 
			+" ON xref_PrepKit.id = Project.PrepKit"
			
			//label for ResultShippedUser=UserName
//path==ResultShippedUser. type==xref.
//path==ResultShippedUser_UserName. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN NgsUser AS xref_ResultShippedUser " 
			+" ON xref_ResultShippedUser.id = Project.ResultShippedUser"
			
			//label for ResultShippedTo=UserName
//path==ResultShippedTo. type==xref.
//path==ResultShippedTo_UserName. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN NgsUser AS xref_ResultShippedTo " 
			+" ON xref_ResultShippedTo.id = Project.ResultShippedTo"
;
	}	

	/** This method first saves the objects that are being refered to by entity, 
	then the entity itself and 
	finally the objects that refer to this object*/
    public void create(org.molgenis.omx.ngs.Project entity) throws org.molgenis.framework.db.DatabaseException {
        try {


			//check if the object refered by 'ProjectCustomer' is known in the databse
			if(entity.getProjectCustomer() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getProjectCustomer().getIdValue() == null)
					new org.molgenis.omx.ngs.db.NgsUserJpaMapper(getDatabase()).create(entity.getProjectCustomer());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getProjectCustomer()) && entity.getProjectCustomer().getIdValue() != null)
					entity.setProjectCustomer(getEntityManager().getReference(org.molgenis.omx.ngs.NgsUser.class, entity.getProjectCustomer().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getProjectCustomer_Id() != null) {
					entity.setProjectCustomer((org.molgenis.omx.ngs.NgsUser)getEntityManager().find(org.molgenis.omx.ngs.NgsUser.class, entity.getProjectCustomer_Id()));
				}
			}
	    java.util.List<org.molgenis.omx.ngs.NgsUser> projectAnalistList = entity.getProjectAnalist();
	    java.util.List<Integer> projectAnalistIds = entity.getProjectAnalist_Id();
	    for(Integer projectAnalistId : projectAnalistIds) {
		org.molgenis.omx.ngs.NgsUser ngsUser = getEntityManager().getReference(org.molgenis.omx.ngs.NgsUser.class, projectAnalistId);
		if(!projectAnalistList.contains(ngsUser))
		    projectAnalistList.add(ngsUser);
	    }
	    entity.setProjectAnalist(projectAnalistList);
			//check if the object refered by 'PrepKit' is known in the databse
			if(entity.getPrepKit() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getPrepKit().getIdValue() == null)
					new org.molgenis.omx.ngs.db.PrepKitJpaMapper(getDatabase()).create(entity.getPrepKit());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getPrepKit()) && entity.getPrepKit().getIdValue() != null)
					entity.setPrepKit(getEntityManager().getReference(org.molgenis.omx.ngs.PrepKit.class, entity.getPrepKit().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getPrepKit_Id() != null) {
					entity.setPrepKit((org.molgenis.omx.ngs.PrepKit)getEntityManager().find(org.molgenis.omx.ngs.PrepKit.class, entity.getPrepKit_Id()));
				}
			}
			//check if the object refered by 'ResultShippedUser' is known in the databse
			if(entity.getResultShippedUser() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getResultShippedUser().getIdValue() == null)
					new org.molgenis.omx.ngs.db.NgsUserJpaMapper(getDatabase()).create(entity.getResultShippedUser());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getResultShippedUser()) && entity.getResultShippedUser().getIdValue() != null)
					entity.setResultShippedUser(getEntityManager().getReference(org.molgenis.omx.ngs.NgsUser.class, entity.getResultShippedUser().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getResultShippedUser_Id() != null) {
					entity.setResultShippedUser((org.molgenis.omx.ngs.NgsUser)getEntityManager().find(org.molgenis.omx.ngs.NgsUser.class, entity.getResultShippedUser_Id()));
				}
			}
			//check if the object refered by 'ResultShippedTo' is known in the databse
			if(entity.getResultShippedTo() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getResultShippedTo().getIdValue() == null)
					new org.molgenis.omx.ngs.db.NgsUserJpaMapper(getDatabase()).create(entity.getResultShippedTo());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getResultShippedTo()) && entity.getResultShippedTo().getIdValue() != null)
					entity.setResultShippedTo(getEntityManager().getReference(org.molgenis.omx.ngs.NgsUser.class, entity.getResultShippedTo().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getResultShippedTo_Id() != null) {
					entity.setResultShippedTo((org.molgenis.omx.ngs.NgsUser)getEntityManager().find(org.molgenis.omx.ngs.NgsUser.class, entity.getResultShippedTo_Id()));
				}
			}

			//prevents uncontrolled recursion call of create (stack overflow)
          
          if(entity.getIdValue() != null) {
            entity = getEntityManager().merge(entity);            
          } else {
            getEntityManager().persist(entity);
          }
//inverse association relation

        } catch (Exception ex) {
            try {
				getEntityManager().getTransaction().rollback();
            } catch (Exception re) {
                throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
            }
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
    }

	public void destroy(org.molgenis.omx.ngs.Project project) throws org.molgenis.framework.db.DatabaseException {
		try {
			try {
				project = getEntityManager().getReference(org.molgenis.omx.ngs.Project.class, project.getIdValue());
			} catch (javax.persistence.EntityNotFoundException enfe) {
				throw new org.molgenis.framework.db.DatabaseException("The project with id " + project.getIdField().toString() + " no longer exists: " + enfe.getMessage());
			}

			getEntityManager().remove(project);
		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}


	public void edit(org.molgenis.omx.ngs.Project project) throws org.molgenis.framework.db.DatabaseException {
		try {





			//7
			org.molgenis.omx.ngs.NgsUser projectCustomerNew = project.getProjectCustomer();

			if (projectCustomerNew == null) { //object is reference by xref		
                            if(project.getProjectCustomer_Id() != null) {
                                project.setProjectCustomer((org.molgenis.omx.ngs.NgsUser)getEntityManager().find(org.molgenis.omx.ngs.NgsUser.class, project.getProjectCustomer_Id()));
                            }
			}


			//7
			for(org.molgenis.omx.ngs.NgsUser m : project.getProjectAnalist()) {
				if(m.getId() == null) {
					getEntityManager().persist(m);
				}
			}
			
			for(Integer id : project.getProjectAnalist_Id()) {
				org.molgenis.omx.ngs.NgsUser mref = getEntityManager().find(org.molgenis.omx.ngs.NgsUser.class, id);
				if(!project.getProjectAnalist().contains(mref)) {
					project.getProjectAnalist().add(mref);
				}
			}    







			//1
			org.molgenis.omx.ngs.PrepKit prepKitNew = project.getPrepKit();

			if (prepKitNew == null) { //object is reference by xref		
                            if(project.getPrepKit_Id() != null) {
                                project.setPrepKit((org.molgenis.omx.ngs.PrepKit)getEntityManager().find(org.molgenis.omx.ngs.PrepKit.class, project.getPrepKit_Id()));
                            }
			}






			//7
			org.molgenis.omx.ngs.NgsUser resultShippedUserNew = project.getResultShippedUser();

			if (resultShippedUserNew == null) { //object is reference by xref		
                            if(project.getResultShippedUser_Id() != null) {
                                project.setResultShippedUser((org.molgenis.omx.ngs.NgsUser)getEntityManager().find(org.molgenis.omx.ngs.NgsUser.class, project.getResultShippedUser_Id()));
                            }
			}


			//7
			org.molgenis.omx.ngs.NgsUser resultShippedToNew = project.getResultShippedTo();

			if (resultShippedToNew == null) { //object is reference by xref		
                            if(project.getResultShippedTo_Id() != null) {
                                project.setResultShippedTo((org.molgenis.omx.ngs.NgsUser)getEntityManager().find(org.molgenis.omx.ngs.NgsUser.class, project.getResultShippedTo_Id()));
                            }
			}

			if(!getEntityManager().contains(project)) {
				project = getEntityManager().merge(project);
			}
			




		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: " + re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}

	@Override
	public int executeAdd(java.util.List<? extends org.molgenis.omx.ngs.Project> entities) throws org.molgenis.framework.db.DatabaseException
	{	
		int count = 0;
		
		try 
		{
			for (org.molgenis.omx.ngs.Project project : entities) 
			{
				create(project);
				++count;
			}
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}

	@Override
	public int executeUpdate(java.util.List<? extends org.molgenis.omx.ngs.Project> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;

		try
		{
			for (org.molgenis.omx.ngs.Project project : entities) 
			{
				edit(project);
				++count;
			} 
			return count;
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }		
	}

	@Override
	public int executeRemove(java.util.List<? extends org.molgenis.omx.ngs.Project> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;		
		try 
		{
			for (org.molgenis.omx.ngs.Project project : entities) 
			{
				destroy(project);
				++count;
			}
		} 
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}
	
	@Override
	public String getTableFieldName(String fieldName)
	{
		if("id".equalsIgnoreCase(fieldName)) return "id";
		if("Project_id".equalsIgnoreCase(fieldName)) return "id";
		if("ProjectName".equalsIgnoreCase(fieldName)) return "ProjectName";
		if("Project_ProjectName".equalsIgnoreCase(fieldName)) return "ProjectName";
		if("ProjectComment".equalsIgnoreCase(fieldName)) return "ProjectComment";
		if("Project_ProjectComment".equalsIgnoreCase(fieldName)) return "ProjectComment";
		if("ProjectCustomer".equalsIgnoreCase(fieldName)) return "ProjectCustomer";
		if("Project_ProjectCustomer".equalsIgnoreCase(fieldName)) return "ProjectCustomer";
		if("ProjectPlannedFinishDate".equalsIgnoreCase(fieldName)) return "ProjectPlannedFinishDate";
		if("Project_ProjectPlannedFinishDate".equalsIgnoreCase(fieldName)) return "ProjectPlannedFinishDate";
		if("LaneAmount".equalsIgnoreCase(fieldName)) return "LaneAmount";
		if("Project_LaneAmount".equalsIgnoreCase(fieldName)) return "LaneAmount";
		if("SampleAmount".equalsIgnoreCase(fieldName)) return "SampleAmount";
		if("Project_SampleAmount".equalsIgnoreCase(fieldName)) return "SampleAmount";
		if("SampleType".equalsIgnoreCase(fieldName)) return "SampleType";
		if("Project_SampleType".equalsIgnoreCase(fieldName)) return "SampleType";
		if("SeqType".equalsIgnoreCase(fieldName)) return "SeqType";
		if("Project_SeqType".equalsIgnoreCase(fieldName)) return "SeqType";
		if("PrepKit".equalsIgnoreCase(fieldName)) return "PrepKit";
		if("Project_PrepKit".equalsIgnoreCase(fieldName)) return "PrepKit";
		if("DeclarationNr".equalsIgnoreCase(fieldName)) return "DeclarationNr";
		if("Project_DeclarationNr".equalsIgnoreCase(fieldName)) return "DeclarationNr";
		if("GccAnalysis".equalsIgnoreCase(fieldName)) return "GccAnalysis";
		if("Project_GccAnalysis".equalsIgnoreCase(fieldName)) return "GccAnalysis";
		if("GccInstructions".equalsIgnoreCase(fieldName)) return "GccInstructions";
		if("Project_GccInstructions".equalsIgnoreCase(fieldName)) return "GccInstructions";
		if("ResultFilesDir".equalsIgnoreCase(fieldName)) return "ResultFilesDir";
		if("Project_ResultFilesDir".equalsIgnoreCase(fieldName)) return "ResultFilesDir";
		if("ResultShippedUser".equalsIgnoreCase(fieldName)) return "ResultShippedUser";
		if("Project_ResultShippedUser".equalsIgnoreCase(fieldName)) return "ResultShippedUser";
		if("ResultShippedTo".equalsIgnoreCase(fieldName)) return "ResultShippedTo";
		if("Project_ResultShippedTo".equalsIgnoreCase(fieldName)) return "ResultShippedTo";
		if("ResultShippedDate".equalsIgnoreCase(fieldName)) return "ResultShippedDate";
		if("Project_ResultShippedDate".equalsIgnoreCase(fieldName)) return "ResultShippedDate";
		if("ProjectCustomer_id".equalsIgnoreCase(fieldName)) return "ProjectCustomer";
		if("Project_ProjectCustomer_id".equalsIgnoreCase(fieldName)) return "ProjectCustomer";
		if("ProjectCustomer_UserName".equalsIgnoreCase(fieldName)) return "ProjectCustomer.UserName";	
		if("Project_ProjectCustomer_UserName".equalsIgnoreCase(fieldName)) return "ProjectCustomer.UserName";
		if("PrepKit_id".equalsIgnoreCase(fieldName)) return "PrepKit";
		if("Project_PrepKit_id".equalsIgnoreCase(fieldName)) return "PrepKit";
		if("PrepKit_PrepKitName".equalsIgnoreCase(fieldName)) return "PrepKit.PrepKitName";	
		if("Project_PrepKit_PrepKitName".equalsIgnoreCase(fieldName)) return "PrepKit.PrepKitName";
		if("ResultShippedUser_id".equalsIgnoreCase(fieldName)) return "ResultShippedUser";
		if("Project_ResultShippedUser_id".equalsIgnoreCase(fieldName)) return "ResultShippedUser";
		if("ResultShippedUser_UserName".equalsIgnoreCase(fieldName)) return "ResultShippedUser.UserName";	
		if("Project_ResultShippedUser_UserName".equalsIgnoreCase(fieldName)) return "ResultShippedUser.UserName";
		if("ResultShippedTo_id".equalsIgnoreCase(fieldName)) return "ResultShippedTo";
		if("Project_ResultShippedTo_id".equalsIgnoreCase(fieldName)) return "ResultShippedTo";
		if("ResultShippedTo_UserName".equalsIgnoreCase(fieldName)) return "ResultShippedTo.UserName";	
		if("Project_ResultShippedTo_UserName".equalsIgnoreCase(fieldName)) return "ResultShippedTo.UserName";
		return fieldName;
	}
	
	/**
	 * Return EMPTY list of given allocated size
	 *
	 * @param i initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	@Override
	public java.util.List<org.molgenis.omx.ngs.Project> createList(int size)
	{
		return new java.util.ArrayList<org.molgenis.omx.ngs.Project>(size);
	}			

	@Override
	public org.molgenis.omx.ngs.Project create()
	{
		return new org.molgenis.omx.ngs.Project();
	}

	@Override
	//Resolve
	public void resolveForeignKeys(java.util.List<org.molgenis.omx.ngs.Project> entities)  throws org.molgenis.framework.db.DatabaseException, java.text.ParseException
	{
		//create foreign key map for field 'projectCustomer' to ngsUser.id using UserName)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> projectCustomerRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'projectAnalist' to ngsUser.id using UserName)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> projectAnalistRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'prepKit' to prepKit.id using PrepKitName)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> prepKitRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'resultShippedUser' to ngsUser.id using UserName)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> resultShippedUserRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'resultShippedTo' to ngsUser.id using UserName)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> resultShippedToRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create all query rules	
		for(org.molgenis.omx.ngs.Project object: entities)
		{
			//create xref/mref rule filtering NgsUser on the label UserName
			if(object.getProjectCustomer_Id() == null && object.getProjectCustomer_UserName() != null)
			{
				Object label = object.getProjectCustomer_UserName();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("UserName", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(label != null && !projectCustomerRules.containsKey(label))
					{
						projectCustomerRules.put(""+label, xrefFilter);
						projectCustomerRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering NgsUser on the label UserName
			if(object.getProjectAnalist_Id().size() == 0 && object.getProjectAnalist_UserName().size() > 0)
			{
				for(Object label: object.getProjectAnalist_UserName())
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("UserName", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(label != null && !projectAnalistRules.containsKey(label))
					{
						projectAnalistRules.put(""+label, xrefFilter);
						projectAnalistRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering PrepKit on the label PrepKitName
			if(object.getPrepKit_Id() == null && object.getPrepKit_PrepKitName() != null)
			{
				Object label = object.getPrepKit_PrepKitName();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("PrepKitName", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(label != null && !prepKitRules.containsKey(label))
					{
						prepKitRules.put(""+label, xrefFilter);
						prepKitRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering NgsUser on the label UserName
			if(object.getResultShippedUser_Id() == null && object.getResultShippedUser_UserName() != null)
			{
				Object label = object.getResultShippedUser_UserName();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("UserName", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(label != null && !resultShippedUserRules.containsKey(label))
					{
						resultShippedUserRules.put(""+label, xrefFilter);
						resultShippedUserRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering NgsUser on the label UserName
			if(object.getResultShippedTo_Id() == null && object.getResultShippedTo_UserName() != null)
			{
				Object label = object.getResultShippedTo_UserName();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("UserName", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(label != null && !resultShippedToRules.containsKey(label))
					{
						resultShippedToRules.put(""+label, xrefFilter);
						resultShippedToRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
		}

		//resolve foreign key field 'projectCustomer' to ngsUser.id using UserName)
		final java.util.Map<String,Integer> projectCustomer_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(projectCustomerRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.ngs.NgsUser> projectCustomerList = null;
			try
			{
				projectCustomerList = getDatabase().find(org.molgenis.omx.ngs.NgsUser.class, projectCustomerRules.values().toArray(new org.molgenis.framework.db.QueryRule[projectCustomerRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.ngs.NgsUser xref :  projectCustomerList)
			{
				String key = "";
				key += 	xref.getUserName();
				
				projectCustomer_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'projectAnalist' to ngsUser.id using UserName)
		final java.util.Map<String,Integer> projectAnalist_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(projectAnalistRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.ngs.NgsUser> projectAnalistList = null;
			try
			{
				projectAnalistList = getDatabase().find(org.molgenis.omx.ngs.NgsUser.class, projectAnalistRules.values().toArray(new org.molgenis.framework.db.QueryRule[projectAnalistRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.ngs.NgsUser xref :  projectAnalistList)
			{
				String key = "";
				key += 	xref.getUserName();
				
				projectAnalist_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'prepKit' to prepKit.id using PrepKitName)
		final java.util.Map<String,Integer> prepKit_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(prepKitRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.ngs.PrepKit> prepKitList = null;
			try
			{
				prepKitList = getDatabase().find(org.molgenis.omx.ngs.PrepKit.class, prepKitRules.values().toArray(new org.molgenis.framework.db.QueryRule[prepKitRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.ngs.PrepKit xref :  prepKitList)
			{
				String key = "";
				key += 	xref.getPrepKitName();
				
				prepKit_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'resultShippedUser' to ngsUser.id using UserName)
		final java.util.Map<String,Integer> resultShippedUser_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(resultShippedUserRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.ngs.NgsUser> resultShippedUserList = null;
			try
			{
				resultShippedUserList = getDatabase().find(org.molgenis.omx.ngs.NgsUser.class, resultShippedUserRules.values().toArray(new org.molgenis.framework.db.QueryRule[resultShippedUserRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.ngs.NgsUser xref :  resultShippedUserList)
			{
				String key = "";
				key += 	xref.getUserName();
				
				resultShippedUser_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'resultShippedTo' to ngsUser.id using UserName)
		final java.util.Map<String,Integer> resultShippedTo_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(resultShippedToRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.ngs.NgsUser> resultShippedToList = null;
			try
			{
				resultShippedToList = getDatabase().find(org.molgenis.omx.ngs.NgsUser.class, resultShippedToRules.values().toArray(new org.molgenis.framework.db.QueryRule[resultShippedToRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.ngs.NgsUser xref :  resultShippedToList)
			{
				String key = "";
				key += 	xref.getUserName();
				
				resultShippedTo_Labels_to_IdMap.put(key, xref.getId());
			}
		}

		//update objects with the keys
		for(int i = 0; i < entities.size(); i++)
		{
			org.molgenis.omx.ngs.Project object = entities.get(i);		
			//update object using label fields UserName
			if(object.getProjectCustomer_Id() == null )
			{
					String key = "";
					if(object.getProjectCustomer_UserName() != null)
						key += 	object.getProjectCustomer_UserName();
					
					if(!"".equals(key) && projectCustomer_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("ProjectCustomer_UserName cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setProjectCustomer_Id(projectCustomer_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields UserName
			if(object.getProjectAnalist_Id() == null || object.getProjectAnalist_Id().size() == 0)
			{
				java.util.List<Integer> idList = new java.util.ArrayList<Integer>();
				for(int j = 0; j < object.getProjectAnalist_UserName().size(); j++)
				{
					String key = "";
					if(object.getProjectAnalist_UserName().get(j) != null)
						key += 	object.getProjectAnalist_UserName().get(j);
					
					if(!"".equals(key) && projectAnalist_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("ProjectAnalist_UserName cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						idList.add(projectAnalist_Labels_to_IdMap.get(key));
					}
				}
				object.setProjectAnalist_Id(idList);
			}
			//update object using label fields PrepKitName
			if(object.getPrepKit_Id() == null )
			{
					String key = "";
					if(object.getPrepKit_PrepKitName() != null)
						key += 	object.getPrepKit_PrepKitName();
					
					if(!"".equals(key) && prepKit_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("PrepKit_PrepKitName cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setPrepKit_Id(prepKit_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields UserName
			if(object.getResultShippedUser_Id() == null )
			{
					String key = "";
					if(object.getResultShippedUser_UserName() != null)
						key += 	object.getResultShippedUser_UserName();
					
					if(!"".equals(key) && resultShippedUser_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("ResultShippedUser_UserName cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setResultShippedUser_Id(resultShippedUser_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields UserName
			if(object.getResultShippedTo_Id() == null )
			{
					String key = "";
					if(object.getResultShippedTo_UserName() != null)
						key += 	object.getResultShippedTo_UserName();
					
					if(!"".equals(key) && resultShippedTo_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("ResultShippedTo_UserName cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setResultShippedTo_Id(resultShippedTo_Labels_to_IdMap.get(key));
					}
			}
						
		}
	}	
	
	@Override
	public org.molgenis.fieldtypes.FieldType getFieldType(String fieldName)
	{
			if("id".equalsIgnoreCase(fieldName) || "project.id".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("projectName".equalsIgnoreCase(fieldName) || "project.projectName".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("projectComment".equalsIgnoreCase(fieldName) || "project.projectComment".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("projectCustomer".equalsIgnoreCase(fieldName) || "project.projectCustomer".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("projectPlannedFinishDate".equalsIgnoreCase(fieldName) || "project.projectPlannedFinishDate".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.DatetimeField();
			if("laneAmount".equalsIgnoreCase(fieldName) || "project.laneAmount".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("sampleAmount".equalsIgnoreCase(fieldName) || "project.sampleAmount".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("sampleType".equalsIgnoreCase(fieldName) || "project.sampleType".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("seqType".equalsIgnoreCase(fieldName) || "project.seqType".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("prepKit".equalsIgnoreCase(fieldName) || "project.prepKit".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("declarationNr".equalsIgnoreCase(fieldName) || "project.declarationNr".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("gccAnalysis".equalsIgnoreCase(fieldName) || "project.gccAnalysis".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.BoolField();
			if("gccInstructions".equalsIgnoreCase(fieldName) || "project.gccInstructions".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("resultFilesDir".equalsIgnoreCase(fieldName) || "project.resultFilesDir".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("resultShippedUser".equalsIgnoreCase(fieldName) || "project.resultShippedUser".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("resultShippedTo".equalsIgnoreCase(fieldName) || "project.resultShippedTo".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("resultShippedDate".equalsIgnoreCase(fieldName) || "project.resultShippedDate".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.DateField();
		return null;
	}		
	@Override
	public void prepareFileAttachements(java.util.List<org.molgenis.omx.ngs.Project> entities, java.io.File baseDir) throws java.io.IOException
	{
	}

	@Override
	public boolean saveFileAttachements(java.util.List<org.molgenis.omx.ngs.Project> entities, java.io.File baseDir) throws java.io.IOException
	{
		return false;
	}}
