
/* File:        Ngs/html/Flowcell.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        August 21, 2013
 * 
 * generator:   org.molgenis.generators.ui.HtmlFormGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
package org.molgenis.omx.ngs.ui;

// jdk
import java.util.Vector;
import java.util.List;
import java.util.ArrayList;


// molgenis
import org.molgenis.framework.ui.html.*;


import org.molgenis.omx.ngs.Machine;
import org.molgenis.omx.ngs.Flowcell;


/**
 * A HtmlForm that is preloaded with all inputs for entity Flowcell
 * @see EntityForm
 */
public class FlowcellForm extends EntityForm<Flowcell>
{
	
	public FlowcellForm()
	{
		super();
	}
	
	public FlowcellForm(Flowcell entity)
	{
		super(entity);
	}
	
	
	@Override
	public Class<Flowcell> getEntityClass()
	{
		return Flowcell.class;
	}
	
	@Override
	public Vector<String> getHeaders()
	{
		Vector<String> headers = new Vector<String>();
		headers.add("Direction");
		headers.add("Flowcell name");
		headers.add("Sequencer");
		headers.add("Run");
		headers.add("Run date");
		return headers;
	}	
	
	@Override
	public List<HtmlInput<?>> getInputs()
	{	
		List<HtmlInput<?>> inputs = new ArrayList<HtmlInput<?>>();			
		//Id: Field(entity=Flowcell, name=id, type=int, auto=true, nillable=false, readonly=true, default=)
		{
			IntInput input = new IntInput("Flowcell_id",getEntity().getId());
			
			input.setLabel("id");
			input.setDescription("automatically generated internal id, only for internal use.");
			input.setNillable(false);
			input.setReadonly(true); //automatic fields that are readonly, are also readonly on newrecord
			input.setHidden(true);
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//FlowcellDirection: Field(entity=Flowcell, name=FlowcellDirection, type=enum, auto=false, nillable=true, readonly=false, default=, enum_options=[A, B])
		{
			EnumInput input = new EnumInput("Flowcell_FlowcellDirection",getEntity().getFlowcellDirection());
			
			input.setLabel("Direction");
			input.setDescription("The direction used to read sequences");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			input.setOptions(getEntity().getFlowcellDirectionOptions());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//FlowcellName: Field(entity=Flowcell, name=FlowcellName, type=string[255], auto=false, nillable=false, readonly=false, default=)
		{
			StringInput input = new StringInput("Flowcell_FlowcellName",getEntity().getFlowcellName());
			
			input.setLabel("Flowcell name");
			input.setDescription("The unique name of a flowcell");
			input.setNillable(false);
			input.setSize(255);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//Machine: Field(entity=Flowcell, name=Machine, type=xref[Machine.id], xref_label='MachineName', auto=false, nillable=true, readonly=false, default=)
		{
		    //TODO: when we have JPA this should become:
			//XrefInput<Flowcell> input = new XrefInput<Flowcell>("Flowcell_Machine", getEntity().getMachine());
			//create xref dummy object
			Machine dummy = null;
			if(getEntity().getMachine_Id() != null)
			{
			 	dummy = new Machine();
				dummy.setId(getEntity().getMachine_Id());
				dummy.setMachineName( getEntity().getMachine_MachineName() ); 
			}
			XrefInput<Machine> input = new XrefInput<Machine>("Flowcell_Machine", org.molgenis.omx.ngs.Machine.class, dummy);
			
			input.setLabel("Sequencer");
			input.setDescription("The machine used for sequencing");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//Run: Field(entity=Flowcell, name=Run, type=string[255], auto=false, nillable=true, readonly=false, default=)
		{
			StringInput input = new StringInput("Flowcell_Run",getEntity().getRun());
			
			input.setLabel("Run");
			input.setDescription("The run number always use 4 digits (with leading 0&apos;s)");
			input.setNillable(true);
			input.setSize(255);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//RunDate: Field(entity=Flowcell, name=RunDate, type=datetime, auto=false, nillable=true, readonly=false, default=)
		{
			DatetimeInput input = new DatetimeInput("Flowcell_RunDate",getEntity().getRunDate());
			
			input.setLabel("Run date");
			input.setDescription("The date the flowcell was run on the machine.");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}

		return inputs;
	}
}


