
/* File:        Ngs/html/Project.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        August 21, 2013
 * 
 * generator:   org.molgenis.generators.ui.HtmlFormGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
package org.molgenis.omx.ngs.ui;

// jdk
import java.util.Vector;
import java.util.List;
import java.util.ArrayList;


// molgenis
import org.molgenis.framework.ui.html.*;


import org.molgenis.omx.ngs.NgsUser;
import org.molgenis.omx.ngs.PrepKit;
import org.molgenis.omx.ngs.Project;


/**
 * A HtmlForm that is preloaded with all inputs for entity Project
 * @see EntityForm
 */
public class ProjectForm extends EntityForm<Project>
{
	
	public ProjectForm()
	{
		super();
	}
	
	public ProjectForm(Project entity)
	{
		super(entity);
	}
	
	
	@Override
	public Class<Project> getEntityClass()
	{
		return Project.class;
	}
	
	@Override
	public Vector<String> getHeaders()
	{
		Vector<String> headers = new Vector<String>();
		headers.add("Project name");
		headers.add("Comment");
		headers.add("Custumor name");
		headers.add("Analist name(s)");
		headers.add("Planned finish date");
		headers.add("Lane amount");
		headers.add("Sample amount");
		headers.add("Sample type");
		headers.add("Sequencing type");
		headers.add("Preparation kit");
		headers.add("Declaration Nr");
		headers.add("GccAnalysis");
		headers.add("GccInstructions");
		headers.add("ResultFilesDir (by GCC)");
		headers.add("ResultShippedUser (by GCC)");
		headers.add("ResultShippedTo (by GCC)");
		headers.add("ResultShippedDate (by GCC)");
		return headers;
	}	
	
	@Override
	public List<HtmlInput<?>> getInputs()
	{	
		List<HtmlInput<?>> inputs = new ArrayList<HtmlInput<?>>();			
		//Id: Field(entity=Project, name=id, type=int, auto=true, nillable=false, readonly=true, default=)
		{
			IntInput input = new IntInput("Project_id",getEntity().getId());
			
			input.setLabel("id");
			input.setDescription("automatically generated internal id, only for internal use.");
			input.setNillable(false);
			input.setReadonly(true); //automatic fields that are readonly, are also readonly on newrecord
			input.setHidden(true);
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//ProjectName: Field(entity=Project, name=ProjectName, type=string[255], auto=false, nillable=false, readonly=false, default=)
		{
			StringInput input = new StringInput("Project_ProjectName",getEntity().getProjectName());
			
			input.setLabel("Project name");
			input.setDescription("The name of a project");
			input.setNillable(false);
			input.setSize(255);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//ProjectComment: Field(entity=Project, name=ProjectComment, type=string[255], auto=false, nillable=true, readonly=false, default=)
		{
			StringInput input = new StringInput("Project_ProjectComment",getEntity().getProjectComment());
			
			input.setLabel("Comment");
			input.setDescription("The comment of a project.");
			input.setNillable(true);
			input.setSize(255);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//ProjectCustomer: Field(entity=Project, name=ProjectCustomer, type=xref[NgsUser.id], xref_label='UserName', auto=false, nillable=true, readonly=false, default=)
		{
		    //TODO: when we have JPA this should become:
			//XrefInput<Project> input = new XrefInput<Project>("Project_ProjectCustomer", getEntity().getProjectCustomer());
			//create xref dummy object
			NgsUser dummy = null;
			if(getEntity().getProjectCustomer_Id() != null)
			{
			 	dummy = new NgsUser();
				dummy.setId(getEntity().getProjectCustomer_Id());
				dummy.setUserName( getEntity().getProjectCustomer_UserName() ); 
			}
			XrefInput<NgsUser> input = new XrefInput<NgsUser>("Project_ProjectCustomer", org.molgenis.omx.ngs.NgsUser.class, dummy);
			
			input.setLabel("Custumor name");
			input.setDescription("The user who ordered the project.");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//ProjectAnalist: Field(entity=Project, name=ProjectAnalist, type=mref[NgsUser.id], mref_name=Project_ProjectAnalist, mref_localid=Project, mref_remoteid=ProjectAnalist, xref_label='UserName', auto=false, nillable=true, readonly=false, default=)
		{
			//TODO: when we have JPA this should become:
			//MrefInput input = new MrefInput("Project_ProjectAnalist", getEntity().getProjectAnalist());
			//create xref dummy list of references
			List<NgsUser> dummyList = new ArrayList<NgsUser>();
			if(getEntity().getProjectAnalist_Id() != null) for(int i = 0; i < getEntity().getProjectAnalist_Id().size(); i++ )
			{
				NgsUser dummy = new NgsUser();
				dummy.setId(getEntity().getProjectAnalist_Id().get(i));
				dummy.setUserName( getEntity().getProjectAnalist_UserName().get(i) ); 
				dummyList.add(dummy);
			}   
			MrefInput<NgsUser> input = new MrefInput<NgsUser> ("Project_ProjectAnalist", org.molgenis.omx.ngs.NgsUser.class, dummyList);
			
			input.setLabel("Analist name(s)");
			input.setDescription("The user which will be responsible for performing the wet-lab activities.");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//ProjectPlannedFinishDate: Field(entity=Project, name=ProjectPlannedFinishDate, type=datetime, auto=false, nillable=true, readonly=false, default=)
		{
			DatetimeInput input = new DatetimeInput("Project_ProjectPlannedFinishDate",getEntity().getProjectPlannedFinishDate());
			
			input.setLabel("Planned finish date");
			input.setDescription("The date a project is expected to be finished");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//LaneAmount: Field(entity=Project, name=LaneAmount, type=int, auto=false, nillable=true, readonly=false, default=)
		{
			IntInput input = new IntInput("Project_LaneAmount",getEntity().getLaneAmount());
			
			input.setLabel("Lane amount");
			input.setDescription("Number of lanes planned in this project");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//SampleAmount: Field(entity=Project, name=SampleAmount, type=int, auto=false, nillable=true, readonly=false, default=)
		{
			IntInput input = new IntInput("Project_SampleAmount",getEntity().getSampleAmount());
			
			input.setLabel("Sample amount");
			input.setDescription("Number of samples planned in this project");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//SampleType: Field(entity=Project, name=SampleType, type=enum, auto=false, nillable=false, readonly=false, default=DNA, enum_options=[DNA, RNA])
		{
			EnumInput input = new EnumInput("Project_SampleType",getEntity().getSampleType());
			
			input.setLabel("Sample type");
			input.setDescription("Type of sample");
			input.setNillable(false);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			input.setOptions(getEntity().getSampleTypeOptions());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//SeqType: Field(entity=Project, name=SeqType, type=enum, auto=false, nillable=true, readonly=false, default=PE, enum_options=[SR, PE, MP, Unknown])
		{
			EnumInput input = new EnumInput("Project_SeqType",getEntity().getSeqType());
			
			input.setLabel("Sequencing type");
			input.setDescription("The type of sequencing.");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			input.setOptions(getEntity().getSeqTypeOptions());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//PrepKit: Field(entity=Project, name=PrepKit, type=xref[PrepKit.id], xref_label='PrepKitName', auto=false, nillable=true, readonly=false, default=)
		{
		    //TODO: when we have JPA this should become:
			//XrefInput<Project> input = new XrefInput<Project>("Project_PrepKit", getEntity().getPrepKit());
			//create xref dummy object
			PrepKit dummy = null;
			if(getEntity().getPrepKit_Id() != null)
			{
			 	dummy = new PrepKit();
				dummy.setId(getEntity().getPrepKit_Id());
				dummy.setPrepKitName( getEntity().getPrepKit_PrepKitName() ); 
			}
			XrefInput<PrepKit> input = new XrefInput<PrepKit>("Project_PrepKit", org.molgenis.omx.ngs.PrepKit.class, dummy);
			
			input.setLabel("Preparation kit");
			input.setDescription("Preparation kit used on the sample for this experiment");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//DeclarationNr: Field(entity=Project, name=DeclarationNr, type=string[255], auto=false, nillable=true, readonly=false, default=)
		{
			StringInput input = new StringInput("Project_DeclarationNr",getEntity().getDeclarationNr());
			
			input.setLabel("Declaration Nr");
			input.setDescription("The Declaration Nr of a project.");
			input.setNillable(true);
			input.setSize(255);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//GccAnalysis: Field(entity=Project, name=GccAnalysis, type=bool, auto=false, nillable=true, readonly=false, default=)
		{
			BoolInput input = new BoolInput("Project_GccAnalysis",getEntity().getGccAnalysis());
			
			input.setLabel("GccAnalysis");
			input.setDescription("Indication if variant calling has to be performed on the experiment.");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//GccInstructions: Field(entity=Project, name=GccInstructions, type=string[255], auto=false, nillable=true, readonly=false, default=)
		{
			StringInput input = new StringInput("Project_GccInstructions",getEntity().getGccInstructions());
			
			input.setLabel("GccInstructions");
			input.setDescription("Specific instructions for GCC members for the analysis.");
			input.setNillable(true);
			input.setSize(255);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//ResultFilesDir: Field(entity=Project, name=ResultFilesDir, type=string[255], auto=false, nillable=true, readonly=false, default=)
		{
			StringInput input = new StringInput("Project_ResultFilesDir",getEntity().getResultFilesDir());
			
			input.setLabel("ResultFilesDir (by GCC)");
			input.setDescription("File location of the resulting files after analysis occurred (for file download purpose)");
			input.setNillable(true);
			input.setSize(255);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//ResultShippedUser: Field(entity=Project, name=ResultShippedUser, type=xref[NgsUser.id], xref_label='UserName', auto=false, nillable=true, readonly=false, default=)
		{
		    //TODO: when we have JPA this should become:
			//XrefInput<Project> input = new XrefInput<Project>("Project_ResultShippedUser", getEntity().getResultShippedUser());
			//create xref dummy object
			NgsUser dummy = null;
			if(getEntity().getResultShippedUser_Id() != null)
			{
			 	dummy = new NgsUser();
				dummy.setId(getEntity().getResultShippedUser_Id());
				dummy.setUserName( getEntity().getResultShippedUser_UserName() ); 
			}
			XrefInput<NgsUser> input = new XrefInput<NgsUser>("Project_ResultShippedUser", org.molgenis.omx.ngs.NgsUser.class, dummy);
			
			input.setLabel("ResultShippedUser (by GCC)");
			input.setDescription("The user who shipped the date.");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//ResultShippedTo: Field(entity=Project, name=ResultShippedTo, type=xref[NgsUser.id], xref_label='UserName', auto=false, nillable=true, readonly=false, default=)
		{
		    //TODO: when we have JPA this should become:
			//XrefInput<Project> input = new XrefInput<Project>("Project_ResultShippedTo", getEntity().getResultShippedTo());
			//create xref dummy object
			NgsUser dummy = null;
			if(getEntity().getResultShippedTo_Id() != null)
			{
			 	dummy = new NgsUser();
				dummy.setId(getEntity().getResultShippedTo_Id());
				dummy.setUserName( getEntity().getResultShippedTo_UserName() ); 
			}
			XrefInput<NgsUser> input = new XrefInput<NgsUser>("Project_ResultShippedTo", org.molgenis.omx.ngs.NgsUser.class, dummy);
			
			input.setLabel("ResultShippedTo (by GCC)");
			input.setDescription("Name of the person to which the data has been shipped.");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//ResultShippedDate: Field(entity=Project, name=ResultShippedDate, type=date, auto=false, nillable=true, readonly=false, default=)
		{
			DateInput input = new DateInput("Project_ResultShippedDate",getEntity().getResultShippedDate());
			
			input.setLabel("ResultShippedDate (by GCC)");
			input.setDescription("The date the result of the experiment is shipped to the custumor.");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}

		return inputs;
	}
}


