package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.value.BoolValue;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class BoolValueService
{
	private static final Logger logger = Logger.getLogger(BoolValueService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public BoolValue create(BoolValue boolValue) throws DatabaseException
	{
		logger.debug("creating BoolValue");
		db.add(boolValue);
		return boolValue;
	}

	public BoolValue read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving BoolValue");
		return db.findById(BoolValue.class, id);
	}

	public void update(BoolValue boolValue) throws DatabaseException
	{
		logger.debug("updating BoolValue");
		db.update(boolValue);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting BoolValue");
		BoolValue boolValue = db.findById(BoolValue.class, id);
		return db.remove(boolValue) == 1;
	}
	
	public Iterable<BoolValue> readAll() throws DatabaseException
	{
		logger.debug("retrieving all BoolValue instances");
		return db.find(BoolValue.class);
	}
	
	public EntityPager<BoolValue> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all BoolValue instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(BoolValue.class, queryRules.toArray(new QueryRule[0]));
		List<BoolValue> boolValueCollection = db.find(BoolValue.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<BoolValue>(start, num, count, boolValueCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("BoolValue");
	}
}