package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.ngs.Machine;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class MachineService
{
	private static final Logger logger = Logger.getLogger(MachineService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public Machine create(Machine machine) throws DatabaseException
	{
		logger.debug("creating Machine");
		db.add(machine);
		return machine;
	}

	public Machine read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Machine");
		return db.findById(Machine.class, id);
	}

	public void update(Machine machine) throws DatabaseException
	{
		logger.debug("updating Machine");
		db.update(machine);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Machine");
		Machine machine = db.findById(Machine.class, id);
		return db.remove(machine) == 1;
	}
	
	public Iterable<Machine> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Machine instances");
		return db.find(Machine.class);
	}
	
	public EntityPager<Machine> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Machine instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Machine.class, queryRules.toArray(new QueryRule[0]));
		List<Machine> machineCollection = db.find(Machine.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Machine>(start, num, count, machineCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Machine");
	}
}