package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.core.MolgenisFile;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class MolgenisFileService
{
	private static final Logger logger = Logger.getLogger(MolgenisFileService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public MolgenisFile create(MolgenisFile molgenisFile) throws DatabaseException
	{
		logger.debug("creating MolgenisFile");
		db.add(molgenisFile);
		return molgenisFile;
	}

	public MolgenisFile read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving MolgenisFile");
		return db.findById(MolgenisFile.class, id);
	}

	public void update(MolgenisFile molgenisFile) throws DatabaseException
	{
		logger.debug("updating MolgenisFile");
		db.update(molgenisFile);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting MolgenisFile");
		MolgenisFile molgenisFile = db.findById(MolgenisFile.class, id);
		return db.remove(molgenisFile) == 1;
	}
	
	public Iterable<MolgenisFile> readAll() throws DatabaseException
	{
		logger.debug("retrieving all MolgenisFile instances");
		return db.find(MolgenisFile.class);
	}
	
	public EntityPager<MolgenisFile> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all MolgenisFile instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(MolgenisFile.class, queryRules.toArray(new QueryRule[0]));
		List<MolgenisFile> molgenisFileCollection = db.find(MolgenisFile.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<MolgenisFile>(start, num, count, molgenisFileCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("MolgenisFile");
	}
}