package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.ngs.PrepKit;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class PrepKitService
{
	private static final Logger logger = Logger.getLogger(PrepKitService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public PrepKit create(PrepKit prepKit) throws DatabaseException
	{
		logger.debug("creating PrepKit");
		db.add(prepKit);
		return prepKit;
	}

	public PrepKit read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving PrepKit");
		return db.findById(PrepKit.class, id);
	}

	public void update(PrepKit prepKit) throws DatabaseException
	{
		logger.debug("updating PrepKit");
		db.update(prepKit);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting PrepKit");
		PrepKit prepKit = db.findById(PrepKit.class, id);
		return db.remove(prepKit) == 1;
	}
	
	public Iterable<PrepKit> readAll() throws DatabaseException
	{
		logger.debug("retrieving all PrepKit instances");
		return db.find(PrepKit.class);
	}
	
	public EntityPager<PrepKit> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all PrepKit instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(PrepKit.class, queryRules.toArray(new QueryRule[0]));
		List<PrepKit> prepKitCollection = db.find(PrepKit.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<PrepKit>(start, num, count, prepKitCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("PrepKit");
	}
}