package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.ngs.SampleBarcodeType;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class SampleBarcodeTypeService
{
	private static final Logger logger = Logger.getLogger(SampleBarcodeTypeService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public SampleBarcodeType create(SampleBarcodeType sampleBarcodeType) throws DatabaseException
	{
		logger.debug("creating SampleBarcodeType");
		db.add(sampleBarcodeType);
		return sampleBarcodeType;
	}

	public SampleBarcodeType read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving SampleBarcodeType");
		return db.findById(SampleBarcodeType.class, id);
	}

	public void update(SampleBarcodeType sampleBarcodeType) throws DatabaseException
	{
		logger.debug("updating SampleBarcodeType");
		db.update(sampleBarcodeType);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting SampleBarcodeType");
		SampleBarcodeType sampleBarcodeType = db.findById(SampleBarcodeType.class, id);
		return db.remove(sampleBarcodeType) == 1;
	}
	
	public Iterable<SampleBarcodeType> readAll() throws DatabaseException
	{
		logger.debug("retrieving all SampleBarcodeType instances");
		return db.find(SampleBarcodeType.class);
	}
	
	public EntityPager<SampleBarcodeType> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all SampleBarcodeType instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(SampleBarcodeType.class, queryRules.toArray(new QueryRule[0]));
		List<SampleBarcodeType> sampleBarcodeTypeCollection = db.find(SampleBarcodeType.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<SampleBarcodeType>(start, num, count, sampleBarcodeTypeCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("SampleBarcodeType");
	}
}