
/* Date:        August 21, 2013
 * 
 * generator:   org.molgenis.generators.excel.ExcelEntityExporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
package org.molgenis;

import java.io.File;
import java.io.IOException;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.io.TableWriter;
import org.molgenis.io.TupleReader;
import org.molgenis.io.TupleWriter;
import org.molgenis.io.csv.CsvReader;
import org.molgenis.io.excel.ExcelWriter;
import org.molgenis.util.tuple.Tuple;

import com.google.common.collect.Lists;

public class ExcelEntityExporter
{
	/**
	 * Default export all using a target file and a database to export
	 * @param directory
	 * @param db
	 * @throws Exception
	 */
	public void exportAll(File excelFile, Database db) throws Exception
	{
		exportAll(excelFile, db, false, new QueryRule[]{});
	}
	
	/**
	 * Export all using a set of QueryRules used for all entities if applicable to that entity
	 * @param directory
	 * @param db
	 * @param rules
	 * @throws Exception
	 */
	public void exportAll(File excelFile, Database db, QueryRule ... rules) throws Exception
	{
		exportAll(excelFile, db, false, rules);
	}
	
	/**
	 * Export all where a boolean skipAutoId forces an ignore of the auto id field ("id")
	 * @param directory
	 * @param db
	 * @param skipAutoId
	 * @throws Exception
	 */
	public void exportAll(File excelFile, Database db, boolean skipAutoId) throws Exception
	{
		exportAll(excelFile, db, skipAutoId, new QueryRule[]{});
	}
	
	/**
	 * Export all with both a boolean skipAutoId and a set of QueryRules to specify both the skipping of auto id, and applying of a filter
	 * @param directory
	 * @param db
	 * @param skipAutoId
	 * @param rules
	 * @throws Exception
	 */
	public void exportAll(File excelFile, Database db, boolean skipAutoId, QueryRule ... rules) throws Exception
	{
		// Do checks on target file
		if(excelFile.exists()){
			throw new Exception("Target file " + excelFile.getAbsolutePath() + " already exists, will not proceed.");
		}
		boolean createSuccess = excelFile.createNewFile();
		if(!createSuccess){
			throw new Exception("Creation of target file " + excelFile.getAbsolutePath() + " failed, cannot proceed.");
		}
		
		// Create temporary directory
		File directory = new File(System.getProperty("java.io.tmpdir") + File.separator + "molgenis_export"+System.currentTimeMillis());
		boolean ok = directory.mkdir();
		if(!ok) throw new IOException("failed to create directory " + directory.toString());
		
		// Export CSV to this directory
		CsvEntityExporter entityExporter = new CsvEntityExporter();
		entityExporter.exportAll(directory, db, skipAutoId, rules);
			
		// Create new Excel workbook
		TableWriter entitiesWriter = new ExcelWriter(excelFile);
		try
		{
		  	// Variable: copy file contents to the workbook sheets
		  	File ngsUserFile = new File(directory+"/ngsuser.txt");
		  	if(ngsUserFile.exists())
			  	{
			  	CsvReader ngsUserReader = new CsvReader(ngsUserFile);
			  	try 
			  	{
					copyCsvToWorkbook("NgsUser", ngsUserReader, entitiesWriter);
				}
				finally
				{
					ngsUserReader.close();
				}
			}		
		  	File sampleBarcodeTypeFile = new File(directory+"/samplebarcodetype.txt");
		  	if(sampleBarcodeTypeFile.exists())
			  	{
			  	CsvReader sampleBarcodeTypeReader = new CsvReader(sampleBarcodeTypeFile);
			  	try 
			  	{
					copyCsvToWorkbook("SampleBarcodeType", sampleBarcodeTypeReader, entitiesWriter);
				}
				finally
				{
					sampleBarcodeTypeReader.close();
				}
			}		
		  	File sampleBarcodeFile = new File(directory+"/samplebarcode.txt");
		  	if(sampleBarcodeFile.exists())
			  	{
			  	CsvReader sampleBarcodeReader = new CsvReader(sampleBarcodeFile);
			  	try 
			  	{
					copyCsvToWorkbook("SampleBarcode", sampleBarcodeReader, entitiesWriter);
				}
				finally
				{
					sampleBarcodeReader.close();
				}
			}		
		  	File capturingKitFile = new File(directory+"/capturingkit.txt");
		  	if(capturingKitFile.exists())
			  	{
			  	CsvReader capturingKitReader = new CsvReader(capturingKitFile);
			  	try 
			  	{
					copyCsvToWorkbook("CapturingKit", capturingKitReader, entitiesWriter);
				}
				finally
				{
					capturingKitReader.close();
				}
			}		
		  	File prepKitFile = new File(directory+"/prepkit.txt");
		  	if(prepKitFile.exists())
			  	{
			  	CsvReader prepKitReader = new CsvReader(prepKitFile);
			  	try 
			  	{
					copyCsvToWorkbook("PrepKit", prepKitReader, entitiesWriter);
				}
				finally
				{
					prepKitReader.close();
				}
			}		
		  	File projectFile = new File(directory+"/project.txt");
		  	if(projectFile.exists())
			  	{
			  	CsvReader projectReader = new CsvReader(projectFile);
			  	try 
			  	{
					copyCsvToWorkbook("Project", projectReader, entitiesWriter);
				}
				finally
				{
					projectReader.close();
				}
			}		
		  	File sampleFile = new File(directory+"/sample.txt");
		  	if(sampleFile.exists())
			  	{
			  	CsvReader sampleReader = new CsvReader(sampleFile);
			  	try 
			  	{
					copyCsvToWorkbook("Sample", sampleReader, entitiesWriter);
				}
				finally
				{
					sampleReader.close();
				}
			}		
		  	File machineFile = new File(directory+"/machine.txt");
		  	if(machineFile.exists())
			  	{
			  	CsvReader machineReader = new CsvReader(machineFile);
			  	try 
			  	{
					copyCsvToWorkbook("Machine", machineReader, entitiesWriter);
				}
				finally
				{
					machineReader.close();
				}
			}		
		  	File flowcellFile = new File(directory+"/flowcell.txt");
		  	if(flowcellFile.exists())
			  	{
			  	CsvReader flowcellReader = new CsvReader(flowcellFile);
			  	try 
			  	{
					copyCsvToWorkbook("Flowcell", flowcellReader, entitiesWriter);
				}
				finally
				{
					flowcellReader.close();
				}
			}		
		  	File flowcellLaneFile = new File(directory+"/flowcelllane.txt");
		  	if(flowcellLaneFile.exists())
			  	{
			  	CsvReader flowcellLaneReader = new CsvReader(flowcellLaneFile);
			  	try 
			  	{
					copyCsvToWorkbook("FlowcellLane", flowcellLaneReader, entitiesWriter);
				}
				finally
				{
					flowcellLaneReader.close();
				}
			}		
		  	File molgenisFileFile = new File(directory+"/molgenisfile.txt");
		  	if(molgenisFileFile.exists())
			  	{
			  	CsvReader molgenisFileReader = new CsvReader(molgenisFileFile);
			  	try 
			  	{
					copyCsvToWorkbook("MolgenisFile", molgenisFileReader, entitiesWriter);
				}
				finally
				{
					molgenisFileReader.close();
				}
			}		
		  	File runtimePropertyFile = new File(directory+"/runtimeproperty.txt");
		  	if(runtimePropertyFile.exists())
			  	{
			  	CsvReader runtimePropertyReader = new CsvReader(runtimePropertyFile);
			  	try 
			  	{
					copyCsvToWorkbook("RuntimeProperty", runtimePropertyReader, entitiesWriter);
				}
				finally
				{
					runtimePropertyReader.close();
				}
			}		
		  	File characteristicFile = new File(directory+"/characteristic.txt");
		  	if(characteristicFile.exists())
			  	{
			  	CsvReader characteristicReader = new CsvReader(characteristicFile);
			  	try 
			  	{
					copyCsvToWorkbook("Characteristic", characteristicReader, entitiesWriter);
				}
				finally
				{
					characteristicReader.close();
				}
			}		
		  	File observationTargetFile = new File(directory+"/observationtarget.txt");
		  	if(observationTargetFile.exists())
			  	{
			  	CsvReader observationTargetReader = new CsvReader(observationTargetFile);
			  	try 
			  	{
					copyCsvToWorkbook("ObservationTarget", observationTargetReader, entitiesWriter);
				}
				finally
				{
					observationTargetReader.close();
				}
			}		
		  	File individualFile = new File(directory+"/individual.txt");
		  	if(individualFile.exists())
			  	{
			  	CsvReader individualReader = new CsvReader(individualFile);
			  	try 
			  	{
					copyCsvToWorkbook("Individual", individualReader, entitiesWriter);
				}
				finally
				{
					individualReader.close();
				}
			}		
		  	File ontologyFile = new File(directory+"/ontology.txt");
		  	if(ontologyFile.exists())
			  	{
			  	CsvReader ontologyReader = new CsvReader(ontologyFile);
			  	try 
			  	{
					copyCsvToWorkbook("Ontology", ontologyReader, entitiesWriter);
				}
				finally
				{
					ontologyReader.close();
				}
			}		
		  	File speciesFile = new File(directory+"/species.txt");
		  	if(speciesFile.exists())
			  	{
			  	CsvReader speciesReader = new CsvReader(speciesFile);
			  	try 
			  	{
					copyCsvToWorkbook("Species", speciesReader, entitiesWriter);
				}
				finally
				{
					speciesReader.close();
				}
			}		
		  	File ontologyTermFile = new File(directory+"/ontologyterm.txt");
		  	if(ontologyTermFile.exists())
			  	{
			  	CsvReader ontologyTermReader = new CsvReader(ontologyTermFile);
			  	try 
			  	{
					copyCsvToWorkbook("OntologyTerm", ontologyTermReader, entitiesWriter);
				}
				finally
				{
					ontologyTermReader.close();
				}
			}		
		  	File accessionFile = new File(directory+"/accession.txt");
		  	if(accessionFile.exists())
			  	{
			  	CsvReader accessionReader = new CsvReader(accessionFile);
			  	try 
			  	{
					copyCsvToWorkbook("Accession", accessionReader, entitiesWriter);
				}
				finally
				{
					accessionReader.close();
				}
			}		
		  	File valueFile = new File(directory+"/value.txt");
		  	if(valueFile.exists())
			  	{
			  	CsvReader valueReader = new CsvReader(valueFile);
			  	try 
			  	{
					copyCsvToWorkbook("Value", valueReader, entitiesWriter);
				}
				finally
				{
					valueReader.close();
				}
			}		
		  	File boolValueFile = new File(directory+"/boolvalue.txt");
		  	if(boolValueFile.exists())
			  	{
			  	CsvReader boolValueReader = new CsvReader(boolValueFile);
			  	try 
			  	{
					copyCsvToWorkbook("BoolValue", boolValueReader, entitiesWriter);
				}
				finally
				{
					boolValueReader.close();
				}
			}		
		  	File dateValueFile = new File(directory+"/datevalue.txt");
		  	if(dateValueFile.exists())
			  	{
			  	CsvReader dateValueReader = new CsvReader(dateValueFile);
			  	try 
			  	{
					copyCsvToWorkbook("DateValue", dateValueReader, entitiesWriter);
				}
				finally
				{
					dateValueReader.close();
				}
			}		
		  	File dateTimeValueFile = new File(directory+"/datetimevalue.txt");
		  	if(dateTimeValueFile.exists())
			  	{
			  	CsvReader dateTimeValueReader = new CsvReader(dateTimeValueFile);
			  	try 
			  	{
					copyCsvToWorkbook("DateTimeValue", dateTimeValueReader, entitiesWriter);
				}
				finally
				{
					dateTimeValueReader.close();
				}
			}		
		  	File decimalValueFile = new File(directory+"/decimalvalue.txt");
		  	if(decimalValueFile.exists())
			  	{
			  	CsvReader decimalValueReader = new CsvReader(decimalValueFile);
			  	try 
			  	{
					copyCsvToWorkbook("DecimalValue", decimalValueReader, entitiesWriter);
				}
				finally
				{
					decimalValueReader.close();
				}
			}		
		  	File emailValueFile = new File(directory+"/emailvalue.txt");
		  	if(emailValueFile.exists())
			  	{
			  	CsvReader emailValueReader = new CsvReader(emailValueFile);
			  	try 
			  	{
					copyCsvToWorkbook("EmailValue", emailValueReader, entitiesWriter);
				}
				finally
				{
					emailValueReader.close();
				}
			}		
		  	File htmlValueFile = new File(directory+"/htmlvalue.txt");
		  	if(htmlValueFile.exists())
			  	{
			  	CsvReader htmlValueReader = new CsvReader(htmlValueFile);
			  	try 
			  	{
					copyCsvToWorkbook("HtmlValue", htmlValueReader, entitiesWriter);
				}
				finally
				{
					htmlValueReader.close();
				}
			}		
		  	File hyperlinkValueFile = new File(directory+"/hyperlinkvalue.txt");
		  	if(hyperlinkValueFile.exists())
			  	{
			  	CsvReader hyperlinkValueReader = new CsvReader(hyperlinkValueFile);
			  	try 
			  	{
					copyCsvToWorkbook("HyperlinkValue", hyperlinkValueReader, entitiesWriter);
				}
				finally
				{
					hyperlinkValueReader.close();
				}
			}		
		  	File intValueFile = new File(directory+"/intvalue.txt");
		  	if(intValueFile.exists())
			  	{
			  	CsvReader intValueReader = new CsvReader(intValueFile);
			  	try 
			  	{
					copyCsvToWorkbook("IntValue", intValueReader, entitiesWriter);
				}
				finally
				{
					intValueReader.close();
				}
			}		
		  	File longValueFile = new File(directory+"/longvalue.txt");
		  	if(longValueFile.exists())
			  	{
			  	CsvReader longValueReader = new CsvReader(longValueFile);
			  	try 
			  	{
					copyCsvToWorkbook("LongValue", longValueReader, entitiesWriter);
				}
				finally
				{
					longValueReader.close();
				}
			}		
		  	File mrefValueFile = new File(directory+"/mrefvalue.txt");
		  	if(mrefValueFile.exists())
			  	{
			  	CsvReader mrefValueReader = new CsvReader(mrefValueFile);
			  	try 
			  	{
					copyCsvToWorkbook("MrefValue", mrefValueReader, entitiesWriter);
				}
				finally
				{
					mrefValueReader.close();
				}
			}		
		  	File stringValueFile = new File(directory+"/stringvalue.txt");
		  	if(stringValueFile.exists())
			  	{
			  	CsvReader stringValueReader = new CsvReader(stringValueFile);
			  	try 
			  	{
					copyCsvToWorkbook("StringValue", stringValueReader, entitiesWriter);
				}
				finally
				{
					stringValueReader.close();
				}
			}		
		  	File textValueFile = new File(directory+"/textvalue.txt");
		  	if(textValueFile.exists())
			  	{
			  	CsvReader textValueReader = new CsvReader(textValueFile);
			  	try 
			  	{
					copyCsvToWorkbook("TextValue", textValueReader, entitiesWriter);
				}
				finally
				{
					textValueReader.close();
				}
			}		
		  	File personRoleFile = new File(directory+"/personrole.txt");
		  	if(personRoleFile.exists())
			  	{
			  	CsvReader personRoleReader = new CsvReader(personRoleFile);
			  	try 
			  	{
					copyCsvToWorkbook("PersonRole", personRoleReader, entitiesWriter);
				}
				finally
				{
					personRoleReader.close();
				}
			}		
		  	File observableFeatureFile = new File(directory+"/observablefeature.txt");
		  	if(observableFeatureFile.exists())
			  	{
			  	CsvReader observableFeatureReader = new CsvReader(observableFeatureFile);
			  	try 
			  	{
					copyCsvToWorkbook("ObservableFeature", observableFeatureReader, entitiesWriter);
				}
				finally
				{
					observableFeatureReader.close();
				}
			}		
		  	File categoryFile = new File(directory+"/category.txt");
		  	if(categoryFile.exists())
			  	{
			  	CsvReader categoryReader = new CsvReader(categoryFile);
			  	try 
			  	{
					copyCsvToWorkbook("Category", categoryReader, entitiesWriter);
				}
				finally
				{
					categoryReader.close();
				}
			}		
		  	File protocolFile = new File(directory+"/protocol.txt");
		  	if(protocolFile.exists())
			  	{
			  	CsvReader protocolReader = new CsvReader(protocolFile);
			  	try 
			  	{
					copyCsvToWorkbook("Protocol", protocolReader, entitiesWriter);
				}
				finally
				{
					protocolReader.close();
				}
			}		
		  	File dataSetFile = new File(directory+"/dataset.txt");
		  	if(dataSetFile.exists())
			  	{
			  	CsvReader dataSetReader = new CsvReader(dataSetFile);
			  	try 
			  	{
					copyCsvToWorkbook("DataSet", dataSetReader, entitiesWriter);
				}
				finally
				{
					dataSetReader.close();
				}
			}		
		  	File observationSetFile = new File(directory+"/observationset.txt");
		  	if(observationSetFile.exists())
			  	{
			  	CsvReader observationSetReader = new CsvReader(observationSetFile);
			  	try 
			  	{
					copyCsvToWorkbook("ObservationSet", observationSetReader, entitiesWriter);
				}
				finally
				{
					observationSetReader.close();
				}
			}		
		  	File panelFile = new File(directory+"/panel.txt");
		  	if(panelFile.exists())
			  	{
			  	CsvReader panelReader = new CsvReader(panelFile);
			  	try 
			  	{
					copyCsvToWorkbook("Panel", panelReader, entitiesWriter);
				}
				finally
				{
					panelReader.close();
				}
			}		
		  	File panelSourceFile = new File(directory+"/panelsource.txt");
		  	if(panelSourceFile.exists())
			  	{
			  	CsvReader panelSourceReader = new CsvReader(panelSourceFile);
			  	try 
			  	{
					copyCsvToWorkbook("PanelSource", panelSourceReader, entitiesWriter);
				}
				finally
				{
					panelSourceReader.close();
				}
			}		
		  	File categoricalValueFile = new File(directory+"/categoricalvalue.txt");
		  	if(categoricalValueFile.exists())
			  	{
			  	CsvReader categoricalValueReader = new CsvReader(categoricalValueFile);
			  	try 
			  	{
					copyCsvToWorkbook("CategoricalValue", categoricalValueReader, entitiesWriter);
				}
				finally
				{
					categoricalValueReader.close();
				}
			}		
		  	File instituteFile = new File(directory+"/institute.txt");
		  	if(instituteFile.exists())
			  	{
			  	CsvReader instituteReader = new CsvReader(instituteFile);
			  	try 
			  	{
					copyCsvToWorkbook("Institute", instituteReader, entitiesWriter);
				}
				finally
				{
					instituteReader.close();
				}
			}		
		  	File personFile = new File(directory+"/person.txt");
		  	if(personFile.exists())
			  	{
			  	CsvReader personReader = new CsvReader(personFile);
			  	try 
			  	{
					copyCsvToWorkbook("Person", personReader, entitiesWriter);
				}
				finally
				{
					personReader.close();
				}
			}		
		  	File xrefValueFile = new File(directory+"/xrefvalue.txt");
		  	if(xrefValueFile.exists())
			  	{
			  	CsvReader xrefValueReader = new CsvReader(xrefValueFile);
			  	try 
			  	{
					copyCsvToWorkbook("XrefValue", xrefValueReader, entitiesWriter);
				}
				finally
				{
					xrefValueReader.close();
				}
			}		
		  	File observedValueFile = new File(directory+"/observedvalue.txt");
		  	if(observedValueFile.exists())
			  	{
			  	CsvReader observedValueReader = new CsvReader(observedValueFile);
			  	try 
			  	{
					copyCsvToWorkbook("ObservedValue", observedValueReader, entitiesWriter);
				}
				finally
				{
					observedValueReader.close();
				}
			}		
		}
		finally
		{
			IOUtils.closeQuietly(entitiesWriter);
			
			// Remove temporary directory
			FileUtils.deleteDirectory(directory);
		}
	}

	/**
	 * Convert a CSV to an Excel sheet inside a workbook
	 * @throws IOException 
	 */
	private void copyCsvToWorkbook(String tableName, TupleReader tupleReader, TableWriter tableWriter) throws IOException
	{
		// create table
		TupleWriter tupleWriter = tableWriter.createTupleWriter(tableName);
		try
		{
			// write table header
			List<String> colNames = Lists.newArrayList(tupleReader.colNamesIterator());
			tupleWriter.writeColNames(colNames);
			
			// write table data rows
			for (Tuple tuple : tupleReader)
				tupleWriter.write(tuple);
		}
		finally 
		{
			tupleWriter.close();
		}
	}
}