package org.molgenis.controller;

import java.lang.RuntimeException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;
import javax.validation.Valid;

import org.molgenis.omx.observ.value.BoolValue;
import org.molgenis.framework.server.EntityCollectionRequest;
import org.molgenis.framework.server.EntityCollectionResponse;
import org.molgenis.framework.db.DatabaseAccessException;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.EntityNotFoundException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.service.BoolValueService;
import org.molgenis.util.EntityPager;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

@SuppressWarnings("unused")
@Lazy
@Controller
@RequestMapping("/api/v1/boolvalue")
public class BoolValueController
{
	@Autowired
	private BoolValueService boolValueService;

	@RequestMapping(method = RequestMethod.POST)
	@ResponseBody
	public ResponseEntity<BoolValueResponse> createBoolValue(@Valid @RequestBody BoolValueRequest boolValueRequest)
			throws DatabaseException
	{
		return _createBoolValue(boolValueRequest);
	}

	// Spring's FormHttpMessageConverter cannot bind target classes (as ModelAttribute can)
	@RequestMapping(method = RequestMethod.POST, headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseBody
	public ResponseEntity<BoolValueResponse> createBoolValueFromForm(@Valid @ModelAttribute BoolValueRequest boolValueRequest)
			throws DatabaseException
	{
		return _createBoolValue(boolValueRequest);
	}

	private ResponseEntity<BoolValueResponse> _createBoolValue(BoolValueRequest boolValueRequest) throws DatabaseException
	{
		BoolValue boolValue = boolValueService.create(boolValueRequest.toBoolValue());
		HttpHeaders responseHeaders = new HttpHeaders();
		responseHeaders.add("Location", "/api/v1/boolvalue/" + boolValue.getId());
		return new ResponseEntity<BoolValueResponse>(responseHeaders, HttpStatus.CREATED);
	}

	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ResponseBody
	public BoolValueResponse retrieveBoolValue(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveBoolValue(id, expandFields);
	}
		
	@RequestMapping(value = "/{id}", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	@ResponseBody
	public BoolValueResponse retrieveBoolValueJson(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveBoolValue(id, expandFields);
	}

	private BoolValueResponse _retrieveBoolValue(Integer id, String... expandFieldsStr) throws DatabaseException
	{
		BoolValue boolValue = boolValueService.read(id);
		if (boolValue == null) throw new EntityNotFoundException("BoolValue " + id.toString() + " not found");
		Set<String> expandFields = expandFieldsStr != null ? new HashSet<String>(Arrays.asList(expandFieldsStr)) : null;
		return new BoolValueResponse(boolValue, expandFields);
	}
			


	@RequestMapping(value = "/{id}", method = RequestMethod.PUT)
	@ResponseStatus(HttpStatus.OK)
	public void updateBoolValue(@PathVariable Integer id, @Valid @RequestBody BoolValueRequest boolValueRequest)
			throws DatabaseException
	{
		_updateBoolValue(id, boolValueRequest);
	}

	// Spring's FormHttpMessageConverter cannot bind target classes (as ModelAttribute can)
	@RequestMapping(value = "/{id}", method = RequestMethod.PUT, headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseBody
	public ResponseEntity<BoolValueResponse> updateBoolValueFromForm(@PathVariable Integer id, @PathVariable String _method,
			@Valid @ModelAttribute BoolValueRequest boolValueRequest) throws DatabaseException
	{
		return _createBoolValue(boolValueRequest);
	}

	// Tunnel PUT through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=PUT")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void updateBoolValuePost(@PathVariable Integer id, @Valid @RequestBody BoolValueRequest boolValueRequest)
			throws DatabaseException
	{
		_updateBoolValue(id, boolValueRequest);
	}

	// Tunnel PUT through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=PUT", headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void updateBoolValueFromFormPost(@PathVariable Integer id, @Valid @ModelAttribute BoolValueRequest boolValueRequest)
			throws DatabaseException
	{
		_updateBoolValue(id, boolValueRequest);
	}

	private void _updateBoolValue(Integer id, BoolValueRequest boolValueRequest) throws DatabaseException
	{
		BoolValue boolValue = boolValueRequest.toBoolValue();
		boolValue.setId(id);
		boolValueService.update(boolValue);
	}

	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void deleteBoolValue(@PathVariable Integer id) throws DatabaseException
	{
		_deleteBoolValue(id);
	}

	// Tunnel DELETE through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=DELETE")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void deleteBoolValuePost(@PathVariable Integer id) throws DatabaseException
	{
		_deleteBoolValue(id);
	}

	private void _deleteBoolValue(Integer id) throws DatabaseException
	{
		boolean isDeleted = boolValueService.deleteById(id);
		if(!isDeleted) throw new EntityNotFoundException("BoolValue " + id.toString() + " not found");
	}
	
	@RequestMapping(method = RequestMethod.GET)
	@ResponseBody
	public EntityCollectionResponse<BoolValueResponse> retrieveBoolValueCollection(@Valid EntityCollectionRequest boolValueCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveBoolValueCollection(boolValueCollectionRequest, expandFields);
	}

	@RequestMapping(method = RequestMethod.GET, params = "format=json", produces = "application/json")
	@ResponseBody
	public EntityCollectionResponse<BoolValueResponse> retrieveBoolValueCollectionJson(@Valid EntityCollectionRequest boolValueCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveBoolValueCollection(boolValueCollectionRequest, expandFields);
	}

	// Tunnel GET with body through POST
	@RequestMapping(method = RequestMethod.POST, params = "_method=GET")
	@ResponseBody
	public EntityCollectionResponse<BoolValueResponse> retrieveBoolValueCollectionPost(@Valid @RequestBody EntityCollectionRequest boolValueCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveBoolValueCollection(boolValueCollectionRequest, expandFields);
	}

	// Tunnel GET with body through POST
	@RequestMapping(method = RequestMethod.POST, params = {"_method=GET", "format=json"}, produces = "application/json")
	@ResponseBody
	public EntityCollectionResponse<BoolValueResponse> retrieveBoolValueCollectionJsonPost(@Valid @RequestBody EntityCollectionRequest boolValueCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveBoolValueCollection(boolValueCollectionRequest, expandFields);
	}
	
	private EntityCollectionResponse<BoolValueResponse> _retrieveBoolValueCollection(EntityCollectionRequest entityCollectionRequest, String... expandFieldsStr) throws DatabaseException
	{
		EntityPager<BoolValue> boolValuePager = boolValueService.readAll(entityCollectionRequest.getStart(), entityCollectionRequest.getNum(), entityCollectionRequest.getQ());
		final Set<String> expandFields = expandFieldsStr != null ? new HashSet<String>(Arrays.asList(expandFieldsStr)) : null;
		return new EntityCollectionResponse<BoolValueResponse>(boolValuePager, Lists.newArrayList(Iterables.transform(
				boolValuePager.getIterable(), new Function<BoolValue, BoolValueResponse>()
				{
					@Override
					@Nullable
					public BoolValueResponse apply(@Nullable BoolValue boolValue)
					{
						try
						{
							return boolValue != null ? new BoolValueResponse(boolValue, expandFields) : null;
						} catch(DatabaseException e)
						{
							throw new RuntimeException(e);
						}
					}
				})), "/api/v1/boolvalue");
	}

	private static class BoolValueRequest
	{
		private Boolean value;
	
		public BoolValue toBoolValue()
		{
			BoolValue boolValue = new BoolValue();
			boolValue.setValue(value);
			return boolValue;
		}
		
		public void setValue(Boolean value)
		{
			this.value = value;
		}
		
	}

	static class BoolValueResponse
	{
		private final String href;
		private final Boolean value;
	
		public BoolValueResponse(BoolValue boolValue, final Set<String> expandFields) throws DatabaseException
		{
			this.href = "/api/v1/boolvalue/" + boolValue.getId();
			this.value = boolValue.getValue();
		}
	
		public String getHref()
		{
			return href;
		}
	
	
		public Boolean getValue()
		{
			return value;
		}
	
	}
	
	@ExceptionHandler(EntityNotFoundException.class)
	@ResponseStatus(value = HttpStatus.NOT_FOUND)
	public void handleEntityNotFoundException(EntityNotFoundException e)
	{
	}
	
	@ExceptionHandler(DatabaseAccessException.class)
	@ResponseStatus(value = HttpStatus.UNAUTHORIZED)
	public void handleDatabaseAccessException(DatabaseAccessException e)
	{
	}
}