package org.molgenis.controller;

import java.lang.RuntimeException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;
import javax.validation.Valid;

import org.molgenis.omx.ngs.FlowcellLane;
import org.molgenis.framework.server.EntityCollectionRequest;
import org.molgenis.framework.server.EntityCollectionResponse;
import org.molgenis.framework.db.DatabaseAccessException;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.EntityNotFoundException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.service.FlowcellLaneService;
import org.molgenis.omx.ngs.Flowcell;
import org.molgenis.controller.FlowcellController.FlowcellResponse;
import org.molgenis.service.FlowcellService;
import org.molgenis.omx.ngs.Sample;
import org.molgenis.controller.SampleController.SampleResponse;
import org.molgenis.service.SampleService;
import org.molgenis.omx.ngs.NgsUser;
import org.molgenis.controller.NgsUserController.NgsUserResponse;
import org.molgenis.service.NgsUserService;
import org.molgenis.util.EntityPager;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

@SuppressWarnings("unused")
@Lazy
@Controller
@RequestMapping("/api/v1/flowcelllane")
public class FlowcellLaneController
{
	@Autowired
	private FlowcellLaneService flowcellLaneService;

	@Autowired
	private FlowcellService flowcellService;
		
	@Autowired
	private SampleService sampleService;
		
	@Autowired
	private NgsUserService ngsUserService;
		
	@RequestMapping(method = RequestMethod.POST)
	@ResponseBody
	public ResponseEntity<FlowcellLaneResponse> createFlowcellLane(@Valid @RequestBody FlowcellLaneRequest flowcellLaneRequest)
			throws DatabaseException
	{
		return _createFlowcellLane(flowcellLaneRequest);
	}

	// Spring's FormHttpMessageConverter cannot bind target classes (as ModelAttribute can)
	@RequestMapping(method = RequestMethod.POST, headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseBody
	public ResponseEntity<FlowcellLaneResponse> createFlowcellLaneFromForm(@Valid @ModelAttribute FlowcellLaneRequest flowcellLaneRequest)
			throws DatabaseException
	{
		return _createFlowcellLane(flowcellLaneRequest);
	}

	private ResponseEntity<FlowcellLaneResponse> _createFlowcellLane(FlowcellLaneRequest flowcellLaneRequest) throws DatabaseException
	{
		FlowcellLane flowcellLane = flowcellLaneService.create(flowcellLaneRequest.toFlowcellLane());
		HttpHeaders responseHeaders = new HttpHeaders();
		responseHeaders.add("Location", "/api/v1/flowcelllane/" + flowcellLane.getId());
		return new ResponseEntity<FlowcellLaneResponse>(responseHeaders, HttpStatus.CREATED);
	}

	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ResponseBody
	public FlowcellLaneResponse retrieveFlowcellLane(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveFlowcellLane(id, expandFields);
	}
		
	@RequestMapping(value = "/{id}", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	@ResponseBody
	public FlowcellLaneResponse retrieveFlowcellLaneJson(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveFlowcellLane(id, expandFields);
	}

	private FlowcellLaneResponse _retrieveFlowcellLane(Integer id, String... expandFieldsStr) throws DatabaseException
	{
		FlowcellLane flowcellLane = flowcellLaneService.read(id);
		if (flowcellLane == null) throw new EntityNotFoundException("FlowcellLane " + id.toString() + " not found");
		Set<String> expandFields = expandFieldsStr != null ? new HashSet<String>(Arrays.asList(expandFieldsStr)) : null;
		return new FlowcellLaneResponse(flowcellLane, expandFields);
	}
			
	@RequestMapping(value = "/{id}/flowcell", method = RequestMethod.GET)
	public String retrieveFlowcellLaneXrefFlowcell(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveFlowcellLaneXrefFlowcell(id, null, expandFields);
	}
	
	@RequestMapping(value = "/{id}/flowcell", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	public String retrieveFlowcellLaneXrefFlowcellJson(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveFlowcellLaneXrefFlowcell(id, "json", expandFields);
	}
	
	private String _retrieveFlowcellLaneXrefFlowcell(Integer id, String format, String... expandFieldsStr) throws DatabaseException
	{
		FlowcellLane flowcellLane = flowcellLaneService.read(id);
		if (flowcellLane == null) throw new EntityNotFoundException("FlowcellLane " + id.toString() + " not found");
		Integer flowcellId = flowcellLane.getFlowcell_Id();
		String redirectUri = "redirect:/api/v1/flowcell/" + flowcellId.toString();
		StringBuilder qsBuilder = new StringBuilder();
		if(format != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("format=").append(format);
		if(expandFieldsStr != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("expand=").append(Joiner.on(',').join(expandFieldsStr));
		return qsBuilder.length() == 0 ? redirectUri : redirectUri + qsBuilder.toString();
	}
	
	@RequestMapping(value = "/{id}/sample", method = RequestMethod.GET)
	public String retrieveFlowcellLaneXrefSample(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveFlowcellLaneXrefSample(id, null, expandFields);
	}
	
	@RequestMapping(value = "/{id}/sample", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	public String retrieveFlowcellLaneXrefSampleJson(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveFlowcellLaneXrefSample(id, "json", expandFields);
	}
	
	private String _retrieveFlowcellLaneXrefSample(Integer id, String format, String... expandFieldsStr) throws DatabaseException
	{
		FlowcellLane flowcellLane = flowcellLaneService.read(id);
		if (flowcellLane == null) throw new EntityNotFoundException("FlowcellLane " + id.toString() + " not found");
		Integer sampleId = flowcellLane.getSample_Id();
		String redirectUri = "redirect:/api/v1/sample/" + sampleId.toString();
		StringBuilder qsBuilder = new StringBuilder();
		if(format != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("format=").append(format);
		if(expandFieldsStr != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("expand=").append(Joiner.on(',').join(expandFieldsStr));
		return qsBuilder.length() == 0 ? redirectUri : redirectUri + qsBuilder.toString();
	}
	
	@RequestMapping(value = "/{id}/qcWetUser", method = RequestMethod.GET)
	public String retrieveFlowcellLaneXrefQcWetUser(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveFlowcellLaneXrefQcWetUser(id, null, expandFields);
	}
	
	@RequestMapping(value = "/{id}/qcWetUser", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	public String retrieveFlowcellLaneXrefQcWetUserJson(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveFlowcellLaneXrefQcWetUser(id, "json", expandFields);
	}
	
	private String _retrieveFlowcellLaneXrefQcWetUser(Integer id, String format, String... expandFieldsStr) throws DatabaseException
	{
		FlowcellLane flowcellLane = flowcellLaneService.read(id);
		if (flowcellLane == null) throw new EntityNotFoundException("FlowcellLane " + id.toString() + " not found");
		Integer ngsUserId = flowcellLane.getQcWetUser_Id();
		String redirectUri = "redirect:/api/v1/ngsuser/" + ngsUserId.toString();
		StringBuilder qsBuilder = new StringBuilder();
		if(format != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("format=").append(format);
		if(expandFieldsStr != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("expand=").append(Joiner.on(',').join(expandFieldsStr));
		return qsBuilder.length() == 0 ? redirectUri : redirectUri + qsBuilder.toString();
	}
	
	@RequestMapping(value = "/{id}/qcDryUser", method = RequestMethod.GET)
	public String retrieveFlowcellLaneXrefQcDryUser(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveFlowcellLaneXrefQcDryUser(id, null, expandFields);
	}
	
	@RequestMapping(value = "/{id}/qcDryUser", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	public String retrieveFlowcellLaneXrefQcDryUserJson(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveFlowcellLaneXrefQcDryUser(id, "json", expandFields);
	}
	
	private String _retrieveFlowcellLaneXrefQcDryUser(Integer id, String format, String... expandFieldsStr) throws DatabaseException
	{
		FlowcellLane flowcellLane = flowcellLaneService.read(id);
		if (flowcellLane == null) throw new EntityNotFoundException("FlowcellLane " + id.toString() + " not found");
		Integer ngsUserId = flowcellLane.getQcDryUser_Id();
		String redirectUri = "redirect:/api/v1/ngsuser/" + ngsUserId.toString();
		StringBuilder qsBuilder = new StringBuilder();
		if(format != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("format=").append(format);
		if(expandFieldsStr != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("expand=").append(Joiner.on(',').join(expandFieldsStr));
		return qsBuilder.length() == 0 ? redirectUri : redirectUri + qsBuilder.toString();
	}
	


	@RequestMapping(value = "/{id}", method = RequestMethod.PUT)
	@ResponseStatus(HttpStatus.OK)
	public void updateFlowcellLane(@PathVariable Integer id, @Valid @RequestBody FlowcellLaneRequest flowcellLaneRequest)
			throws DatabaseException
	{
		_updateFlowcellLane(id, flowcellLaneRequest);
	}

	// Spring's FormHttpMessageConverter cannot bind target classes (as ModelAttribute can)
	@RequestMapping(value = "/{id}", method = RequestMethod.PUT, headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseBody
	public ResponseEntity<FlowcellLaneResponse> updateFlowcellLaneFromForm(@PathVariable Integer id, @PathVariable String _method,
			@Valid @ModelAttribute FlowcellLaneRequest flowcellLaneRequest) throws DatabaseException
	{
		return _createFlowcellLane(flowcellLaneRequest);
	}

	// Tunnel PUT through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=PUT")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void updateFlowcellLanePost(@PathVariable Integer id, @Valid @RequestBody FlowcellLaneRequest flowcellLaneRequest)
			throws DatabaseException
	{
		_updateFlowcellLane(id, flowcellLaneRequest);
	}

	// Tunnel PUT through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=PUT", headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void updateFlowcellLaneFromFormPost(@PathVariable Integer id, @Valid @ModelAttribute FlowcellLaneRequest flowcellLaneRequest)
			throws DatabaseException
	{
		_updateFlowcellLane(id, flowcellLaneRequest);
	}

	private void _updateFlowcellLane(Integer id, FlowcellLaneRequest flowcellLaneRequest) throws DatabaseException
	{
		FlowcellLane flowcellLane = flowcellLaneRequest.toFlowcellLane();
		flowcellLane.setId(id);
		flowcellLaneService.update(flowcellLane);
	}

	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void deleteFlowcellLane(@PathVariable Integer id) throws DatabaseException
	{
		_deleteFlowcellLane(id);
	}

	// Tunnel DELETE through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=DELETE")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void deleteFlowcellLanePost(@PathVariable Integer id) throws DatabaseException
	{
		_deleteFlowcellLane(id);
	}

	private void _deleteFlowcellLane(Integer id) throws DatabaseException
	{
		boolean isDeleted = flowcellLaneService.deleteById(id);
		if(!isDeleted) throw new EntityNotFoundException("FlowcellLane " + id.toString() + " not found");
	}
	
	@RequestMapping(method = RequestMethod.GET)
	@ResponseBody
	public EntityCollectionResponse<FlowcellLaneResponse> retrieveFlowcellLaneCollection(@Valid EntityCollectionRequest flowcellLaneCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveFlowcellLaneCollection(flowcellLaneCollectionRequest, expandFields);
	}

	@RequestMapping(method = RequestMethod.GET, params = "format=json", produces = "application/json")
	@ResponseBody
	public EntityCollectionResponse<FlowcellLaneResponse> retrieveFlowcellLaneCollectionJson(@Valid EntityCollectionRequest flowcellLaneCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveFlowcellLaneCollection(flowcellLaneCollectionRequest, expandFields);
	}

	// Tunnel GET with body through POST
	@RequestMapping(method = RequestMethod.POST, params = "_method=GET")
	@ResponseBody
	public EntityCollectionResponse<FlowcellLaneResponse> retrieveFlowcellLaneCollectionPost(@Valid @RequestBody EntityCollectionRequest flowcellLaneCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveFlowcellLaneCollection(flowcellLaneCollectionRequest, expandFields);
	}

	// Tunnel GET with body through POST
	@RequestMapping(method = RequestMethod.POST, params = {"_method=GET", "format=json"}, produces = "application/json")
	@ResponseBody
	public EntityCollectionResponse<FlowcellLaneResponse> retrieveFlowcellLaneCollectionJsonPost(@Valid @RequestBody EntityCollectionRequest flowcellLaneCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveFlowcellLaneCollection(flowcellLaneCollectionRequest, expandFields);
	}
	
	private EntityCollectionResponse<FlowcellLaneResponse> _retrieveFlowcellLaneCollection(EntityCollectionRequest entityCollectionRequest, String... expandFieldsStr) throws DatabaseException
	{
		EntityPager<FlowcellLane> flowcellLanePager = flowcellLaneService.readAll(entityCollectionRequest.getStart(), entityCollectionRequest.getNum(), entityCollectionRequest.getQ());
		final Set<String> expandFields = expandFieldsStr != null ? new HashSet<String>(Arrays.asList(expandFieldsStr)) : null;
		return new EntityCollectionResponse<FlowcellLaneResponse>(flowcellLanePager, Lists.newArrayList(Iterables.transform(
				flowcellLanePager.getIterable(), new Function<FlowcellLane, FlowcellLaneResponse>()
				{
					@Override
					@Nullable
					public FlowcellLaneResponse apply(@Nullable FlowcellLane flowcellLane)
					{
						try
						{
							return flowcellLane != null ? new FlowcellLaneResponse(flowcellLane, expandFields) : null;
						} catch(DatabaseException e)
						{
							throw new RuntimeException(e);
						}
					}
				})), "/api/v1/flowcelllane");
	}

	private static class FlowcellLaneRequest
	{
		private Integer flowcell;
		private String lane;
		private Integer sample;
		private String flowcellLaneComment;
		private String qcWetMet;
		private Integer qcWetUser;
		private java.util.Date qcWetDate;
		private String qcDryMet;
		private Integer qcDryUser;
		private java.util.Date qcDryDate;
	
		public FlowcellLane toFlowcellLane()
		{
			FlowcellLane flowcellLane = new FlowcellLane();
			flowcellLane.setFlowcell_Id(flowcell);
			flowcellLane.setLane(lane);
			flowcellLane.setSample_Id(sample);
			flowcellLane.setFlowcellLaneComment(flowcellLaneComment);
			flowcellLane.setQcWetMet(qcWetMet);
			flowcellLane.setQcWetUser_Id(qcWetUser);
			flowcellLane.setQcWetDate(qcWetDate);
			flowcellLane.setQcDryMet(qcDryMet);
			flowcellLane.setQcDryUser_Id(qcDryUser);
			flowcellLane.setQcDryDate(qcDryDate);
			return flowcellLane;
		}
		
		public void setFlowcell(Integer flowcell)
		{
			this.flowcell = flowcell;
		}
		
		public void setLane(String lane)
		{
			this.lane = lane;
		}
		
		public void setSample(Integer sample)
		{
			this.sample = sample;
		}
		
		public void setFlowcellLaneComment(String flowcellLaneComment)
		{
			this.flowcellLaneComment = flowcellLaneComment;
		}
		
		public void setQcWetMet(String qcWetMet)
		{
			this.qcWetMet = qcWetMet;
		}
		
		public void setQcWetUser(Integer qcWetUser)
		{
			this.qcWetUser = qcWetUser;
		}
		
		public void setQcWetDate(java.util.Date qcWetDate)
		{
			this.qcWetDate = qcWetDate;
		}
		
		public void setQcDryMet(String qcDryMet)
		{
			this.qcDryMet = qcDryMet;
		}
		
		public void setQcDryUser(Integer qcDryUser)
		{
			this.qcDryUser = qcDryUser;
		}
		
		public void setQcDryDate(java.util.Date qcDryDate)
		{
			this.qcDryDate = qcDryDate;
		}
		
	}

	static class FlowcellLaneResponse
	{
		private final String href;
		private final Object flowcell;
		private final String lane;
		private final Object sample;
		private final String flowcellLaneComment;
		private final String qcWetMet;
		private final Object qcWetUser;
		private final java.util.Date qcWetDate;
		private final String qcDryMet;
		private final Object qcDryUser;
		private final java.util.Date qcDryDate;
	
		public FlowcellLaneResponse(FlowcellLane flowcellLane, final Set<String> expandFields) throws DatabaseException
		{
			this.href = "/api/v1/flowcelllane/" + flowcellLane.getId();
			if (expandFields != null && expandFields.contains("flowcell")) this.flowcell = flowcellLane.getFlowcell() == null ? null : new FlowcellResponse(flowcellLane.getFlowcell(), null);
			else this.flowcell = flowcellLane.getFlowcell() == null ? null : java.util.Collections.singletonMap("href", "/api/v1/flowcelllane/" + flowcellLane.getId() + "/flowcell");
			this.lane = flowcellLane.getLane();
			if (expandFields != null && expandFields.contains("sample")) this.sample = new SampleResponse(flowcellLane.getSample(), null);
			else this.sample = java.util.Collections.singletonMap("href", "/api/v1/flowcelllane/" + flowcellLane.getId() + "/sample");
			this.flowcellLaneComment = flowcellLane.getFlowcellLaneComment();
			this.qcWetMet = flowcellLane.getQcWetMet();
			if (expandFields != null && expandFields.contains("qcWetUser")) this.qcWetUser = flowcellLane.getQcWetUser() == null ? null : new NgsUserResponse(flowcellLane.getQcWetUser(), null);
			else this.qcWetUser = flowcellLane.getQcWetUser() == null ? null : java.util.Collections.singletonMap("href", "/api/v1/flowcelllane/" + flowcellLane.getId() + "/qcWetUser");
			this.qcWetDate = flowcellLane.getQcWetDate();
			this.qcDryMet = flowcellLane.getQcDryMet();
			if (expandFields != null && expandFields.contains("qcDryUser")) this.qcDryUser = flowcellLane.getQcDryUser() == null ? null : new NgsUserResponse(flowcellLane.getQcDryUser(), null);
			else this.qcDryUser = flowcellLane.getQcDryUser() == null ? null : java.util.Collections.singletonMap("href", "/api/v1/flowcelllane/" + flowcellLane.getId() + "/qcDryUser");
			this.qcDryDate = flowcellLane.getQcDryDate();
		}
	
		public String getHref()
		{
			return href;
		}
	
		public Object getFlowcell()
		{
			return flowcell;
		}
	
		public String getLane()
		{
			return lane;
		}
	
		public Object getSample()
		{
			return sample;
		}
	
		public String getFlowcellLaneComment()
		{
			return flowcellLaneComment;
		}
	
		public String getQcWetMet()
		{
			return qcWetMet;
		}
	
		public Object getQcWetUser()
		{
			return qcWetUser;
		}
	
		public java.util.Date getQcWetDate()
		{
			return qcWetDate;
		}
	
		public String getQcDryMet()
		{
			return qcDryMet;
		}
	
		public Object getQcDryUser()
		{
			return qcDryUser;
		}
	
		public java.util.Date getQcDryDate()
		{
			return qcDryDate;
		}
	
	}
	
	@ExceptionHandler(EntityNotFoundException.class)
	@ResponseStatus(value = HttpStatus.NOT_FOUND)
	public void handleEntityNotFoundException(EntityNotFoundException e)
	{
	}
	
	@ExceptionHandler(DatabaseAccessException.class)
	@ResponseStatus(value = HttpStatus.UNAUTHORIZED)
	public void handleDatabaseAccessException(DatabaseAccessException e)
	{
	}
}