
/* File:        ngs/model/Sample.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.ngs;

/**
 * Sample: A Sample bundles information about a sample. Sample can be pooled. A pooled sample is just another sample, but with a additional mref (many to many) linking to the samples inside the pool..
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
//@org.hibernate.search.annotations.Indexed
@javax.persistence.Table(name = "Sample", uniqueConstraints={ @javax.persistence.UniqueConstraint( columnNames={ "InternalId" } ) }
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
//@EntityListeners({org.molgenis.omx.ngs.db.SampleEntityListener.class})
public class Sample extends org.molgenis.util.AbstractEntity implements org.molgenis.omx.core.Autoid
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
	// fieldname constants
	public final static String ID = "id";
	public final static String INTERNALID = "InternalId";
	public final static String EXTERNALID = "ExternalId";
	public final static String SAMPLECOMMENT = "SampleComment";
	public final static String PROJECTID = "ProjectId";
	public final static String PROJECTID_PROJECTNAME = "ProjectId_ProjectName";
	public final static String ARRAYFILE = "ArrayFile";
	public final static String ARRAYID = "ArrayId";
	public final static String CAPTURINGKIT = "CapturingKit";
	public final static String CAPTURINGKIT_CAPTURINGKITNAME = "CapturingKit_CapturingKitName";
	public final static String SAMPLEBARCODE = "SampleBarcode";
	public final static String SAMPLEBARCODE_SAMPLEBARCODENAME = "SampleBarcode_SampleBarcodeName";
	public final static String SAMPLEINPOOL = "SampleInPool";
	public final static String SAMPLEINPOOL_INTERNALID = "SampleInPool_InternalId";
	public final static String LABSTATUS = "LabStatus";
	
	//static methods
	/**
	 * Shorthand for db.query(Sample.class).
	 */
	public static org.molgenis.framework.db.Query<? extends Sample> query(org.molgenis.framework.db.Database db)
	{
		return db.query(Sample.class);
	}
	
	/**
	 * Shorthand for db.find(Sample.class, org.molgenis.framework.db.QueryRule ... rules).
	 */
	public static java.util.List<? extends Sample> find(org.molgenis.framework.db.Database db, org.molgenis.framework.db.QueryRule ... rules) throws org.molgenis.framework.db.DatabaseException
	{
		return db.find(Sample.class, rules);
	}	
	
	/**
	 * 
	 */
	public static Sample findById(org.molgenis.framework.db.Database db, Integer id) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<Sample> q = db.query(Sample.class);
		q.eq(Sample.ID, id);
		java.util.List<Sample> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	/**
	 * 
	 */
	public static Sample findByInternalId(org.molgenis.framework.db.Database db, String internalId) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<Sample> q = db.query(Sample.class);
		q.eq(Sample.INTERNALID, internalId);
		java.util.List<Sample> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	
	// member variables (including setters.getters for interface)

	//automatically generated internal id, only for internal use.[type=int]
    @javax.persistence.Id @javax.persistence.GeneratedValue(strategy = javax.persistence.GenerationType.AUTO)
    @javax.persistence.Column(name="id", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="id")
	
	//@javax.validation.constraints.NotNull
	private Integer id =  null;

	//The number of a sample as used in-house[type=string]
//	@org.hibernate.search.annotations.Field(index=org.hibernate.search.annotations.Index.TOKENIZED, store=org.hibernate.search.annotations.Store.NO)
	@javax.persistence.Column(name="InternalId", length=255, nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="internalId")
	
				

	@javax.validation.constraints.NotNull
	private String internalId =  null;

	//The name of a sample as known by the customer[type=string]
	@javax.persistence.Column(name="ExternalId", length=255)
	@javax.xml.bind.annotation.XmlElement(name="externalId")
	
				

	private String externalId =  null;

	//Comments about the sample[type=text]
	@javax.persistence.Lob
	@javax.persistence.Column(name="SampleComment")
	
				

	private String sampleComment =  null;

	//the sample that this sample is part of[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="ProjectId", nullable=false)   	
	
				

	@javax.validation.constraints.NotNull
	private org.molgenis.omx.ngs.Project projectId = null;
	@javax.persistence.Transient
	private Integer projectId_id = null;	
	@javax.persistence.Transient
	private String projectId_ProjectName = null;						

	//Location of arrayfile for the sample in this lane-barcode[type=string]
	@javax.persistence.Column(name="ArrayFile", length=255)
	@javax.xml.bind.annotation.XmlElement(name="arrayFile")
	
				

	private String arrayFile =  null;

	//ID of the sample on the arrayFile[type=string]
	@javax.persistence.Column(name="ArrayId", length=255)
	@javax.xml.bind.annotation.XmlElement(name="arrayId")
	
				

	private String arrayId =  null;

	//Capturing kit used.[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="CapturingKit")   	
	
				

	private org.molgenis.omx.ngs.CapturingKit capturingKit = null;
	@javax.persistence.Transient
	private Integer capturingKit_id = null;	
	@javax.persistence.Transient
	private String capturingKit_CapturingKitName = null;						

	//Multiple samples can be on one flowcell using barcodes.[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="SampleBarcode")   	
	
				

	private org.molgenis.omx.ngs.SampleBarcode sampleBarcode = null;
	@javax.persistence.Transient
	private Integer sampleBarcode_id = null;	
	@javax.persistence.Transient
	private String sampleBarcode_SampleBarcodeName = null;						

	//List of samples inside the pool[type=mref]
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="SampleInPool", insertable=true, updatable=true, nullable=true)
	@javax.persistence.JoinTable(name="Sample_SampleInPool", 
			joinColumns=@javax.persistence.JoinColumn(name="Sample"), inverseJoinColumns=@javax.persistence.JoinColumn(name="SampleInPool"))
	
				

	private java.util.List<org.molgenis.omx.ngs.Sample> sampleInPool = new java.util.ArrayList<org.molgenis.omx.ngs.Sample>();
	@javax.persistence.Transient
	private java.util.List<Integer> sampleInPool_id = new java.util.ArrayList<Integer>();		
	@javax.persistence.Transient
	private java.util.List<String> sampleInPool_InternalId = new java.util.ArrayList<String>();

	//Lab status phase of this sample[type=enum]
	@javax.persistence.Column(name="LabStatus", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="labStatus")
	
				

	@javax.validation.constraints.NotNull
	private String labStatus =  "Not Started";
	@javax.persistence.Transient
	private String labStatus_label = null;
	@javax.persistence.Transient
	private static final java.util.List<org.molgenis.util.ValueLabel> labStatus_options;
	
	static {
		labStatus_options = new java.util.ArrayList<org.molgenis.util.ValueLabel>();
		labStatus_options.add(new org.molgenis.util.ValueLabel("Not Started","Not Started"));
		labStatus_options.add(new org.molgenis.util.ValueLabel("Sample Prep _ Started","Sample Prep _ Started"));
		labStatus_options.add(new org.molgenis.util.ValueLabel("Sample Prep _ Failed","Sample Prep _ Failed"));
		labStatus_options.add(new org.molgenis.util.ValueLabel("Ready for Clustering","Ready for Clustering"));
		labStatus_options.add(new org.molgenis.util.ValueLabel("Clustering and Sequencing _ Started","Clustering and Sequencing _ Started"));
		labStatus_options.add(new org.molgenis.util.ValueLabel("Clustering and Sequencing _ Failed","Clustering and Sequencing _ Failed"));
		labStatus_options.add(new org.molgenis.util.ValueLabel("Data Post Processing","Data Post Processing"));
		labStatus_options.add(new org.molgenis.util.ValueLabel("Finished Successfully","Finished Successfully"));
		labStatus_options.add(new org.molgenis.util.ValueLabel("Other","Other"));
	}

	//constructors
	public Sample()
	{
	}
	
	/** copy constructor */
	public Sample(Sample copyMe) throws Exception
	{	
		for(String f : this.getFields())
		{
			this.set(f, copyMe.get(f));
		}	
	}
	
	//getters and setters
	/**
	 * Get the automatically generated internal id, only for internal use..
	 * @return id.
	 */
	public Integer getId()
	{
		return this.id;
	}
	
	
	/**
	 * Set the automatically generated internal id, only for internal use..
	 * @param id
	 */
	public void setId( Integer id)
	{
		this.id = id;
	}

	

	/**
	 * Get the The number of a sample as used in-house.
	 * @return internalId.
	 */
	public String getInternalId()
	{
		return this.internalId;
	}
	
	@Deprecated
	public String getInternalId(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The number of a sample as used in-house.
	 * @param internalId
	 */
	public void setInternalId( String internalId)
	{
		
		this.internalId = internalId;
	}

	

	/**
	 * Get the The name of a sample as known by the customer.
	 * @return externalId.
	 */
	public String getExternalId()
	{
		return this.externalId;
	}
	
	@Deprecated
	public String getExternalId(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The name of a sample as known by the customer.
	 * @param externalId
	 */
	public void setExternalId( String externalId)
	{
		
		this.externalId = externalId;
	}

	

	/**
	 * Get the Comments about the sample.
	 * @return sampleComment.
	 */
	public String getSampleComment()
	{
		return this.sampleComment;
	}
	
	@Deprecated
	public String getSampleComment(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Comments about the sample.
	 * @param sampleComment
	 */
	public void setSampleComment( String sampleComment)
	{
		
		this.sampleComment = sampleComment;
	}

	

	/**
	 * Get the the sample that this sample is part of.
	 * @return projectId.
	 */
	public org.molgenis.omx.ngs.Project getProjectId()
	{
		return this.projectId;
	}
	
	@Deprecated
	public org.molgenis.omx.ngs.Project getProjectId(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the the sample that this sample is part of.
	 * @param projectId
	 */
	public void setProjectId( org.molgenis.omx.ngs.Project projectId)
	{
		
		this.projectId = projectId;
	}

	
	
	/**
	 * Set foreign key for field projectId.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setProjectId_Id(Integer projectId_id)
	{
		this.projectId_id = projectId_id;
	}	

	public void setProjectId(Integer projectId_id)
	{
		this.projectId_id = projectId_id;
	}
	
	public Integer getProjectId_Id()
	{
		
		if(projectId != null) 
		{
			return projectId.getId();
		}
		else
		{
			return projectId_id;
		}
	}	
	 
	/**
	 * Get a pretty label ProjectName for cross reference ProjectId to Project.Id.
	 */
	public String getProjectId_ProjectName()
	{		
		//FIXME should we auto-load based on getProjectId()?	
		if(projectId != null) {
			return projectId.getProjectName();
		} else {
			return projectId_ProjectName;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference ProjectId to <a href="Project.html#Id">Project.Id</a>.
	 * Implies setProjectId(null) until save
	 */
	public void setProjectId_ProjectName(String projectId_ProjectName)
	{
		this.projectId_ProjectName = projectId_ProjectName;
	}		
	 
	

	/**
	 * Get the Location of arrayfile for the sample in this lane-barcode.
	 * @return arrayFile.
	 */
	public String getArrayFile()
	{
		return this.arrayFile;
	}
	
	@Deprecated
	public String getArrayFile(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Location of arrayfile for the sample in this lane-barcode.
	 * @param arrayFile
	 */
	public void setArrayFile( String arrayFile)
	{
		
		this.arrayFile = arrayFile;
	}

	

	/**
	 * Get the ID of the sample on the arrayFile.
	 * @return arrayId.
	 */
	public String getArrayId()
	{
		return this.arrayId;
	}
	
	@Deprecated
	public String getArrayId(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the ID of the sample on the arrayFile.
	 * @param arrayId
	 */
	public void setArrayId( String arrayId)
	{
		
		this.arrayId = arrayId;
	}

	

	/**
	 * Get the Capturing kit used..
	 * @return capturingKit.
	 */
	public org.molgenis.omx.ngs.CapturingKit getCapturingKit()
	{
		return this.capturingKit;
	}
	
	@Deprecated
	public org.molgenis.omx.ngs.CapturingKit getCapturingKit(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Capturing kit used..
	 * @param capturingKit
	 */
	public void setCapturingKit( org.molgenis.omx.ngs.CapturingKit capturingKit)
	{
		
		this.capturingKit = capturingKit;
	}

	
	
	/**
	 * Set foreign key for field capturingKit.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setCapturingKit_Id(Integer capturingKit_id)
	{
		this.capturingKit_id = capturingKit_id;
	}	

	public void setCapturingKit(Integer capturingKit_id)
	{
		this.capturingKit_id = capturingKit_id;
	}
	
	public Integer getCapturingKit_Id()
	{
		
		if(capturingKit != null) 
		{
			return capturingKit.getId();
		}
		else
		{
			return capturingKit_id;
		}
	}	
	 
	/**
	 * Get a pretty label CapturingKitName for cross reference CapturingKit to CapturingKit.Id.
	 */
	public String getCapturingKit_CapturingKitName()
	{		
		//FIXME should we auto-load based on getCapturingKit()?	
		if(capturingKit != null) {
			return capturingKit.getCapturingKitName();
		} else {
			return capturingKit_CapturingKitName;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference CapturingKit to <a href="CapturingKit.html#Id">CapturingKit.Id</a>.
	 * Implies setCapturingKit(null) until save
	 */
	public void setCapturingKit_CapturingKitName(String capturingKit_CapturingKitName)
	{
		this.capturingKit_CapturingKitName = capturingKit_CapturingKitName;
	}		
	 
	

	/**
	 * Get the Multiple samples can be on one flowcell using barcodes..
	 * @return sampleBarcode.
	 */
	public org.molgenis.omx.ngs.SampleBarcode getSampleBarcode()
	{
		return this.sampleBarcode;
	}
	
	@Deprecated
	public org.molgenis.omx.ngs.SampleBarcode getSampleBarcode(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Multiple samples can be on one flowcell using barcodes..
	 * @param sampleBarcode
	 */
	public void setSampleBarcode( org.molgenis.omx.ngs.SampleBarcode sampleBarcode)
	{
		
		this.sampleBarcode = sampleBarcode;
	}

	
	
	/**
	 * Set foreign key for field sampleBarcode.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setSampleBarcode_Id(Integer sampleBarcode_id)
	{
		this.sampleBarcode_id = sampleBarcode_id;
	}	

	public void setSampleBarcode(Integer sampleBarcode_id)
	{
		this.sampleBarcode_id = sampleBarcode_id;
	}
	
	public Integer getSampleBarcode_Id()
	{
		
		if(sampleBarcode != null) 
		{
			return sampleBarcode.getId();
		}
		else
		{
			return sampleBarcode_id;
		}
	}	
	 
	/**
	 * Get a pretty label SampleBarcodeName for cross reference SampleBarcode to SampleBarcode.Id.
	 */
	public String getSampleBarcode_SampleBarcodeName()
	{		
		//FIXME should we auto-load based on getSampleBarcode()?	
		if(sampleBarcode != null) {
			return sampleBarcode.getSampleBarcodeName();
		} else {
			return sampleBarcode_SampleBarcodeName;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference SampleBarcode to <a href="SampleBarcode.html#Id">SampleBarcode.Id</a>.
	 * Implies setSampleBarcode(null) until save
	 */
	public void setSampleBarcode_SampleBarcodeName(String sampleBarcode_SampleBarcodeName)
	{
		this.sampleBarcode_SampleBarcodeName = sampleBarcode_SampleBarcodeName;
	}		
	 
	

	/**
	 * Get the List of samples inside the pool.
	 * @return sampleInPool.
	 */
	public java.util.List<org.molgenis.omx.ngs.Sample> getSampleInPool()
	{
		return this.sampleInPool;
	}
	
	@Deprecated
	public java.util.List<org.molgenis.omx.ngs.Sample> getSampleInPool(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the List of samples inside the pool.
	 * @param sampleInPool
	 */
	public void setSampleInPool( java.util.List<org.molgenis.omx.ngs.Sample> sampleInPool)
	{
		
		this.sampleInPool = sampleInPool;
	}

	
	public void setSampleInPool_Id(Integer ... sampleInPool)
	{
		this.setSampleInPool_Id(java.util.Arrays.asList(sampleInPool));
	}	
	
	public void setSampleInPool(org.molgenis.omx.ngs.Sample ... sampleInPool)
	{
		this.setSampleInPool(java.util.Arrays.asList(sampleInPool));
	}	
	
	/**
	 * Set foreign key for field sampleInPool.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setSampleInPool_Id(java.util.List<Integer> sampleInPool_id)
	{
		this.sampleInPool_id = sampleInPool_id;
	}	
	
	public java.util.List<Integer> getSampleInPool_Id()
	{
		if(sampleInPool != null && !sampleInPool.isEmpty()) {
			java.util.List<Integer> result = new java.util.ArrayList<Integer>();
			for (int i = 0; i < sampleInPool.size(); i++)
				result.add(sampleInPool.get(i).getId());
			return result;
		} else {
			if(sampleInPool_id == null) {
				sampleInPool_id = new java.util.ArrayList<Integer>();
			}		
			return sampleInPool_id;
		}
	}	
	
	/**
	 * Get a pretty label for cross reference SampleInPool to <a href="Sample.html#Id">Sample.Id</a>.
	 */
	public java.util.List<String> getSampleInPool_InternalId()
	{
		if(this.sampleInPool != null && !this.sampleInPool.isEmpty())
		{
			java.util.List<String> result = new java.util.ArrayList<String>(this.sampleInPool.size());
			for(org.molgenis.omx.ngs.Sample o: sampleInPool) result.add(o.getInternalId());
			return java.util.Collections.unmodifiableList(result);
		}	
		else
		{	
			return sampleInPool_InternalId;
		}
	}
	
	/**
	 * Update the foreign key SampleInPool
	 * This sets sampleInPool to null until next database transaction.
	 */
	public void setSampleInPool_InternalId(java.util.List<String> sampleInPool_InternalId)
	{
		this.sampleInPool_InternalId = sampleInPool_InternalId;
	}		
	

	/**
	 * Get the Lab status phase of this sample.
	 * @return labStatus.
	 */
	public String getLabStatus()
	{
		return this.labStatus;
	}
	
	@Deprecated
	public String getLabStatus(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Lab status phase of this sample.
	 * @param labStatus
	 */
	public void setLabStatus( String labStatus)
	{
		
		this.labStatus = labStatus;
	}

	
	/**
	 * Get tha label for enum LabStatus.
	 */
	public String getLabStatusLabel()
	{
		return this.labStatus_label;
	}
	/**
	 * LabStatus is enum. This method returns all available enum options.
	 */
	public java.util.List<org.molgenis.util.ValueLabel> getLabStatusOptions()
	{
		return labStatus_options;
	}	
	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("internalid"))
			return getInternalId();
		if (name.equals("externalid"))
			return getExternalId();
		if (name.equals("samplecomment"))
			return getSampleComment();
		if (name.equals("projectid"))
			return getProjectId();
		if(name.equals("projectid_id"))
			return getProjectId_Id();
		if(name.equals("projectid_projectname"))
			return getProjectId_ProjectName();
		if (name.equals("arrayfile"))
			return getArrayFile();
		if (name.equals("arrayid"))
			return getArrayId();
		if (name.equals("capturingkit"))
			return getCapturingKit();
		if(name.equals("capturingkit_id"))
			return getCapturingKit_Id();
		if(name.equals("capturingkit_capturingkitname"))
			return getCapturingKit_CapturingKitName();
		if (name.equals("samplebarcode"))
			return getSampleBarcode();
		if(name.equals("samplebarcode_id"))
			return getSampleBarcode_Id();
		if(name.equals("samplebarcode_samplebarcodename"))
			return getSampleBarcode_SampleBarcodeName();
		if (name.equals("sampleinpool"))
			return getSampleInPool();
		if(name.equals("sampleinpool_id"))
			return getSampleInPool_Id();
		if(name.equals("sampleinpool_internalid"))
			return getSampleInPool_InternalId();
		if (name.equals("labstatus"))
			return getLabStatus();
		if(name.equals("labstatus_label"))
			return getLabStatusLabel();
		return null;
	}	
	
	@Override
	public void validate() throws org.molgenis.framework.db.DatabaseException
	{
		if(this.getId() == null) throw new org.molgenis.framework.db.DatabaseException("required field id is null");
		if(this.getInternalId() == null) throw new org.molgenis.framework.db.DatabaseException("required field internalId is null");
		if(this.getProjectId() == null) throw new org.molgenis.framework.db.DatabaseException("required field projectId is null");
		if(this.getLabStatus() == null) throw new org.molgenis.framework.db.DatabaseException("required field labStatus is null");
	}
	
	@Override
	public void set(org.molgenis.util.tuple.Tuple tuple, boolean strict ) throws Exception
	{
		//set Id
		// query formal name, else lowercase name
		if(tuple.getInt("id") != null) this.setId(tuple.getInt("id"));
		else if(tuple.getInt("id") != null) this.setId(tuple.getInt("id"));
		else if(strict) this.setId(tuple.getInt("id")); // setting null is not an option due to function overloading
		if( tuple.getInt("sample_id") != null) this.setId(tuple.getInt("sample_id"));
		else if( tuple.getInt("Sample_id") != null) this.setId(tuple.getInt("Sample_id"));
		//set InternalId
		// query formal name, else lowercase name
		if(tuple.getString("internalid") != null) this.setInternalId(tuple.getString("internalid"));
		else if(tuple.getString("InternalId") != null) this.setInternalId(tuple.getString("InternalId"));
		else if(strict) this.setInternalId(tuple.getString("internalid")); // setting null is not an option due to function overloading
		if( tuple.getString("sample_internalid") != null) this.setInternalId(tuple.getString("sample_internalid"));
		else if( tuple.getString("Sample_InternalId") != null) this.setInternalId(tuple.getString("Sample_InternalId"));
		//set ExternalId
		// query formal name, else lowercase name
		if(tuple.getString("externalid") != null) this.setExternalId(tuple.getString("externalid"));
		else if(tuple.getString("ExternalId") != null) this.setExternalId(tuple.getString("ExternalId"));
		else if(strict) this.setExternalId(tuple.getString("externalid")); // setting null is not an option due to function overloading
		if( tuple.getString("sample_externalid") != null) this.setExternalId(tuple.getString("sample_externalid"));
		else if( tuple.getString("Sample_ExternalId") != null) this.setExternalId(tuple.getString("Sample_ExternalId"));
		//set SampleComment
		// query formal name, else lowercase name
		if(tuple.getString("samplecomment") != null) this.setSampleComment(tuple.getString("samplecomment"));
		else if(tuple.getString("SampleComment") != null) this.setSampleComment(tuple.getString("SampleComment"));
		else if(strict) this.setSampleComment(tuple.getString("samplecomment")); // setting null is not an option due to function overloading
		if( tuple.getString("sample_samplecomment") != null) this.setSampleComment(tuple.getString("sample_samplecomment"));
		else if( tuple.getString("Sample_SampleComment") != null) this.setSampleComment(tuple.getString("Sample_SampleComment"));
		//set ProjectId
		// query formal name, else lowercase name
		if(tuple.getInt("ProjectId_id") != null) this.setProjectId(tuple.getInt("ProjectId_id"));
		else if(tuple.getInt("projectid_id") != null) this.setProjectId(tuple.getInt("projectid_id"));
		else if(strict) this.setProjectId(tuple.getInt("ProjectId_id")); // setting null is not an option due to function overloading
		
		if( tuple.getInt("Sample_ProjectId_id") != null) this.setProjectId(tuple.getInt("Sample_ProjectId_id"));
		else if( tuple.getInt("sample_projectid_id") != null) this.setProjectId(tuple.getInt("sample_projectid_id"));
		//alias of xref
		if( tuple.get("ProjectId") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("ProjectId").toString())) {
				org.molgenis.omx.ngs.Project instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("ProjectId"), org.molgenis.omx.ngs.Project.class);
				this.setProjectId(instance);				
			} else {
				this.setProjectId_Id(tuple.getInt("ProjectId")); 
			}
		}
		else if( tuple.get("projectid") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("projectid").toString())) {
				org.molgenis.omx.ngs.Project instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("projectid"), org.molgenis.omx.ngs.Project.class);
				this.setProjectId(instance);				
			} else {
				this.setProjectId_Id(tuple.getInt("ProjectId"));
			}
		}
		if( tuple.get("Sample_ProjectId") != null)
			this.setProjectId_Id(tuple.getInt("Sample_ProjectId"));			
		else if( tuple.get("sample_projectid") != null)
			this.setProjectId_Id(tuple.getInt("sample_projectid"));
			
		if( tuple.get("Sample.ProjectId") != null) 
			this.setProjectId((org.molgenis.omx.ngs.Project)tuple.get("Sample.ProjectId_id"));
		else if( tuple.get("sample.projectid") != null) 
			this.setProjectId((org.molgenis.omx.ngs.Project)tuple.get("sample.projectid_id"));	
		//set label for field ProjectId
		if(tuple.get("ProjectId_ProjectName") != null) this.setProjectId_ProjectName(tuple.getString("ProjectId_ProjectName"));
		else if(tuple.get("projectid_projectname") != null) this.setProjectId_ProjectName(tuple.getString("projectid_projectname"));
		else if(strict) this.setProjectId_ProjectName(tuple.getString("ProjectId_ProjectName")); // setting null is not an option due to function overloading
		if( tuple.get("Sample_ProjectId_ProjectName") != null ) this.setProjectId_ProjectName(tuple.getString("Sample_ProjectId_ProjectName"));		
		else if( tuple.get("sample_projectid_projectname") != null ) this.setProjectId_ProjectName(tuple.getString("sample_projectid_projectname"));
		//set ArrayFile
		// query formal name, else lowercase name
		if(tuple.getString("arrayfile") != null) this.setArrayFile(tuple.getString("arrayfile"));
		else if(tuple.getString("ArrayFile") != null) this.setArrayFile(tuple.getString("ArrayFile"));
		else if(strict) this.setArrayFile(tuple.getString("arrayfile")); // setting null is not an option due to function overloading
		if( tuple.getString("sample_arrayfile") != null) this.setArrayFile(tuple.getString("sample_arrayfile"));
		else if( tuple.getString("Sample_ArrayFile") != null) this.setArrayFile(tuple.getString("Sample_ArrayFile"));
		//set ArrayId
		// query formal name, else lowercase name
		if(tuple.getString("arrayid") != null) this.setArrayId(tuple.getString("arrayid"));
		else if(tuple.getString("ArrayId") != null) this.setArrayId(tuple.getString("ArrayId"));
		else if(strict) this.setArrayId(tuple.getString("arrayid")); // setting null is not an option due to function overloading
		if( tuple.getString("sample_arrayid") != null) this.setArrayId(tuple.getString("sample_arrayid"));
		else if( tuple.getString("Sample_ArrayId") != null) this.setArrayId(tuple.getString("Sample_ArrayId"));
		//set CapturingKit
		// query formal name, else lowercase name
		if(tuple.getInt("CapturingKit_id") != null) this.setCapturingKit(tuple.getInt("CapturingKit_id"));
		else if(tuple.getInt("capturingkit_id") != null) this.setCapturingKit(tuple.getInt("capturingkit_id"));
		else if(strict) this.setCapturingKit(tuple.getInt("CapturingKit_id")); // setting null is not an option due to function overloading
		
		if( tuple.getInt("Sample_CapturingKit_id") != null) this.setCapturingKit(tuple.getInt("Sample_CapturingKit_id"));
		else if( tuple.getInt("sample_capturingkit_id") != null) this.setCapturingKit(tuple.getInt("sample_capturingkit_id"));
		//alias of xref
		if( tuple.get("CapturingKit") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("CapturingKit").toString())) {
				org.molgenis.omx.ngs.CapturingKit instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("CapturingKit"), org.molgenis.omx.ngs.CapturingKit.class);
				this.setCapturingKit(instance);				
			} else {
				this.setCapturingKit_Id(tuple.getInt("CapturingKit")); 
			}
		}
		else if( tuple.get("capturingkit") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("capturingkit").toString())) {
				org.molgenis.omx.ngs.CapturingKit instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("capturingkit"), org.molgenis.omx.ngs.CapturingKit.class);
				this.setCapturingKit(instance);				
			} else {
				this.setCapturingKit_Id(tuple.getInt("CapturingKit"));
			}
		}
		if( tuple.get("Sample_CapturingKit") != null)
			this.setCapturingKit_Id(tuple.getInt("Sample_CapturingKit"));			
		else if( tuple.get("sample_capturingkit") != null)
			this.setCapturingKit_Id(tuple.getInt("sample_capturingkit"));
			
		if( tuple.get("Sample.CapturingKit") != null) 
			this.setCapturingKit((org.molgenis.omx.ngs.CapturingKit)tuple.get("Sample.CapturingKit_id"));
		else if( tuple.get("sample.capturingkit") != null) 
			this.setCapturingKit((org.molgenis.omx.ngs.CapturingKit)tuple.get("sample.capturingkit_id"));	
		//set label for field CapturingKit
		if(tuple.get("CapturingKit_CapturingKitName") != null) this.setCapturingKit_CapturingKitName(tuple.getString("CapturingKit_CapturingKitName"));
		else if(tuple.get("capturingkit_capturingkitname") != null) this.setCapturingKit_CapturingKitName(tuple.getString("capturingkit_capturingkitname"));
		else if(strict) this.setCapturingKit_CapturingKitName(tuple.getString("CapturingKit_CapturingKitName")); // setting null is not an option due to function overloading
		if( tuple.get("Sample_CapturingKit_CapturingKitName") != null ) this.setCapturingKit_CapturingKitName(tuple.getString("Sample_CapturingKit_CapturingKitName"));		
		else if( tuple.get("sample_capturingkit_capturingkitname") != null ) this.setCapturingKit_CapturingKitName(tuple.getString("sample_capturingkit_capturingkitname"));
		//set SampleBarcode
		// query formal name, else lowercase name
		if(tuple.getInt("SampleBarcode_id") != null) this.setSampleBarcode(tuple.getInt("SampleBarcode_id"));
		else if(tuple.getInt("samplebarcode_id") != null) this.setSampleBarcode(tuple.getInt("samplebarcode_id"));
		else if(strict) this.setSampleBarcode(tuple.getInt("SampleBarcode_id")); // setting null is not an option due to function overloading
		
		if( tuple.getInt("Sample_SampleBarcode_id") != null) this.setSampleBarcode(tuple.getInt("Sample_SampleBarcode_id"));
		else if( tuple.getInt("sample_samplebarcode_id") != null) this.setSampleBarcode(tuple.getInt("sample_samplebarcode_id"));
		//alias of xref
		if( tuple.get("SampleBarcode") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("SampleBarcode").toString())) {
				org.molgenis.omx.ngs.SampleBarcode instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("SampleBarcode"), org.molgenis.omx.ngs.SampleBarcode.class);
				this.setSampleBarcode(instance);				
			} else {
				this.setSampleBarcode_Id(tuple.getInt("SampleBarcode")); 
			}
		}
		else if( tuple.get("samplebarcode") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("samplebarcode").toString())) {
				org.molgenis.omx.ngs.SampleBarcode instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("samplebarcode"), org.molgenis.omx.ngs.SampleBarcode.class);
				this.setSampleBarcode(instance);				
			} else {
				this.setSampleBarcode_Id(tuple.getInt("SampleBarcode"));
			}
		}
		if( tuple.get("Sample_SampleBarcode") != null)
			this.setSampleBarcode_Id(tuple.getInt("Sample_SampleBarcode"));			
		else if( tuple.get("sample_samplebarcode") != null)
			this.setSampleBarcode_Id(tuple.getInt("sample_samplebarcode"));
			
		if( tuple.get("Sample.SampleBarcode") != null) 
			this.setSampleBarcode((org.molgenis.omx.ngs.SampleBarcode)tuple.get("Sample.SampleBarcode_id"));
		else if( tuple.get("sample.samplebarcode") != null) 
			this.setSampleBarcode((org.molgenis.omx.ngs.SampleBarcode)tuple.get("sample.samplebarcode_id"));	
		//set label for field SampleBarcode
		if(tuple.get("SampleBarcode_SampleBarcodeName") != null) this.setSampleBarcode_SampleBarcodeName(tuple.getString("SampleBarcode_SampleBarcodeName"));
		else if(tuple.get("samplebarcode_samplebarcodename") != null) this.setSampleBarcode_SampleBarcodeName(tuple.getString("samplebarcode_samplebarcodename"));
		else if(strict) this.setSampleBarcode_SampleBarcodeName(tuple.getString("SampleBarcode_SampleBarcodeName")); // setting null is not an option due to function overloading
		if( tuple.get("Sample_SampleBarcode_SampleBarcodeName") != null ) this.setSampleBarcode_SampleBarcodeName(tuple.getString("Sample_SampleBarcode_SampleBarcodeName"));		
		else if( tuple.get("sample_samplebarcode_samplebarcodename") != null ) this.setSampleBarcode_SampleBarcodeName(tuple.getString("sample_samplebarcode_samplebarcodename"));
		//set SampleInPool
		if( tuple.get("SampleInPool") != null || tuple.get("Sample_SampleInPool") != null || tuple.get("sampleinpool") != null || tuple.get("sample_sampleinpool") != null) 
		{
			java.util.List<Integer> values = new java.util.ArrayList<Integer>();
			java.util.List<?> mrefs = tuple.getList("SampleInPool");
			if(mrefs == null) mrefs = tuple.getList("sampleinpool");
			if(tuple.get("sample_sampleinpool")!= null) mrefs = tuple.getList("sample_sampleinpool");
			else if(tuple.get("Sample_SampleInPool")!= null) mrefs = tuple.getList("Sample_SampleInPool");
			if(mrefs != null) for(Object ref: mrefs)
			{
				if(ref instanceof String)
					values.add(Integer.parseInt((String)ref));
				else if(ref instanceof org.molgenis.util.AbstractEntity) 	
					values.add((Integer)((org.molgenis.util.AbstractEntity)ref).getIdValue() );
				else
					values.add((Integer)ref);		
			}											
			this.setSampleInPool_Id( values );
		}
		//set labels InternalId for mref field SampleInPool	
		if( tuple.get("SampleInPool_InternalId") != null || tuple.get("Sample_SampleInPool_InternalId")!= null || tuple.get("sampleinpool_internalid") != null || tuple.get("sample_sampleinpool_internalid") != null) 
		{
			java.util.List<String> values = new java.util.ArrayList<String>();
			java.util.List<?> mrefs = tuple.getList("SampleInPool_InternalId");
			if(mrefs == null) mrefs = tuple.getList("sampleinpool_internalid");
			if(tuple.get("Sample_SampleInPool_InternalId")!= null) mrefs = tuple.getList("Sample_SampleInPool_InternalId");
			else if(tuple.get("sample_sampleinpool_internalid")!= null) mrefs = tuple.getList("sample_sampleinpool_internalid");
			if(mrefs != null) 
				for(Object ref: mrefs)
				{
					String[] refs = ref.toString().split("\\|");
					for(String r : refs) {
						values.add(r);	
					}						
				}							
			this.setSampleInPool_InternalId( values );			
		}	
		//set LabStatus
		// query formal name, else lowercase name
		if(tuple.getString("labstatus") != null) this.setLabStatus(tuple.getString("labstatus"));
		else if(tuple.getString("LabStatus") != null) this.setLabStatus(tuple.getString("LabStatus"));
		else if(strict) this.setLabStatus(tuple.getString("labstatus")); // setting null is not an option due to function overloading
		if( tuple.getString("sample_labstatus") != null) this.setLabStatus(tuple.getString("sample_labstatus"));
		else if( tuple.getString("Sample_LabStatus") != null) this.setLabStatus(tuple.getString("Sample_LabStatus"));
	}

	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		String result = "Sample(";
		result+= "id='" + getId()+"' ";	
		result+= "internalId='" + getInternalId()+"' ";	
		result+= "externalId='" + getExternalId()+"' ";	
		result+= "sampleComment='" + getSampleComment()+"' ";	
		result+= " projectId_id='" + getProjectId_Id()+"' ";	
		result+= " projectId_projectName='" + getProjectId_ProjectName()+"' ";
		result+= "arrayFile='" + getArrayFile()+"' ";	
		result+= "arrayId='" + getArrayId()+"' ";	
		result+= " capturingKit_id='" + getCapturingKit_Id()+"' ";	
		result+= " capturingKit_capturingKitName='" + getCapturingKit_CapturingKitName()+"' ";
		result+= " sampleBarcode_id='" + getSampleBarcode_Id()+"' ";	
		result+= " sampleBarcode_sampleBarcodeName='" + getSampleBarcode_SampleBarcodeName()+"' ";
		result+= " sampleInPool_id='" + getSampleInPool_Id()+"' ";	
		result+= " sampleInPool_internalId='" + getSampleInPool_InternalId()+"' ";
		result+= "labStatus='" + getLabStatus()+"'";	
		result += ");";
		return result;

	}

	/**
	 * Get the names of all public properties of Sample.
	 */
	@Override
	public java.util.Vector<String> getFields(boolean skipAutoIds)
	{
		java.util.Vector<String> fields = new java.util.Vector<String>();
		if(!skipAutoIds)
		{
			fields.add("id");
		}
		{
			fields.add("InternalId");
		}
		{
			fields.add("ExternalId");
		}
		{
			fields.add("SampleComment");
		}
		{
			fields.add("ProjectId_id");
		}
		fields.add("ProjectId_ProjectName");
		{
			fields.add("ArrayFile");
		}
		{
			fields.add("ArrayId");
		}
		{
			fields.add("CapturingKit_id");
		}
		fields.add("CapturingKit_CapturingKitName");
		{
			fields.add("SampleBarcode_id");
		}
		fields.add("SampleBarcode_SampleBarcodeName");
		{
			fields.add("SampleInPool_id");
		}
		fields.add("SampleInPool_InternalId");
		{
			fields.add("LabStatus");
		}
		return fields;
	}	

	@Override
	public java.util.Vector<String> getFields()
	{
		return getFields(false);
	}

	@Override
	public String getIdField()
	{
		return "id";
	}

	@Override
	public java.util.List<String> getLabelFields()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("InternalId");
		return result;
	}

	@Deprecated
	@Override
	public String getFields(String sep)
	{
		return (""
		+ "id" +sep
		+ "internalId" +sep
		+ "externalId" +sep
		+ "sampleComment" +sep
		+ "projectId" +sep
		+ "arrayFile" +sep
		+ "arrayId" +sep
		+ "capturingKit" +sep
		+ "sampleBarcode" +sep
		+ "sampleInPool" +sep
		+ "labStatus" 
		);
	}

	@Override
	public Object getIdValue()
	{
		return get(getIdField());
	}		
	
	@Override
    public String getXrefIdFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("projectId")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("capturingKit")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("sampleBarcode")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("sampleInPool")) {
            return "id";
        }
        
        return null;
    }	

	@Deprecated
	@Override
	public String getValues(String sep)
	{
		java.io.StringWriter out = new java.io.StringWriter();
		{
			Object valueO = getId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getInternalId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getExternalId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSampleComment();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getProjectId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getArrayFile();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getArrayId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getCapturingKit();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSampleBarcode();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSampleInPool();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getLabStatus();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS);
		}
		return out.toString();
	}
	
	@Override
	public Sample create(org.molgenis.util.tuple.Tuple tuple) throws Exception
	{
		Sample e = new Sample();
		e.set(tuple);
		return e;
	}
	
	//4
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY, mappedBy="sampleInPool"/*, cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    private java.util.Collection<org.molgenis.omx.ngs.Sample> sampleInPoolSampleCollection;

	@javax.xml.bind.annotation.XmlTransient
	public java.util.Collection<org.molgenis.omx.ngs.Sample> getSampleInPoolSampleCollection()
	{
		if(sampleInPoolSampleCollection == null) sampleInPoolSampleCollection = new java.util.ArrayList<org.molgenis.omx.ngs.Sample>(); 
        return sampleInPoolSampleCollection;
	}

	@javax.xml.bind.annotation.XmlTransient
	public java.util.Collection<org.molgenis.omx.ngs.Sample> getSampleInPoolSampleCollection(org.molgenis.framework.db.Database db)
	{
        return getSampleInPoolSampleCollection();
	}

    public void setSampleInPoolSampleCollection(java.util.Collection<org.molgenis.omx.ngs.Sample> collection)
    {
		if(sampleInPoolSampleCollection == null) sampleInPoolSampleCollection = new java.util.ArrayList<org.molgenis.omx.ngs.Sample>();
    	sampleInPoolSampleCollection.addAll(collection);
    }	

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (getClass() != obj.getClass()) return false;
		Sample other = (Sample) obj;
		if (internalId == null)
		{
			if (other.internalId != null) return false;
		}
		else if (!internalId.equals(other.internalId)) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		final int prime = 31;
		int result = 1;
		result = prime * result + ((internalId == null) ? 0 : internalId.hashCode());
		return result;
	}
}
