
/* File:        ngs/model/CapturingKit.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        August 21, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.ngs.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.ngs.CapturingKit;


/**
 * Reads CapturingKit from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class CapturingKitEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(CapturingKitEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
			
	/**
	 * Imports CapturingKit from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<CapturingKit> capturingKitsMissingRefs = new ArrayList<CapturingKit>();
	
		//cache for objects to be imported from file (in batch)
		final List<CapturingKit> capturingKitList = new ArrayList<CapturingKit>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			CapturingKit object = new CapturingKit();
			object.set(tuple, false);				
			capturingKitList.add(object);		
			
			//add to db when batch size is reached
			if(capturingKitList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				capturingKitsMissingRefs.addAll(resolveForeignKeys(db, capturingKitList));
				capturingKitList.removeAll(capturingKitsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'CapturingKitName' defined in xref_label
				db.update(capturingKitList,dbAction, "CapturingKitName");
				
				//clear for next batch						
				capturingKitList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!capturingKitList.isEmpty())
		{
			total.set(total.get() + capturingKitList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			capturingKitsMissingRefs.addAll(resolveForeignKeys(db, capturingKitList));
			capturingKitList.removeAll(capturingKitsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'CapturingKitName' defined in xref_label
			db.update(capturingKitList,dbAction, "CapturingKitName");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<CapturingKit> capturingKits = new ArrayList<CapturingKit>(capturingKitsMissingRefs);

		int iterationCount = 0;

		do
		{
			capturingKitsMissingRefs = resolveForeignKeys(db, capturingKitsMissingRefs);
			
			LinkedHashSet<CapturingKit> differenceSet = new LinkedHashSet<CapturingKit>();
			Sets.symmetricDifference(new LinkedHashSet<CapturingKit>(capturingKits), new LinkedHashSet<CapturingKit>(capturingKitsMissingRefs)).copyInto(differenceSet);
			List<CapturingKit> resolvablecapturingKits = new ArrayList<CapturingKit>(differenceSet);
			
			capturingKits.removeAll(resolvablecapturingKits);
			
			db.update(resolvablecapturingKits,dbAction, "CapturingKitName");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(CapturingKit blaat : capturingKitsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'capturingKit' entity failed:"
								+ "This is probably caused by a(n) 'capturingKit' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (capturingKitsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " capturingKit from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param capturingKitList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<CapturingKit> resolveForeignKeys(Database db, List<CapturingKit> capturingKitList) throws Exception
	{
		//keep a list of CapturingKit instances that miss a reference which might be resolvable later
		List<CapturingKit> capturingKitsMissingRefs = new ArrayList<CapturingKit>();
	
		//update objects with foreign key values
		for(CapturingKit o:  capturingKitList)
		{
			while(true){
				break;
			}
		}
		
		
		return capturingKitsMissingRefs;
	}
}

