/* File:        ngs/model/Sample.java
 * Copyright:   GBIC 2000-2,013, all rights reserved
 * Date:        August 21, 2013
 * Template:	JpaMapperGen.java.ftl
 * generator:   org.molgenis.generators.db.JpaMapperGen 4.0.0-testing
 *
 * Jpa Entity Mapper, helper to add, delete and update entities
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.ngs.db;

@edu.umd.cs.findbugs.annotations.SuppressWarnings(value = "DLS_DEAD_LOCAL_STORE", justification = "Too much template code required to prevent warnings")
public class SampleJpaMapper extends org.molgenis.framework.db.jpa.AbstractJpaMapper<org.molgenis.omx.ngs.Sample>
{
	private final static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(SampleJpaMapper.class);

	public SampleJpaMapper(org.molgenis.framework.db.Database db) 
	{
		super(db);
	}
	
	@Override
	public String createFindSqlInclRules(org.molgenis.framework.db.QueryRule[] rules) throws org.molgenis.framework.db.DatabaseException
	{
		return "SELECT Sample.id"
			+", Sample.InternalId"
			+", Sample.ExternalId"
			+", Sample.SampleComment"
			+", Sample.ProjectId"
			+", Sample.ArrayFile"
			+", Sample.ArrayId"
			+", Sample.CapturingKit"
			+", Sample.SampleBarcode"
			+", Sample.LabStatus"
			//parent is SimpleTree(name='ProjectId')
			+", xref_ProjectId.ProjectName AS ProjectId_ProjectName"
			//parent is SimpleTree(name='CapturingKit')
			+", xref_CapturingKit.CapturingKitName AS CapturingKit_CapturingKitName"
			//parent is SimpleTree(name='SampleBarcode')
			+", xref_SampleBarcode.SampleBarcodeName AS SampleBarcode_SampleBarcodeName"
			+" FROM Sample "

			
			//label for ProjectId=ProjectName
//path==ProjectId. type==xref.
//path==ProjectId_ProjectName. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Project AS xref_ProjectId " 
			+" ON xref_ProjectId.id = Sample.ProjectId"
			
			//label for CapturingKit=CapturingKitName
//path==CapturingKit. type==xref.
//path==CapturingKit_CapturingKitName. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN CapturingKit AS xref_CapturingKit " 
			+" ON xref_CapturingKit.id = Sample.CapturingKit"
			
			//label for SampleBarcode=SampleBarcodeName
//path==SampleBarcode. type==xref.
//path==SampleBarcode_SampleBarcodeName. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN SampleBarcode AS xref_SampleBarcode " 
			+" ON xref_SampleBarcode.id = Sample.SampleBarcode"
;
	}	

	/** This method first saves the objects that are being refered to by entity, 
	then the entity itself and 
	finally the objects that refer to this object*/
    public void create(org.molgenis.omx.ngs.Sample entity) throws org.molgenis.framework.db.DatabaseException {
        try {


			//check if the object refered by 'ProjectId' is known in the databse
			if(entity.getProjectId() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getProjectId().getIdValue() == null)
					new org.molgenis.omx.ngs.db.ProjectJpaMapper(getDatabase()).create(entity.getProjectId());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getProjectId()) && entity.getProjectId().getIdValue() != null)
					entity.setProjectId(getEntityManager().getReference(org.molgenis.omx.ngs.Project.class, entity.getProjectId().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getProjectId_Id() != null) {
					entity.setProjectId((org.molgenis.omx.ngs.Project)getEntityManager().find(org.molgenis.omx.ngs.Project.class, entity.getProjectId_Id()));
				}
			}
			//check if the object refered by 'CapturingKit' is known in the databse
			if(entity.getCapturingKit() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getCapturingKit().getIdValue() == null)
					new org.molgenis.omx.ngs.db.CapturingKitJpaMapper(getDatabase()).create(entity.getCapturingKit());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getCapturingKit()) && entity.getCapturingKit().getIdValue() != null)
					entity.setCapturingKit(getEntityManager().getReference(org.molgenis.omx.ngs.CapturingKit.class, entity.getCapturingKit().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getCapturingKit_Id() != null) {
					entity.setCapturingKit((org.molgenis.omx.ngs.CapturingKit)getEntityManager().find(org.molgenis.omx.ngs.CapturingKit.class, entity.getCapturingKit_Id()));
				}
			}
			//check if the object refered by 'SampleBarcode' is known in the databse
			if(entity.getSampleBarcode() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getSampleBarcode().getIdValue() == null)
					new org.molgenis.omx.ngs.db.SampleBarcodeJpaMapper(getDatabase()).create(entity.getSampleBarcode());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getSampleBarcode()) && entity.getSampleBarcode().getIdValue() != null)
					entity.setSampleBarcode(getEntityManager().getReference(org.molgenis.omx.ngs.SampleBarcode.class, entity.getSampleBarcode().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getSampleBarcode_Id() != null) {
					entity.setSampleBarcode((org.molgenis.omx.ngs.SampleBarcode)getEntityManager().find(org.molgenis.omx.ngs.SampleBarcode.class, entity.getSampleBarcode_Id()));
				}
			}
	    java.util.List<org.molgenis.omx.ngs.Sample> sampleInPoolList = entity.getSampleInPool();
	    java.util.List<Integer> sampleInPoolIds = entity.getSampleInPool_Id();
	    for(Integer sampleInPoolId : sampleInPoolIds) {
		org.molgenis.omx.ngs.Sample sample = getEntityManager().getReference(org.molgenis.omx.ngs.Sample.class, sampleInPoolId);
		if(!sampleInPoolList.contains(sample))
		    sampleInPoolList.add(sample);
	    }
	    entity.setSampleInPool(sampleInPoolList);

			//prevents uncontrolled recursion call of create (stack overflow)
          
          if(entity.getIdValue() != null) {
            entity = getEntityManager().merge(entity);            
          } else {
            getEntityManager().persist(entity);
          }
//inverse association relation

        } catch (Exception ex) {
            try {
				getEntityManager().getTransaction().rollback();
            } catch (Exception re) {
                throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
            }
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
    }

	public void destroy(org.molgenis.omx.ngs.Sample sample) throws org.molgenis.framework.db.DatabaseException {
		try {
			try {
				sample = getEntityManager().getReference(org.molgenis.omx.ngs.Sample.class, sample.getIdValue());
			} catch (javax.persistence.EntityNotFoundException enfe) {
				throw new org.molgenis.framework.db.DatabaseException("The sample with id " + sample.getIdField().toString() + " no longer exists: " + enfe.getMessage());
			}

			getEntityManager().remove(sample);
		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}


	public void edit(org.molgenis.omx.ngs.Sample sample) throws org.molgenis.framework.db.DatabaseException {
		try {






			//2
			org.molgenis.omx.ngs.Project projectIdNew = sample.getProjectId();

			if (projectIdNew == null) { //object is reference by xref		
                            if(sample.getProjectId_Id() != null) {
                                sample.setProjectId((org.molgenis.omx.ngs.Project)getEntityManager().find(org.molgenis.omx.ngs.Project.class, sample.getProjectId_Id()));
                            }
			}




			//1
			org.molgenis.omx.ngs.CapturingKit capturingKitNew = sample.getCapturingKit();

			if (capturingKitNew == null) { //object is reference by xref		
                            if(sample.getCapturingKit_Id() != null) {
                                sample.setCapturingKit((org.molgenis.omx.ngs.CapturingKit)getEntityManager().find(org.molgenis.omx.ngs.CapturingKit.class, sample.getCapturingKit_Id()));
                            }
			}


			//1
			org.molgenis.omx.ngs.SampleBarcode sampleBarcodeNew = sample.getSampleBarcode();

			if (sampleBarcodeNew == null) { //object is reference by xref		
                            if(sample.getSampleBarcode_Id() != null) {
                                sample.setSampleBarcode((org.molgenis.omx.ngs.SampleBarcode)getEntityManager().find(org.molgenis.omx.ngs.SampleBarcode.class, sample.getSampleBarcode_Id()));
                            }
			}


			//4
			for(org.molgenis.omx.ngs.Sample m : sample.getSampleInPool()) {
				if(m.getId() == null) {
					getEntityManager().persist(m);
				}
			}
			
			for(Integer id : sample.getSampleInPool_Id()) {
				org.molgenis.omx.ngs.Sample mref = getEntityManager().find(org.molgenis.omx.ngs.Sample.class, id);
				if(!sample.getSampleInPool().contains(mref)) {
					sample.getSampleInPool().add(mref);
				}
			}    

			if(!getEntityManager().contains(sample)) {
				sample = getEntityManager().merge(sample);
			}
			



		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: " + re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}

	@Override
	public int executeAdd(java.util.List<? extends org.molgenis.omx.ngs.Sample> entities) throws org.molgenis.framework.db.DatabaseException
	{	
		int count = 0;
		
		try 
		{
			for (org.molgenis.omx.ngs.Sample sample : entities) 
			{
				create(sample);
				++count;
			}
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}

	@Override
	public int executeUpdate(java.util.List<? extends org.molgenis.omx.ngs.Sample> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;

		try
		{
			for (org.molgenis.omx.ngs.Sample sample : entities) 
			{
				edit(sample);
				++count;
			} 
			return count;
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }		
	}

	@Override
	public int executeRemove(java.util.List<? extends org.molgenis.omx.ngs.Sample> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;		
		try 
		{
			for (org.molgenis.omx.ngs.Sample sample : entities) 
			{
				destroy(sample);
				++count;
			}
		} 
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}
	
	@Override
	public String getTableFieldName(String fieldName)
	{
		if("id".equalsIgnoreCase(fieldName)) return "id";
		if("Sample_id".equalsIgnoreCase(fieldName)) return "id";
		if("InternalId".equalsIgnoreCase(fieldName)) return "InternalId";
		if("Sample_InternalId".equalsIgnoreCase(fieldName)) return "InternalId";
		if("ExternalId".equalsIgnoreCase(fieldName)) return "ExternalId";
		if("Sample_ExternalId".equalsIgnoreCase(fieldName)) return "ExternalId";
		if("SampleComment".equalsIgnoreCase(fieldName)) return "SampleComment";
		if("Sample_SampleComment".equalsIgnoreCase(fieldName)) return "SampleComment";
		if("ProjectId".equalsIgnoreCase(fieldName)) return "ProjectId";
		if("Sample_ProjectId".equalsIgnoreCase(fieldName)) return "ProjectId";
		if("ArrayFile".equalsIgnoreCase(fieldName)) return "ArrayFile";
		if("Sample_ArrayFile".equalsIgnoreCase(fieldName)) return "ArrayFile";
		if("ArrayId".equalsIgnoreCase(fieldName)) return "ArrayId";
		if("Sample_ArrayId".equalsIgnoreCase(fieldName)) return "ArrayId";
		if("CapturingKit".equalsIgnoreCase(fieldName)) return "CapturingKit";
		if("Sample_CapturingKit".equalsIgnoreCase(fieldName)) return "CapturingKit";
		if("SampleBarcode".equalsIgnoreCase(fieldName)) return "SampleBarcode";
		if("Sample_SampleBarcode".equalsIgnoreCase(fieldName)) return "SampleBarcode";
		if("LabStatus".equalsIgnoreCase(fieldName)) return "LabStatus";
		if("Sample_LabStatus".equalsIgnoreCase(fieldName)) return "LabStatus";
		if("ProjectId_id".equalsIgnoreCase(fieldName)) return "ProjectId";
		if("Sample_ProjectId_id".equalsIgnoreCase(fieldName)) return "ProjectId";
		if("ProjectId_ProjectName".equalsIgnoreCase(fieldName)) return "ProjectId.ProjectName";	
		if("Sample_ProjectId_ProjectName".equalsIgnoreCase(fieldName)) return "ProjectId.ProjectName";
		if("CapturingKit_id".equalsIgnoreCase(fieldName)) return "CapturingKit";
		if("Sample_CapturingKit_id".equalsIgnoreCase(fieldName)) return "CapturingKit";
		if("CapturingKit_CapturingKitName".equalsIgnoreCase(fieldName)) return "CapturingKit.CapturingKitName";	
		if("Sample_CapturingKit_CapturingKitName".equalsIgnoreCase(fieldName)) return "CapturingKit.CapturingKitName";
		if("SampleBarcode_id".equalsIgnoreCase(fieldName)) return "SampleBarcode";
		if("Sample_SampleBarcode_id".equalsIgnoreCase(fieldName)) return "SampleBarcode";
		if("SampleBarcode_SampleBarcodeName".equalsIgnoreCase(fieldName)) return "SampleBarcode.SampleBarcodeName";	
		if("Sample_SampleBarcode_SampleBarcodeName".equalsIgnoreCase(fieldName)) return "SampleBarcode.SampleBarcodeName";
		return fieldName;
	}
	
	/**
	 * Return EMPTY list of given allocated size
	 *
	 * @param i initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	@Override
	public java.util.List<org.molgenis.omx.ngs.Sample> createList(int size)
	{
		return new java.util.ArrayList<org.molgenis.omx.ngs.Sample>(size);
	}			

	@Override
	public org.molgenis.omx.ngs.Sample create()
	{
		return new org.molgenis.omx.ngs.Sample();
	}

	@Override
	//Resolve
	public void resolveForeignKeys(java.util.List<org.molgenis.omx.ngs.Sample> entities)  throws org.molgenis.framework.db.DatabaseException, java.text.ParseException
	{
		//create foreign key map for field 'projectId' to project.id using ProjectName)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> projectIdRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'capturingKit' to capturingKit.id using CapturingKitName)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> capturingKitRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'sampleBarcode' to sampleBarcode.id using SampleBarcodeName)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> sampleBarcodeRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'sampleInPool' to sample.id using InternalId)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> sampleInPoolRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create all query rules	
		for(org.molgenis.omx.ngs.Sample object: entities)
		{
			//create xref/mref rule filtering Project on the label ProjectName
			if(object.getProjectId_Id() == null && object.getProjectId_ProjectName() != null)
			{
				Object label = object.getProjectId_ProjectName();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("ProjectName", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(label != null && !projectIdRules.containsKey(label))
					{
						projectIdRules.put(""+label, xrefFilter);
						projectIdRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering CapturingKit on the label CapturingKitName
			if(object.getCapturingKit_Id() == null && object.getCapturingKit_CapturingKitName() != null)
			{
				Object label = object.getCapturingKit_CapturingKitName();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("CapturingKitName", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(label != null && !capturingKitRules.containsKey(label))
					{
						capturingKitRules.put(""+label, xrefFilter);
						capturingKitRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering SampleBarcode on the label SampleBarcodeName
			if(object.getSampleBarcode_Id() == null && object.getSampleBarcode_SampleBarcodeName() != null)
			{
				Object label = object.getSampleBarcode_SampleBarcodeName();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("SampleBarcodeName", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(label != null && !sampleBarcodeRules.containsKey(label))
					{
						sampleBarcodeRules.put(""+label, xrefFilter);
						sampleBarcodeRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering Sample on the label InternalId
			if(object.getSampleInPool_Id().size() == 0 && object.getSampleInPool_InternalId().size() > 0)
			{
				for(Object label: object.getSampleInPool_InternalId())
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("InternalId", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(label != null && !sampleInPoolRules.containsKey(label))
					{
						sampleInPoolRules.put(""+label, xrefFilter);
						sampleInPoolRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
		}

		//resolve foreign key field 'projectId' to project.id using ProjectName)
		final java.util.Map<String,Integer> projectId_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(projectIdRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.ngs.Project> projectIdList = null;
			try
			{
				projectIdList = getDatabase().find(org.molgenis.omx.ngs.Project.class, projectIdRules.values().toArray(new org.molgenis.framework.db.QueryRule[projectIdRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.ngs.Project xref :  projectIdList)
			{
				String key = "";
				key += 	xref.getProjectName();
				
				projectId_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'capturingKit' to capturingKit.id using CapturingKitName)
		final java.util.Map<String,Integer> capturingKit_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(capturingKitRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.ngs.CapturingKit> capturingKitList = null;
			try
			{
				capturingKitList = getDatabase().find(org.molgenis.omx.ngs.CapturingKit.class, capturingKitRules.values().toArray(new org.molgenis.framework.db.QueryRule[capturingKitRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.ngs.CapturingKit xref :  capturingKitList)
			{
				String key = "";
				key += 	xref.getCapturingKitName();
				
				capturingKit_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'sampleBarcode' to sampleBarcode.id using SampleBarcodeName)
		final java.util.Map<String,Integer> sampleBarcode_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(sampleBarcodeRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.ngs.SampleBarcode> sampleBarcodeList = null;
			try
			{
				sampleBarcodeList = getDatabase().find(org.molgenis.omx.ngs.SampleBarcode.class, sampleBarcodeRules.values().toArray(new org.molgenis.framework.db.QueryRule[sampleBarcodeRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.ngs.SampleBarcode xref :  sampleBarcodeList)
			{
				String key = "";
				key += 	xref.getSampleBarcodeName();
				
				sampleBarcode_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'sampleInPool' to sample.id using InternalId)
		final java.util.Map<String,Integer> sampleInPool_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(sampleInPoolRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.ngs.Sample> sampleInPoolList = null;
			try
			{
				sampleInPoolList = getDatabase().find(org.molgenis.omx.ngs.Sample.class, sampleInPoolRules.values().toArray(new org.molgenis.framework.db.QueryRule[sampleInPoolRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.ngs.Sample xref :  sampleInPoolList)
			{
				String key = "";
				key += 	xref.getInternalId();
				
				sampleInPool_Labels_to_IdMap.put(key, xref.getId());
			}
		}

		//update objects with the keys
		for(int i = 0; i < entities.size(); i++)
		{
			org.molgenis.omx.ngs.Sample object = entities.get(i);		
			//update object using label fields ProjectName
			if(object.getProjectId_Id() == null )
			{
					String key = "";
					if(object.getProjectId_ProjectName() != null)
						key += 	object.getProjectId_ProjectName();
					
					if(!"".equals(key) && projectId_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("ProjectId_ProjectName cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setProjectId_Id(projectId_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields CapturingKitName
			if(object.getCapturingKit_Id() == null )
			{
					String key = "";
					if(object.getCapturingKit_CapturingKitName() != null)
						key += 	object.getCapturingKit_CapturingKitName();
					
					if(!"".equals(key) && capturingKit_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("CapturingKit_CapturingKitName cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setCapturingKit_Id(capturingKit_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields SampleBarcodeName
			if(object.getSampleBarcode_Id() == null )
			{
					String key = "";
					if(object.getSampleBarcode_SampleBarcodeName() != null)
						key += 	object.getSampleBarcode_SampleBarcodeName();
					
					if(!"".equals(key) && sampleBarcode_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("SampleBarcode_SampleBarcodeName cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setSampleBarcode_Id(sampleBarcode_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields InternalId
			if(object.getSampleInPool_Id() == null || object.getSampleInPool_Id().size() == 0)
			{
				java.util.List<Integer> idList = new java.util.ArrayList<Integer>();
				for(int j = 0; j < object.getSampleInPool_InternalId().size(); j++)
				{
					String key = "";
					if(object.getSampleInPool_InternalId().get(j) != null)
						key += 	object.getSampleInPool_InternalId().get(j);
					
					if(!"".equals(key) && sampleInPool_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("SampleInPool_InternalId cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						idList.add(sampleInPool_Labels_to_IdMap.get(key));
					}
				}
				object.setSampleInPool_Id(idList);
			}
						
		}
	}	
	
	@Override
	public org.molgenis.fieldtypes.FieldType getFieldType(String fieldName)
	{
			if("id".equalsIgnoreCase(fieldName) || "sample.id".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("internalId".equalsIgnoreCase(fieldName) || "sample.internalId".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("externalId".equalsIgnoreCase(fieldName) || "sample.externalId".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("sampleComment".equalsIgnoreCase(fieldName) || "sample.sampleComment".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("projectId".equalsIgnoreCase(fieldName) || "sample.projectId".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("arrayFile".equalsIgnoreCase(fieldName) || "sample.arrayFile".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("arrayId".equalsIgnoreCase(fieldName) || "sample.arrayId".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("capturingKit".equalsIgnoreCase(fieldName) || "sample.capturingKit".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("sampleBarcode".equalsIgnoreCase(fieldName) || "sample.sampleBarcode".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("labStatus".equalsIgnoreCase(fieldName) || "sample.labStatus".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
		return null;
	}		
	@Override
	public void prepareFileAttachements(java.util.List<org.molgenis.omx.ngs.Sample> entities, java.io.File baseDir) throws java.io.IOException
	{
	}

	@Override
	public boolean saveFileAttachements(java.util.List<org.molgenis.omx.ngs.Sample> entities, java.io.File baseDir) throws java.io.IOException
	{
		return false;
	}}
