
/* File:        Ngs/html/FlowcellLane.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        August 21, 2013
 * 
 * generator:   org.molgenis.generators.ui.HtmlFormGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
package org.molgenis.omx.ngs.ui;

// jdk
import java.util.Vector;
import java.util.List;
import java.util.ArrayList;


// molgenis
import org.molgenis.framework.ui.html.*;


import org.molgenis.omx.ngs.Flowcell;
import org.molgenis.omx.ngs.Sample;
import org.molgenis.omx.ngs.NgsUser;
import org.molgenis.omx.ngs.FlowcellLane;


/**
 * A HtmlForm that is preloaded with all inputs for entity FlowcellLane
 * @see EntityForm
 */
public class FlowcellLaneForm extends EntityForm<FlowcellLane>
{
	
	public FlowcellLaneForm()
	{
		super();
	}
	
	public FlowcellLaneForm(FlowcellLane entity)
	{
		super(entity);
	}
	
	
	@Override
	public Class<FlowcellLane> getEntityClass()
	{
		return FlowcellLane.class;
	}
	
	@Override
	public Vector<String> getHeaders()
	{
		Vector<String> headers = new Vector<String>();
		headers.add("Flowcell name");
		headers.add("Lane");
		headers.add("Sample");
		headers.add("Comment");
		headers.add("QC wet-lab status");
		headers.add("QC wet-lab user");
		headers.add("QC wet-lab date");
		headers.add("QC dry-lab status");
		headers.add("QC dry-lab user");
		headers.add("QC dry-lab date");
		return headers;
	}	
	
	@Override
	public List<HtmlInput<?>> getInputs()
	{	
		List<HtmlInput<?>> inputs = new ArrayList<HtmlInput<?>>();			
		//Id: Field(entity=FlowcellLane, name=id, type=int, auto=true, nillable=false, readonly=true, default=)
		{
			IntInput input = new IntInput("FlowcellLane_id",getEntity().getId());
			
			input.setLabel("id");
			input.setDescription("automatically generated internal id, only for internal use.");
			input.setNillable(false);
			input.setReadonly(true); //automatic fields that are readonly, are also readonly on newrecord
			input.setHidden(true);
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//Flowcell: Field(entity=FlowcellLane, name=Flowcell, type=xref[Flowcell.id], xref_label='FlowcellName', auto=false, nillable=true, readonly=false, default=)
		{
		    //TODO: when we have JPA this should become:
			//XrefInput<FlowcellLane> input = new XrefInput<FlowcellLane>("FlowcellLane_Flowcell", getEntity().getFlowcell());
			//create xref dummy object
			Flowcell dummy = null;
			if(getEntity().getFlowcell_Id() != null)
			{
			 	dummy = new Flowcell();
				dummy.setId(getEntity().getFlowcell_Id());
				dummy.setFlowcellName( getEntity().getFlowcell_FlowcellName() ); 
			}
			XrefInput<Flowcell> input = new XrefInput<Flowcell>("FlowcellLane_Flowcell", org.molgenis.omx.ngs.Flowcell.class, dummy);
			
			input.setLabel("Flowcell name");
			input.setDescription("The flowcell to which this lane belongs");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//Lane: Field(entity=FlowcellLane, name=Lane, type=enum, auto=false, nillable=true, readonly=false, default=, enum_options=[1, 2, 3, 4, 5, 6, 7, 8])
		{
			EnumInput input = new EnumInput("FlowcellLane_Lane",getEntity().getLane());
			
			input.setLabel("Lane");
			input.setDescription("The lane number that is unique within a flow cell with a range of 1-8.");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			input.setOptions(getEntity().getLaneOptions());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//Sample: Field(entity=FlowcellLane, name=Sample, type=xref[Sample.id], xref_label='InternalId', auto=false, nillable=false, readonly=false, default=)
		{
		    //TODO: when we have JPA this should become:
			//XrefInput<FlowcellLane> input = new XrefInput<FlowcellLane>("FlowcellLane_Sample", getEntity().getSample());
			//create xref dummy object
			Sample dummy = null;
			if(getEntity().getSample_Id() != null)
			{
			 	dummy = new Sample();
				dummy.setId(getEntity().getSample_Id());
				dummy.setInternalId( getEntity().getSample_InternalId() ); 
			}
			XrefInput<Sample> input = new XrefInput<Sample>("FlowcellLane_Sample", org.molgenis.omx.ngs.Sample.class, dummy);
			
			input.setLabel("Sample");
			input.setDescription("Sample");
			input.setNillable(false);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//FlowcellLaneComment: Field(entity=FlowcellLane, name=FlowcellLaneComment, type=text, auto=false, nillable=true, readonly=false, default=)
		{
			TextInput input = new TextInput("FlowcellLane_FlowcellLaneComment",getEntity().getFlowcellLaneComment());
			
			input.setLabel("Comment");
			input.setDescription("Comment about the experiment.");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//QcWetMet: Field(entity=FlowcellLane, name=QcWetMet, type=enum, auto=false, nillable=false, readonly=false, default=Not determined, enum_options=[Not determined, Passed, Failed])
		{
			EnumInput input = new EnumInput("FlowcellLane_QcWetMet",getEntity().getQcWetMet());
			
			input.setLabel("QC wet-lab status");
			input.setDescription("Quality criteria of the wet lab met");
			input.setNillable(false);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			input.setOptions(getEntity().getQcWetMetOptions());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//QcWetUser: Field(entity=FlowcellLane, name=QcWetUser, type=xref[NgsUser.id], xref_label='UserName', auto=false, nillable=true, readonly=false, default=)
		{
		    //TODO: when we have JPA this should become:
			//XrefInput<FlowcellLane> input = new XrefInput<FlowcellLane>("FlowcellLane_QcWetUser", getEntity().getQcWetUser());
			//create xref dummy object
			NgsUser dummy = null;
			if(getEntity().getQcWetUser_Id() != null)
			{
			 	dummy = new NgsUser();
				dummy.setId(getEntity().getQcWetUser_Id());
				dummy.setUserName( getEntity().getQcWetUser_UserName() ); 
			}
			XrefInput<NgsUser> input = new XrefInput<NgsUser>("FlowcellLane_QcWetUser", org.molgenis.omx.ngs.NgsUser.class, dummy);
			
			input.setLabel("QC wet-lab user");
			input.setDescription("The user who checked if the quality score on the wet-lab was met");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//QcWetDate: Field(entity=FlowcellLane, name=QcWetDate, type=datetime, auto=false, nillable=true, readonly=false, default=)
		{
			DatetimeInput input = new DatetimeInput("FlowcellLane_QcWetDate",getEntity().getQcWetDate());
			
			input.setLabel("QC wet-lab date");
			input.setDescription("The date the QcWetUser selected the QcWetMet value.");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//QcDryMet: Field(entity=FlowcellLane, name=QcDryMet, type=enum, auto=false, nillable=false, readonly=false, default=Not determined, enum_options=[Not determined, Passed, Failed])
		{
			EnumInput input = new EnumInput("FlowcellLane_QcDryMet",getEntity().getQcDryMet());
			
			input.setLabel("QC dry-lab status");
			input.setDescription("Variant calling quality criteria");
			input.setNillable(false);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			input.setOptions(getEntity().getQcDryMetOptions());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//QcDryUser: Field(entity=FlowcellLane, name=QcDryUser, type=xref[NgsUser.id], xref_label='UserName', auto=false, nillable=true, readonly=false, default=)
		{
		    //TODO: when we have JPA this should become:
			//XrefInput<FlowcellLane> input = new XrefInput<FlowcellLane>("FlowcellLane_QcDryUser", getEntity().getQcDryUser());
			//create xref dummy object
			NgsUser dummy = null;
			if(getEntity().getQcDryUser_Id() != null)
			{
			 	dummy = new NgsUser();
				dummy.setId(getEntity().getQcDryUser_Id());
				dummy.setUserName( getEntity().getQcDryUser_UserName() ); 
			}
			XrefInput<NgsUser> input = new XrefInput<NgsUser>("FlowcellLane_QcDryUser", org.molgenis.omx.ngs.NgsUser.class, dummy);
			
			input.setLabel("QC dry-lab user");
			input.setDescription("The user who checked if the quality score of the analysis was met");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//QcDryDate: Field(entity=FlowcellLane, name=QcDryDate, type=datetime, auto=false, nillable=true, readonly=false, default=)
		{
			DatetimeInput input = new DatetimeInput("FlowcellLane_QcDryDate",getEntity().getQcDryDate());
			
			input.setLabel("QC dry-lab date");
			input.setDescription("The date the QcWetUser selected the QcWetMet value");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}

		return inputs;
	}
}


