
/* File:        Ngs/html/NgsUser.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        August 21, 2013
 * 
 * generator:   org.molgenis.generators.ui.HtmlFormGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
package org.molgenis.omx.ngs.ui;

// jdk
import java.util.Vector;
import java.util.List;
import java.util.ArrayList;


// molgenis
import org.molgenis.framework.ui.html.*;


import org.molgenis.omx.ngs.NgsUser;


/**
 * A HtmlForm that is preloaded with all inputs for entity NgsUser
 * @see EntityForm
 */
public class NgsUserForm extends EntityForm<NgsUser>
{
	
	public NgsUserForm()
	{
		super();
	}
	
	public NgsUserForm(NgsUser entity)
	{
		super(entity);
	}
	
	
	@Override
	public Class<NgsUser> getEntityClass()
	{
		return NgsUser.class;
	}
	
	@Override
	public Vector<String> getHeaders()
	{
		Vector<String> headers = new Vector<String>();
		headers.add("User name");
		headers.add("email");
		headers.add("Role");
		headers.add("Group");
		return headers;
	}	
	
	@Override
	public List<HtmlInput<?>> getInputs()
	{	
		List<HtmlInput<?>> inputs = new ArrayList<HtmlInput<?>>();			
		//Id: Field(entity=NgsUser, name=id, type=int, auto=true, nillable=false, readonly=true, default=)
		{
			IntInput input = new IntInput("NgsUser_id",getEntity().getId());
			
			input.setLabel("id");
			input.setDescription("automatically generated internal id, only for internal use.");
			input.setNillable(false);
			input.setReadonly(true); //automatic fields that are readonly, are also readonly on newrecord
			input.setHidden(true);
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//UserName: Field(entity=NgsUser, name=UserName, type=string[255], auto=false, nillable=false, readonly=false, default=)
		{
			StringInput input = new StringInput("NgsUser_UserName",getEntity().getUserName());
			
			input.setLabel("User name");
			input.setDescription("The name of a user");
			input.setNillable(false);
			input.setSize(255);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//UserEmail: Field(entity=NgsUser, name=UserEmail, type=string[255], auto=false, nillable=true, readonly=false, default=)
		{
			StringInput input = new StringInput("NgsUser_UserEmail",getEntity().getUserEmail());
			
			input.setLabel("email");
			input.setDescription("The email of a user.");
			input.setNillable(true);
			input.setSize(255);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//UserRole: Field(entity=NgsUser, name=UserRole, type=enum, auto=false, nillable=false, readonly=false, default=, enum_options=[Customer, Analist, Bioinformatician])
		{
			EnumInput input = new EnumInput("NgsUser_UserRole",getEntity().getUserRole());
			
			input.setLabel("Role");
			input.setDescription("The role the user has.");
			input.setNillable(false);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			input.setOptions(getEntity().getUserRoleOptions());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//UserGroup: Field(entity=NgsUser, name=UserGroup, type=enum, auto=false, nillable=true, readonly=false, default=, enum_options=[GAF, GCC, None])
		{
			EnumInput input = new EnumInput("NgsUser_UserGroup",getEntity().getUserGroup());
			
			input.setLabel("Group");
			input.setDescription("The group a user belongs to.");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			input.setOptions(getEntity().getUserGroupOptions());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}

		return inputs;
	}
}


