
/* File:        Ngs/html/Sample.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        August 21, 2013
 * 
 * generator:   org.molgenis.generators.ui.HtmlFormGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
package org.molgenis.omx.ngs.ui;

// jdk
import java.util.Vector;
import java.util.List;
import java.util.ArrayList;


// molgenis
import org.molgenis.framework.ui.html.*;


import org.molgenis.omx.ngs.Project;
import org.molgenis.omx.ngs.CapturingKit;
import org.molgenis.omx.ngs.SampleBarcode;
import org.molgenis.omx.ngs.Sample;


/**
 * A HtmlForm that is preloaded with all inputs for entity Sample
 * @see EntityForm
 */
public class SampleForm extends EntityForm<Sample>
{
	
	public SampleForm()
	{
		super();
	}
	
	public SampleForm(Sample entity)
	{
		super(entity);
	}
	
	
	@Override
	public Class<Sample> getEntityClass()
	{
		return Sample.class;
	}
	
	@Override
	public Vector<String> getHeaders()
	{
		Vector<String> headers = new Vector<String>();
		headers.add("InternalId");
		headers.add("ExternalId");
		headers.add("Comment");
		headers.add("Project name");
		headers.add("Array file");
		headers.add("Array ID");
		headers.add("Capturing kit");
		headers.add("Barcode");
		headers.add("Pooled InternalSampleId(s)");
		headers.add("Lab status");
		return headers;
	}	
	
	@Override
	public List<HtmlInput<?>> getInputs()
	{	
		List<HtmlInput<?>> inputs = new ArrayList<HtmlInput<?>>();			
		//Id: Field(entity=Sample, name=id, type=int, auto=true, nillable=false, readonly=true, default=)
		{
			IntInput input = new IntInput("Sample_id",getEntity().getId());
			
			input.setLabel("id");
			input.setDescription("automatically generated internal id, only for internal use.");
			input.setNillable(false);
			input.setReadonly(true); //automatic fields that are readonly, are also readonly on newrecord
			input.setHidden(true);
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//InternalId: Field(entity=Sample, name=InternalId, type=string[255], auto=false, nillable=false, readonly=false, default=)
		{
			StringInput input = new StringInput("Sample_InternalId",getEntity().getInternalId());
			
			input.setLabel("InternalId");
			input.setDescription("The number of a sample as used in-house");
			input.setNillable(false);
			input.setSize(255);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//ExternalId: Field(entity=Sample, name=ExternalId, type=string[255], auto=false, nillable=true, readonly=false, default=)
		{
			StringInput input = new StringInput("Sample_ExternalId",getEntity().getExternalId());
			
			input.setLabel("ExternalId");
			input.setDescription("The name of a sample as known by the customer");
			input.setNillable(true);
			input.setSize(255);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//SampleComment: Field(entity=Sample, name=SampleComment, type=text, auto=false, nillable=true, readonly=false, default=)
		{
			TextInput input = new TextInput("Sample_SampleComment",getEntity().getSampleComment());
			
			input.setLabel("Comment");
			input.setDescription("Comments about the sample");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//ProjectId: Field(entity=Sample, name=ProjectId, type=xref[Project.id], xref_label='ProjectName', auto=false, nillable=false, readonly=false, default=)
		{
		    //TODO: when we have JPA this should become:
			//XrefInput<Sample> input = new XrefInput<Sample>("Sample_ProjectId", getEntity().getProjectId());
			//create xref dummy object
			Project dummy = null;
			if(getEntity().getProjectId_Id() != null)
			{
			 	dummy = new Project();
				dummy.setId(getEntity().getProjectId_Id());
				dummy.setProjectName( getEntity().getProjectId_ProjectName() ); 
			}
			XrefInput<Project> input = new XrefInput<Project>("Sample_ProjectId", org.molgenis.omx.ngs.Project.class, dummy);
			
			input.setLabel("Project name");
			input.setDescription("the sample that this sample is part of");
			input.setNillable(false);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//ArrayFile: Field(entity=Sample, name=ArrayFile, type=string[255], auto=false, nillable=true, readonly=false, default=)
		{
			StringInput input = new StringInput("Sample_ArrayFile",getEntity().getArrayFile());
			
			input.setLabel("Array file");
			input.setDescription("Location of arrayfile for the sample in this lane-barcode");
			input.setNillable(true);
			input.setSize(255);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//ArrayId: Field(entity=Sample, name=ArrayId, type=string[255], auto=false, nillable=true, readonly=false, default=)
		{
			StringInput input = new StringInput("Sample_ArrayId",getEntity().getArrayId());
			
			input.setLabel("Array ID");
			input.setDescription("ID of the sample on the arrayFile");
			input.setNillable(true);
			input.setSize(255);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//CapturingKit: Field(entity=Sample, name=CapturingKit, type=xref[CapturingKit.id], xref_label='CapturingKitName', auto=false, nillable=true, readonly=false, default=)
		{
		    //TODO: when we have JPA this should become:
			//XrefInput<Sample> input = new XrefInput<Sample>("Sample_CapturingKit", getEntity().getCapturingKit());
			//create xref dummy object
			CapturingKit dummy = null;
			if(getEntity().getCapturingKit_Id() != null)
			{
			 	dummy = new CapturingKit();
				dummy.setId(getEntity().getCapturingKit_Id());
				dummy.setCapturingKitName( getEntity().getCapturingKit_CapturingKitName() ); 
			}
			XrefInput<CapturingKit> input = new XrefInput<CapturingKit>("Sample_CapturingKit", org.molgenis.omx.ngs.CapturingKit.class, dummy);
			
			input.setLabel("Capturing kit");
			input.setDescription("Capturing kit used.");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//SampleBarcode: Field(entity=Sample, name=SampleBarcode, type=xref[SampleBarcode.id], xref_label='SampleBarcodeName', auto=false, nillable=true, readonly=false, default=)
		{
		    //TODO: when we have JPA this should become:
			//XrefInput<Sample> input = new XrefInput<Sample>("Sample_SampleBarcode", getEntity().getSampleBarcode());
			//create xref dummy object
			SampleBarcode dummy = null;
			if(getEntity().getSampleBarcode_Id() != null)
			{
			 	dummy = new SampleBarcode();
				dummy.setId(getEntity().getSampleBarcode_Id());
				dummy.setSampleBarcodeName( getEntity().getSampleBarcode_SampleBarcodeName() ); 
			}
			XrefInput<SampleBarcode> input = new XrefInput<SampleBarcode>("Sample_SampleBarcode", org.molgenis.omx.ngs.SampleBarcode.class, dummy);
			
			input.setLabel("Barcode");
			input.setDescription("Multiple samples can be on one flowcell using barcodes.");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//SampleInPool: Field(entity=Sample, name=SampleInPool, type=mref[Sample.id], mref_name=Sample_SampleInPool, mref_localid=Sample, mref_remoteid=SampleInPool, xref_label='InternalId', auto=false, nillable=true, readonly=false, default=)
		{
			//TODO: when we have JPA this should become:
			//MrefInput input = new MrefInput("Sample_SampleInPool", getEntity().getSampleInPool());
			//create xref dummy list of references
			List<Sample> dummyList = new ArrayList<Sample>();
			if(getEntity().getSampleInPool_Id() != null) for(int i = 0; i < getEntity().getSampleInPool_Id().size(); i++ )
			{
				Sample dummy = new Sample();
				dummy.setId(getEntity().getSampleInPool_Id().get(i));
				dummy.setInternalId( getEntity().getSampleInPool_InternalId().get(i) ); 
				dummyList.add(dummy);
			}   
			MrefInput<Sample> input = new MrefInput<Sample> ("Sample_SampleInPool", org.molgenis.omx.ngs.Sample.class, dummyList);
			
			input.setLabel("Pooled InternalSampleId(s)");
			input.setDescription("List of samples inside the pool");
			input.setNillable(true);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}
		//LabStatus: Field(entity=Sample, name=LabStatus, type=enum, auto=false, nillable=false, readonly=false, default=Not Started, enum_options=[Not Started, Sample Prep _ Started, Sample Prep _ Failed, Ready for Clustering, Clustering and Sequencing _ Started, Clustering and Sequencing _ Failed, Data Post Processing, Finished Successfully, Other])
		{
			EnumInput input = new EnumInput("Sample_LabStatus",getEntity().getLabStatus());
			
			input.setLabel("Lab status");
			input.setDescription("Lab status phase of this sample");
			input.setNillable(false);
			input.setReadonly( isReadonly() || getEntity().isReadonly());
			input.setOptions(getEntity().getLabStatusOptions());
			if(this.getHiddenColumns().contains(input.getName()))
			{	
				input.setHidden(true);
			}
			if(this.getCompactView().size() > 0 && !this.getCompactView().contains(input.getName()))
			{
				input.setCollapse(true);
			}

			inputs.add(input);
		}

		return inputs;
	}
}


