package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.ngs.CapturingKit;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class CapturingKitService
{
	private static final Logger logger = Logger.getLogger(CapturingKitService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public CapturingKit create(CapturingKit capturingKit) throws DatabaseException
	{
		logger.debug("creating CapturingKit");
		db.add(capturingKit);
		return capturingKit;
	}

	public CapturingKit read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving CapturingKit");
		return db.findById(CapturingKit.class, id);
	}

	public void update(CapturingKit capturingKit) throws DatabaseException
	{
		logger.debug("updating CapturingKit");
		db.update(capturingKit);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting CapturingKit");
		CapturingKit capturingKit = db.findById(CapturingKit.class, id);
		return db.remove(capturingKit) == 1;
	}
	
	public Iterable<CapturingKit> readAll() throws DatabaseException
	{
		logger.debug("retrieving all CapturingKit instances");
		return db.find(CapturingKit.class);
	}
	
	public EntityPager<CapturingKit> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all CapturingKit instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(CapturingKit.class, queryRules.toArray(new QueryRule[0]));
		List<CapturingKit> capturingKitCollection = db.find(CapturingKit.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<CapturingKit>(start, num, count, capturingKitCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("CapturingKit");
	}
}