package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.ngs.Flowcell;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class FlowcellService
{
	private static final Logger logger = Logger.getLogger(FlowcellService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public Flowcell create(Flowcell flowcell) throws DatabaseException
	{
		logger.debug("creating Flowcell");
		db.add(flowcell);
		return flowcell;
	}

	public Flowcell read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Flowcell");
		return db.findById(Flowcell.class, id);
	}

	public void update(Flowcell flowcell) throws DatabaseException
	{
		logger.debug("updating Flowcell");
		db.update(flowcell);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Flowcell");
		Flowcell flowcell = db.findById(Flowcell.class, id);
		return db.remove(flowcell) == 1;
	}
	
	public Iterable<Flowcell> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Flowcell instances");
		return db.find(Flowcell.class);
	}
	
	public EntityPager<Flowcell> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Flowcell instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Flowcell.class, queryRules.toArray(new QueryRule[0]));
		List<Flowcell> flowcellCollection = db.find(Flowcell.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Flowcell>(start, num, count, flowcellCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Flowcell");
	}
}