package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.ngs.SampleBarcode;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class SampleBarcodeService
{
	private static final Logger logger = Logger.getLogger(SampleBarcodeService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public SampleBarcode create(SampleBarcode sampleBarcode) throws DatabaseException
	{
		logger.debug("creating SampleBarcode");
		db.add(sampleBarcode);
		return sampleBarcode;
	}

	public SampleBarcode read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving SampleBarcode");
		return db.findById(SampleBarcode.class, id);
	}

	public void update(SampleBarcode sampleBarcode) throws DatabaseException
	{
		logger.debug("updating SampleBarcode");
		db.update(sampleBarcode);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting SampleBarcode");
		SampleBarcode sampleBarcode = db.findById(SampleBarcode.class, id);
		return db.remove(sampleBarcode) == 1;
	}
	
	public Iterable<SampleBarcode> readAll() throws DatabaseException
	{
		logger.debug("retrieving all SampleBarcode instances");
		return db.find(SampleBarcode.class);
	}
	
	public EntityPager<SampleBarcode> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all SampleBarcode instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(SampleBarcode.class, queryRules.toArray(new QueryRule[0]));
		List<SampleBarcode> sampleBarcodeCollection = db.find(SampleBarcode.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<SampleBarcode>(start, num, count, sampleBarcodeCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("SampleBarcode");
	}
}