/* File:        Ngs/screen/Projects.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        August 21, 2013
 * 
 * generator:   org.molgenis.generators.ui.FormControllerGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
package org.molgenis.ui;

// jdk
import java.util.Vector;
import java.util.ArrayList;

// molgenis
import org.molgenis.framework.ui.ScreenController;
import org.molgenis.framework.ui.FormModel;
import org.molgenis.framework.ui.FormController;

import org.molgenis.framework.ui.html.*;

import org.molgenis.omx.ngs.NgsUser;
import org.molgenis.omx.ngs.PrepKit;
import org.molgenis.omx.ngs.Project;

import org.molgenis.omx.ngs.ui.NgsUserForm;
import org.molgenis.omx.ngs.ui.PrepKitForm;
import org.molgenis.omx.ngs.ui.ProjectForm;


/**
 *
 */
public class ProjectsFormController extends FormController<Project>
{
	private static final long serialVersionUID = 1L;
	
	public ProjectsFormController()
	{
		this(null);
	}
	
	public ProjectsFormController(ScreenController<?> parent)
	{
		super( "Projects", parent );
		getModel().setLabel("Projects");
		getModel().setLimit(10);
		
		

		getModel().setMode(FormModel.Mode.EDIT_VIEW);
		getModel().setEntityClass(Project.class);


		new org.molgenis.ui.Samples1FormController(this);


		getModel().addCommand(new org.molgenis.framework.ui.commands.AddXrefCommand<NgsUser>("Project_ProjectCustomer", this, new NgsUser(), new NgsUserForm()));
		getModel().addCommand(new org.molgenis.framework.ui.commands.AddXrefCommand<NgsUser>("Project_ProjectAnalist", this, new NgsUser(), new NgsUserForm()));
		getModel().addCommand(new org.molgenis.framework.ui.commands.AddXrefCommand<PrepKit>("Project_PrepKit", this, new PrepKit(), new PrepKitForm()));
		getModel().addCommand(new org.molgenis.framework.ui.commands.AddXrefCommand<NgsUser>("Project_ResultShippedUser", this, new NgsUser(), new NgsUserForm()));
		getModel().addCommand(new org.molgenis.framework.ui.commands.AddXrefCommand<NgsUser>("Project_ResultShippedTo", this, new NgsUser(), new NgsUserForm()));
	}
	
	@Override
	public HtmlForm getInputs(Project entity, boolean newrecord)
	{
	
		ProjectForm form = new ProjectForm(entity);
		form.setNewRecord(newrecord);
		form.setReadonly(getModel().isReadonly());
		form.setHiddenColumns(getModel().getUserHiddenColumns());
		
		return form;
	}
	
	@Override
	public void resetSystemHiddenColumns()
	{
		Vector<String> systemHiddenColumns = new Vector<String>();
		systemHiddenColumns.add("id");
        getModel().setSystemHiddenColumns(systemHiddenColumns);
	}

	@Override	
	public String getSearchField(String fieldName)
	{
		if(fieldName.equals("ProjectCustomer")) return "ProjectCustomer_UserName";
		if(fieldName.equals("ProjectAnalist")) return "ProjectAnalist_UserName";
		if(fieldName.equals("PrepKit")) return "PrepKit_PrepKitName";
		if(fieldName.equals("ResultShippedUser")) return "ResultShippedUser_UserName";
		if(fieldName.equals("ResultShippedTo")) return "ResultShippedTo_UserName";
		return fieldName;
	}	

	@Override	
	public String getField(String searchFieldName)
	{
		if(searchFieldName.equals("ProjectCustomer_UserName")) return "ProjectCustomer";
		if(searchFieldName.equals("ProjectAnalist_UserName")) return "ProjectAnalist";
		if(searchFieldName.equals("PrepKit_PrepKitName")) return "PrepKit";
		if(searchFieldName.equals("ResultShippedUser_UserName")) return "ResultShippedUser";
		if(searchFieldName.equals("ResultShippedTo_UserName")) return "ResultShippedTo";
		return searchFieldName;
	}
		
	@Override
	public void resetCompactView()
	{
		ArrayList<String> compactView = new ArrayList<String>();
        getModel().setCompactView(compactView);
	}
	
	@Override
	public Class<Project> getEntityClass()
	{
		return new ProjectForm().getEntityClass();
	}
	
	@Override
	public Vector<String> getHeaders()
	{
		return new ProjectForm().getHeaders();
	}
}