package org.molgenis.controller;

import java.beans.PropertyEditorSupport;
import java.text.ParseException;
import java.lang.RuntimeException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;
import javax.validation.Valid;

import org.molgenis.omx.ngs.SampleBarcodeType;
import org.molgenis.framework.server.EntityCollectionRequest;
import org.molgenis.framework.server.EntityCollectionResponse;
import org.molgenis.framework.db.DatabaseAccessException;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.EntityNotFoundException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.service.SampleBarcodeTypeService;
import org.molgenis.util.EntityPager;
import org.molgenis.util.MolgenisDateFormat;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import org.apache.commons.lang3.StringUtils;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

@SuppressWarnings("unused")
@Lazy
@Controller
@RequestMapping("/api/v1/samplebarcodetype")
public class SampleBarcodeTypeController
{
	@Autowired
	private SampleBarcodeTypeService sampleBarcodeTypeService;

	@RequestMapping(method = RequestMethod.POST)
	@ResponseBody
	public ResponseEntity<SampleBarcodeTypeResponse> createSampleBarcodeType(@Valid @RequestBody SampleBarcodeTypeRequest sampleBarcodeTypeRequest)
			throws DatabaseException
	{
		return _createSampleBarcodeType(sampleBarcodeTypeRequest);
	}

	// Spring's FormHttpMessageConverter cannot bind target classes (as ModelAttribute can)
	@RequestMapping(method = RequestMethod.POST, headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseBody
	public ResponseEntity<SampleBarcodeTypeResponse> createSampleBarcodeTypeFromForm(@Valid @ModelAttribute SampleBarcodeTypeRequest sampleBarcodeTypeRequest)
			throws DatabaseException
	{
		return _createSampleBarcodeType(sampleBarcodeTypeRequest);
	}

	private ResponseEntity<SampleBarcodeTypeResponse> _createSampleBarcodeType(SampleBarcodeTypeRequest sampleBarcodeTypeRequest) throws DatabaseException
	{
		SampleBarcodeType sampleBarcodeType = sampleBarcodeTypeService.create(sampleBarcodeTypeRequest.toSampleBarcodeType());
		HttpHeaders responseHeaders = new HttpHeaders();
		responseHeaders.add("Location", "/api/v1/samplebarcodetype/" + sampleBarcodeType.getId());
		return new ResponseEntity<SampleBarcodeTypeResponse>(responseHeaders, HttpStatus.CREATED);
	}

	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ResponseBody
	public SampleBarcodeTypeResponse retrieveSampleBarcodeType(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveSampleBarcodeType(id, expandFields);
	}
		
	@RequestMapping(value = "/{id}", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	@ResponseBody
	public SampleBarcodeTypeResponse retrieveSampleBarcodeTypeJson(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveSampleBarcodeType(id, expandFields);
	}

	@InitBinder
	public void binder(WebDataBinder binder)
	{

		binder.registerCustomEditor(Date.class, new PropertyEditorSupport()
		{
			@Override
			public void setAsText(String value)
			{
				try
				{
					if (StringUtils.isNotBlank(value))
					{
						setValue(MolgenisDateFormat.getDateFormat().parse(value));
					}
				}
				catch (ParseException e)
				{
					throw new RuntimeException(e);
				}
			}

			@Override
			public String getAsText()
			{
				if (getValue() == null)
				{
					return null;
				}
				
				return MolgenisDateFormat.getDateFormat().format((Date) getValue());
			}

		});
	}

	private SampleBarcodeTypeResponse _retrieveSampleBarcodeType(Integer id, String... expandFieldsStr) throws DatabaseException
	{
		SampleBarcodeType sampleBarcodeType = sampleBarcodeTypeService.read(id);
		if (sampleBarcodeType == null) throw new EntityNotFoundException("SampleBarcodeType " + id.toString() + " not found");
		Set<String> expandFields = expandFieldsStr != null ? new HashSet<String>(Arrays.asList(expandFieldsStr)) : null;
		return new SampleBarcodeTypeResponse(sampleBarcodeType, expandFields);
	}
			


	@RequestMapping(value = "/{id}", method = RequestMethod.PUT)
	@ResponseStatus(HttpStatus.OK)
	public void updateSampleBarcodeType(@PathVariable Integer id, @Valid @RequestBody SampleBarcodeTypeRequest sampleBarcodeTypeRequest)
			throws DatabaseException
	{
		_updateSampleBarcodeType(id, sampleBarcodeTypeRequest);
	}

	// Spring's FormHttpMessageConverter cannot bind target classes (as ModelAttribute can)
	@RequestMapping(value = "/{id}", method = RequestMethod.PUT, headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseBody
	public ResponseEntity<SampleBarcodeTypeResponse> updateSampleBarcodeTypeFromForm(@PathVariable Integer id, @PathVariable String _method,
			@Valid @ModelAttribute SampleBarcodeTypeRequest sampleBarcodeTypeRequest) throws DatabaseException
	{
		return _createSampleBarcodeType(sampleBarcodeTypeRequest);
	}

	// Tunnel PUT through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=PUT")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void updateSampleBarcodeTypePost(@PathVariable Integer id, @Valid @RequestBody SampleBarcodeTypeRequest sampleBarcodeTypeRequest)
			throws DatabaseException
	{
		_updateSampleBarcodeType(id, sampleBarcodeTypeRequest);
	}

	// Tunnel PUT through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=PUT", headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void updateSampleBarcodeTypeFromFormPost(@PathVariable Integer id, @Valid @ModelAttribute SampleBarcodeTypeRequest sampleBarcodeTypeRequest)
			throws DatabaseException
	{
		_updateSampleBarcodeType(id, sampleBarcodeTypeRequest);
	}

	private void _updateSampleBarcodeType(Integer id, SampleBarcodeTypeRequest sampleBarcodeTypeRequest) throws DatabaseException
	{
		SampleBarcodeType sampleBarcodeType = sampleBarcodeTypeRequest.toSampleBarcodeType();
		sampleBarcodeType.setId(id);
		sampleBarcodeTypeService.update(sampleBarcodeType);
	}

	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void deleteSampleBarcodeType(@PathVariable Integer id) throws DatabaseException
	{
		_deleteSampleBarcodeType(id);
	}

	// Tunnel DELETE through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=DELETE")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void deleteSampleBarcodeTypePost(@PathVariable Integer id) throws DatabaseException
	{
		_deleteSampleBarcodeType(id);
	}

	private void _deleteSampleBarcodeType(Integer id) throws DatabaseException
	{
		boolean isDeleted = sampleBarcodeTypeService.deleteById(id);
		if(!isDeleted) throw new EntityNotFoundException("SampleBarcodeType " + id.toString() + " not found");
	}
	
	@RequestMapping(method = RequestMethod.GET)
	@ResponseBody
	public EntityCollectionResponse<SampleBarcodeTypeResponse> retrieveSampleBarcodeTypeCollection(@Valid EntityCollectionRequest sampleBarcodeTypeCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveSampleBarcodeTypeCollection(sampleBarcodeTypeCollectionRequest, expandFields);
	}

	@RequestMapping(method = RequestMethod.GET, params = "format=json", produces = "application/json")
	@ResponseBody
	public EntityCollectionResponse<SampleBarcodeTypeResponse> retrieveSampleBarcodeTypeCollectionJson(@Valid EntityCollectionRequest sampleBarcodeTypeCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveSampleBarcodeTypeCollection(sampleBarcodeTypeCollectionRequest, expandFields);
	}

	// Tunnel GET with body through POST
	@RequestMapping(method = RequestMethod.POST, params = "_method=GET")
	@ResponseBody
	public EntityCollectionResponse<SampleBarcodeTypeResponse> retrieveSampleBarcodeTypeCollectionPost(@Valid @RequestBody EntityCollectionRequest sampleBarcodeTypeCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveSampleBarcodeTypeCollection(sampleBarcodeTypeCollectionRequest, expandFields);
	}

	// Tunnel GET with body through POST
	@RequestMapping(method = RequestMethod.POST, params = {"_method=GET", "format=json"}, produces = "application/json")
	@ResponseBody
	public EntityCollectionResponse<SampleBarcodeTypeResponse> retrieveSampleBarcodeTypeCollectionJsonPost(@Valid @RequestBody EntityCollectionRequest sampleBarcodeTypeCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveSampleBarcodeTypeCollection(sampleBarcodeTypeCollectionRequest, expandFields);
	}
	
	private EntityCollectionResponse<SampleBarcodeTypeResponse> _retrieveSampleBarcodeTypeCollection(EntityCollectionRequest entityCollectionRequest, String... expandFieldsStr) throws DatabaseException
	{
		EntityPager<SampleBarcodeType> sampleBarcodeTypePager = sampleBarcodeTypeService.readAll(entityCollectionRequest.getStart(), entityCollectionRequest.getNum(), entityCollectionRequest.getQ());
		final Set<String> expandFields = expandFieldsStr != null ? new HashSet<String>(Arrays.asList(expandFieldsStr)) : null;
		return new EntityCollectionResponse<SampleBarcodeTypeResponse>(sampleBarcodeTypePager, Lists.newArrayList(Iterables.transform(
				sampleBarcodeTypePager.getIterable(), new Function<SampleBarcodeType, SampleBarcodeTypeResponse>()
				{
					@Override
					@Nullable
					public SampleBarcodeTypeResponse apply(@Nullable SampleBarcodeType sampleBarcodeType)
					{
						try
						{
							return sampleBarcodeType != null ? new SampleBarcodeTypeResponse(sampleBarcodeType, expandFields) : null;
						} catch(DatabaseException e)
						{
							throw new RuntimeException(e);
						}
					}
				})), "/api/v1/samplebarcodetype");
	}

	private static class SampleBarcodeTypeRequest
	{
		private String sampleBarcodeTypeName;
	
		public SampleBarcodeType toSampleBarcodeType()
		{
			SampleBarcodeType sampleBarcodeType = new SampleBarcodeType();
			sampleBarcodeType.setSampleBarcodeTypeName(sampleBarcodeTypeName);
			return sampleBarcodeType;
		}
		
		public void setSampleBarcodeTypeName(String sampleBarcodeTypeName)
		{
			this.sampleBarcodeTypeName = sampleBarcodeTypeName;
		}
		
	}

	static class SampleBarcodeTypeResponse
	{
		private final String href;
		private final String sampleBarcodeTypeName;
	
		public SampleBarcodeTypeResponse(SampleBarcodeType sampleBarcodeType, final Set<String> expandFields) throws DatabaseException
		{
			this.href = "/api/v1/samplebarcodetype/" + sampleBarcodeType.getId();
			this.sampleBarcodeTypeName = sampleBarcodeType.getSampleBarcodeTypeName();
		}
	
		public String getHref()
		{
			return href;
		}
	
		public String getSampleBarcodeTypeName()
		{
			return sampleBarcodeTypeName;
		}
	
	}
	
	@ExceptionHandler(EntityNotFoundException.class)
	@ResponseStatus(value = HttpStatus.NOT_FOUND)
	public void handleEntityNotFoundException(EntityNotFoundException e)
	{
	}
	
	@ExceptionHandler(DatabaseAccessException.class)
	@ResponseStatus(value = HttpStatus.UNAUTHORIZED)
	public void handleDatabaseAccessException(DatabaseAccessException e)
	{
	}
}