
/* File:        org.molgenis.omx/model/FlowcellLane.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.ngs;

/**
 * FlowcellLane: A FlowcellLaneSampleBarcode bundles information about a sample which is added to a lane on a flowcell..
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
//@org.hibernate.search.annotations.Indexed
@javax.persistence.Table(name = "FlowcellLane", uniqueConstraints={ @javax.persistence.UniqueConstraint( columnNames={ "Flowcell", "Lane", "Sample" } ) }
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
//@EntityListeners({org.molgenis.omx.ngs.db.FlowcellLaneEntityListener.class})
public class FlowcellLane extends org.molgenis.util.AbstractEntity implements org.molgenis.omx.core.Autoid
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
	// fieldname constants
	public final static String ID = "id";
	public final static String FLOWCELL = "Flowcell";
	public final static String FLOWCELL_FLOWCELLNAME = "Flowcell_FlowcellName";
	public final static String LANE = "Lane";
	public final static String SAMPLE = "Sample";
	public final static String SAMPLE_INTERNALID = "Sample_InternalId";
	public final static String FLOWCELLLANECOMMENT = "FlowcellLaneComment";
	public final static String QCWETMET = "QcWetMet";
	public final static String QCWETUSER = "QcWetUser";
	public final static String QCWETUSER_USERNAME = "QcWetUser_UserName";
	public final static String QCWETDATE = "QcWetDate";
	public final static String QCDRYMET = "QcDryMet";
	public final static String QCDRYUSER = "QcDryUser";
	public final static String QCDRYUSER_USERNAME = "QcDryUser_UserName";
	public final static String QCDRYDATE = "QcDryDate";
	
	//static methods
	/**
	 * Shorthand for db.query(FlowcellLane.class).
	 */
	public static org.molgenis.framework.db.Query<? extends FlowcellLane> query(org.molgenis.framework.db.Database db)
	{
		return db.query(FlowcellLane.class);
	}
	
	/**
	 * Shorthand for db.find(FlowcellLane.class, org.molgenis.framework.db.QueryRule ... rules).
	 */
	public static java.util.List<? extends FlowcellLane> find(org.molgenis.framework.db.Database db, org.molgenis.framework.db.QueryRule ... rules) throws org.molgenis.framework.db.DatabaseException
	{
		return db.find(FlowcellLane.class, rules);
	}	
	
	/**
	 * 
	 */
	public static FlowcellLane findById(org.molgenis.framework.db.Database db, Integer id) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<FlowcellLane> q = db.query(FlowcellLane.class);
		q.eq(FlowcellLane.ID, id);
		java.util.List<FlowcellLane> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	/**
	 * 
	 */
	public static FlowcellLane findByFlowcellLaneSample(org.molgenis.framework.db.Database db, Integer flowcell, String lane, Integer sample) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<FlowcellLane> q = db.query(FlowcellLane.class);
		q.eq(FlowcellLane.FLOWCELL, flowcell);q.eq(FlowcellLane.LANE, lane);q.eq(FlowcellLane.SAMPLE, sample);
		java.util.List<FlowcellLane> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	
	// member variables (including setters.getters for interface)

	//automatically generated internal id, only for internal use.[type=int]
    @javax.persistence.Id @javax.persistence.GeneratedValue(strategy = javax.persistence.GenerationType.AUTO)
    @javax.persistence.Column(name="id", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="id")
	
	//@javax.validation.constraints.NotNull
	private Integer id =  null;

	//The flowcell to which this lane belongs[type=xref]
//	@org.hibernate.search.annotations.Field(index=org.hibernate.search.annotations.Index.TOKENIZED, store=org.hibernate.search.annotations.Store.NO)
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Flowcell")   	
	
				

	private org.molgenis.omx.ngs.Flowcell flowcell = null;
	@javax.persistence.Transient
	private Integer flowcell_id = null;	
	@javax.persistence.Transient
	private String flowcell_FlowcellName = null;						

	//The lane number that is unique within a flow cell with a range of 1-8.[type=enum]
//	@org.hibernate.search.annotations.Field(index=org.hibernate.search.annotations.Index.TOKENIZED, store=org.hibernate.search.annotations.Store.NO)
	@javax.persistence.Column(name="Lane")
	@javax.xml.bind.annotation.XmlElement(name="lane")
	
				

	private String lane =  null;
	@javax.persistence.Transient
	private String lane_label = null;
	@javax.persistence.Transient
	private static final java.util.List<org.molgenis.util.ValueLabel> lane_options;
	
	static {
		lane_options = new java.util.ArrayList<org.molgenis.util.ValueLabel>();
		lane_options.add(new org.molgenis.util.ValueLabel("1","1"));
		lane_options.add(new org.molgenis.util.ValueLabel("2","2"));
		lane_options.add(new org.molgenis.util.ValueLabel("3","3"));
		lane_options.add(new org.molgenis.util.ValueLabel("4","4"));
		lane_options.add(new org.molgenis.util.ValueLabel("5","5"));
		lane_options.add(new org.molgenis.util.ValueLabel("6","6"));
		lane_options.add(new org.molgenis.util.ValueLabel("7","7"));
		lane_options.add(new org.molgenis.util.ValueLabel("8","8"));
	}

	//Sample[type=xref]
//	@org.hibernate.search.annotations.Field(index=org.hibernate.search.annotations.Index.TOKENIZED, store=org.hibernate.search.annotations.Store.NO)
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Sample", nullable=false)   	
	
				

	@javax.validation.constraints.NotNull
	private org.molgenis.omx.ngs.Sample sample = null;
	@javax.persistence.Transient
	private Integer sample_id = null;	
	@javax.persistence.Transient
	private String sample_InternalId = null;						

	//Comment about the experiment.[type=text]
	@javax.persistence.Lob
	@javax.persistence.Column(name="FlowcellLaneComment")
	
				

	private String flowcellLaneComment =  null;

	//Quality criteria of the wet lab met[type=enum]
	@javax.persistence.Column(name="QcWetMet", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="qcWetMet")
	
				

	@javax.validation.constraints.NotNull
	private String qcWetMet =  "Not determined";
	@javax.persistence.Transient
	private String qcWetMet_label = null;
	@javax.persistence.Transient
	private static final java.util.List<org.molgenis.util.ValueLabel> qcWetMet_options;
	
	static {
		qcWetMet_options = new java.util.ArrayList<org.molgenis.util.ValueLabel>();
		qcWetMet_options.add(new org.molgenis.util.ValueLabel("Not determined","Not determined"));
		qcWetMet_options.add(new org.molgenis.util.ValueLabel("Passed","Passed"));
		qcWetMet_options.add(new org.molgenis.util.ValueLabel("Failed","Failed"));
	}

	//The user who checked if the quality score on the wet-lab was met[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="QcWetUser")   	
	
				

	private org.molgenis.omx.ngs.NgsUser qcWetUser = null;
	@javax.persistence.Transient
	private Integer qcWetUser_id = null;	
	@javax.persistence.Transient
	private String qcWetUser_UserName = null;						

	//The date the QcWetUser selected the QcWetMet value.[type=datetime]
    @javax.persistence.Temporal(javax.persistence.TemporalType.TIMESTAMP)
	@javax.persistence.Column(name="QcWetDate")
	@javax.xml.bind.annotation.XmlElement(name="qcWetDate")
	
				

	private java.util.Date qcWetDate =  null;

	//Variant calling quality criteria[type=enum]
	@javax.persistence.Column(name="QcDryMet", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="qcDryMet")
	
				

	@javax.validation.constraints.NotNull
	private String qcDryMet =  "Not determined";
	@javax.persistence.Transient
	private String qcDryMet_label = null;
	@javax.persistence.Transient
	private static final java.util.List<org.molgenis.util.ValueLabel> qcDryMet_options;
	
	static {
		qcDryMet_options = new java.util.ArrayList<org.molgenis.util.ValueLabel>();
		qcDryMet_options.add(new org.molgenis.util.ValueLabel("Not determined","Not determined"));
		qcDryMet_options.add(new org.molgenis.util.ValueLabel("Passed","Passed"));
		qcDryMet_options.add(new org.molgenis.util.ValueLabel("Failed","Failed"));
	}

	//The user who checked if the quality score of the analysis was met[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="QcDryUser")   	
	
				

	private org.molgenis.omx.ngs.NgsUser qcDryUser = null;
	@javax.persistence.Transient
	private Integer qcDryUser_id = null;	
	@javax.persistence.Transient
	private String qcDryUser_UserName = null;						

	//The date the QcWetUser selected the QcWetMet value[type=datetime]
    @javax.persistence.Temporal(javax.persistence.TemporalType.TIMESTAMP)
	@javax.persistence.Column(name="QcDryDate")
	@javax.xml.bind.annotation.XmlElement(name="qcDryDate")
	
				

	private java.util.Date qcDryDate =  null;

	//constructors
	public FlowcellLane()
	{
	}
	
	/** copy constructor */
	public FlowcellLane(FlowcellLane copyMe) throws Exception
	{	
		for(String f : this.getFields())
		{
			this.set(f, copyMe.get(f));
		}	
	}
	
	//getters and setters
	/**
	 * Get the automatically generated internal id, only for internal use..
	 * @return id.
	 */
	public Integer getId()
	{
		return this.id;
	}
	
	
	/**
	 * Set the automatically generated internal id, only for internal use..
	 * @param id
	 */
	public void setId( Integer id)
	{
		this.id = id;
	}

	

	/**
	 * Get the The flowcell to which this lane belongs.
	 * @return flowcell.
	 */
	public org.molgenis.omx.ngs.Flowcell getFlowcell()
	{
		return this.flowcell;
	}
	
	@Deprecated
	public org.molgenis.omx.ngs.Flowcell getFlowcell(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The flowcell to which this lane belongs.
	 * @param flowcell
	 */
	public void setFlowcell( org.molgenis.omx.ngs.Flowcell flowcell)
	{
		
		this.flowcell = flowcell;
	}

	
	
	/**
	 * Set foreign key for field flowcell.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setFlowcell_Id(Integer flowcell_id)
	{
		this.flowcell_id = flowcell_id;
	}	

	public void setFlowcell(Integer flowcell_id)
	{
		this.flowcell_id = flowcell_id;
	}
	
	public Integer getFlowcell_Id()
	{
		
		if(flowcell != null) 
		{
			return flowcell.getId();
		}
		else
		{
			return flowcell_id;
		}
	}	
	 
	/**
	 * Get a pretty label FlowcellName for cross reference Flowcell to Flowcell.Id.
	 */
	public String getFlowcell_FlowcellName()
	{		
		//FIXME should we auto-load based on getFlowcell()?	
		if(flowcell != null) {
			return flowcell.getFlowcellName();
		} else {
			return flowcell_FlowcellName;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference Flowcell to <a href="Flowcell.html#Id">Flowcell.Id</a>.
	 * Implies setFlowcell(null) until save
	 */
	public void setFlowcell_FlowcellName(String flowcell_FlowcellName)
	{
		this.flowcell_FlowcellName = flowcell_FlowcellName;
	}		
	 
	

	/**
	 * Get the The lane number that is unique within a flow cell with a range of 1-8..
	 * @return lane.
	 */
	public String getLane()
	{
		return this.lane;
	}
	
	@Deprecated
	public String getLane(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The lane number that is unique within a flow cell with a range of 1-8..
	 * @param lane
	 */
	public void setLane( String lane)
	{
		
		this.lane = lane;
	}

	
	/**
	 * Get tha label for enum Lane.
	 */
	public String getLaneLabel()
	{
		return this.lane_label;
	}
	/**
	 * Lane is enum. This method returns all available enum options.
	 */
	public java.util.List<org.molgenis.util.ValueLabel> getLaneOptions()
	{
		return lane_options;
	}	
	

	/**
	 * Get the Sample.
	 * @return sample.
	 */
	public org.molgenis.omx.ngs.Sample getSample()
	{
		return this.sample;
	}
	
	@Deprecated
	public org.molgenis.omx.ngs.Sample getSample(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Sample.
	 * @param sample
	 */
	public void setSample( org.molgenis.omx.ngs.Sample sample)
	{
		
		this.sample = sample;
	}

	
	
	/**
	 * Set foreign key for field sample.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setSample_Id(Integer sample_id)
	{
		this.sample_id = sample_id;
	}	

	public void setSample(Integer sample_id)
	{
		this.sample_id = sample_id;
	}
	
	public Integer getSample_Id()
	{
		
		if(sample != null) 
		{
			return sample.getId();
		}
		else
		{
			return sample_id;
		}
	}	
	 
	/**
	 * Get a pretty label InternalId for cross reference Sample to Sample.Id.
	 */
	public String getSample_InternalId()
	{		
		//FIXME should we auto-load based on getSample()?	
		if(sample != null) {
			return sample.getInternalId();
		} else {
			return sample_InternalId;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference Sample to <a href="Sample.html#Id">Sample.Id</a>.
	 * Implies setSample(null) until save
	 */
	public void setSample_InternalId(String sample_InternalId)
	{
		this.sample_InternalId = sample_InternalId;
	}		
	 
	

	/**
	 * Get the Comment about the experiment..
	 * @return flowcellLaneComment.
	 */
	public String getFlowcellLaneComment()
	{
		return this.flowcellLaneComment;
	}
	
	@Deprecated
	public String getFlowcellLaneComment(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Comment about the experiment..
	 * @param flowcellLaneComment
	 */
	public void setFlowcellLaneComment( String flowcellLaneComment)
	{
		
		this.flowcellLaneComment = flowcellLaneComment;
	}

	

	/**
	 * Get the Quality criteria of the wet lab met.
	 * @return qcWetMet.
	 */
	public String getQcWetMet()
	{
		return this.qcWetMet;
	}
	
	@Deprecated
	public String getQcWetMet(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Quality criteria of the wet lab met.
	 * @param qcWetMet
	 */
	public void setQcWetMet( String qcWetMet)
	{
		
		this.qcWetMet = qcWetMet;
	}

	
	/**
	 * Get tha label for enum QcWetMet.
	 */
	public String getQcWetMetLabel()
	{
		return this.qcWetMet_label;
	}
	/**
	 * QcWetMet is enum. This method returns all available enum options.
	 */
	public java.util.List<org.molgenis.util.ValueLabel> getQcWetMetOptions()
	{
		return qcWetMet_options;
	}	
	

	/**
	 * Get the The user who checked if the quality score on the wet-lab was met.
	 * @return qcWetUser.
	 */
	public org.molgenis.omx.ngs.NgsUser getQcWetUser()
	{
		return this.qcWetUser;
	}
	
	@Deprecated
	public org.molgenis.omx.ngs.NgsUser getQcWetUser(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The user who checked if the quality score on the wet-lab was met.
	 * @param qcWetUser
	 */
	public void setQcWetUser( org.molgenis.omx.ngs.NgsUser qcWetUser)
	{
		
		this.qcWetUser = qcWetUser;
	}

	
	
	/**
	 * Set foreign key for field qcWetUser.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setQcWetUser_Id(Integer qcWetUser_id)
	{
		this.qcWetUser_id = qcWetUser_id;
	}	

	public void setQcWetUser(Integer qcWetUser_id)
	{
		this.qcWetUser_id = qcWetUser_id;
	}
	
	public Integer getQcWetUser_Id()
	{
		
		if(qcWetUser != null) 
		{
			return qcWetUser.getId();
		}
		else
		{
			return qcWetUser_id;
		}
	}	
	 
	/**
	 * Get a pretty label UserName for cross reference QcWetUser to NgsUser.Id.
	 */
	public String getQcWetUser_UserName()
	{		
		//FIXME should we auto-load based on getQcWetUser()?	
		if(qcWetUser != null) {
			return qcWetUser.getUserName();
		} else {
			return qcWetUser_UserName;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference QcWetUser to <a href="NgsUser.html#Id">NgsUser.Id</a>.
	 * Implies setQcWetUser(null) until save
	 */
	public void setQcWetUser_UserName(String qcWetUser_UserName)
	{
		this.qcWetUser_UserName = qcWetUser_UserName;
	}		
	 
	

	/**
	 * Get the The date the QcWetUser selected the QcWetMet value..
	 * @return qcWetDate.
	 */
	public java.util.Date getQcWetDate()
	{
		return this.qcWetDate;
	}
	
	@Deprecated
	public java.util.Date getQcWetDate(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The date the QcWetUser selected the QcWetMet value..
	 * @param qcWetDate
	 */
	public void setQcWetDate( java.util.Date qcWetDate)
	{
		
		this.qcWetDate = qcWetDate;
	}

	

	/**
	 * Get the Variant calling quality criteria.
	 * @return qcDryMet.
	 */
	public String getQcDryMet()
	{
		return this.qcDryMet;
	}
	
	@Deprecated
	public String getQcDryMet(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Variant calling quality criteria.
	 * @param qcDryMet
	 */
	public void setQcDryMet( String qcDryMet)
	{
		
		this.qcDryMet = qcDryMet;
	}

	
	/**
	 * Get tha label for enum QcDryMet.
	 */
	public String getQcDryMetLabel()
	{
		return this.qcDryMet_label;
	}
	/**
	 * QcDryMet is enum. This method returns all available enum options.
	 */
	public java.util.List<org.molgenis.util.ValueLabel> getQcDryMetOptions()
	{
		return qcDryMet_options;
	}	
	

	/**
	 * Get the The user who checked if the quality score of the analysis was met.
	 * @return qcDryUser.
	 */
	public org.molgenis.omx.ngs.NgsUser getQcDryUser()
	{
		return this.qcDryUser;
	}
	
	@Deprecated
	public org.molgenis.omx.ngs.NgsUser getQcDryUser(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The user who checked if the quality score of the analysis was met.
	 * @param qcDryUser
	 */
	public void setQcDryUser( org.molgenis.omx.ngs.NgsUser qcDryUser)
	{
		
		this.qcDryUser = qcDryUser;
	}

	
	
	/**
	 * Set foreign key for field qcDryUser.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setQcDryUser_Id(Integer qcDryUser_id)
	{
		this.qcDryUser_id = qcDryUser_id;
	}	

	public void setQcDryUser(Integer qcDryUser_id)
	{
		this.qcDryUser_id = qcDryUser_id;
	}
	
	public Integer getQcDryUser_Id()
	{
		
		if(qcDryUser != null) 
		{
			return qcDryUser.getId();
		}
		else
		{
			return qcDryUser_id;
		}
	}	
	 
	/**
	 * Get a pretty label UserName for cross reference QcDryUser to NgsUser.Id.
	 */
	public String getQcDryUser_UserName()
	{		
		//FIXME should we auto-load based on getQcDryUser()?	
		if(qcDryUser != null) {
			return qcDryUser.getUserName();
		} else {
			return qcDryUser_UserName;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference QcDryUser to <a href="NgsUser.html#Id">NgsUser.Id</a>.
	 * Implies setQcDryUser(null) until save
	 */
	public void setQcDryUser_UserName(String qcDryUser_UserName)
	{
		this.qcDryUser_UserName = qcDryUser_UserName;
	}		
	 
	

	/**
	 * Get the The date the QcWetUser selected the QcWetMet value.
	 * @return qcDryDate.
	 */
	public java.util.Date getQcDryDate()
	{
		return this.qcDryDate;
	}
	
	@Deprecated
	public java.util.Date getQcDryDate(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The date the QcWetUser selected the QcWetMet value.
	 * @param qcDryDate
	 */
	public void setQcDryDate( java.util.Date qcDryDate)
	{
		
		this.qcDryDate = qcDryDate;
	}

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("flowcell"))
			return getFlowcell();
		if(name.equals("flowcell_id"))
			return getFlowcell_Id();
		if(name.equals("flowcell_flowcellname"))
			return getFlowcell_FlowcellName();
		if (name.equals("lane"))
			return getLane();
		if(name.equals("lane_label"))
			return getLaneLabel();
		if (name.equals("sample"))
			return getSample();
		if(name.equals("sample_id"))
			return getSample_Id();
		if(name.equals("sample_internalid"))
			return getSample_InternalId();
		if (name.equals("flowcelllanecomment"))
			return getFlowcellLaneComment();
		if (name.equals("qcwetmet"))
			return getQcWetMet();
		if(name.equals("qcwetmet_label"))
			return getQcWetMetLabel();
		if (name.equals("qcwetuser"))
			return getQcWetUser();
		if(name.equals("qcwetuser_id"))
			return getQcWetUser_Id();
		if(name.equals("qcwetuser_username"))
			return getQcWetUser_UserName();
		if (name.equals("qcwetdate"))
			return getQcWetDate();
		if (name.equals("qcdrymet"))
			return getQcDryMet();
		if(name.equals("qcdrymet_label"))
			return getQcDryMetLabel();
		if (name.equals("qcdryuser"))
			return getQcDryUser();
		if(name.equals("qcdryuser_id"))
			return getQcDryUser_Id();
		if(name.equals("qcdryuser_username"))
			return getQcDryUser_UserName();
		if (name.equals("qcdrydate"))
			return getQcDryDate();
		return null;
	}	
	
	@Override
	public void validate() throws org.molgenis.framework.db.DatabaseException
	{
		if(this.getId() == null) throw new org.molgenis.framework.db.DatabaseException("required field id is null");
		if(this.getSample() == null) throw new org.molgenis.framework.db.DatabaseException("required field sample is null");
		if(this.getQcWetMet() == null) throw new org.molgenis.framework.db.DatabaseException("required field qcWetMet is null");
		if(this.getQcDryMet() == null) throw new org.molgenis.framework.db.DatabaseException("required field qcDryMet is null");
	}
	
	@Override
	public void set(org.molgenis.util.tuple.Tuple tuple, boolean strict ) throws Exception
	{
		//set Id
		// query formal name, else lowercase name
		if(tuple.getInt("id") != null) this.setId(tuple.getInt("id"));
		else if(tuple.getInt("id") != null) this.setId(tuple.getInt("id"));
		else if(strict) this.setId(tuple.getInt("id")); // setting null is not an option due to function overloading
		if( tuple.getInt("flowcelllane_id") != null) this.setId(tuple.getInt("flowcelllane_id"));
		else if( tuple.getInt("FlowcellLane_id") != null) this.setId(tuple.getInt("FlowcellLane_id"));
		//set Flowcell
		// query formal name, else lowercase name
		if(tuple.getInt("Flowcell_id") != null) this.setFlowcell(tuple.getInt("Flowcell_id"));
		else if(tuple.getInt("flowcell_id") != null) this.setFlowcell(tuple.getInt("flowcell_id"));
		else if(strict) this.setFlowcell(tuple.getInt("Flowcell_id")); // setting null is not an option due to function overloading
		
		if( tuple.getInt("FlowcellLane_Flowcell_id") != null) this.setFlowcell(tuple.getInt("FlowcellLane_Flowcell_id"));
		else if( tuple.getInt("flowcelllane_flowcell_id") != null) this.setFlowcell(tuple.getInt("flowcelllane_flowcell_id"));
		//alias of xref
		if( tuple.get("Flowcell") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("Flowcell").toString())) {
				org.molgenis.omx.ngs.Flowcell instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("Flowcell"), org.molgenis.omx.ngs.Flowcell.class);
				this.setFlowcell(instance);				
			} else {
				this.setFlowcell_Id(tuple.getInt("Flowcell")); 
			}
		}
		else if( tuple.get("flowcell") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("flowcell").toString())) {
				org.molgenis.omx.ngs.Flowcell instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("flowcell"), org.molgenis.omx.ngs.Flowcell.class);
				this.setFlowcell(instance);				
			} else {
				this.setFlowcell_Id(tuple.getInt("Flowcell"));
			}
		}
		if( tuple.get("FlowcellLane_Flowcell") != null)
			this.setFlowcell_Id(tuple.getInt("FlowcellLane_Flowcell"));			
		else if( tuple.get("flowcelllane_flowcell") != null)
			this.setFlowcell_Id(tuple.getInt("flowcelllane_flowcell"));
			
		if( tuple.get("FlowcellLane.Flowcell") != null) 
			this.setFlowcell((org.molgenis.omx.ngs.Flowcell)tuple.get("FlowcellLane.Flowcell_id"));
		else if( tuple.get("flowcelllane.flowcell") != null) 
			this.setFlowcell((org.molgenis.omx.ngs.Flowcell)tuple.get("flowcelllane.flowcell_id"));	
		//set label for field Flowcell
		if(tuple.get("Flowcell_FlowcellName") != null) this.setFlowcell_FlowcellName(tuple.getString("Flowcell_FlowcellName"));
		else if(tuple.get("flowcell_flowcellname") != null) this.setFlowcell_FlowcellName(tuple.getString("flowcell_flowcellname"));
		else if(strict) this.setFlowcell_FlowcellName(tuple.getString("Flowcell_FlowcellName")); // setting null is not an option due to function overloading
		if( tuple.get("FlowcellLane_Flowcell_FlowcellName") != null ) this.setFlowcell_FlowcellName(tuple.getString("FlowcellLane_Flowcell_FlowcellName"));		
		else if( tuple.get("flowcelllane_flowcell_flowcellname") != null ) this.setFlowcell_FlowcellName(tuple.getString("flowcelllane_flowcell_flowcellname"));
		//set Lane
		// query formal name, else lowercase name
		if(tuple.getString("lane") != null) this.setLane(tuple.getString("lane"));
		else if(tuple.getString("Lane") != null) this.setLane(tuple.getString("Lane"));
		else if(strict) this.setLane(tuple.getString("lane")); // setting null is not an option due to function overloading
		if( tuple.getString("flowcelllane_lane") != null) this.setLane(tuple.getString("flowcelllane_lane"));
		else if( tuple.getString("FlowcellLane_Lane") != null) this.setLane(tuple.getString("FlowcellLane_Lane"));
		//set Sample
		// query formal name, else lowercase name
		if(tuple.getInt("Sample_id") != null) this.setSample(tuple.getInt("Sample_id"));
		else if(tuple.getInt("sample_id") != null) this.setSample(tuple.getInt("sample_id"));
		else if(strict) this.setSample(tuple.getInt("Sample_id")); // setting null is not an option due to function overloading
		
		if( tuple.getInt("FlowcellLane_Sample_id") != null) this.setSample(tuple.getInt("FlowcellLane_Sample_id"));
		else if( tuple.getInt("flowcelllane_sample_id") != null) this.setSample(tuple.getInt("flowcelllane_sample_id"));
		//alias of xref
		if( tuple.get("Sample") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("Sample").toString())) {
				org.molgenis.omx.ngs.Sample instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("Sample"), org.molgenis.omx.ngs.Sample.class);
				this.setSample(instance);				
			} else {
				this.setSample_Id(tuple.getInt("Sample")); 
			}
		}
		else if( tuple.get("sample") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("sample").toString())) {
				org.molgenis.omx.ngs.Sample instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("sample"), org.molgenis.omx.ngs.Sample.class);
				this.setSample(instance);				
			} else {
				this.setSample_Id(tuple.getInt("Sample"));
			}
		}
		if( tuple.get("FlowcellLane_Sample") != null)
			this.setSample_Id(tuple.getInt("FlowcellLane_Sample"));			
		else if( tuple.get("flowcelllane_sample") != null)
			this.setSample_Id(tuple.getInt("flowcelllane_sample"));
			
		if( tuple.get("FlowcellLane.Sample") != null) 
			this.setSample((org.molgenis.omx.ngs.Sample)tuple.get("FlowcellLane.Sample_id"));
		else if( tuple.get("flowcelllane.sample") != null) 
			this.setSample((org.molgenis.omx.ngs.Sample)tuple.get("flowcelllane.sample_id"));	
		//set label for field Sample
		if(tuple.get("Sample_InternalId") != null) this.setSample_InternalId(tuple.getString("Sample_InternalId"));
		else if(tuple.get("sample_internalid") != null) this.setSample_InternalId(tuple.getString("sample_internalid"));
		else if(strict) this.setSample_InternalId(tuple.getString("Sample_InternalId")); // setting null is not an option due to function overloading
		if( tuple.get("FlowcellLane_Sample_InternalId") != null ) this.setSample_InternalId(tuple.getString("FlowcellLane_Sample_InternalId"));		
		else if( tuple.get("flowcelllane_sample_internalid") != null ) this.setSample_InternalId(tuple.getString("flowcelllane_sample_internalid"));
		//set FlowcellLaneComment
		// query formal name, else lowercase name
		if(tuple.getString("flowcelllanecomment") != null) this.setFlowcellLaneComment(tuple.getString("flowcelllanecomment"));
		else if(tuple.getString("FlowcellLaneComment") != null) this.setFlowcellLaneComment(tuple.getString("FlowcellLaneComment"));
		else if(strict) this.setFlowcellLaneComment(tuple.getString("flowcelllanecomment")); // setting null is not an option due to function overloading
		if( tuple.getString("flowcelllane_flowcelllanecomment") != null) this.setFlowcellLaneComment(tuple.getString("flowcelllane_flowcelllanecomment"));
		else if( tuple.getString("FlowcellLane_FlowcellLaneComment") != null) this.setFlowcellLaneComment(tuple.getString("FlowcellLane_FlowcellLaneComment"));
		//set QcWetMet
		// query formal name, else lowercase name
		if(tuple.getString("qcwetmet") != null) this.setQcWetMet(tuple.getString("qcwetmet"));
		else if(tuple.getString("QcWetMet") != null) this.setQcWetMet(tuple.getString("QcWetMet"));
		else if(strict) this.setQcWetMet(tuple.getString("qcwetmet")); // setting null is not an option due to function overloading
		if( tuple.getString("flowcelllane_qcwetmet") != null) this.setQcWetMet(tuple.getString("flowcelllane_qcwetmet"));
		else if( tuple.getString("FlowcellLane_QcWetMet") != null) this.setQcWetMet(tuple.getString("FlowcellLane_QcWetMet"));
		//set QcWetUser
		// query formal name, else lowercase name
		if(tuple.getInt("QcWetUser_id") != null) this.setQcWetUser(tuple.getInt("QcWetUser_id"));
		else if(tuple.getInt("qcwetuser_id") != null) this.setQcWetUser(tuple.getInt("qcwetuser_id"));
		else if(strict) this.setQcWetUser(tuple.getInt("QcWetUser_id")); // setting null is not an option due to function overloading
		
		if( tuple.getInt("FlowcellLane_QcWetUser_id") != null) this.setQcWetUser(tuple.getInt("FlowcellLane_QcWetUser_id"));
		else if( tuple.getInt("flowcelllane_qcwetuser_id") != null) this.setQcWetUser(tuple.getInt("flowcelllane_qcwetuser_id"));
		//alias of xref
		if( tuple.get("QcWetUser") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("QcWetUser").toString())) {
				org.molgenis.omx.ngs.NgsUser instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("QcWetUser"), org.molgenis.omx.ngs.NgsUser.class);
				this.setQcWetUser(instance);				
			} else {
				this.setQcWetUser_Id(tuple.getInt("QcWetUser")); 
			}
		}
		else if( tuple.get("qcwetuser") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("qcwetuser").toString())) {
				org.molgenis.omx.ngs.NgsUser instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("qcwetuser"), org.molgenis.omx.ngs.NgsUser.class);
				this.setQcWetUser(instance);				
			} else {
				this.setQcWetUser_Id(tuple.getInt("QcWetUser"));
			}
		}
		if( tuple.get("FlowcellLane_QcWetUser") != null)
			this.setQcWetUser_Id(tuple.getInt("FlowcellLane_QcWetUser"));			
		else if( tuple.get("flowcelllane_qcwetuser") != null)
			this.setQcWetUser_Id(tuple.getInt("flowcelllane_qcwetuser"));
			
		if( tuple.get("FlowcellLane.QcWetUser") != null) 
			this.setQcWetUser((org.molgenis.omx.ngs.NgsUser)tuple.get("FlowcellLane.QcWetUser_id"));
		else if( tuple.get("flowcelllane.qcwetuser") != null) 
			this.setQcWetUser((org.molgenis.omx.ngs.NgsUser)tuple.get("flowcelllane.qcwetuser_id"));	
		//set label for field QcWetUser
		if(tuple.get("QcWetUser_UserName") != null) this.setQcWetUser_UserName(tuple.getString("QcWetUser_UserName"));
		else if(tuple.get("qcwetuser_username") != null) this.setQcWetUser_UserName(tuple.getString("qcwetuser_username"));
		else if(strict) this.setQcWetUser_UserName(tuple.getString("QcWetUser_UserName")); // setting null is not an option due to function overloading
		if( tuple.get("FlowcellLane_QcWetUser_UserName") != null ) this.setQcWetUser_UserName(tuple.getString("FlowcellLane_QcWetUser_UserName"));		
		else if( tuple.get("flowcelllane_qcwetuser_username") != null ) this.setQcWetUser_UserName(tuple.getString("flowcelllane_qcwetuser_username"));
		//set QcWetDate
		// query formal name, else lowercase name
		if(tuple.getTimestamp("qcwetdate") != null) this.setQcWetDate(tuple.getTimestamp("qcwetdate"));
		else if(tuple.getTimestamp("QcWetDate") != null) this.setQcWetDate(tuple.getTimestamp("QcWetDate"));
		else if(strict) this.setQcWetDate(tuple.getTimestamp("qcwetdate")); // setting null is not an option due to function overloading
		if( tuple.getTimestamp("flowcelllane_qcwetdate") != null) this.setQcWetDate(tuple.getTimestamp("flowcelllane_qcwetdate"));
		else if( tuple.getTimestamp("FlowcellLane_QcWetDate") != null) this.setQcWetDate(tuple.getTimestamp("FlowcellLane_QcWetDate"));
		//set QcDryMet
		// query formal name, else lowercase name
		if(tuple.getString("qcdrymet") != null) this.setQcDryMet(tuple.getString("qcdrymet"));
		else if(tuple.getString("QcDryMet") != null) this.setQcDryMet(tuple.getString("QcDryMet"));
		else if(strict) this.setQcDryMet(tuple.getString("qcdrymet")); // setting null is not an option due to function overloading
		if( tuple.getString("flowcelllane_qcdrymet") != null) this.setQcDryMet(tuple.getString("flowcelllane_qcdrymet"));
		else if( tuple.getString("FlowcellLane_QcDryMet") != null) this.setQcDryMet(tuple.getString("FlowcellLane_QcDryMet"));
		//set QcDryUser
		// query formal name, else lowercase name
		if(tuple.getInt("QcDryUser_id") != null) this.setQcDryUser(tuple.getInt("QcDryUser_id"));
		else if(tuple.getInt("qcdryuser_id") != null) this.setQcDryUser(tuple.getInt("qcdryuser_id"));
		else if(strict) this.setQcDryUser(tuple.getInt("QcDryUser_id")); // setting null is not an option due to function overloading
		
		if( tuple.getInt("FlowcellLane_QcDryUser_id") != null) this.setQcDryUser(tuple.getInt("FlowcellLane_QcDryUser_id"));
		else if( tuple.getInt("flowcelllane_qcdryuser_id") != null) this.setQcDryUser(tuple.getInt("flowcelllane_qcdryuser_id"));
		//alias of xref
		if( tuple.get("QcDryUser") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("QcDryUser").toString())) {
				org.molgenis.omx.ngs.NgsUser instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("QcDryUser"), org.molgenis.omx.ngs.NgsUser.class);
				this.setQcDryUser(instance);				
			} else {
				this.setQcDryUser_Id(tuple.getInt("QcDryUser")); 
			}
		}
		else if( tuple.get("qcdryuser") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("qcdryuser").toString())) {
				org.molgenis.omx.ngs.NgsUser instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("qcdryuser"), org.molgenis.omx.ngs.NgsUser.class);
				this.setQcDryUser(instance);				
			} else {
				this.setQcDryUser_Id(tuple.getInt("QcDryUser"));
			}
		}
		if( tuple.get("FlowcellLane_QcDryUser") != null)
			this.setQcDryUser_Id(tuple.getInt("FlowcellLane_QcDryUser"));			
		else if( tuple.get("flowcelllane_qcdryuser") != null)
			this.setQcDryUser_Id(tuple.getInt("flowcelllane_qcdryuser"));
			
		if( tuple.get("FlowcellLane.QcDryUser") != null) 
			this.setQcDryUser((org.molgenis.omx.ngs.NgsUser)tuple.get("FlowcellLane.QcDryUser_id"));
		else if( tuple.get("flowcelllane.qcdryuser") != null) 
			this.setQcDryUser((org.molgenis.omx.ngs.NgsUser)tuple.get("flowcelllane.qcdryuser_id"));	
		//set label for field QcDryUser
		if(tuple.get("QcDryUser_UserName") != null) this.setQcDryUser_UserName(tuple.getString("QcDryUser_UserName"));
		else if(tuple.get("qcdryuser_username") != null) this.setQcDryUser_UserName(tuple.getString("qcdryuser_username"));
		else if(strict) this.setQcDryUser_UserName(tuple.getString("QcDryUser_UserName")); // setting null is not an option due to function overloading
		if( tuple.get("FlowcellLane_QcDryUser_UserName") != null ) this.setQcDryUser_UserName(tuple.getString("FlowcellLane_QcDryUser_UserName"));		
		else if( tuple.get("flowcelllane_qcdryuser_username") != null ) this.setQcDryUser_UserName(tuple.getString("flowcelllane_qcdryuser_username"));
		//set QcDryDate
		// query formal name, else lowercase name
		if(tuple.getTimestamp("qcdrydate") != null) this.setQcDryDate(tuple.getTimestamp("qcdrydate"));
		else if(tuple.getTimestamp("QcDryDate") != null) this.setQcDryDate(tuple.getTimestamp("QcDryDate"));
		else if(strict) this.setQcDryDate(tuple.getTimestamp("qcdrydate")); // setting null is not an option due to function overloading
		if( tuple.getTimestamp("flowcelllane_qcdrydate") != null) this.setQcDryDate(tuple.getTimestamp("flowcelllane_qcdrydate"));
		else if( tuple.getTimestamp("FlowcellLane_QcDryDate") != null) this.setQcDryDate(tuple.getTimestamp("FlowcellLane_QcDryDate"));
	}

	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		String result = "FlowcellLane(";
		result+= "id='" + getId()+"' ";	
		result+= " flowcell_id='" + getFlowcell_Id()+"' ";	
		result+= " flowcell_flowcellName='" + getFlowcell_FlowcellName()+"' ";
		result+= "lane='" + getLane()+"' ";	
		result+= " sample_id='" + getSample_Id()+"' ";	
		result+= " sample_internalId='" + getSample_InternalId()+"' ";
		result+= "flowcellLaneComment='" + getFlowcellLaneComment()+"' ";	
		result+= "qcWetMet='" + getQcWetMet()+"' ";	
		result+= " qcWetUser_id='" + getQcWetUser_Id()+"' ";	
		result+= " qcWetUser_userName='" + getQcWetUser_UserName()+"' ";
		result+= "qcWetDate='" + (getQcWetDate() == null ? "" : new java.text.SimpleDateFormat("MMMM d, yyyy, HH:mm:ss", java.util.Locale.US).format(getQcWetDate()))+"' ";
		result+= "qcWetDate='" + (getQcWetDate() == null ? "" : new java.text.SimpleDateFormat("MMMM d, yyyy", java.util.Locale.US).format(getQcWetDate()))+"' ";		
		result+= "qcDryMet='" + getQcDryMet()+"' ";	
		result+= " qcDryUser_id='" + getQcDryUser_Id()+"' ";	
		result+= " qcDryUser_userName='" + getQcDryUser_UserName()+"' ";
		result+= "qcDryDate='" + (getQcDryDate() == null ? "" : new java.text.SimpleDateFormat("MMMM d, yyyy, HH:mm:ss", java.util.Locale.US).format(getQcDryDate()))+"'";
		result+= "qcDryDate='" + (getQcDryDate() == null ? "" : new java.text.SimpleDateFormat("MMMM d, yyyy", java.util.Locale.US).format(getQcDryDate()))+"'";		
		result += ");";
		return result;

	}

	/**
	 * Get the names of all public properties of FlowcellLane.
	 */
	@Override
	public java.util.Vector<String> getFields(boolean skipAutoIds)
	{
		java.util.Vector<String> fields = new java.util.Vector<String>();
		if(!skipAutoIds)
		{
			fields.add("id");
		}
		{
			fields.add("Flowcell_id");
		}
		fields.add("Flowcell_FlowcellName");
		{
			fields.add("Lane");
		}
		{
			fields.add("Sample_id");
		}
		fields.add("Sample_InternalId");
		{
			fields.add("FlowcellLaneComment");
		}
		{
			fields.add("QcWetMet");
		}
		{
			fields.add("QcWetUser_id");
		}
		fields.add("QcWetUser_UserName");
		{
			fields.add("QcWetDate");
		}
		{
			fields.add("QcDryMet");
		}
		{
			fields.add("QcDryUser_id");
		}
		fields.add("QcDryUser_UserName");
		{
			fields.add("QcDryDate");
		}
		return fields;
	}	

	@Override
	public java.util.Vector<String> getFields()
	{
		return getFields(false);
	}

	@Override
	public String getIdField()
	{
		return "id";
	}

	@Override
	public java.util.List<String> getLabelFields()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Flowcell");
		result.add("Lane");
		result.add("Sample");
		return result;
	}

	@Deprecated
	@Override
	public String getFields(String sep)
	{
		return (""
		+ "id" +sep
		+ "flowcell" +sep
		+ "lane" +sep
		+ "sample" +sep
		+ "flowcellLaneComment" +sep
		+ "qcWetMet" +sep
		+ "qcWetUser" +sep
		+ "qcWetDate" +sep
		+ "qcDryMet" +sep
		+ "qcDryUser" +sep
		+ "qcDryDate" 
		);
	}

	@Override
	public Object getIdValue()
	{
		return get(getIdField());
	}		
	
	@Override
    public String getXrefIdFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("flowcell")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("sample")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("qcWetUser")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("qcDryUser")) {
            return "id";
        }
        
        return null;
    }	

	@Deprecated
	@Override
	public String getValues(String sep)
	{
		java.io.StringWriter out = new java.io.StringWriter();
		{
			Object valueO = getId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getFlowcell();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getLane();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSample();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getFlowcellLaneComment();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getQcWetMet();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getQcWetUser();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getQcWetDate();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getQcDryMet();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getQcDryUser();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getQcDryDate();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS);
		}
		return out.toString();
	}
	
	@Override
	public FlowcellLane create(org.molgenis.util.tuple.Tuple tuple) throws Exception
	{
		FlowcellLane e = new FlowcellLane();
		e.set(tuple);
		return e;
	}
	

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (getClass() != obj.getClass()) return false;
		FlowcellLane other = (FlowcellLane) obj;
		if (flowcell == null)
		{
			if (other.flowcell != null) return false;
		}
		else if (!flowcell.equals(other.flowcell)) return false;
		if (lane == null)
		{
			if (other.lane != null) return false;
		}
		else if (!lane.equals(other.lane)) return false;
		if (sample == null)
		{
			if (other.sample != null) return false;
		}
		else if (!sample.equals(other.sample)) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		final int prime = 31;
		int result = 1;
		result = prime * result + ((flowcell == null) ? 0 : flowcell.hashCode());
		result = prime * result + ((lane == null) ? 0 : lane.hashCode());
		result = prime * result + ((sample == null) ? 0 : sample.hashCode());
		return result;
	}
}
