
/* File:        org.molgenis.omx/model/Project.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.ngs;

/**
 * Project: A Project bundles information about one project..
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
//@org.hibernate.search.annotations.Indexed
@javax.persistence.Table(name = "Project", uniqueConstraints={ @javax.persistence.UniqueConstraint( columnNames={ "ProjectName" } ) }
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
//@EntityListeners({org.molgenis.omx.ngs.db.ProjectEntityListener.class})
public class Project extends org.molgenis.util.AbstractEntity implements org.molgenis.omx.core.Autoid
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
	// fieldname constants
	public final static String ID = "id";
	public final static String PROJECTNAME = "ProjectName";
	public final static String PROJECTCOMMENT = "ProjectComment";
	public final static String PROJECTCUSTOMER = "ProjectCustomer";
	public final static String PROJECTCUSTOMER_USERNAME = "ProjectCustomer_UserName";
	public final static String PROJECTANALIST = "ProjectAnalist";
	public final static String PROJECTANALIST_USERNAME = "ProjectAnalist_UserName";
	public final static String PROJECTPLANNEDFINISHDATE = "ProjectPlannedFinishDate";
	public final static String LANEAMOUNT = "LaneAmount";
	public final static String SAMPLEAMOUNT = "SampleAmount";
	public final static String SAMPLETYPE = "SampleType";
	public final static String SEQTYPE = "SeqType";
	public final static String PREPKIT = "PrepKit";
	public final static String PREPKIT_PREPKITNAME = "PrepKit_PrepKitName";
	public final static String DECLARATIONNR = "DeclarationNr";
	public final static String GCCANALYSIS = "GccAnalysis";
	public final static String GCCINSTRUCTIONS = "GccInstructions";
	public final static String RESULTFILESDIR = "ResultFilesDir";
	public final static String RESULTSHIPPEDUSER = "ResultShippedUser";
	public final static String RESULTSHIPPEDUSER_USERNAME = "ResultShippedUser_UserName";
	public final static String RESULTSHIPPEDTO = "ResultShippedTo";
	public final static String RESULTSHIPPEDTO_USERNAME = "ResultShippedTo_UserName";
	public final static String RESULTSHIPPEDDATE = "ResultShippedDate";
	
	//static methods
	/**
	 * Shorthand for db.query(Project.class).
	 */
	public static org.molgenis.framework.db.Query<? extends Project> query(org.molgenis.framework.db.Database db)
	{
		return db.query(Project.class);
	}
	
	/**
	 * Shorthand for db.find(Project.class, org.molgenis.framework.db.QueryRule ... rules).
	 */
	public static java.util.List<? extends Project> find(org.molgenis.framework.db.Database db, org.molgenis.framework.db.QueryRule ... rules) throws org.molgenis.framework.db.DatabaseException
	{
		return db.find(Project.class, rules);
	}	
	
	/**
	 * 
	 */
	public static Project findById(org.molgenis.framework.db.Database db, Integer id) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<Project> q = db.query(Project.class);
		q.eq(Project.ID, id);
		java.util.List<Project> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	/**
	 * 
	 */
	public static Project findByProjectName(org.molgenis.framework.db.Database db, String projectName) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<Project> q = db.query(Project.class);
		q.eq(Project.PROJECTNAME, projectName);
		java.util.List<Project> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	
	// member variables (including setters.getters for interface)

	//automatically generated internal id, only for internal use.[type=int]
    @javax.persistence.Id @javax.persistence.GeneratedValue(strategy = javax.persistence.GenerationType.AUTO)
    @javax.persistence.Column(name="id", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="id")
	
	//@javax.validation.constraints.NotNull
	private Integer id =  null;

	//The name of a project[type=string]
//	@org.hibernate.search.annotations.Field(index=org.hibernate.search.annotations.Index.TOKENIZED, store=org.hibernate.search.annotations.Store.NO)
	@javax.persistence.Column(name="ProjectName", length=255, nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="projectName")
	
				

	@javax.validation.constraints.NotNull
	private String projectName =  null;

	//The comment of a project.[type=string]
	@javax.persistence.Column(name="ProjectComment", length=255)
	@javax.xml.bind.annotation.XmlElement(name="projectComment")
	
				

	private String projectComment =  null;

	//The user who ordered the project.[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="ProjectCustomer")   	
	
				

	private org.molgenis.omx.ngs.NgsUser projectCustomer = null;
	@javax.persistence.Transient
	private Integer projectCustomer_id = null;	
	@javax.persistence.Transient
	private String projectCustomer_UserName = null;						

	//The user which will be responsible for performing the wet-lab activities.[type=mref]
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="ProjectAnalist", insertable=true, updatable=true, nullable=true)
	@javax.persistence.JoinTable(name="Project_ProjectAnalist", 
			joinColumns=@javax.persistence.JoinColumn(name="Project"), inverseJoinColumns=@javax.persistence.JoinColumn(name="ProjectAnalist"))
	
				

	private java.util.List<org.molgenis.omx.ngs.NgsUser> projectAnalist = new java.util.ArrayList<org.molgenis.omx.ngs.NgsUser>();
	@javax.persistence.Transient
	private java.util.List<Integer> projectAnalist_id = new java.util.ArrayList<Integer>();		
	@javax.persistence.Transient
	private java.util.List<String> projectAnalist_UserName = new java.util.ArrayList<String>();

	//The date a project is expected to be finished[type=datetime]
    @javax.persistence.Temporal(javax.persistence.TemporalType.TIMESTAMP)
	@javax.persistence.Column(name="ProjectPlannedFinishDate")
	@javax.xml.bind.annotation.XmlElement(name="projectPlannedFinishDate")
	
				

	private java.util.Date projectPlannedFinishDate =  null;

	//Number of lanes planned in this project[type=int]
	@javax.persistence.Column(name="LaneAmount")
	@javax.xml.bind.annotation.XmlElement(name="laneAmount")
	
				

	private Integer laneAmount =  null;

	//Number of samples planned in this project[type=int]
	@javax.persistence.Column(name="SampleAmount")
	@javax.xml.bind.annotation.XmlElement(name="sampleAmount")
	
				

	private Integer sampleAmount =  null;

	//Type of sample[type=enum]
	@javax.persistence.Column(name="SampleType", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="sampleType")
	
				

	@javax.validation.constraints.NotNull
	private String sampleType =  "DNA";
	@javax.persistence.Transient
	private String sampleType_label = null;
	@javax.persistence.Transient
	private static final java.util.List<org.molgenis.util.ValueLabel> sampleType_options;
	
	static {
		sampleType_options = new java.util.ArrayList<org.molgenis.util.ValueLabel>();
		sampleType_options.add(new org.molgenis.util.ValueLabel("DNA","DNA"));
		sampleType_options.add(new org.molgenis.util.ValueLabel("RNA","RNA"));
	}

	//The type of sequencing.[type=enum]
	@javax.persistence.Column(name="SeqType")
	@javax.xml.bind.annotation.XmlElement(name="seqType")
	
				

	private String seqType =  "PE";
	@javax.persistence.Transient
	private String seqType_label = null;
	@javax.persistence.Transient
	private static final java.util.List<org.molgenis.util.ValueLabel> seqType_options;
	
	static {
		seqType_options = new java.util.ArrayList<org.molgenis.util.ValueLabel>();
		seqType_options.add(new org.molgenis.util.ValueLabel("SR","SR"));
		seqType_options.add(new org.molgenis.util.ValueLabel("PE","PE"));
		seqType_options.add(new org.molgenis.util.ValueLabel("MP","MP"));
		seqType_options.add(new org.molgenis.util.ValueLabel("Unknown","Unknown"));
	}

	//Preparation kit used on the sample for this experiment[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="PrepKit")   	
	
				

	private org.molgenis.omx.ngs.PrepKit prepKit = null;
	@javax.persistence.Transient
	private Integer prepKit_id = null;	
	@javax.persistence.Transient
	private String prepKit_PrepKitName = null;						

	//The Declaration Nr of a project.[type=string]
	@javax.persistence.Column(name="DeclarationNr", length=255)
	@javax.xml.bind.annotation.XmlElement(name="declarationNr")
	
				

	private String declarationNr =  null;

	//Indication if variant calling has to be performed on the experiment.[type=bool]
	@javax.persistence.Column(name="GccAnalysis")
	@javax.xml.bind.annotation.XmlElement(name="gccAnalysis")
	
				

	private Boolean gccAnalysis =  null;

	//Specific instructions for GCC members for the analysis.[type=string]
	@javax.persistence.Column(name="GccInstructions", length=255)
	@javax.xml.bind.annotation.XmlElement(name="gccInstructions")
	
				

	private String gccInstructions =  null;

	//File location of the resulting files after analysis occurred (for file download purpose)[type=string]
	@javax.persistence.Column(name="ResultFilesDir", length=255)
	@javax.xml.bind.annotation.XmlElement(name="resultFilesDir")
	
				

	private String resultFilesDir =  null;

	//The user who shipped the date.[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="ResultShippedUser")   	
	
				

	private org.molgenis.omx.ngs.NgsUser resultShippedUser = null;
	@javax.persistence.Transient
	private Integer resultShippedUser_id = null;	
	@javax.persistence.Transient
	private String resultShippedUser_UserName = null;						

	//Name of the person to which the data has been shipped.[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="ResultShippedTo")   	
	
				

	private org.molgenis.omx.ngs.NgsUser resultShippedTo = null;
	@javax.persistence.Transient
	private Integer resultShippedTo_id = null;	
	@javax.persistence.Transient
	private String resultShippedTo_UserName = null;						

	//The date the result of the experiment is shipped to the custumor.[type=date]
    @javax.persistence.Temporal(javax.persistence.TemporalType.DATE)
	@javax.persistence.Column(name="ResultShippedDate")
	@javax.xml.bind.annotation.XmlElement(name="resultShippedDate")
	
				

	private java.util.Date resultShippedDate =  null;

	//constructors
	public Project()
	{
	}
	
	/** copy constructor */
	public Project(Project copyMe) throws Exception
	{	
		for(String f : this.getFields())
		{
			this.set(f, copyMe.get(f));
		}	
	}
	
	//getters and setters
	/**
	 * Get the automatically generated internal id, only for internal use..
	 * @return id.
	 */
	public Integer getId()
	{
		return this.id;
	}
	
	
	/**
	 * Set the automatically generated internal id, only for internal use..
	 * @param id
	 */
	public void setId( Integer id)
	{
		this.id = id;
	}

	

	/**
	 * Get the The name of a project.
	 * @return projectName.
	 */
	public String getProjectName()
	{
		return this.projectName;
	}
	
	@Deprecated
	public String getProjectName(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The name of a project.
	 * @param projectName
	 */
	public void setProjectName( String projectName)
	{
		
		this.projectName = projectName;
	}

	

	/**
	 * Get the The comment of a project..
	 * @return projectComment.
	 */
	public String getProjectComment()
	{
		return this.projectComment;
	}
	
	@Deprecated
	public String getProjectComment(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The comment of a project..
	 * @param projectComment
	 */
	public void setProjectComment( String projectComment)
	{
		
		this.projectComment = projectComment;
	}

	

	/**
	 * Get the The user who ordered the project..
	 * @return projectCustomer.
	 */
	public org.molgenis.omx.ngs.NgsUser getProjectCustomer()
	{
		return this.projectCustomer;
	}
	
	@Deprecated
	public org.molgenis.omx.ngs.NgsUser getProjectCustomer(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The user who ordered the project..
	 * @param projectCustomer
	 */
	public void setProjectCustomer( org.molgenis.omx.ngs.NgsUser projectCustomer)
	{
		
		this.projectCustomer = projectCustomer;
	}

	
	
	/**
	 * Set foreign key for field projectCustomer.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setProjectCustomer_Id(Integer projectCustomer_id)
	{
		this.projectCustomer_id = projectCustomer_id;
	}	

	public void setProjectCustomer(Integer projectCustomer_id)
	{
		this.projectCustomer_id = projectCustomer_id;
	}
	
	public Integer getProjectCustomer_Id()
	{
		
		if(projectCustomer != null) 
		{
			return projectCustomer.getId();
		}
		else
		{
			return projectCustomer_id;
		}
	}	
	 
	/**
	 * Get a pretty label UserName for cross reference ProjectCustomer to NgsUser.Id.
	 */
	public String getProjectCustomer_UserName()
	{		
		//FIXME should we auto-load based on getProjectCustomer()?	
		if(projectCustomer != null) {
			return projectCustomer.getUserName();
		} else {
			return projectCustomer_UserName;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference ProjectCustomer to <a href="NgsUser.html#Id">NgsUser.Id</a>.
	 * Implies setProjectCustomer(null) until save
	 */
	public void setProjectCustomer_UserName(String projectCustomer_UserName)
	{
		this.projectCustomer_UserName = projectCustomer_UserName;
	}		
	 
	

	/**
	 * Get the The user which will be responsible for performing the wet-lab activities..
	 * @return projectAnalist.
	 */
	public java.util.List<org.molgenis.omx.ngs.NgsUser> getProjectAnalist()
	{
		return this.projectAnalist;
	}
	
	@Deprecated
	public java.util.List<org.molgenis.omx.ngs.NgsUser> getProjectAnalist(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The user which will be responsible for performing the wet-lab activities..
	 * @param projectAnalist
	 */
	public void setProjectAnalist( java.util.List<org.molgenis.omx.ngs.NgsUser> projectAnalist)
	{
		
		this.projectAnalist = projectAnalist;
	}

	
	public void setProjectAnalist_Id(Integer ... projectAnalist)
	{
		this.setProjectAnalist_Id(java.util.Arrays.asList(projectAnalist));
	}	
	
	public void setProjectAnalist(org.molgenis.omx.ngs.NgsUser ... projectAnalist)
	{
		this.setProjectAnalist(java.util.Arrays.asList(projectAnalist));
	}	
	
	/**
	 * Set foreign key for field projectAnalist.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setProjectAnalist_Id(java.util.List<Integer> projectAnalist_id)
	{
		this.projectAnalist_id = projectAnalist_id;
	}	
	
	public java.util.List<Integer> getProjectAnalist_Id()
	{
		if(projectAnalist != null && !projectAnalist.isEmpty()) {
			java.util.List<Integer> result = new java.util.ArrayList<Integer>();
			for (int i = 0; i < projectAnalist.size(); i++)
				result.add(projectAnalist.get(i).getId());
			return result;
		} else {
			if(projectAnalist_id == null) {
				projectAnalist_id = new java.util.ArrayList<Integer>();
			}		
			return projectAnalist_id;
		}
	}	
	
	/**
	 * Get a pretty label for cross reference ProjectAnalist to <a href="NgsUser.html#Id">NgsUser.Id</a>.
	 */
	public java.util.List<String> getProjectAnalist_UserName()
	{
		if(this.projectAnalist != null && !this.projectAnalist.isEmpty())
		{
			java.util.List<String> result = new java.util.ArrayList<String>(this.projectAnalist.size());
			for(org.molgenis.omx.ngs.NgsUser o: projectAnalist) result.add(o.getUserName());
			return java.util.Collections.unmodifiableList(result);
		}	
		else
		{	
			return projectAnalist_UserName;
		}
	}
	
	/**
	 * Update the foreign key ProjectAnalist
	 * This sets projectAnalist to null until next database transaction.
	 */
	public void setProjectAnalist_UserName(java.util.List<String> projectAnalist_UserName)
	{
		this.projectAnalist_UserName = projectAnalist_UserName;
	}		
	

	/**
	 * Get the The date a project is expected to be finished.
	 * @return projectPlannedFinishDate.
	 */
	public java.util.Date getProjectPlannedFinishDate()
	{
		return this.projectPlannedFinishDate;
	}
	
	@Deprecated
	public java.util.Date getProjectPlannedFinishDate(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The date a project is expected to be finished.
	 * @param projectPlannedFinishDate
	 */
	public void setProjectPlannedFinishDate( java.util.Date projectPlannedFinishDate)
	{
		
		this.projectPlannedFinishDate = projectPlannedFinishDate;
	}

	

	/**
	 * Get the Number of lanes planned in this project.
	 * @return laneAmount.
	 */
	public Integer getLaneAmount()
	{
		return this.laneAmount;
	}
	
	@Deprecated
	public Integer getLaneAmount(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Number of lanes planned in this project.
	 * @param laneAmount
	 */
	public void setLaneAmount( Integer laneAmount)
	{
		
		this.laneAmount = laneAmount;
	}

	

	/**
	 * Get the Number of samples planned in this project.
	 * @return sampleAmount.
	 */
	public Integer getSampleAmount()
	{
		return this.sampleAmount;
	}
	
	@Deprecated
	public Integer getSampleAmount(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Number of samples planned in this project.
	 * @param sampleAmount
	 */
	public void setSampleAmount( Integer sampleAmount)
	{
		
		this.sampleAmount = sampleAmount;
	}

	

	/**
	 * Get the Type of sample.
	 * @return sampleType.
	 */
	public String getSampleType()
	{
		return this.sampleType;
	}
	
	@Deprecated
	public String getSampleType(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Type of sample.
	 * @param sampleType
	 */
	public void setSampleType( String sampleType)
	{
		
		this.sampleType = sampleType;
	}

	
	/**
	 * Get tha label for enum SampleType.
	 */
	public String getSampleTypeLabel()
	{
		return this.sampleType_label;
	}
	/**
	 * SampleType is enum. This method returns all available enum options.
	 */
	public java.util.List<org.molgenis.util.ValueLabel> getSampleTypeOptions()
	{
		return sampleType_options;
	}	
	

	/**
	 * Get the The type of sequencing..
	 * @return seqType.
	 */
	public String getSeqType()
	{
		return this.seqType;
	}
	
	@Deprecated
	public String getSeqType(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The type of sequencing..
	 * @param seqType
	 */
	public void setSeqType( String seqType)
	{
		
		this.seqType = seqType;
	}

	
	/**
	 * Get tha label for enum SeqType.
	 */
	public String getSeqTypeLabel()
	{
		return this.seqType_label;
	}
	/**
	 * SeqType is enum. This method returns all available enum options.
	 */
	public java.util.List<org.molgenis.util.ValueLabel> getSeqTypeOptions()
	{
		return seqType_options;
	}	
	

	/**
	 * Get the Preparation kit used on the sample for this experiment.
	 * @return prepKit.
	 */
	public org.molgenis.omx.ngs.PrepKit getPrepKit()
	{
		return this.prepKit;
	}
	
	@Deprecated
	public org.molgenis.omx.ngs.PrepKit getPrepKit(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Preparation kit used on the sample for this experiment.
	 * @param prepKit
	 */
	public void setPrepKit( org.molgenis.omx.ngs.PrepKit prepKit)
	{
		
		this.prepKit = prepKit;
	}

	
	
	/**
	 * Set foreign key for field prepKit.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setPrepKit_Id(Integer prepKit_id)
	{
		this.prepKit_id = prepKit_id;
	}	

	public void setPrepKit(Integer prepKit_id)
	{
		this.prepKit_id = prepKit_id;
	}
	
	public Integer getPrepKit_Id()
	{
		
		if(prepKit != null) 
		{
			return prepKit.getId();
		}
		else
		{
			return prepKit_id;
		}
	}	
	 
	/**
	 * Get a pretty label PrepKitName for cross reference PrepKit to PrepKit.Id.
	 */
	public String getPrepKit_PrepKitName()
	{		
		//FIXME should we auto-load based on getPrepKit()?	
		if(prepKit != null) {
			return prepKit.getPrepKitName();
		} else {
			return prepKit_PrepKitName;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference PrepKit to <a href="PrepKit.html#Id">PrepKit.Id</a>.
	 * Implies setPrepKit(null) until save
	 */
	public void setPrepKit_PrepKitName(String prepKit_PrepKitName)
	{
		this.prepKit_PrepKitName = prepKit_PrepKitName;
	}		
	 
	

	/**
	 * Get the The Declaration Nr of a project..
	 * @return declarationNr.
	 */
	public String getDeclarationNr()
	{
		return this.declarationNr;
	}
	
	@Deprecated
	public String getDeclarationNr(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The Declaration Nr of a project..
	 * @param declarationNr
	 */
	public void setDeclarationNr( String declarationNr)
	{
		
		this.declarationNr = declarationNr;
	}

	

	/**
	 * Get the Indication if variant calling has to be performed on the experiment..
	 * @return gccAnalysis.
	 */
	public Boolean getGccAnalysis()
	{
		return this.gccAnalysis;
	}
	
	@Deprecated
	public Boolean getGccAnalysis(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Indication if variant calling has to be performed on the experiment..
	 * @param gccAnalysis
	 */
	public void setGccAnalysis( Boolean gccAnalysis)
	{
		
		this.gccAnalysis = gccAnalysis;
	}

	

	/**
	 * Get the Specific instructions for GCC members for the analysis..
	 * @return gccInstructions.
	 */
	public String getGccInstructions()
	{
		return this.gccInstructions;
	}
	
	@Deprecated
	public String getGccInstructions(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Specific instructions for GCC members for the analysis..
	 * @param gccInstructions
	 */
	public void setGccInstructions( String gccInstructions)
	{
		
		this.gccInstructions = gccInstructions;
	}

	

	/**
	 * Get the File location of the resulting files after analysis occurred (for file download purpose).
	 * @return resultFilesDir.
	 */
	public String getResultFilesDir()
	{
		return this.resultFilesDir;
	}
	
	@Deprecated
	public String getResultFilesDir(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the File location of the resulting files after analysis occurred (for file download purpose).
	 * @param resultFilesDir
	 */
	public void setResultFilesDir( String resultFilesDir)
	{
		
		this.resultFilesDir = resultFilesDir;
	}

	

	/**
	 * Get the The user who shipped the date..
	 * @return resultShippedUser.
	 */
	public org.molgenis.omx.ngs.NgsUser getResultShippedUser()
	{
		return this.resultShippedUser;
	}
	
	@Deprecated
	public org.molgenis.omx.ngs.NgsUser getResultShippedUser(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The user who shipped the date..
	 * @param resultShippedUser
	 */
	public void setResultShippedUser( org.molgenis.omx.ngs.NgsUser resultShippedUser)
	{
		
		this.resultShippedUser = resultShippedUser;
	}

	
	
	/**
	 * Set foreign key for field resultShippedUser.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setResultShippedUser_Id(Integer resultShippedUser_id)
	{
		this.resultShippedUser_id = resultShippedUser_id;
	}	

	public void setResultShippedUser(Integer resultShippedUser_id)
	{
		this.resultShippedUser_id = resultShippedUser_id;
	}
	
	public Integer getResultShippedUser_Id()
	{
		
		if(resultShippedUser != null) 
		{
			return resultShippedUser.getId();
		}
		else
		{
			return resultShippedUser_id;
		}
	}	
	 
	/**
	 * Get a pretty label UserName for cross reference ResultShippedUser to NgsUser.Id.
	 */
	public String getResultShippedUser_UserName()
	{		
		//FIXME should we auto-load based on getResultShippedUser()?	
		if(resultShippedUser != null) {
			return resultShippedUser.getUserName();
		} else {
			return resultShippedUser_UserName;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference ResultShippedUser to <a href="NgsUser.html#Id">NgsUser.Id</a>.
	 * Implies setResultShippedUser(null) until save
	 */
	public void setResultShippedUser_UserName(String resultShippedUser_UserName)
	{
		this.resultShippedUser_UserName = resultShippedUser_UserName;
	}		
	 
	

	/**
	 * Get the Name of the person to which the data has been shipped..
	 * @return resultShippedTo.
	 */
	public org.molgenis.omx.ngs.NgsUser getResultShippedTo()
	{
		return this.resultShippedTo;
	}
	
	@Deprecated
	public org.molgenis.omx.ngs.NgsUser getResultShippedTo(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Name of the person to which the data has been shipped..
	 * @param resultShippedTo
	 */
	public void setResultShippedTo( org.molgenis.omx.ngs.NgsUser resultShippedTo)
	{
		
		this.resultShippedTo = resultShippedTo;
	}

	
	
	/**
	 * Set foreign key for field resultShippedTo.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setResultShippedTo_Id(Integer resultShippedTo_id)
	{
		this.resultShippedTo_id = resultShippedTo_id;
	}	

	public void setResultShippedTo(Integer resultShippedTo_id)
	{
		this.resultShippedTo_id = resultShippedTo_id;
	}
	
	public Integer getResultShippedTo_Id()
	{
		
		if(resultShippedTo != null) 
		{
			return resultShippedTo.getId();
		}
		else
		{
			return resultShippedTo_id;
		}
	}	
	 
	/**
	 * Get a pretty label UserName for cross reference ResultShippedTo to NgsUser.Id.
	 */
	public String getResultShippedTo_UserName()
	{		
		//FIXME should we auto-load based on getResultShippedTo()?	
		if(resultShippedTo != null) {
			return resultShippedTo.getUserName();
		} else {
			return resultShippedTo_UserName;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference ResultShippedTo to <a href="NgsUser.html#Id">NgsUser.Id</a>.
	 * Implies setResultShippedTo(null) until save
	 */
	public void setResultShippedTo_UserName(String resultShippedTo_UserName)
	{
		this.resultShippedTo_UserName = resultShippedTo_UserName;
	}		
	 
	

	/**
	 * Get the The date the result of the experiment is shipped to the custumor..
	 * @return resultShippedDate.
	 */
	public java.util.Date getResultShippedDate()
	{
		return this.resultShippedDate;
	}
	
	@Deprecated
	public java.util.Date getResultShippedDate(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The date the result of the experiment is shipped to the custumor..
	 * @param resultShippedDate
	 */
	public void setResultShippedDate( java.util.Date resultShippedDate)
	{
		
		this.resultShippedDate = resultShippedDate;
	}

	
	/**
	 * Set the The date the result of the experiment is shipped to the custumor.. Automatically converts string into date;
	 * @param resultShippedDate
	 */	
	public void setResultShippedDate(String datestring) throws java.text.ParseException
	{
		this.setResultShippedDate(string2date(datestring));
	}	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("projectname"))
			return getProjectName();
		if (name.equals("projectcomment"))
			return getProjectComment();
		if (name.equals("projectcustomer"))
			return getProjectCustomer();
		if(name.equals("projectcustomer_id"))
			return getProjectCustomer_Id();
		if(name.equals("projectcustomer_username"))
			return getProjectCustomer_UserName();
		if (name.equals("projectanalist"))
			return getProjectAnalist();
		if(name.equals("projectanalist_id"))
			return getProjectAnalist_Id();
		if(name.equals("projectanalist_username"))
			return getProjectAnalist_UserName();
		if (name.equals("projectplannedfinishdate"))
			return getProjectPlannedFinishDate();
		if (name.equals("laneamount"))
			return getLaneAmount();
		if (name.equals("sampleamount"))
			return getSampleAmount();
		if (name.equals("sampletype"))
			return getSampleType();
		if(name.equals("sampletype_label"))
			return getSampleTypeLabel();
		if (name.equals("seqtype"))
			return getSeqType();
		if(name.equals("seqtype_label"))
			return getSeqTypeLabel();
		if (name.equals("prepkit"))
			return getPrepKit();
		if(name.equals("prepkit_id"))
			return getPrepKit_Id();
		if(name.equals("prepkit_prepkitname"))
			return getPrepKit_PrepKitName();
		if (name.equals("declarationnr"))
			return getDeclarationNr();
		if (name.equals("gccanalysis"))
			return getGccAnalysis();
		if (name.equals("gccinstructions"))
			return getGccInstructions();
		if (name.equals("resultfilesdir"))
			return getResultFilesDir();
		if (name.equals("resultshippeduser"))
			return getResultShippedUser();
		if(name.equals("resultshippeduser_id"))
			return getResultShippedUser_Id();
		if(name.equals("resultshippeduser_username"))
			return getResultShippedUser_UserName();
		if (name.equals("resultshippedto"))
			return getResultShippedTo();
		if(name.equals("resultshippedto_id"))
			return getResultShippedTo_Id();
		if(name.equals("resultshippedto_username"))
			return getResultShippedTo_UserName();
		if (name.equals("resultshippeddate"))
			return getResultShippedDate();
		return null;
	}	
	
	@Override
	public void validate() throws org.molgenis.framework.db.DatabaseException
	{
		if(this.getId() == null) throw new org.molgenis.framework.db.DatabaseException("required field id is null");
		if(this.getProjectName() == null) throw new org.molgenis.framework.db.DatabaseException("required field projectName is null");
		if(this.getSampleType() == null) throw new org.molgenis.framework.db.DatabaseException("required field sampleType is null");
	}
	
	@Override
	public void set(org.molgenis.util.tuple.Tuple tuple, boolean strict ) throws Exception
	{
		//set Id
		// query formal name, else lowercase name
		if(tuple.getInt("id") != null) this.setId(tuple.getInt("id"));
		else if(tuple.getInt("id") != null) this.setId(tuple.getInt("id"));
		else if(strict) this.setId(tuple.getInt("id")); // setting null is not an option due to function overloading
		if( tuple.getInt("project_id") != null) this.setId(tuple.getInt("project_id"));
		else if( tuple.getInt("Project_id") != null) this.setId(tuple.getInt("Project_id"));
		//set ProjectName
		// query formal name, else lowercase name
		if(tuple.getString("projectname") != null) this.setProjectName(tuple.getString("projectname"));
		else if(tuple.getString("ProjectName") != null) this.setProjectName(tuple.getString("ProjectName"));
		else if(strict) this.setProjectName(tuple.getString("projectname")); // setting null is not an option due to function overloading
		if( tuple.getString("project_projectname") != null) this.setProjectName(tuple.getString("project_projectname"));
		else if( tuple.getString("Project_ProjectName") != null) this.setProjectName(tuple.getString("Project_ProjectName"));
		//set ProjectComment
		// query formal name, else lowercase name
		if(tuple.getString("projectcomment") != null) this.setProjectComment(tuple.getString("projectcomment"));
		else if(tuple.getString("ProjectComment") != null) this.setProjectComment(tuple.getString("ProjectComment"));
		else if(strict) this.setProjectComment(tuple.getString("projectcomment")); // setting null is not an option due to function overloading
		if( tuple.getString("project_projectcomment") != null) this.setProjectComment(tuple.getString("project_projectcomment"));
		else if( tuple.getString("Project_ProjectComment") != null) this.setProjectComment(tuple.getString("Project_ProjectComment"));
		//set ProjectCustomer
		// query formal name, else lowercase name
		if(tuple.getInt("ProjectCustomer_id") != null) this.setProjectCustomer(tuple.getInt("ProjectCustomer_id"));
		else if(tuple.getInt("projectcustomer_id") != null) this.setProjectCustomer(tuple.getInt("projectcustomer_id"));
		else if(strict) this.setProjectCustomer(tuple.getInt("ProjectCustomer_id")); // setting null is not an option due to function overloading
		
		if( tuple.getInt("Project_ProjectCustomer_id") != null) this.setProjectCustomer(tuple.getInt("Project_ProjectCustomer_id"));
		else if( tuple.getInt("project_projectcustomer_id") != null) this.setProjectCustomer(tuple.getInt("project_projectcustomer_id"));
		//alias of xref
		if( tuple.get("ProjectCustomer") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("ProjectCustomer").toString())) {
				org.molgenis.omx.ngs.NgsUser instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("ProjectCustomer"), org.molgenis.omx.ngs.NgsUser.class);
				this.setProjectCustomer(instance);				
			} else {
				this.setProjectCustomer_Id(tuple.getInt("ProjectCustomer")); 
			}
		}
		else if( tuple.get("projectcustomer") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("projectcustomer").toString())) {
				org.molgenis.omx.ngs.NgsUser instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("projectcustomer"), org.molgenis.omx.ngs.NgsUser.class);
				this.setProjectCustomer(instance);				
			} else {
				this.setProjectCustomer_Id(tuple.getInt("ProjectCustomer"));
			}
		}
		if( tuple.get("Project_ProjectCustomer") != null)
			this.setProjectCustomer_Id(tuple.getInt("Project_ProjectCustomer"));			
		else if( tuple.get("project_projectcustomer") != null)
			this.setProjectCustomer_Id(tuple.getInt("project_projectcustomer"));
			
		if( tuple.get("Project.ProjectCustomer") != null) 
			this.setProjectCustomer((org.molgenis.omx.ngs.NgsUser)tuple.get("Project.ProjectCustomer_id"));
		else if( tuple.get("project.projectcustomer") != null) 
			this.setProjectCustomer((org.molgenis.omx.ngs.NgsUser)tuple.get("project.projectcustomer_id"));	
		//set label for field ProjectCustomer
		if(tuple.get("ProjectCustomer_UserName") != null) this.setProjectCustomer_UserName(tuple.getString("ProjectCustomer_UserName"));
		else if(tuple.get("projectcustomer_username") != null) this.setProjectCustomer_UserName(tuple.getString("projectcustomer_username"));
		else if(strict) this.setProjectCustomer_UserName(tuple.getString("ProjectCustomer_UserName")); // setting null is not an option due to function overloading
		if( tuple.get("Project_ProjectCustomer_UserName") != null ) this.setProjectCustomer_UserName(tuple.getString("Project_ProjectCustomer_UserName"));		
		else if( tuple.get("project_projectcustomer_username") != null ) this.setProjectCustomer_UserName(tuple.getString("project_projectcustomer_username"));
		//set ProjectAnalist
		if( tuple.get("ProjectAnalist") != null || tuple.get("Project_ProjectAnalist") != null || tuple.get("projectanalist") != null || tuple.get("project_projectanalist") != null) 
		{
			java.util.List<Integer> values = new java.util.ArrayList<Integer>();
			java.util.List<?> mrefs = tuple.getList("ProjectAnalist");
			if(mrefs == null) mrefs = tuple.getList("projectanalist");
			if(tuple.get("project_projectanalist")!= null) mrefs = tuple.getList("project_projectanalist");
			else if(tuple.get("Project_ProjectAnalist")!= null) mrefs = tuple.getList("Project_ProjectAnalist");
			if(mrefs != null) for(Object ref: mrefs)
			{
				if(ref instanceof String)
					values.add(Integer.parseInt((String)ref));
				else if(ref instanceof org.molgenis.util.AbstractEntity) 	
					values.add((Integer)((org.molgenis.util.AbstractEntity)ref).getIdValue() );
				else
					values.add((Integer)ref);		
			}											
			this.setProjectAnalist_Id( values );
		}
		//set labels UserName for mref field ProjectAnalist	
		if( tuple.get("ProjectAnalist_UserName") != null || tuple.get("Project_ProjectAnalist_UserName")!= null || tuple.get("projectanalist_username") != null || tuple.get("project_projectanalist_username") != null) 
		{
			java.util.List<String> values = new java.util.ArrayList<String>();
			java.util.List<?> mrefs = tuple.getList("ProjectAnalist_UserName");
			if(mrefs == null) mrefs = tuple.getList("projectanalist_username");
			if(tuple.get("Project_ProjectAnalist_UserName")!= null) mrefs = tuple.getList("Project_ProjectAnalist_UserName");
			else if(tuple.get("project_projectanalist_username")!= null) mrefs = tuple.getList("project_projectanalist_username");
			if(mrefs != null) 
				for(Object ref: mrefs)
				{
					String[] refs = ref.toString().split("\\|");
					for(String r : refs) {
						values.add(r);	
					}						
				}							
			this.setProjectAnalist_UserName( values );			
		}	
		//set ProjectPlannedFinishDate
		// query formal name, else lowercase name
		if(tuple.getTimestamp("projectplannedfinishdate") != null) this.setProjectPlannedFinishDate(tuple.getTimestamp("projectplannedfinishdate"));
		else if(tuple.getTimestamp("ProjectPlannedFinishDate") != null) this.setProjectPlannedFinishDate(tuple.getTimestamp("ProjectPlannedFinishDate"));
		else if(strict) this.setProjectPlannedFinishDate(tuple.getTimestamp("projectplannedfinishdate")); // setting null is not an option due to function overloading
		if( tuple.getTimestamp("project_projectplannedfinishdate") != null) this.setProjectPlannedFinishDate(tuple.getTimestamp("project_projectplannedfinishdate"));
		else if( tuple.getTimestamp("Project_ProjectPlannedFinishDate") != null) this.setProjectPlannedFinishDate(tuple.getTimestamp("Project_ProjectPlannedFinishDate"));
		//set LaneAmount
		// query formal name, else lowercase name
		if(tuple.getInt("laneamount") != null) this.setLaneAmount(tuple.getInt("laneamount"));
		else if(tuple.getInt("LaneAmount") != null) this.setLaneAmount(tuple.getInt("LaneAmount"));
		else if(strict) this.setLaneAmount(tuple.getInt("laneamount")); // setting null is not an option due to function overloading
		if( tuple.getInt("project_laneamount") != null) this.setLaneAmount(tuple.getInt("project_laneamount"));
		else if( tuple.getInt("Project_LaneAmount") != null) this.setLaneAmount(tuple.getInt("Project_LaneAmount"));
		//set SampleAmount
		// query formal name, else lowercase name
		if(tuple.getInt("sampleamount") != null) this.setSampleAmount(tuple.getInt("sampleamount"));
		else if(tuple.getInt("SampleAmount") != null) this.setSampleAmount(tuple.getInt("SampleAmount"));
		else if(strict) this.setSampleAmount(tuple.getInt("sampleamount")); // setting null is not an option due to function overloading
		if( tuple.getInt("project_sampleamount") != null) this.setSampleAmount(tuple.getInt("project_sampleamount"));
		else if( tuple.getInt("Project_SampleAmount") != null) this.setSampleAmount(tuple.getInt("Project_SampleAmount"));
		//set SampleType
		// query formal name, else lowercase name
		if(tuple.getString("sampletype") != null) this.setSampleType(tuple.getString("sampletype"));
		else if(tuple.getString("SampleType") != null) this.setSampleType(tuple.getString("SampleType"));
		else if(strict) this.setSampleType(tuple.getString("sampletype")); // setting null is not an option due to function overloading
		if( tuple.getString("project_sampletype") != null) this.setSampleType(tuple.getString("project_sampletype"));
		else if( tuple.getString("Project_SampleType") != null) this.setSampleType(tuple.getString("Project_SampleType"));
		//set SeqType
		// query formal name, else lowercase name
		if(tuple.getString("seqtype") != null) this.setSeqType(tuple.getString("seqtype"));
		else if(tuple.getString("SeqType") != null) this.setSeqType(tuple.getString("SeqType"));
		else if(strict) this.setSeqType(tuple.getString("seqtype")); // setting null is not an option due to function overloading
		if( tuple.getString("project_seqtype") != null) this.setSeqType(tuple.getString("project_seqtype"));
		else if( tuple.getString("Project_SeqType") != null) this.setSeqType(tuple.getString("Project_SeqType"));
		//set PrepKit
		// query formal name, else lowercase name
		if(tuple.getInt("PrepKit_id") != null) this.setPrepKit(tuple.getInt("PrepKit_id"));
		else if(tuple.getInt("prepkit_id") != null) this.setPrepKit(tuple.getInt("prepkit_id"));
		else if(strict) this.setPrepKit(tuple.getInt("PrepKit_id")); // setting null is not an option due to function overloading
		
		if( tuple.getInt("Project_PrepKit_id") != null) this.setPrepKit(tuple.getInt("Project_PrepKit_id"));
		else if( tuple.getInt("project_prepkit_id") != null) this.setPrepKit(tuple.getInt("project_prepkit_id"));
		//alias of xref
		if( tuple.get("PrepKit") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("PrepKit").toString())) {
				org.molgenis.omx.ngs.PrepKit instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("PrepKit"), org.molgenis.omx.ngs.PrepKit.class);
				this.setPrepKit(instance);				
			} else {
				this.setPrepKit_Id(tuple.getInt("PrepKit")); 
			}
		}
		else if( tuple.get("prepkit") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("prepkit").toString())) {
				org.molgenis.omx.ngs.PrepKit instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("prepkit"), org.molgenis.omx.ngs.PrepKit.class);
				this.setPrepKit(instance);				
			} else {
				this.setPrepKit_Id(tuple.getInt("PrepKit"));
			}
		}
		if( tuple.get("Project_PrepKit") != null)
			this.setPrepKit_Id(tuple.getInt("Project_PrepKit"));			
		else if( tuple.get("project_prepkit") != null)
			this.setPrepKit_Id(tuple.getInt("project_prepkit"));
			
		if( tuple.get("Project.PrepKit") != null) 
			this.setPrepKit((org.molgenis.omx.ngs.PrepKit)tuple.get("Project.PrepKit_id"));
		else if( tuple.get("project.prepkit") != null) 
			this.setPrepKit((org.molgenis.omx.ngs.PrepKit)tuple.get("project.prepkit_id"));	
		//set label for field PrepKit
		if(tuple.get("PrepKit_PrepKitName") != null) this.setPrepKit_PrepKitName(tuple.getString("PrepKit_PrepKitName"));
		else if(tuple.get("prepkit_prepkitname") != null) this.setPrepKit_PrepKitName(tuple.getString("prepkit_prepkitname"));
		else if(strict) this.setPrepKit_PrepKitName(tuple.getString("PrepKit_PrepKitName")); // setting null is not an option due to function overloading
		if( tuple.get("Project_PrepKit_PrepKitName") != null ) this.setPrepKit_PrepKitName(tuple.getString("Project_PrepKit_PrepKitName"));		
		else if( tuple.get("project_prepkit_prepkitname") != null ) this.setPrepKit_PrepKitName(tuple.getString("project_prepkit_prepkitname"));
		//set DeclarationNr
		// query formal name, else lowercase name
		if(tuple.getString("declarationnr") != null) this.setDeclarationNr(tuple.getString("declarationnr"));
		else if(tuple.getString("DeclarationNr") != null) this.setDeclarationNr(tuple.getString("DeclarationNr"));
		else if(strict) this.setDeclarationNr(tuple.getString("declarationnr")); // setting null is not an option due to function overloading
		if( tuple.getString("project_declarationnr") != null) this.setDeclarationNr(tuple.getString("project_declarationnr"));
		else if( tuple.getString("Project_DeclarationNr") != null) this.setDeclarationNr(tuple.getString("Project_DeclarationNr"));
		//set GccAnalysis
		// query formal name, else lowercase name
		if(tuple.getBoolean("gccanalysis") != null) this.setGccAnalysis(tuple.getBoolean("gccanalysis"));
		else if(tuple.getBoolean("GccAnalysis") != null) this.setGccAnalysis(tuple.getBoolean("GccAnalysis"));
		else if(strict) this.setGccAnalysis(tuple.getBoolean("gccanalysis")); // setting null is not an option due to function overloading
		if( tuple.getBoolean("project_gccanalysis") != null) this.setGccAnalysis(tuple.getBoolean("project_gccanalysis"));
		else if( tuple.getBoolean("Project_GccAnalysis") != null) this.setGccAnalysis(tuple.getBoolean("Project_GccAnalysis"));
		//set GccInstructions
		// query formal name, else lowercase name
		if(tuple.getString("gccinstructions") != null) this.setGccInstructions(tuple.getString("gccinstructions"));
		else if(tuple.getString("GccInstructions") != null) this.setGccInstructions(tuple.getString("GccInstructions"));
		else if(strict) this.setGccInstructions(tuple.getString("gccinstructions")); // setting null is not an option due to function overloading
		if( tuple.getString("project_gccinstructions") != null) this.setGccInstructions(tuple.getString("project_gccinstructions"));
		else if( tuple.getString("Project_GccInstructions") != null) this.setGccInstructions(tuple.getString("Project_GccInstructions"));
		//set ResultFilesDir
		// query formal name, else lowercase name
		if(tuple.getString("resultfilesdir") != null) this.setResultFilesDir(tuple.getString("resultfilesdir"));
		else if(tuple.getString("ResultFilesDir") != null) this.setResultFilesDir(tuple.getString("ResultFilesDir"));
		else if(strict) this.setResultFilesDir(tuple.getString("resultfilesdir")); // setting null is not an option due to function overloading
		if( tuple.getString("project_resultfilesdir") != null) this.setResultFilesDir(tuple.getString("project_resultfilesdir"));
		else if( tuple.getString("Project_ResultFilesDir") != null) this.setResultFilesDir(tuple.getString("Project_ResultFilesDir"));
		//set ResultShippedUser
		// query formal name, else lowercase name
		if(tuple.getInt("ResultShippedUser_id") != null) this.setResultShippedUser(tuple.getInt("ResultShippedUser_id"));
		else if(tuple.getInt("resultshippeduser_id") != null) this.setResultShippedUser(tuple.getInt("resultshippeduser_id"));
		else if(strict) this.setResultShippedUser(tuple.getInt("ResultShippedUser_id")); // setting null is not an option due to function overloading
		
		if( tuple.getInt("Project_ResultShippedUser_id") != null) this.setResultShippedUser(tuple.getInt("Project_ResultShippedUser_id"));
		else if( tuple.getInt("project_resultshippeduser_id") != null) this.setResultShippedUser(tuple.getInt("project_resultshippeduser_id"));
		//alias of xref
		if( tuple.get("ResultShippedUser") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("ResultShippedUser").toString())) {
				org.molgenis.omx.ngs.NgsUser instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("ResultShippedUser"), org.molgenis.omx.ngs.NgsUser.class);
				this.setResultShippedUser(instance);				
			} else {
				this.setResultShippedUser_Id(tuple.getInt("ResultShippedUser")); 
			}
		}
		else if( tuple.get("resultshippeduser") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("resultshippeduser").toString())) {
				org.molgenis.omx.ngs.NgsUser instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("resultshippeduser"), org.molgenis.omx.ngs.NgsUser.class);
				this.setResultShippedUser(instance);				
			} else {
				this.setResultShippedUser_Id(tuple.getInt("ResultShippedUser"));
			}
		}
		if( tuple.get("Project_ResultShippedUser") != null)
			this.setResultShippedUser_Id(tuple.getInt("Project_ResultShippedUser"));			
		else if( tuple.get("project_resultshippeduser") != null)
			this.setResultShippedUser_Id(tuple.getInt("project_resultshippeduser"));
			
		if( tuple.get("Project.ResultShippedUser") != null) 
			this.setResultShippedUser((org.molgenis.omx.ngs.NgsUser)tuple.get("Project.ResultShippedUser_id"));
		else if( tuple.get("project.resultshippeduser") != null) 
			this.setResultShippedUser((org.molgenis.omx.ngs.NgsUser)tuple.get("project.resultshippeduser_id"));	
		//set label for field ResultShippedUser
		if(tuple.get("ResultShippedUser_UserName") != null) this.setResultShippedUser_UserName(tuple.getString("ResultShippedUser_UserName"));
		else if(tuple.get("resultshippeduser_username") != null) this.setResultShippedUser_UserName(tuple.getString("resultshippeduser_username"));
		else if(strict) this.setResultShippedUser_UserName(tuple.getString("ResultShippedUser_UserName")); // setting null is not an option due to function overloading
		if( tuple.get("Project_ResultShippedUser_UserName") != null ) this.setResultShippedUser_UserName(tuple.getString("Project_ResultShippedUser_UserName"));		
		else if( tuple.get("project_resultshippeduser_username") != null ) this.setResultShippedUser_UserName(tuple.getString("project_resultshippeduser_username"));
		//set ResultShippedTo
		// query formal name, else lowercase name
		if(tuple.getInt("ResultShippedTo_id") != null) this.setResultShippedTo(tuple.getInt("ResultShippedTo_id"));
		else if(tuple.getInt("resultshippedto_id") != null) this.setResultShippedTo(tuple.getInt("resultshippedto_id"));
		else if(strict) this.setResultShippedTo(tuple.getInt("ResultShippedTo_id")); // setting null is not an option due to function overloading
		
		if( tuple.getInt("Project_ResultShippedTo_id") != null) this.setResultShippedTo(tuple.getInt("Project_ResultShippedTo_id"));
		else if( tuple.getInt("project_resultshippedto_id") != null) this.setResultShippedTo(tuple.getInt("project_resultshippedto_id"));
		//alias of xref
		if( tuple.get("ResultShippedTo") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("ResultShippedTo").toString())) {
				org.molgenis.omx.ngs.NgsUser instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("ResultShippedTo"), org.molgenis.omx.ngs.NgsUser.class);
				this.setResultShippedTo(instance);				
			} else {
				this.setResultShippedTo_Id(tuple.getInt("ResultShippedTo")); 
			}
		}
		else if( tuple.get("resultshippedto") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("resultshippedto").toString())) {
				org.molgenis.omx.ngs.NgsUser instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("resultshippedto"), org.molgenis.omx.ngs.NgsUser.class);
				this.setResultShippedTo(instance);				
			} else {
				this.setResultShippedTo_Id(tuple.getInt("ResultShippedTo"));
			}
		}
		if( tuple.get("Project_ResultShippedTo") != null)
			this.setResultShippedTo_Id(tuple.getInt("Project_ResultShippedTo"));			
		else if( tuple.get("project_resultshippedto") != null)
			this.setResultShippedTo_Id(tuple.getInt("project_resultshippedto"));
			
		if( tuple.get("Project.ResultShippedTo") != null) 
			this.setResultShippedTo((org.molgenis.omx.ngs.NgsUser)tuple.get("Project.ResultShippedTo_id"));
		else if( tuple.get("project.resultshippedto") != null) 
			this.setResultShippedTo((org.molgenis.omx.ngs.NgsUser)tuple.get("project.resultshippedto_id"));	
		//set label for field ResultShippedTo
		if(tuple.get("ResultShippedTo_UserName") != null) this.setResultShippedTo_UserName(tuple.getString("ResultShippedTo_UserName"));
		else if(tuple.get("resultshippedto_username") != null) this.setResultShippedTo_UserName(tuple.getString("resultshippedto_username"));
		else if(strict) this.setResultShippedTo_UserName(tuple.getString("ResultShippedTo_UserName")); // setting null is not an option due to function overloading
		if( tuple.get("Project_ResultShippedTo_UserName") != null ) this.setResultShippedTo_UserName(tuple.getString("Project_ResultShippedTo_UserName"));		
		else if( tuple.get("project_resultshippedto_username") != null ) this.setResultShippedTo_UserName(tuple.getString("project_resultshippedto_username"));
		//set ResultShippedDate
		// query formal name, else lowercase name
		if(tuple.getDate("resultshippeddate") != null) this.setResultShippedDate(tuple.getDate("resultshippeddate"));
		else if(tuple.getDate("ResultShippedDate") != null) this.setResultShippedDate(tuple.getDate("ResultShippedDate"));
		else if(strict) this.setResultShippedDate(tuple.getDate("resultshippeddate")); // setting null is not an option due to function overloading
		if( tuple.getDate("project_resultshippeddate") != null) this.setResultShippedDate(tuple.getDate("project_resultshippeddate"));
		else if( tuple.getDate("Project_ResultShippedDate") != null) this.setResultShippedDate(tuple.getDate("Project_ResultShippedDate"));
	}

	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		String result = "Project(";
		result+= "id='" + getId()+"' ";	
		result+= "projectName='" + getProjectName()+"' ";	
		result+= "projectComment='" + getProjectComment()+"' ";	
		result+= " projectCustomer_id='" + getProjectCustomer_Id()+"' ";	
		result+= " projectCustomer_userName='" + getProjectCustomer_UserName()+"' ";
		result+= " projectAnalist_id='" + getProjectAnalist_Id()+"' ";	
		result+= " projectAnalist_userName='" + getProjectAnalist_UserName()+"' ";
		result+= "projectPlannedFinishDate='" + (getProjectPlannedFinishDate() == null ? "" : new java.text.SimpleDateFormat("MMMM d, yyyy, HH:mm:ss", java.util.Locale.US).format(getProjectPlannedFinishDate()))+"' ";
		result+= "projectPlannedFinishDate='" + (getProjectPlannedFinishDate() == null ? "" : new java.text.SimpleDateFormat("MMMM d, yyyy", java.util.Locale.US).format(getProjectPlannedFinishDate()))+"' ";		
		result+= "laneAmount='" + getLaneAmount()+"' ";	
		result+= "sampleAmount='" + getSampleAmount()+"' ";	
		result+= "sampleType='" + getSampleType()+"' ";	
		result+= "seqType='" + getSeqType()+"' ";	
		result+= " prepKit_id='" + getPrepKit_Id()+"' ";	
		result+= " prepKit_prepKitName='" + getPrepKit_PrepKitName()+"' ";
		result+= "declarationNr='" + getDeclarationNr()+"' ";	
		result+= "gccAnalysis='" + getGccAnalysis()+"' ";	
		result+= "gccInstructions='" + getGccInstructions()+"' ";	
		result+= "resultFilesDir='" + getResultFilesDir()+"' ";	
		result+= " resultShippedUser_id='" + getResultShippedUser_Id()+"' ";	
		result+= " resultShippedUser_userName='" + getResultShippedUser_UserName()+"' ";
		result+= " resultShippedTo_id='" + getResultShippedTo_Id()+"' ";	
		result+= " resultShippedTo_userName='" + getResultShippedTo_UserName()+"' ";
		result+= "resultShippedDate='" + getResultShippedDate()+"'";	
		result += ");";
		return result;

	}

	/**
	 * Get the names of all public properties of Project.
	 */
	@Override
	public java.util.Vector<String> getFields(boolean skipAutoIds)
	{
		java.util.Vector<String> fields = new java.util.Vector<String>();
		if(!skipAutoIds)
		{
			fields.add("id");
		}
		{
			fields.add("ProjectName");
		}
		{
			fields.add("ProjectComment");
		}
		{
			fields.add("ProjectCustomer_id");
		}
		fields.add("ProjectCustomer_UserName");
		{
			fields.add("ProjectAnalist_id");
		}
		fields.add("ProjectAnalist_UserName");
		{
			fields.add("ProjectPlannedFinishDate");
		}
		{
			fields.add("LaneAmount");
		}
		{
			fields.add("SampleAmount");
		}
		{
			fields.add("SampleType");
		}
		{
			fields.add("SeqType");
		}
		{
			fields.add("PrepKit_id");
		}
		fields.add("PrepKit_PrepKitName");
		{
			fields.add("DeclarationNr");
		}
		{
			fields.add("GccAnalysis");
		}
		{
			fields.add("GccInstructions");
		}
		{
			fields.add("ResultFilesDir");
		}
		{
			fields.add("ResultShippedUser_id");
		}
		fields.add("ResultShippedUser_UserName");
		{
			fields.add("ResultShippedTo_id");
		}
		fields.add("ResultShippedTo_UserName");
		{
			fields.add("ResultShippedDate");
		}
		return fields;
	}	

	@Override
	public java.util.Vector<String> getFields()
	{
		return getFields(false);
	}

	@Override
	public String getIdField()
	{
		return "id";
	}

	@Override
	public java.util.List<String> getLabelFields()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("ProjectName");
		return result;
	}

	@Deprecated
	@Override
	public String getFields(String sep)
	{
		return (""
		+ "id" +sep
		+ "projectName" +sep
		+ "projectComment" +sep
		+ "projectCustomer" +sep
		+ "projectAnalist" +sep
		+ "projectPlannedFinishDate" +sep
		+ "laneAmount" +sep
		+ "sampleAmount" +sep
		+ "sampleType" +sep
		+ "seqType" +sep
		+ "prepKit" +sep
		+ "declarationNr" +sep
		+ "gccAnalysis" +sep
		+ "gccInstructions" +sep
		+ "resultFilesDir" +sep
		+ "resultShippedUser" +sep
		+ "resultShippedTo" +sep
		+ "resultShippedDate" 
		);
	}

	@Override
	public Object getIdValue()
	{
		return get(getIdField());
	}		
	
	@Override
    public String getXrefIdFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("projectCustomer")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("projectAnalist")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("prepKit")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("resultShippedUser")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("resultShippedTo")) {
            return "id";
        }
        
        return null;
    }	

	@Deprecated
	@Override
	public String getValues(String sep)
	{
		java.io.StringWriter out = new java.io.StringWriter();
		{
			Object valueO = getId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getProjectName();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getProjectComment();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getProjectCustomer();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getProjectAnalist();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getProjectPlannedFinishDate();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getLaneAmount();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSampleAmount();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSampleType();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSeqType();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getPrepKit();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getDeclarationNr();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getGccAnalysis();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getGccInstructions();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getResultFilesDir();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getResultShippedUser();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getResultShippedTo();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getResultShippedDate();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS);
		}
		return out.toString();
	}
	
	@Override
	public Project create(org.molgenis.util.tuple.Tuple tuple) throws Exception
	{
		Project e = new Project();
		e.set(tuple);
		return e;
	}
	

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (getClass() != obj.getClass()) return false;
		Project other = (Project) obj;
		if (projectName == null)
		{
			if (other.projectName != null) return false;
		}
		else if (!projectName.equals(other.projectName)) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		final int prime = 31;
		int result = 1;
		result = prime * result + ((projectName == null) ? 0 : projectName.hashCode());
		return result;
	}
}
