
/* File:        org.molgenis.omx/model/Flowcell.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        September 20, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.ngs.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.ngs.Machine;
import org.molgenis.omx.ngs.Flowcell;


/**
 * Reads Flowcell from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class FlowcellEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(FlowcellEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'machine' (maps machine.MachineName -> machine.id)			
	final Map<String,Integer> machineKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports Flowcell from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Flowcell> flowcellsMissingRefs = new ArrayList<Flowcell>();
	
		//cache for objects to be imported from file (in batch)
		final List<Flowcell> flowcellList = new ArrayList<Flowcell>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			Flowcell object = new Flowcell();
			object.set(tuple, false);				
			flowcellList.add(object);		
			
			//add to db when batch size is reached
			if(flowcellList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				flowcellsMissingRefs.addAll(resolveForeignKeys(db, flowcellList));
				flowcellList.removeAll(flowcellsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'FlowcellName' defined in xref_label
				db.update(flowcellList,dbAction, "FlowcellName");
				
				//clear for next batch						
				flowcellList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!flowcellList.isEmpty())
		{
			total.set(total.get() + flowcellList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			flowcellsMissingRefs.addAll(resolveForeignKeys(db, flowcellList));
			flowcellList.removeAll(flowcellsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'FlowcellName' defined in xref_label
			db.update(flowcellList,dbAction, "FlowcellName");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Flowcell> flowcells = new ArrayList<Flowcell>(flowcellsMissingRefs);

		int iterationCount = 0;

		do
		{
			flowcellsMissingRefs = resolveForeignKeys(db, flowcellsMissingRefs);
			
			LinkedHashSet<Flowcell> differenceSet = new LinkedHashSet<Flowcell>();
			Sets.symmetricDifference(new LinkedHashSet<Flowcell>(flowcells), new LinkedHashSet<Flowcell>(flowcellsMissingRefs)).copyInto(differenceSet);
			List<Flowcell> resolvableflowcells = new ArrayList<Flowcell>(differenceSet);
			
			flowcells.removeAll(resolvableflowcells);
			
			db.update(resolvableflowcells,dbAction, "FlowcellName");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Flowcell blaat : flowcellsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'flowcell' entity failed:"
								+ "This is probably caused by a(n) 'flowcell' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (flowcellsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " flowcell from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param flowcellList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Flowcell> resolveForeignKeys(Database db, List<Flowcell> flowcellList) throws Exception
	{
		//keep a list of Flowcell instances that miss a reference which might be resolvable later
		List<Flowcell> flowcellsMissingRefs = new ArrayList<Flowcell>();
	
		//resolve xref 'machine' from machine.MachineName -> machine.id
		for(Flowcell o: flowcellList) 
		{
			if(o.getMachine_MachineName() != null) 
				machineKeymap.put(o.getMachine_MachineName(), null);
		}
		
		if(machineKeymap.size() > 0) 
		{
			List<Machine> machineList = db.query(Machine.class).in("MachineName",new ArrayList<Object>(machineKeymap.keySet())).find();
			for(Machine xref :  machineList)
			{
				machineKeymap.put(xref.getMachineName(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(Flowcell o:  flowcellList)
		{
			while(true){
				//update xref Machine
				if(o.getMachine_MachineName() != null) 
				{
					String key = o.getMachine_MachineName();
					if(machineKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Flowcell' objects failed: cannot find Machine for machine_MachineName='"+o.getMachine_MachineName()+"'");
					}
					o.setMachine_Id(machineKeymap.get(key));
				}
				break;
			}
		}
		
		machineKeymap.clear();
		
		return flowcellsMissingRefs;
	}
}

