
/* File:        org.molgenis.omx/model/FlowcellLane.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        September 20, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.ngs.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.ngs.Flowcell;
import org.molgenis.omx.ngs.Sample;
import org.molgenis.omx.ngs.NgsUser;
import org.molgenis.omx.ngs.FlowcellLane;


/**
 * Reads FlowcellLane from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class FlowcellLaneEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(FlowcellLaneEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'flowcell' (maps flowcell.FlowcellName -> flowcell.id)			
	final Map<String,Integer> flowcellKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'sample' (maps sample.InternalId -> sample.id)			
	final Map<String,Integer> sampleKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'qcWetUser' (maps ngsUser.UserName -> ngsUser.id)			
	final Map<String,Integer> qcWetUserKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'qcDryUser' (maps ngsUser.UserName -> ngsUser.id)			
	final Map<String,Integer> qcDryUserKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports FlowcellLane from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<FlowcellLane> flowcellLanesMissingRefs = new ArrayList<FlowcellLane>();
	
		//cache for objects to be imported from file (in batch)
		final List<FlowcellLane> flowcellLaneList = new ArrayList<FlowcellLane>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			FlowcellLane object = new FlowcellLane();
			object.set(tuple, false);				
			flowcellLaneList.add(object);		
			
			//add to db when batch size is reached
			if(flowcellLaneList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				flowcellLanesMissingRefs.addAll(resolveForeignKeys(db, flowcellLaneList));
				flowcellLaneList.removeAll(flowcellLanesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Flowcell,Lane,Sample' defined in xref_label
				db.update(flowcellLaneList,dbAction, "Flowcell", "Lane", "Sample");
				
				//clear for next batch						
				flowcellLaneList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!flowcellLaneList.isEmpty())
		{
			total.set(total.get() + flowcellLaneList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			flowcellLanesMissingRefs.addAll(resolveForeignKeys(db, flowcellLaneList));
			flowcellLaneList.removeAll(flowcellLanesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Flowcell,Lane,Sample' defined in xref_label
			db.update(flowcellLaneList,dbAction, "Flowcell", "Lane", "Sample");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<FlowcellLane> flowcellLanes = new ArrayList<FlowcellLane>(flowcellLanesMissingRefs);

		int iterationCount = 0;

		do
		{
			flowcellLanesMissingRefs = resolveForeignKeys(db, flowcellLanesMissingRefs);
			
			LinkedHashSet<FlowcellLane> differenceSet = new LinkedHashSet<FlowcellLane>();
			Sets.symmetricDifference(new LinkedHashSet<FlowcellLane>(flowcellLanes), new LinkedHashSet<FlowcellLane>(flowcellLanesMissingRefs)).copyInto(differenceSet);
			List<FlowcellLane> resolvableflowcellLanes = new ArrayList<FlowcellLane>(differenceSet);
			
			flowcellLanes.removeAll(resolvableflowcellLanes);
			
			db.update(resolvableflowcellLanes,dbAction, "Flowcell", "Lane", "Sample");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(FlowcellLane blaat : flowcellLanesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'flowcellLane' entity failed:"
								+ "This is probably caused by a(n) 'flowcellLane' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (flowcellLanesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " flowcellLane from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param flowcellLaneList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<FlowcellLane> resolveForeignKeys(Database db, List<FlowcellLane> flowcellLaneList) throws Exception
	{
		//keep a list of FlowcellLane instances that miss a reference which might be resolvable later
		List<FlowcellLane> flowcellLanesMissingRefs = new ArrayList<FlowcellLane>();
	
		//resolve xref 'flowcell' from flowcell.FlowcellName -> flowcell.id
		for(FlowcellLane o: flowcellLaneList) 
		{
			if(o.getFlowcell_FlowcellName() != null) 
				flowcellKeymap.put(o.getFlowcell_FlowcellName(), null);
		}
		
		if(flowcellKeymap.size() > 0) 
		{
			List<Flowcell> flowcellList = db.query(Flowcell.class).in("FlowcellName",new ArrayList<Object>(flowcellKeymap.keySet())).find();
			for(Flowcell xref :  flowcellList)
			{
				flowcellKeymap.put(xref.getFlowcellName(), xref.getId());
			}
		}
		//resolve xref 'sample' from sample.InternalId -> sample.id
		for(FlowcellLane o: flowcellLaneList) 
		{
			if(o.getSample_InternalId() != null) 
				sampleKeymap.put(o.getSample_InternalId(), null);
		}
		
		if(sampleKeymap.size() > 0) 
		{
			List<Sample> sampleList = db.query(Sample.class).in("InternalId",new ArrayList<Object>(sampleKeymap.keySet())).find();
			for(Sample xref :  sampleList)
			{
				sampleKeymap.put(xref.getInternalId(), xref.getId());
			}
		}
		//resolve xref 'qcWetUser' from ngsUser.UserName -> ngsUser.id
		for(FlowcellLane o: flowcellLaneList) 
		{
			if(o.getQcWetUser_UserName() != null) 
				qcWetUserKeymap.put(o.getQcWetUser_UserName(), null);
		}
		
		if(qcWetUserKeymap.size() > 0) 
		{
			List<NgsUser> qcWetUserList = db.query(NgsUser.class).in("UserName",new ArrayList<Object>(qcWetUserKeymap.keySet())).find();
			for(NgsUser xref :  qcWetUserList)
			{
				qcWetUserKeymap.put(xref.getUserName(), xref.getId());
			}
		}
		//resolve xref 'qcDryUser' from ngsUser.UserName -> ngsUser.id
		for(FlowcellLane o: flowcellLaneList) 
		{
			if(o.getQcDryUser_UserName() != null) 
				qcDryUserKeymap.put(o.getQcDryUser_UserName(), null);
		}
		
		if(qcDryUserKeymap.size() > 0) 
		{
			List<NgsUser> qcDryUserList = db.query(NgsUser.class).in("UserName",new ArrayList<Object>(qcDryUserKeymap.keySet())).find();
			for(NgsUser xref :  qcDryUserList)
			{
				qcDryUserKeymap.put(xref.getUserName(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(FlowcellLane o:  flowcellLaneList)
		{
			while(true){
				//update xref Flowcell
				if(o.getFlowcell_FlowcellName() != null) 
				{
					String key = o.getFlowcell_FlowcellName();
					if(flowcellKeymap.get(key) == null)
					{
						throw new Exception("Import of 'FlowcellLane' objects failed: cannot find Flowcell for flowcell_FlowcellName='"+o.getFlowcell_FlowcellName()+"'");
					}
					o.setFlowcell_Id(flowcellKeymap.get(key));
				}
				//update xref Sample
				if(o.getSample_InternalId() != null) 
				{
					String key = o.getSample_InternalId();
					if(sampleKeymap.get(key) == null)
					{
						throw new Exception("Import of 'FlowcellLane' objects failed: cannot find Sample for sample_InternalId='"+o.getSample_InternalId()+"'");
					}
					o.setSample_Id(sampleKeymap.get(key));
				}
				//update xref QcWetUser
				if(o.getQcWetUser_UserName() != null) 
				{
					String key = o.getQcWetUser_UserName();
					if(qcWetUserKeymap.get(key) == null)
					{
						throw new Exception("Import of 'FlowcellLane' objects failed: cannot find NgsUser for qcWetUser_UserName='"+o.getQcWetUser_UserName()+"'");
					}
					o.setQcWetUser_Id(qcWetUserKeymap.get(key));
				}
				//update xref QcDryUser
				if(o.getQcDryUser_UserName() != null) 
				{
					String key = o.getQcDryUser_UserName();
					if(qcDryUserKeymap.get(key) == null)
					{
						throw new Exception("Import of 'FlowcellLane' objects failed: cannot find NgsUser for qcDryUser_UserName='"+o.getQcDryUser_UserName()+"'");
					}
					o.setQcDryUser_Id(qcDryUserKeymap.get(key));
				}
				break;
			}
		}
		
		flowcellKeymap.clear();
		sampleKeymap.clear();
		qcWetUserKeymap.clear();
		qcDryUserKeymap.clear();
		
		return flowcellLanesMissingRefs;
	}
}

