
/* File:        org.molgenis.omx/model/Project.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        September 20, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.ngs.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.ngs.NgsUser;
import org.molgenis.omx.ngs.PrepKit;
import org.molgenis.omx.ngs.Project;


/**
 * Reads Project from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class ProjectEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(ProjectEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'projectCustomer' (maps ngsUser.UserName -> ngsUser.id)			
	final Map<String,Integer> projectCustomerKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'projectAnalist' (maps ngsUser.UserName -> ngsUser.id)			
	final Map<String,Integer> projectAnalistKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'prepKit' (maps prepKit.PrepKitName -> prepKit.id)			
	final Map<String,Integer> prepKitKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'resultShippedUser' (maps ngsUser.UserName -> ngsUser.id)			
	final Map<String,Integer> resultShippedUserKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'resultShippedTo' (maps ngsUser.UserName -> ngsUser.id)			
	final Map<String,Integer> resultShippedToKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports Project from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Project> projectsMissingRefs = new ArrayList<Project>();
	
		//cache for objects to be imported from file (in batch)
		final List<Project> projectList = new ArrayList<Project>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			Project object = new Project();
			object.set(tuple, false);				
			projectList.add(object);		
			
			//add to db when batch size is reached
			if(projectList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				projectsMissingRefs.addAll(resolveForeignKeys(db, projectList));
				projectList.removeAll(projectsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'ProjectName' defined in xref_label
				db.update(projectList,dbAction, "ProjectName");
				
				//clear for next batch						
				projectList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!projectList.isEmpty())
		{
			total.set(total.get() + projectList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			projectsMissingRefs.addAll(resolveForeignKeys(db, projectList));
			projectList.removeAll(projectsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'ProjectName' defined in xref_label
			db.update(projectList,dbAction, "ProjectName");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Project> projects = new ArrayList<Project>(projectsMissingRefs);

		int iterationCount = 0;

		do
		{
			projectsMissingRefs = resolveForeignKeys(db, projectsMissingRefs);
			
			LinkedHashSet<Project> differenceSet = new LinkedHashSet<Project>();
			Sets.symmetricDifference(new LinkedHashSet<Project>(projects), new LinkedHashSet<Project>(projectsMissingRefs)).copyInto(differenceSet);
			List<Project> resolvableprojects = new ArrayList<Project>(differenceSet);
			
			projects.removeAll(resolvableprojects);
			
			db.update(resolvableprojects,dbAction, "ProjectName");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Project blaat : projectsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'project' entity failed:"
								+ "This is probably caused by a(n) 'project' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (projectsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " project from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param projectList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Project> resolveForeignKeys(Database db, List<Project> projectList) throws Exception
	{
		//keep a list of Project instances that miss a reference which might be resolvable later
		List<Project> projectsMissingRefs = new ArrayList<Project>();
	
		//resolve xref 'projectCustomer' from ngsUser.UserName -> ngsUser.id
		for(Project o: projectList) 
		{
			if(o.getProjectCustomer_UserName() != null) 
				projectCustomerKeymap.put(o.getProjectCustomer_UserName(), null);
		}
		
		if(projectCustomerKeymap.size() > 0) 
		{
			List<NgsUser> projectCustomerList = db.query(NgsUser.class).in("UserName",new ArrayList<Object>(projectCustomerKeymap.keySet())).find();
			for(NgsUser xref :  projectCustomerList)
			{
				projectCustomerKeymap.put(xref.getUserName(), xref.getId());
			}
		}
		//resolve xref 'projectAnalist' from ngsUser.UserName -> ngsUser.id
		for(Project o: projectList) for(String xref_label: o.getProjectAnalist_UserName())
		{
			if(xref_label != null) 
				projectAnalistKeymap.put(xref_label.trim(), null);
		}
		
		if(projectAnalistKeymap.size() > 0) 
		{
			List<NgsUser> projectAnalistList = db.query(NgsUser.class).in("UserName",new ArrayList<Object>(projectAnalistKeymap.keySet())).find();
			for(NgsUser xref :  projectAnalistList)
			{
				projectAnalistKeymap.put(xref.getUserName(), xref.getId());
			}
		}
		//resolve xref 'prepKit' from prepKit.PrepKitName -> prepKit.id
		for(Project o: projectList) 
		{
			if(o.getPrepKit_PrepKitName() != null) 
				prepKitKeymap.put(o.getPrepKit_PrepKitName(), null);
		}
		
		if(prepKitKeymap.size() > 0) 
		{
			List<PrepKit> prepKitList = db.query(PrepKit.class).in("PrepKitName",new ArrayList<Object>(prepKitKeymap.keySet())).find();
			for(PrepKit xref :  prepKitList)
			{
				prepKitKeymap.put(xref.getPrepKitName(), xref.getId());
			}
		}
		//resolve xref 'resultShippedUser' from ngsUser.UserName -> ngsUser.id
		for(Project o: projectList) 
		{
			if(o.getResultShippedUser_UserName() != null) 
				resultShippedUserKeymap.put(o.getResultShippedUser_UserName(), null);
		}
		
		if(resultShippedUserKeymap.size() > 0) 
		{
			List<NgsUser> resultShippedUserList = db.query(NgsUser.class).in("UserName",new ArrayList<Object>(resultShippedUserKeymap.keySet())).find();
			for(NgsUser xref :  resultShippedUserList)
			{
				resultShippedUserKeymap.put(xref.getUserName(), xref.getId());
			}
		}
		//resolve xref 'resultShippedTo' from ngsUser.UserName -> ngsUser.id
		for(Project o: projectList) 
		{
			if(o.getResultShippedTo_UserName() != null) 
				resultShippedToKeymap.put(o.getResultShippedTo_UserName(), null);
		}
		
		if(resultShippedToKeymap.size() > 0) 
		{
			List<NgsUser> resultShippedToList = db.query(NgsUser.class).in("UserName",new ArrayList<Object>(resultShippedToKeymap.keySet())).find();
			for(NgsUser xref :  resultShippedToList)
			{
				resultShippedToKeymap.put(xref.getUserName(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(Project o:  projectList)
		{
			while(true){
				//update xref ProjectCustomer
				if(o.getProjectCustomer_UserName() != null) 
				{
					String key = o.getProjectCustomer_UserName();
					if(projectCustomerKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Project' objects failed: cannot find NgsUser for projectCustomer_UserName='"+o.getProjectCustomer_UserName()+"'");
					}
					o.setProjectCustomer_Id(projectCustomerKeymap.get(key));
				}
				//update mref ProjectAnalist
				if(o.getProjectAnalist_UserName() != null) 
				{
					List<Integer> mrefs = new ArrayList<Integer>();
					boolean breakToNextProject = false;

					int listSize = 0;
					if(o.getProjectAnalist_UserName() != null) listSize = Math.max(o.getProjectAnalist_UserName().size(), listSize);
					for(int i = 0; i < listSize; i++)
					{
						String key = o.getProjectAnalist_UserName().get(i);
							key = key.trim();				
						if(projectAnalistKeymap.get(key) == null){
							logger.error("Import of 'Project' objects failed: "+o);
							throw new Exception("Import of 'Project' objects failed:" 
							+"cannot find projectAnalist_UserName='"+(o.getProjectAnalist_UserName() != null && i < o.getProjectAnalist_UserName().size() ? o.getProjectAnalist_UserName().get(i) : "null")+"'");
						}
						mrefs.add(projectAnalistKeymap.get(key));
					}
					if(breakToNextProject){
						break;
					}
					o.setProjectAnalist_Id(mrefs);
				}
				//update xref PrepKit
				if(o.getPrepKit_PrepKitName() != null) 
				{
					String key = o.getPrepKit_PrepKitName();
					if(prepKitKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Project' objects failed: cannot find PrepKit for prepKit_PrepKitName='"+o.getPrepKit_PrepKitName()+"'");
					}
					o.setPrepKit_Id(prepKitKeymap.get(key));
				}
				//update xref ResultShippedUser
				if(o.getResultShippedUser_UserName() != null) 
				{
					String key = o.getResultShippedUser_UserName();
					if(resultShippedUserKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Project' objects failed: cannot find NgsUser for resultShippedUser_UserName='"+o.getResultShippedUser_UserName()+"'");
					}
					o.setResultShippedUser_Id(resultShippedUserKeymap.get(key));
				}
				//update xref ResultShippedTo
				if(o.getResultShippedTo_UserName() != null) 
				{
					String key = o.getResultShippedTo_UserName();
					if(resultShippedToKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Project' objects failed: cannot find NgsUser for resultShippedTo_UserName='"+o.getResultShippedTo_UserName()+"'");
					}
					o.setResultShippedTo_Id(resultShippedToKeymap.get(key));
				}
				break;
			}
		}
		
		projectCustomerKeymap.clear();
		projectAnalistKeymap.clear();
		prepKitKeymap.clear();
		resultShippedUserKeymap.clear();
		resultShippedToKeymap.clear();
		
		return projectsMissingRefs;
	}
}

