
/* File:        org.molgenis.omx/model/Project_ProjectAnalist.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        September 20, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.ngs.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.ngs.NgsUser;
import org.molgenis.omx.ngs.Project;
import org.molgenis.omx.ngs.Project_ProjectAnalist;


/**
 * Reads Project_ProjectAnalist from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class Project_ProjectAnalistEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(Project_ProjectAnalistEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'projectAnalist' (maps ngsUser.UserName -> ngsUser.id)			
	final Map<String,Integer> projectAnalistKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'project' (maps project.ProjectName -> project.id)			
	final Map<String,Integer> projectKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports Project_ProjectAnalist from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Project_ProjectAnalist> project_ProjectAnalistsMissingRefs = new ArrayList<Project_ProjectAnalist>();
	
		//cache for objects to be imported from file (in batch)
		final List<Project_ProjectAnalist> project_ProjectAnalistList = new ArrayList<Project_ProjectAnalist>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			Project_ProjectAnalist object = new Project_ProjectAnalist();
			object.set(tuple, false);				
			project_ProjectAnalistList.add(object);		
			
			//add to db when batch size is reached
			if(project_ProjectAnalistList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				project_ProjectAnalistsMissingRefs.addAll(resolveForeignKeys(db, project_ProjectAnalistList));
				project_ProjectAnalistList.removeAll(project_ProjectAnalistsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'ProjectAnalist,Project' defined in xref_label
				db.update(project_ProjectAnalistList,dbAction, "ProjectAnalist", "Project");
				
				//clear for next batch						
				project_ProjectAnalistList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!project_ProjectAnalistList.isEmpty())
		{
			total.set(total.get() + project_ProjectAnalistList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			project_ProjectAnalistsMissingRefs.addAll(resolveForeignKeys(db, project_ProjectAnalistList));
			project_ProjectAnalistList.removeAll(project_ProjectAnalistsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'ProjectAnalist,Project' defined in xref_label
			db.update(project_ProjectAnalistList,dbAction, "ProjectAnalist", "Project");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Project_ProjectAnalist> project_ProjectAnalists = new ArrayList<Project_ProjectAnalist>(project_ProjectAnalistsMissingRefs);

		int iterationCount = 0;

		do
		{
			project_ProjectAnalistsMissingRefs = resolveForeignKeys(db, project_ProjectAnalistsMissingRefs);
			
			LinkedHashSet<Project_ProjectAnalist> differenceSet = new LinkedHashSet<Project_ProjectAnalist>();
			Sets.symmetricDifference(new LinkedHashSet<Project_ProjectAnalist>(project_ProjectAnalists), new LinkedHashSet<Project_ProjectAnalist>(project_ProjectAnalistsMissingRefs)).copyInto(differenceSet);
			List<Project_ProjectAnalist> resolvableproject_ProjectAnalists = new ArrayList<Project_ProjectAnalist>(differenceSet);
			
			project_ProjectAnalists.removeAll(resolvableproject_ProjectAnalists);
			
			db.update(resolvableproject_ProjectAnalists,dbAction, "ProjectAnalist", "Project");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Project_ProjectAnalist blaat : project_ProjectAnalistsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'project_ProjectAnalist' entity failed:"
								+ "This is probably caused by a(n) 'project_ProjectAnalist' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (project_ProjectAnalistsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " project_ProjectAnalist from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param project_ProjectAnalistList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Project_ProjectAnalist> resolveForeignKeys(Database db, List<Project_ProjectAnalist> project_ProjectAnalistList) throws Exception
	{
		//keep a list of Project_ProjectAnalist instances that miss a reference which might be resolvable later
		List<Project_ProjectAnalist> project_ProjectAnalistsMissingRefs = new ArrayList<Project_ProjectAnalist>();
	
		//resolve xref 'projectAnalist' from ngsUser.UserName -> ngsUser.id
		for(Project_ProjectAnalist o: project_ProjectAnalistList) 
		{
			if(o.getProjectAnalist_UserName() != null) 
				projectAnalistKeymap.put(o.getProjectAnalist_UserName(), null);
		}
		
		if(projectAnalistKeymap.size() > 0) 
		{
			List<NgsUser> projectAnalistList = db.query(NgsUser.class).in("UserName",new ArrayList<Object>(projectAnalistKeymap.keySet())).find();
			for(NgsUser xref :  projectAnalistList)
			{
				projectAnalistKeymap.put(xref.getUserName(), xref.getId());
			}
		}
		//resolve xref 'project' from project.ProjectName -> project.id
		for(Project_ProjectAnalist o: project_ProjectAnalistList) 
		{
			if(o.getProject_ProjectName() != null) 
				projectKeymap.put(o.getProject_ProjectName(), null);
		}
		
		if(projectKeymap.size() > 0) 
		{
			List<Project> projectList = db.query(Project.class).in("ProjectName",new ArrayList<Object>(projectKeymap.keySet())).find();
			for(Project xref :  projectList)
			{
				projectKeymap.put(xref.getProjectName(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(Project_ProjectAnalist o:  project_ProjectAnalistList)
		{
			while(true){
				//update xref ProjectAnalist
				if(o.getProjectAnalist_UserName() != null) 
				{
					String key = o.getProjectAnalist_UserName();
					if(projectAnalistKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Project_ProjectAnalist' objects failed: cannot find NgsUser for projectAnalist_UserName='"+o.getProjectAnalist_UserName()+"'");
					}
					o.setProjectAnalist_Id(projectAnalistKeymap.get(key));
				}
				//update xref Project
				if(o.getProject_ProjectName() != null) 
				{
					String key = o.getProject_ProjectName();
					if(projectKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Project_ProjectAnalist' objects failed: cannot find Project for project_ProjectName='"+o.getProject_ProjectName()+"'");
					}
					o.setProject_Id(projectKeymap.get(key));
				}
				break;
			}
		}
		
		projectAnalistKeymap.clear();
		projectKeymap.clear();
		
		return project_ProjectAnalistsMissingRefs;
	}
}

