
/* File:        org.molgenis.omx/model/SampleBarcodeType.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        September 20, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.ngs.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.ngs.SampleBarcodeType;


/**
 * Reads SampleBarcodeType from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class SampleBarcodeTypeEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(SampleBarcodeTypeEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
			
	/**
	 * Imports SampleBarcodeType from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<SampleBarcodeType> sampleBarcodeTypesMissingRefs = new ArrayList<SampleBarcodeType>();
	
		//cache for objects to be imported from file (in batch)
		final List<SampleBarcodeType> sampleBarcodeTypeList = new ArrayList<SampleBarcodeType>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			SampleBarcodeType object = new SampleBarcodeType();
			object.set(tuple, false);				
			sampleBarcodeTypeList.add(object);		
			
			//add to db when batch size is reached
			if(sampleBarcodeTypeList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				sampleBarcodeTypesMissingRefs.addAll(resolveForeignKeys(db, sampleBarcodeTypeList));
				sampleBarcodeTypeList.removeAll(sampleBarcodeTypesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'SampleBarcodeTypeName' defined in xref_label
				db.update(sampleBarcodeTypeList,dbAction, "SampleBarcodeTypeName");
				
				//clear for next batch						
				sampleBarcodeTypeList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!sampleBarcodeTypeList.isEmpty())
		{
			total.set(total.get() + sampleBarcodeTypeList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			sampleBarcodeTypesMissingRefs.addAll(resolveForeignKeys(db, sampleBarcodeTypeList));
			sampleBarcodeTypeList.removeAll(sampleBarcodeTypesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'SampleBarcodeTypeName' defined in xref_label
			db.update(sampleBarcodeTypeList,dbAction, "SampleBarcodeTypeName");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<SampleBarcodeType> sampleBarcodeTypes = new ArrayList<SampleBarcodeType>(sampleBarcodeTypesMissingRefs);

		int iterationCount = 0;

		do
		{
			sampleBarcodeTypesMissingRefs = resolveForeignKeys(db, sampleBarcodeTypesMissingRefs);
			
			LinkedHashSet<SampleBarcodeType> differenceSet = new LinkedHashSet<SampleBarcodeType>();
			Sets.symmetricDifference(new LinkedHashSet<SampleBarcodeType>(sampleBarcodeTypes), new LinkedHashSet<SampleBarcodeType>(sampleBarcodeTypesMissingRefs)).copyInto(differenceSet);
			List<SampleBarcodeType> resolvablesampleBarcodeTypes = new ArrayList<SampleBarcodeType>(differenceSet);
			
			sampleBarcodeTypes.removeAll(resolvablesampleBarcodeTypes);
			
			db.update(resolvablesampleBarcodeTypes,dbAction, "SampleBarcodeTypeName");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(SampleBarcodeType blaat : sampleBarcodeTypesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'sampleBarcodeType' entity failed:"
								+ "This is probably caused by a(n) 'sampleBarcodeType' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (sampleBarcodeTypesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " sampleBarcodeType from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param sampleBarcodeTypeList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<SampleBarcodeType> resolveForeignKeys(Database db, List<SampleBarcodeType> sampleBarcodeTypeList) throws Exception
	{
		//keep a list of SampleBarcodeType instances that miss a reference which might be resolvable later
		List<SampleBarcodeType> sampleBarcodeTypesMissingRefs = new ArrayList<SampleBarcodeType>();
	
		//update objects with foreign key values
		for(SampleBarcodeType o:  sampleBarcodeTypeList)
		{
			while(true){
				break;
			}
		}
		
		
		return sampleBarcodeTypesMissingRefs;
	}
}

