
/* File:        org.molgenis.omx/model/Sample.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        September 20, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.ngs.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.ngs.Project;
import org.molgenis.omx.ngs.CapturingKit;
import org.molgenis.omx.ngs.SampleBarcode;
import org.molgenis.omx.ngs.Sample;


/**
 * Reads Sample from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class SampleEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(SampleEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'projectId' (maps project.ProjectName -> project.id)			
	final Map<String,Integer> projectIdKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'capturingKit' (maps capturingKit.CapturingKitName -> capturingKit.id)			
	final Map<String,Integer> capturingKitKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'sampleBarcode' (maps sampleBarcode.SampleBarcodeName -> sampleBarcode.id)			
	final Map<String,Integer> sampleBarcodeKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'sampleInPool' (maps sample.InternalId -> sample.id)			
	final Map<String,Integer> sampleInPoolKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports Sample from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Sample> samplesMissingRefs = new ArrayList<Sample>();
	
		//cache for objects to be imported from file (in batch)
		final List<Sample> sampleList = new ArrayList<Sample>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			Sample object = new Sample();
			object.set(tuple, false);				
			sampleList.add(object);		
			
			//add to db when batch size is reached
			if(sampleList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				samplesMissingRefs.addAll(resolveForeignKeys(db, sampleList));
				sampleList.removeAll(samplesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'InternalId' defined in xref_label
				db.update(sampleList,dbAction, "InternalId");
				
				//clear for next batch						
				sampleList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!sampleList.isEmpty())
		{
			total.set(total.get() + sampleList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			samplesMissingRefs.addAll(resolveForeignKeys(db, sampleList));
			sampleList.removeAll(samplesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'InternalId' defined in xref_label
			db.update(sampleList,dbAction, "InternalId");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Sample> samples = new ArrayList<Sample>(samplesMissingRefs);

		int iterationCount = 0;

		do
		{
			samplesMissingRefs = resolveForeignKeys(db, samplesMissingRefs);
			
			LinkedHashSet<Sample> differenceSet = new LinkedHashSet<Sample>();
			Sets.symmetricDifference(new LinkedHashSet<Sample>(samples), new LinkedHashSet<Sample>(samplesMissingRefs)).copyInto(differenceSet);
			List<Sample> resolvablesamples = new ArrayList<Sample>(differenceSet);
			
			samples.removeAll(resolvablesamples);
			
			db.update(resolvablesamples,dbAction, "InternalId");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Sample blaat : samplesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'sample' entity failed:"
								+ "This is probably caused by a(n) 'sample' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (samplesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " sample from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param sampleList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Sample> resolveForeignKeys(Database db, List<Sample> sampleList) throws Exception
	{
		//keep a list of Sample instances that miss a reference which might be resolvable later
		List<Sample> samplesMissingRefs = new ArrayList<Sample>();
	
		//resolve xref 'projectId' from project.ProjectName -> project.id
		for(Sample o: sampleList) 
		{
			if(o.getProjectId_ProjectName() != null) 
				projectIdKeymap.put(o.getProjectId_ProjectName(), null);
		}
		
		if(projectIdKeymap.size() > 0) 
		{
			List<Project> projectIdList = db.query(Project.class).in("ProjectName",new ArrayList<Object>(projectIdKeymap.keySet())).find();
			for(Project xref :  projectIdList)
			{
				projectIdKeymap.put(xref.getProjectName(), xref.getId());
			}
		}
		//resolve xref 'capturingKit' from capturingKit.CapturingKitName -> capturingKit.id
		for(Sample o: sampleList) 
		{
			if(o.getCapturingKit_CapturingKitName() != null) 
				capturingKitKeymap.put(o.getCapturingKit_CapturingKitName(), null);
		}
		
		if(capturingKitKeymap.size() > 0) 
		{
			List<CapturingKit> capturingKitList = db.query(CapturingKit.class).in("CapturingKitName",new ArrayList<Object>(capturingKitKeymap.keySet())).find();
			for(CapturingKit xref :  capturingKitList)
			{
				capturingKitKeymap.put(xref.getCapturingKitName(), xref.getId());
			}
		}
		//resolve xref 'sampleBarcode' from sampleBarcode.SampleBarcodeName -> sampleBarcode.id
		for(Sample o: sampleList) 
		{
			if(o.getSampleBarcode_SampleBarcodeName() != null) 
				sampleBarcodeKeymap.put(o.getSampleBarcode_SampleBarcodeName(), null);
		}
		
		if(sampleBarcodeKeymap.size() > 0) 
		{
			List<SampleBarcode> sampleBarcodeList = db.query(SampleBarcode.class).in("SampleBarcodeName",new ArrayList<Object>(sampleBarcodeKeymap.keySet())).find();
			for(SampleBarcode xref :  sampleBarcodeList)
			{
				sampleBarcodeKeymap.put(xref.getSampleBarcodeName(), xref.getId());
			}
		}
		//resolve xref 'sampleInPool' from sample.InternalId -> sample.id
		for(Sample o: sampleList) for(String xref_label: o.getSampleInPool_InternalId())
		{
			if(xref_label != null) 
				sampleInPoolKeymap.put(xref_label.trim(), null);
		}
		
		if(sampleInPoolKeymap.size() > 0) 
		{
			List<Sample> sampleInPoolList = db.query(Sample.class).in("InternalId",new ArrayList<Object>(sampleInPoolKeymap.keySet())).find();
			for(Sample xref :  sampleInPoolList)
			{
				sampleInPoolKeymap.put(xref.getInternalId(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(Sample o:  sampleList)
		{
			while(true){
				//update xref ProjectId
				if(o.getProjectId_ProjectName() != null) 
				{
					String key = o.getProjectId_ProjectName();
					if(projectIdKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Sample' objects failed: cannot find Project for projectId_ProjectName='"+o.getProjectId_ProjectName()+"'");
					}
					o.setProjectId_Id(projectIdKeymap.get(key));
				}
				//update xref CapturingKit
				if(o.getCapturingKit_CapturingKitName() != null) 
				{
					String key = o.getCapturingKit_CapturingKitName();
					if(capturingKitKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Sample' objects failed: cannot find CapturingKit for capturingKit_CapturingKitName='"+o.getCapturingKit_CapturingKitName()+"'");
					}
					o.setCapturingKit_Id(capturingKitKeymap.get(key));
				}
				//update xref SampleBarcode
				if(o.getSampleBarcode_SampleBarcodeName() != null) 
				{
					String key = o.getSampleBarcode_SampleBarcodeName();
					if(sampleBarcodeKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Sample' objects failed: cannot find SampleBarcode for sampleBarcode_SampleBarcodeName='"+o.getSampleBarcode_SampleBarcodeName()+"'");
					}
					o.setSampleBarcode_Id(sampleBarcodeKeymap.get(key));
				}
				//update mref SampleInPool
				if(o.getSampleInPool_InternalId() != null) 
				{
					List<Integer> mrefs = new ArrayList<Integer>();
					boolean breakToNextSample = false;

					int listSize = 0;
					if(o.getSampleInPool_InternalId() != null) listSize = Math.max(o.getSampleInPool_InternalId().size(), listSize);
					for(int i = 0; i < listSize; i++)
					{
						String key = o.getSampleInPool_InternalId().get(i);
							key = key.trim();				
						if(sampleInPoolKeymap.get(key) == null){
							samplesMissingRefs.add(o);
							breakToNextSample = true;
							break;
						}
						mrefs.add(sampleInPoolKeymap.get(key));
					}
					if(breakToNextSample){
						break;
					}
					o.setSampleInPool_Id(mrefs);
				}
				break;
			}
		}
		
		projectIdKeymap.clear();
		capturingKitKeymap.clear();
		sampleBarcodeKeymap.clear();
		sampleInPoolKeymap.clear();
		
		return samplesMissingRefs;
	}
}

