package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.ngs.NgsUser;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class NgsUserService
{
	private static final Logger logger = Logger.getLogger(NgsUserService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public NgsUser create(NgsUser ngsUser) throws DatabaseException
	{
		logger.debug("creating NgsUser");
		db.add(ngsUser);
		return ngsUser;
	}

	public NgsUser read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving NgsUser");
		return db.findById(NgsUser.class, id);
	}

	public void update(NgsUser ngsUser) throws DatabaseException
	{
		logger.debug("updating NgsUser");
		db.update(ngsUser);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting NgsUser");
		NgsUser ngsUser = db.findById(NgsUser.class, id);
		return db.remove(ngsUser) == 1;
	}
	
	public Iterable<NgsUser> readAll() throws DatabaseException
	{
		logger.debug("retrieving all NgsUser instances");
		return db.find(NgsUser.class);
	}
	
	public EntityPager<NgsUser> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all NgsUser instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(NgsUser.class, queryRules.toArray(new QueryRule[0]));
		List<NgsUser> ngsUserCollection = db.find(NgsUser.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<NgsUser>(start, num, count, ngsUserCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("NgsUser");
	}
}