package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.ngs.Sample;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class SampleService
{
	private static final Logger logger = Logger.getLogger(SampleService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public Sample create(Sample sample) throws DatabaseException
	{
		logger.debug("creating Sample");
		db.add(sample);
		return sample;
	}

	public Sample read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Sample");
		return db.findById(Sample.class, id);
	}

	public void update(Sample sample) throws DatabaseException
	{
		logger.debug("updating Sample");
		db.update(sample);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Sample");
		Sample sample = db.findById(Sample.class, id);
		return db.remove(sample) == 1;
	}
	
	public Iterable<Sample> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Sample instances");
		return db.find(Sample.class);
	}
	
	public EntityPager<Sample> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Sample instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Sample.class, queryRules.toArray(new QueryRule[0]));
		List<Sample> sampleCollection = db.find(Sample.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Sample>(start, num, count, sampleCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Sample");
	}
}