package org.molgenis.controller;

import java.beans.PropertyEditorSupport;
import java.text.ParseException;
import java.lang.RuntimeException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;
import javax.validation.Valid;

import org.molgenis.omx.ngs.SampleBarcode;
import org.molgenis.framework.server.EntityCollectionRequest;
import org.molgenis.framework.server.EntityCollectionResponse;
import org.molgenis.framework.db.DatabaseAccessException;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.EntityNotFoundException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.service.SampleBarcodeService;
import org.molgenis.omx.ngs.SampleBarcodeType;
import org.molgenis.controller.SampleBarcodeTypeController.SampleBarcodeTypeResponse;
import org.molgenis.service.SampleBarcodeTypeService;
import org.molgenis.util.EntityPager;
import org.molgenis.util.MolgenisDateFormat;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import org.apache.commons.lang3.StringUtils;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

@SuppressWarnings("unused")
@Lazy
@Controller
@RequestMapping("/api/v1/samplebarcode")
public class SampleBarcodeController
{
	@Autowired
	private SampleBarcodeService sampleBarcodeService;

	@Autowired
	private SampleBarcodeTypeService sampleBarcodeTypeService;
		
	@RequestMapping(method = RequestMethod.POST)
	@ResponseBody
	public ResponseEntity<SampleBarcodeResponse> createSampleBarcode(@Valid @RequestBody SampleBarcodeRequest sampleBarcodeRequest)
			throws DatabaseException
	{
		return _createSampleBarcode(sampleBarcodeRequest);
	}

	// Spring's FormHttpMessageConverter cannot bind target classes (as ModelAttribute can)
	@RequestMapping(method = RequestMethod.POST, headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseBody
	public ResponseEntity<SampleBarcodeResponse> createSampleBarcodeFromForm(@Valid @ModelAttribute SampleBarcodeRequest sampleBarcodeRequest)
			throws DatabaseException
	{
		return _createSampleBarcode(sampleBarcodeRequest);
	}

	private ResponseEntity<SampleBarcodeResponse> _createSampleBarcode(SampleBarcodeRequest sampleBarcodeRequest) throws DatabaseException
	{
		SampleBarcode sampleBarcode = sampleBarcodeService.create(sampleBarcodeRequest.toSampleBarcode());
		HttpHeaders responseHeaders = new HttpHeaders();
		responseHeaders.add("Location", "/api/v1/samplebarcode/" + sampleBarcode.getId());
		return new ResponseEntity<SampleBarcodeResponse>(responseHeaders, HttpStatus.CREATED);
	}

	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ResponseBody
	public SampleBarcodeResponse retrieveSampleBarcode(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveSampleBarcode(id, expandFields);
	}
		
	@RequestMapping(value = "/{id}", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	@ResponseBody
	public SampleBarcodeResponse retrieveSampleBarcodeJson(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveSampleBarcode(id, expandFields);
	}

	@InitBinder
	public void binder(WebDataBinder binder)
	{

		binder.registerCustomEditor(Date.class, new PropertyEditorSupport()
		{
			@Override
			public void setAsText(String value)
			{
				try
				{
					if (StringUtils.isNotBlank(value))
					{
						setValue(MolgenisDateFormat.getDateFormat().parse(value));
					}
				}
				catch (ParseException e)
				{
					throw new RuntimeException(e);
				}
			}

			@Override
			public String getAsText()
			{
				if (getValue() == null)
				{
					return null;
				}
				
				return MolgenisDateFormat.getDateFormat().format((Date) getValue());
			}

		});
	}

	private SampleBarcodeResponse _retrieveSampleBarcode(Integer id, String... expandFieldsStr) throws DatabaseException
	{
		SampleBarcode sampleBarcode = sampleBarcodeService.read(id);
		if (sampleBarcode == null) throw new EntityNotFoundException("SampleBarcode " + id.toString() + " not found");
		Set<String> expandFields = expandFieldsStr != null ? new HashSet<String>(Arrays.asList(expandFieldsStr)) : null;
		return new SampleBarcodeResponse(sampleBarcode, expandFields);
	}
			
	@RequestMapping(value = "/{id}/sampleBarcodeType", method = RequestMethod.GET)
	public String retrieveSampleBarcodeXrefSampleBarcodeType(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveSampleBarcodeXrefSampleBarcodeType(id, null, expandFields);
	}
	
	@RequestMapping(value = "/{id}/sampleBarcodeType", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	public String retrieveSampleBarcodeXrefSampleBarcodeTypeJson(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveSampleBarcodeXrefSampleBarcodeType(id, "json", expandFields);
	}
	
	private String _retrieveSampleBarcodeXrefSampleBarcodeType(Integer id, String format, String... expandFieldsStr) throws DatabaseException
	{
		SampleBarcode sampleBarcode = sampleBarcodeService.read(id);
		if (sampleBarcode == null) throw new EntityNotFoundException("SampleBarcode " + id.toString() + " not found");
		Integer sampleBarcodeTypeId = sampleBarcode.getSampleBarcodeType_Id();
		String redirectUri = "redirect:/api/v1/samplebarcodetype/" + sampleBarcodeTypeId.toString();
		StringBuilder qsBuilder = new StringBuilder();
		if(format != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("format=").append(format);
		if(expandFieldsStr != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("expand=").append(Joiner.on(',').join(expandFieldsStr));
		return qsBuilder.length() == 0 ? redirectUri : redirectUri + qsBuilder.toString();
	}
	


	@RequestMapping(value = "/{id}", method = RequestMethod.PUT)
	@ResponseStatus(HttpStatus.OK)
	public void updateSampleBarcode(@PathVariable Integer id, @Valid @RequestBody SampleBarcodeRequest sampleBarcodeRequest)
			throws DatabaseException
	{
		_updateSampleBarcode(id, sampleBarcodeRequest);
	}

	// Spring's FormHttpMessageConverter cannot bind target classes (as ModelAttribute can)
	@RequestMapping(value = "/{id}", method = RequestMethod.PUT, headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseBody
	public ResponseEntity<SampleBarcodeResponse> updateSampleBarcodeFromForm(@PathVariable Integer id, @PathVariable String _method,
			@Valid @ModelAttribute SampleBarcodeRequest sampleBarcodeRequest) throws DatabaseException
	{
		return _createSampleBarcode(sampleBarcodeRequest);
	}

	// Tunnel PUT through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=PUT")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void updateSampleBarcodePost(@PathVariable Integer id, @Valid @RequestBody SampleBarcodeRequest sampleBarcodeRequest)
			throws DatabaseException
	{
		_updateSampleBarcode(id, sampleBarcodeRequest);
	}

	// Tunnel PUT through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=PUT", headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void updateSampleBarcodeFromFormPost(@PathVariable Integer id, @Valid @ModelAttribute SampleBarcodeRequest sampleBarcodeRequest)
			throws DatabaseException
	{
		_updateSampleBarcode(id, sampleBarcodeRequest);
	}

	private void _updateSampleBarcode(Integer id, SampleBarcodeRequest sampleBarcodeRequest) throws DatabaseException
	{
		SampleBarcode sampleBarcode = sampleBarcodeRequest.toSampleBarcode();
		sampleBarcode.setId(id);
		sampleBarcodeService.update(sampleBarcode);
	}

	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void deleteSampleBarcode(@PathVariable Integer id) throws DatabaseException
	{
		_deleteSampleBarcode(id);
	}

	// Tunnel DELETE through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=DELETE")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void deleteSampleBarcodePost(@PathVariable Integer id) throws DatabaseException
	{
		_deleteSampleBarcode(id);
	}

	private void _deleteSampleBarcode(Integer id) throws DatabaseException
	{
		boolean isDeleted = sampleBarcodeService.deleteById(id);
		if(!isDeleted) throw new EntityNotFoundException("SampleBarcode " + id.toString() + " not found");
	}
	
	@RequestMapping(method = RequestMethod.GET)
	@ResponseBody
	public EntityCollectionResponse<SampleBarcodeResponse> retrieveSampleBarcodeCollection(@Valid EntityCollectionRequest sampleBarcodeCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveSampleBarcodeCollection(sampleBarcodeCollectionRequest, expandFields);
	}

	@RequestMapping(method = RequestMethod.GET, params = "format=json", produces = "application/json")
	@ResponseBody
	public EntityCollectionResponse<SampleBarcodeResponse> retrieveSampleBarcodeCollectionJson(@Valid EntityCollectionRequest sampleBarcodeCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveSampleBarcodeCollection(sampleBarcodeCollectionRequest, expandFields);
	}

	// Tunnel GET with body through POST
	@RequestMapping(method = RequestMethod.POST, params = "_method=GET")
	@ResponseBody
	public EntityCollectionResponse<SampleBarcodeResponse> retrieveSampleBarcodeCollectionPost(@Valid @RequestBody EntityCollectionRequest sampleBarcodeCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveSampleBarcodeCollection(sampleBarcodeCollectionRequest, expandFields);
	}

	// Tunnel GET with body through POST
	@RequestMapping(method = RequestMethod.POST, params = {"_method=GET", "format=json"}, produces = "application/json")
	@ResponseBody
	public EntityCollectionResponse<SampleBarcodeResponse> retrieveSampleBarcodeCollectionJsonPost(@Valid @RequestBody EntityCollectionRequest sampleBarcodeCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveSampleBarcodeCollection(sampleBarcodeCollectionRequest, expandFields);
	}
	
	private EntityCollectionResponse<SampleBarcodeResponse> _retrieveSampleBarcodeCollection(EntityCollectionRequest entityCollectionRequest, String... expandFieldsStr) throws DatabaseException
	{
		EntityPager<SampleBarcode> sampleBarcodePager = sampleBarcodeService.readAll(entityCollectionRequest.getStart(), entityCollectionRequest.getNum(), entityCollectionRequest.getQ());
		final Set<String> expandFields = expandFieldsStr != null ? new HashSet<String>(Arrays.asList(expandFieldsStr)) : null;
		return new EntityCollectionResponse<SampleBarcodeResponse>(sampleBarcodePager, Lists.newArrayList(Iterables.transform(
				sampleBarcodePager.getIterable(), new Function<SampleBarcode, SampleBarcodeResponse>()
				{
					@Override
					@Nullable
					public SampleBarcodeResponse apply(@Nullable SampleBarcode sampleBarcode)
					{
						try
						{
							return sampleBarcode != null ? new SampleBarcodeResponse(sampleBarcode, expandFields) : null;
						} catch(DatabaseException e)
						{
							throw new RuntimeException(e);
						}
					}
				})), "/api/v1/samplebarcode");
	}

	private static class SampleBarcodeRequest
	{
		private String sampleBarcodeNr;
		private String sampleBarcodeSequence;
		private Integer sampleBarcodeType;
		private String sampleBarcodeName;
		private Boolean active = false;	
	
		public SampleBarcode toSampleBarcode()
		{
			SampleBarcode sampleBarcode = new SampleBarcode();
			sampleBarcode.setSampleBarcodeNr(sampleBarcodeNr);
			sampleBarcode.setSampleBarcodeSequence(sampleBarcodeSequence);
			sampleBarcode.setSampleBarcodeType_Id(sampleBarcodeType);
			sampleBarcode.setSampleBarcodeName(sampleBarcodeName);
			sampleBarcode.setActive(active);
			return sampleBarcode;
		}
		
		public void setSampleBarcodeNr(String sampleBarcodeNr)
		{
			this.sampleBarcodeNr = sampleBarcodeNr;
		}
		
		public void setSampleBarcodeSequence(String sampleBarcodeSequence)
		{
			this.sampleBarcodeSequence = sampleBarcodeSequence;
		}
		
		public void setSampleBarcodeType(Integer sampleBarcodeType)
		{
			this.sampleBarcodeType = sampleBarcodeType;
		}
		
		public void setSampleBarcodeName(String sampleBarcodeName)
		{
			this.sampleBarcodeName = sampleBarcodeName;
		}
		
		public void setActive(Boolean active)
		{
			this.active = active;
		}
		
	}

	static class SampleBarcodeResponse
	{
		private final String href;
		private final String sampleBarcodeNr;
		private final String sampleBarcodeSequence;
		private final Object sampleBarcodeType;
		private final String sampleBarcodeName;
		private final Boolean active;
	
		public SampleBarcodeResponse(SampleBarcode sampleBarcode, final Set<String> expandFields) throws DatabaseException
		{
			this.href = "/api/v1/samplebarcode/" + sampleBarcode.getId();
			this.sampleBarcodeNr = sampleBarcode.getSampleBarcodeNr();
			this.sampleBarcodeSequence = sampleBarcode.getSampleBarcodeSequence();
			if (expandFields != null && expandFields.contains("sampleBarcodeType")) this.sampleBarcodeType = sampleBarcode.getSampleBarcodeType() == null ? null : new SampleBarcodeTypeResponse(sampleBarcode.getSampleBarcodeType(), null);
			else this.sampleBarcodeType = sampleBarcode.getSampleBarcodeType() == null ? null : java.util.Collections.singletonMap("href", "/api/v1/samplebarcode/" + sampleBarcode.getId() + "/sampleBarcodeType");
			this.sampleBarcodeName = sampleBarcode.getSampleBarcodeName();
			this.active = sampleBarcode.getActive();
		}
	
		public String getHref()
		{
			return href;
		}
	
		public String getSampleBarcodeNr()
		{
			return sampleBarcodeNr;
		}
	
		public String getSampleBarcodeSequence()
		{
			return sampleBarcodeSequence;
		}
	
		public Object getSampleBarcodeType()
		{
			return sampleBarcodeType;
		}
	
		public String getSampleBarcodeName()
		{
			return sampleBarcodeName;
		}
	
		public Boolean getActive()
		{
			return active;
		}
	
	}
	
	@ExceptionHandler(EntityNotFoundException.class)
	@ResponseStatus(value = HttpStatus.NOT_FOUND)
	public void handleEntityNotFoundException(EntityNotFoundException e)
	{
	}
	
	@ExceptionHandler(DatabaseAccessException.class)
	@ResponseStatus(value = HttpStatus.UNAUTHORIZED)
	public void handleDatabaseAccessException(DatabaseAccessException e)
	{
	}
}