
/* File:        org.molgenis.omx/model/NgsUser.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        September 20, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.ngs.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.ngs.NgsUser;


/**
 * Reads NgsUser from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class NgsUserEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(NgsUserEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
			
	/**
	 * Imports NgsUser from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<NgsUser> ngsUsersMissingRefs = new ArrayList<NgsUser>();
	
		//cache for objects to be imported from file (in batch)
		final List<NgsUser> ngsUserList = new ArrayList<NgsUser>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			NgsUser object = new NgsUser();
			object.set(tuple, false);				
			ngsUserList.add(object);		
			
			//add to db when batch size is reached
			if(ngsUserList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				ngsUsersMissingRefs.addAll(resolveForeignKeys(db, ngsUserList));
				ngsUserList.removeAll(ngsUsersMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'UserName' defined in xref_label
				db.update(ngsUserList,dbAction, "UserName");
				
				//clear for next batch						
				ngsUserList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!ngsUserList.isEmpty())
		{
			total.set(total.get() + ngsUserList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			ngsUsersMissingRefs.addAll(resolveForeignKeys(db, ngsUserList));
			ngsUserList.removeAll(ngsUsersMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'UserName' defined in xref_label
			db.update(ngsUserList,dbAction, "UserName");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<NgsUser> ngsUsers = new ArrayList<NgsUser>(ngsUsersMissingRefs);

		int iterationCount = 0;

		do
		{
			ngsUsersMissingRefs = resolveForeignKeys(db, ngsUsersMissingRefs);
			
			LinkedHashSet<NgsUser> differenceSet = new LinkedHashSet<NgsUser>();
			Sets.symmetricDifference(new LinkedHashSet<NgsUser>(ngsUsers), new LinkedHashSet<NgsUser>(ngsUsersMissingRefs)).copyInto(differenceSet);
			List<NgsUser> resolvablengsUsers = new ArrayList<NgsUser>(differenceSet);
			
			ngsUsers.removeAll(resolvablengsUsers);
			
			db.update(resolvablengsUsers,dbAction, "UserName");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(NgsUser blaat : ngsUsersMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'ngsUser' entity failed:"
								+ "This is probably caused by a(n) 'ngsUser' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (ngsUsersMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " ngsUser from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param ngsUserList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<NgsUser> resolveForeignKeys(Database db, List<NgsUser> ngsUserList) throws Exception
	{
		//keep a list of NgsUser instances that miss a reference which might be resolvable later
		List<NgsUser> ngsUsersMissingRefs = new ArrayList<NgsUser>();
	
		//update objects with foreign key values
		for(NgsUser o:  ngsUserList)
		{
			while(true){
				break;
			}
		}
		
		
		return ngsUsersMissingRefs;
	}
}

