
/* File:        org.molgenis.omx/model/SampleBarcode.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        September 20, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.ngs.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.ngs.SampleBarcodeType;
import org.molgenis.omx.ngs.SampleBarcode;


/**
 * Reads SampleBarcode from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class SampleBarcodeEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(SampleBarcodeEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'sampleBarcodeType' (maps sampleBarcodeType.SampleBarcodeTypeName -> sampleBarcodeType.id)			
	final Map<String,Integer> sampleBarcodeTypeKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports SampleBarcode from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<SampleBarcode> sampleBarcodesMissingRefs = new ArrayList<SampleBarcode>();
	
		//cache for objects to be imported from file (in batch)
		final List<SampleBarcode> sampleBarcodeList = new ArrayList<SampleBarcode>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			SampleBarcode object = new SampleBarcode();
			object.set(tuple, false);				
			sampleBarcodeList.add(object);		
			
			//add to db when batch size is reached
			if(sampleBarcodeList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				sampleBarcodesMissingRefs.addAll(resolveForeignKeys(db, sampleBarcodeList));
				sampleBarcodeList.removeAll(sampleBarcodesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'SampleBarcodeName' defined in xref_label
				db.update(sampleBarcodeList,dbAction, "SampleBarcodeName");
				
				//clear for next batch						
				sampleBarcodeList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!sampleBarcodeList.isEmpty())
		{
			total.set(total.get() + sampleBarcodeList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			sampleBarcodesMissingRefs.addAll(resolveForeignKeys(db, sampleBarcodeList));
			sampleBarcodeList.removeAll(sampleBarcodesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'SampleBarcodeName' defined in xref_label
			db.update(sampleBarcodeList,dbAction, "SampleBarcodeName");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<SampleBarcode> sampleBarcodes = new ArrayList<SampleBarcode>(sampleBarcodesMissingRefs);

		int iterationCount = 0;

		do
		{
			sampleBarcodesMissingRefs = resolveForeignKeys(db, sampleBarcodesMissingRefs);
			
			LinkedHashSet<SampleBarcode> differenceSet = new LinkedHashSet<SampleBarcode>();
			Sets.symmetricDifference(new LinkedHashSet<SampleBarcode>(sampleBarcodes), new LinkedHashSet<SampleBarcode>(sampleBarcodesMissingRefs)).copyInto(differenceSet);
			List<SampleBarcode> resolvablesampleBarcodes = new ArrayList<SampleBarcode>(differenceSet);
			
			sampleBarcodes.removeAll(resolvablesampleBarcodes);
			
			db.update(resolvablesampleBarcodes,dbAction, "SampleBarcodeName");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(SampleBarcode blaat : sampleBarcodesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'sampleBarcode' entity failed:"
								+ "This is probably caused by a(n) 'sampleBarcode' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (sampleBarcodesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " sampleBarcode from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param sampleBarcodeList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<SampleBarcode> resolveForeignKeys(Database db, List<SampleBarcode> sampleBarcodeList) throws Exception
	{
		//keep a list of SampleBarcode instances that miss a reference which might be resolvable later
		List<SampleBarcode> sampleBarcodesMissingRefs = new ArrayList<SampleBarcode>();
	
		//resolve xref 'sampleBarcodeType' from sampleBarcodeType.SampleBarcodeTypeName -> sampleBarcodeType.id
		for(SampleBarcode o: sampleBarcodeList) 
		{
			if(o.getSampleBarcodeType_SampleBarcodeTypeName() != null) 
				sampleBarcodeTypeKeymap.put(o.getSampleBarcodeType_SampleBarcodeTypeName(), null);
		}
		
		if(sampleBarcodeTypeKeymap.size() > 0) 
		{
			List<SampleBarcodeType> sampleBarcodeTypeList = db.query(SampleBarcodeType.class).in("SampleBarcodeTypeName",new ArrayList<Object>(sampleBarcodeTypeKeymap.keySet())).find();
			for(SampleBarcodeType xref :  sampleBarcodeTypeList)
			{
				sampleBarcodeTypeKeymap.put(xref.getSampleBarcodeTypeName(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(SampleBarcode o:  sampleBarcodeList)
		{
			while(true){
				//update xref SampleBarcodeType
				if(o.getSampleBarcodeType_SampleBarcodeTypeName() != null) 
				{
					String key = o.getSampleBarcodeType_SampleBarcodeTypeName();
					if(sampleBarcodeTypeKeymap.get(key) == null)
					{
						throw new Exception("Import of 'SampleBarcode' objects failed: cannot find SampleBarcodeType for sampleBarcodeType_SampleBarcodeTypeName='"+o.getSampleBarcodeType_SampleBarcodeTypeName()+"'");
					}
					o.setSampleBarcodeType_Id(sampleBarcodeTypeKeymap.get(key));
				}
				break;
			}
		}
		
		sampleBarcodeTypeKeymap.clear();
		
		return sampleBarcodesMissingRefs;
	}
}

