
/* File:        org.molgenis.omx/model/Sample_SampleInPool.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        September 20, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.ngs.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.ngs.Sample;
import org.molgenis.omx.ngs.Sample_SampleInPool;


/**
 * Reads Sample_SampleInPool from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class Sample_SampleInPoolEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(Sample_SampleInPoolEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'sampleInPool' (maps sample.InternalId -> sample.id)			
	final Map<String,Integer> sampleInPoolKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'sample' (maps sample.InternalId -> sample.id)			
	final Map<String,Integer> sampleKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports Sample_SampleInPool from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Sample_SampleInPool> sample_SampleInPoolsMissingRefs = new ArrayList<Sample_SampleInPool>();
	
		//cache for objects to be imported from file (in batch)
		final List<Sample_SampleInPool> sample_SampleInPoolList = new ArrayList<Sample_SampleInPool>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			Sample_SampleInPool object = new Sample_SampleInPool();
			object.set(tuple, false);				
			sample_SampleInPoolList.add(object);		
			
			//add to db when batch size is reached
			if(sample_SampleInPoolList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				sample_SampleInPoolsMissingRefs.addAll(resolveForeignKeys(db, sample_SampleInPoolList));
				sample_SampleInPoolList.removeAll(sample_SampleInPoolsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'SampleInPool,Sample' defined in xref_label
				db.update(sample_SampleInPoolList,dbAction, "SampleInPool", "Sample");
				
				//clear for next batch						
				sample_SampleInPoolList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!sample_SampleInPoolList.isEmpty())
		{
			total.set(total.get() + sample_SampleInPoolList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			sample_SampleInPoolsMissingRefs.addAll(resolveForeignKeys(db, sample_SampleInPoolList));
			sample_SampleInPoolList.removeAll(sample_SampleInPoolsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'SampleInPool,Sample' defined in xref_label
			db.update(sample_SampleInPoolList,dbAction, "SampleInPool", "Sample");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Sample_SampleInPool> sample_SampleInPools = new ArrayList<Sample_SampleInPool>(sample_SampleInPoolsMissingRefs);

		int iterationCount = 0;

		do
		{
			sample_SampleInPoolsMissingRefs = resolveForeignKeys(db, sample_SampleInPoolsMissingRefs);
			
			LinkedHashSet<Sample_SampleInPool> differenceSet = new LinkedHashSet<Sample_SampleInPool>();
			Sets.symmetricDifference(new LinkedHashSet<Sample_SampleInPool>(sample_SampleInPools), new LinkedHashSet<Sample_SampleInPool>(sample_SampleInPoolsMissingRefs)).copyInto(differenceSet);
			List<Sample_SampleInPool> resolvablesample_SampleInPools = new ArrayList<Sample_SampleInPool>(differenceSet);
			
			sample_SampleInPools.removeAll(resolvablesample_SampleInPools);
			
			db.update(resolvablesample_SampleInPools,dbAction, "SampleInPool", "Sample");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Sample_SampleInPool blaat : sample_SampleInPoolsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'sample_SampleInPool' entity failed:"
								+ "This is probably caused by a(n) 'sample_SampleInPool' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (sample_SampleInPoolsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " sample_SampleInPool from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param sample_SampleInPoolList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Sample_SampleInPool> resolveForeignKeys(Database db, List<Sample_SampleInPool> sample_SampleInPoolList) throws Exception
	{
		//keep a list of Sample_SampleInPool instances that miss a reference which might be resolvable later
		List<Sample_SampleInPool> sample_SampleInPoolsMissingRefs = new ArrayList<Sample_SampleInPool>();
	
		//resolve xref 'sampleInPool' from sample.InternalId -> sample.id
		for(Sample_SampleInPool o: sample_SampleInPoolList) 
		{
			if(o.getSampleInPool_InternalId() != null) 
				sampleInPoolKeymap.put(o.getSampleInPool_InternalId(), null);
		}
		
		if(sampleInPoolKeymap.size() > 0) 
		{
			List<Sample> sampleInPoolList = db.query(Sample.class).in("InternalId",new ArrayList<Object>(sampleInPoolKeymap.keySet())).find();
			for(Sample xref :  sampleInPoolList)
			{
				sampleInPoolKeymap.put(xref.getInternalId(), xref.getId());
			}
		}
		//resolve xref 'sample' from sample.InternalId -> sample.id
		for(Sample_SampleInPool o: sample_SampleInPoolList) 
		{
			if(o.getSample_InternalId() != null) 
				sampleKeymap.put(o.getSample_InternalId(), null);
		}
		
		if(sampleKeymap.size() > 0) 
		{
			List<Sample> sampleList = db.query(Sample.class).in("InternalId",new ArrayList<Object>(sampleKeymap.keySet())).find();
			for(Sample xref :  sampleList)
			{
				sampleKeymap.put(xref.getInternalId(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(Sample_SampleInPool o:  sample_SampleInPoolList)
		{
			while(true){
				//update xref SampleInPool
				if(o.getSampleInPool_InternalId() != null) 
				{
					String key = o.getSampleInPool_InternalId();
					if(sampleInPoolKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Sample_SampleInPool' objects failed: cannot find Sample for sampleInPool_InternalId='"+o.getSampleInPool_InternalId()+"'");
					}
					o.setSampleInPool_Id(sampleInPoolKeymap.get(key));
				}
				//update xref Sample
				if(o.getSample_InternalId() != null) 
				{
					String key = o.getSample_InternalId();
					if(sampleKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Sample_SampleInPool' objects failed: cannot find Sample for sample_InternalId='"+o.getSample_InternalId()+"'");
					}
					o.setSample_Id(sampleKeymap.get(key));
				}
				break;
			}
		}
		
		sampleInPoolKeymap.clear();
		sampleKeymap.clear();
		
		return sample_SampleInPoolsMissingRefs;
	}
}

