package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.ngs.FlowcellLane;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class FlowcellLaneService
{
	private static final Logger logger = Logger.getLogger(FlowcellLaneService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public FlowcellLane create(FlowcellLane flowcellLane) throws DatabaseException
	{
		logger.debug("creating FlowcellLane");
		db.add(flowcellLane);
		return flowcellLane;
	}

	public FlowcellLane read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving FlowcellLane");
		return db.findById(FlowcellLane.class, id);
	}

	public void update(FlowcellLane flowcellLane) throws DatabaseException
	{
		logger.debug("updating FlowcellLane");
		db.update(flowcellLane);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting FlowcellLane");
		FlowcellLane flowcellLane = db.findById(FlowcellLane.class, id);
		return db.remove(flowcellLane) == 1;
	}
	
	public Iterable<FlowcellLane> readAll() throws DatabaseException
	{
		logger.debug("retrieving all FlowcellLane instances");
		return db.find(FlowcellLane.class);
	}
	
	public EntityPager<FlowcellLane> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all FlowcellLane instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(FlowcellLane.class, queryRules.toArray(new QueryRule[0]));
		List<FlowcellLane> flowcellLaneCollection = db.find(FlowcellLane.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<FlowcellLane>(start, num, count, flowcellLaneCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("FlowcellLane");
	}
}