package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.value.LongValue;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class LongValueService
{
	private static final Logger logger = Logger.getLogger(LongValueService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public LongValue create(LongValue longValue) throws DatabaseException
	{
		logger.debug("creating LongValue");
		db.add(longValue);
		return longValue;
	}

	public LongValue read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving LongValue");
		return db.findById(LongValue.class, id);
	}

	public void update(LongValue longValue) throws DatabaseException
	{
		logger.debug("updating LongValue");
		db.update(longValue);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting LongValue");
		LongValue longValue = db.findById(LongValue.class, id);
		return db.remove(longValue) == 1;
	}
	
	public Iterable<LongValue> readAll() throws DatabaseException
	{
		logger.debug("retrieving all LongValue instances");
		return db.find(LongValue.class);
	}
	
	public EntityPager<LongValue> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all LongValue instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(LongValue.class, queryRules.toArray(new QueryRule[0]));
		List<LongValue> longValueCollection = db.find(LongValue.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<LongValue>(start, num, count, longValueCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("LongValue");
	}
}